<?php
add_action('admin_menu', 'mpvw_add_admin_menu');
function mpvw_add_admin_menu(): void
{
    add_menu_page(
        _x('Magic Product Video for WooCommerce', 'admin', 'magic-product-video-for-woocommerce'),
        _x('Magic PVW', 'admin', 'magic-product-video-for-woocommerce'),
        'manage_options',
        'mpvw_settings',
        'mpvw_admin_page_callback',
        'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMTU1IiBoZWlnaHQ9IjE1NSIgdmlld0JveD0iMCAwIDE1NSAxNTUiIGZpbGw9Im5vbmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+CjxwYXRoIGQ9Ik0xMzEuMzM1IDI4QzEyMC4wNTkgMjggMTExLjAxIDMzLjU2MzEgMTA0LjE4OSA0Ni4zNTg3TDg5LjAxNTcgNzQuNzMxNVY1MC42NzA0Qzg5LjAxNTcgMzYuNDg0IDc5LjgyNzkgMjggNjUuNjI4NyAyOEM1NC40OTIxIDI4IDQ2LjI3ODYgMzIuODY3OSAzOC4zNDQxIDQ2LjM1ODdMMy40MDI4NyAxMDUuMzNDLTQuMjUzNDYgMTE4LjI2NCAxLjE3NTU2IDEyOCAxOC4wMTk3IDEyOEMyNy4wNjgxIDEyOCAzMi45MTQ3IDEyNS4wNzkgMzguMjA0NyAxMTUuMjA0TDYyLjI4NzUgNzAuMDAyNVYxMTAuMTk3QzYyLjI4NzUgMTIyLjE1OSA2Ny45OTUxIDEyOCA3OC41NzQ5IDEyOEM4Ni45Mjc1IDEyOCA5My42MDk0IDEyNC4zODQgOTguNzYwMyAxMTQuMzdMMTIxLjQ1MSA3MC4wMDI1VjEwOS43OEMxMjEuNDUxIDEyMi42NSAxMjQuNjEzIDEyNy45NDggMTM4Ljk5MiAxMjcuOTQ4QzE1MS44NTcgMTI3Ljk0OCAxNTQuODg0IDEyMi42NSAxNTQuODg0IDEwOS43OEMxNTQuODg0IDk5LjUxNjMgMTU0LjkyOSA4MC42NTc1IDE1NC45NyA2My40Mzk0TDE1NC45NyA2My40MTgyVjYzLjQxNDJDMTU0Ljk4MSA1OS4wNTE0IDE1NC45OTEgNTQuNzk0MiAxNTUgNTAuODA5M0MxNTUgMzYuNDg0IDE0NS4zOTUgMjggMTMxLjMzNSAyOFoiIGZpbGw9IiNhN2FhYWQiLz4KPC9zdmc+',
        58
    );
}

function mpvw_admin_page_callback(): void
{
    ?>
    <div class="wrap" style="height: 100%;">
        <div id="mpvw-app">
            <app-root>
                <div class="mpvw-loading-app"><?php echo esc_html_x('Loading MPVW admin app files ...', 'admin', 'magic-product-video-for-woocommerce'); ?></div>
            </app-root>
        </div>
    </div>
    <?php
}

add_action('admin_enqueue_scripts', 'mpvw_enqueue_admin_app_scripts_and_styles');
function mpvw_enqueue_admin_app_scripts_and_styles($hook_suffix)
{

    if ($hook_suffix !== 'toplevel_page_mpvw_settings') {
        return;
    }

    $locale = mpvw_get_user_locale();
    $app_url = MPVW_PLUGIN_URL . 'admin/app/browser/' . $locale . '/';
    $app_path = MPVW_PLUGIN_DIR . 'admin/app/browser/' . $locale . '/';

    if (!is_dir($app_path)) return;

    $files = scandir($app_path);
    if (!$files) return;

    $style_file = null;
    $polyfills_file = null;
    $main_file = null;

    foreach ($files as $file) {
        if ($file === '.' || $file === '..') continue;

        if (preg_match('/^styles.*\.css$/', $file)) {
            $style_file = $file;
        } elseif (preg_match('/^polyfills.*\.js$/', $file)) {
            $polyfills_file = $file;
        } elseif (preg_match('/^main.*\.js$/', $file)) {
            $main_file = $file;
        }
    }

    if ($style_file) {
        wp_enqueue_style(MPVW_PLUGIN_SLUG . '-app-style', $app_url . $style_file, [], MPVW_PLUGIN_VERSION);
    }

    if ($polyfills_file && function_exists('wp_enqueue_script_module')) {
        wp_enqueue_script_module(
            MPVW_PLUGIN_SLUG . '-app-polyfills',
            $app_url . $polyfills_file,
            [],
            MPVW_PLUGIN_VERSION
        );
    }

    if ($main_file && function_exists('wp_enqueue_script_module')) {
        wp_enqueue_script_module(
            MPVW_PLUGIN_SLUG . '-app-main',
            $app_url . $main_file,
            [],
            MPVW_PLUGIN_VERSION
        );
    }
}

function mpvw_get_user_locale(): string
{
    $user_locale = get_user_locale();
    if (!in_array($user_locale, MPVW_LOCALES)) $user_locale = MPVW_LOCALES[0];
    return $user_locale;
}
