<?php
/**
 * Uninstall script for MA Smart Image Cleaner
 *
 * This file is executed when the plugin is deleted from the WordPress admin.
 * It removes all plugin data from the database.
 *
 * @package MA_Smart_Image_Cleaner
 */

// If uninstall not called from WordPress, exit
if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
	exit;
}

global $wpdb;

// Remove custom database tables
// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.DirectDatabaseQuery.SchemaChange
$wpdb->query( "DROP TABLE IF EXISTS {$wpdb->prefix}masic_scan_results" );
// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.DirectDatabaseQuery.SchemaChange
$wpdb->query( "DROP TABLE IF EXISTS {$wpdb->prefix}masic_delete_logs" );

// Remove all plugin options
$masic_options = array(
	'masic_db_version',
	'masic_enable_auto_scan',
	'masic_scan_frequency',
	'masic_enable_elementor_scan',
	'masic_excluded_folders',
	'masic_excluded_file_types',
	'masic_batch_size',
	'masic_trash_retention_days',
	'masic_editor_can_view',
	'masic_scan_in_progress',
	'masic_scan_progress',
	'masic_last_batch_run',
	'masic_last_db_error',
);

foreach ( $masic_options as $masic_option ) {
	delete_option( $masic_option );
}

// Clear scheduled cron events
wp_clear_scheduled_hook( 'masic_scheduled_scan' );
wp_clear_scheduled_hook( 'masic_batch_scan' );

// Clear any transients
delete_transient( 'masic_scan_status' );
