<?php
/**
 * Trash page for MA Smart Image Cleaner
 *
 * @package MA_Smart_Image_Cleaner
 */

// Prevent direct access
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// phpcs:ignore WordPress.Security.NonceVerification.Recommended -- This is a read-only page display
$masic_current_page = isset( $_GET['paged'] ) ? absint( $_GET['paged'] ) : 1;
$masic_results = masic_get_trashed_images( array(
	'paged'    => $masic_current_page,
	'per_page' => 20,
) );
?>

<div class="wrap masic-wrap">
	<h1 class="wp-heading-inline">
		<span class="dashicons dashicons-trash"></span>
		<?php esc_html_e( 'Trash', 'ma-smart-image-cleaner' ); ?>
	</h1>

	<!-- Navigation Tabs -->
	<nav class="nav-tab-wrapper masic-nav-tabs">
		<a href="<?php echo esc_url( admin_url( 'upload.php?page=masic-cleaner' ) ); ?>" class="nav-tab">
			<?php esc_html_e( 'Dashboard', 'ma-smart-image-cleaner' ); ?>
		</a>
		<a href="<?php echo esc_url( admin_url( 'upload.php?page=masic-cleaner-results' ) ); ?>" class="nav-tab">
			<?php esc_html_e( 'Scan Results', 'ma-smart-image-cleaner' ); ?>
		</a>
		<a href="<?php echo esc_url( admin_url( 'upload.php?page=masic-cleaner-trash' ) ); ?>" class="nav-tab nav-tab-active">
			<?php esc_html_e( 'Trash', 'ma-smart-image-cleaner' ); ?>
		</a>
		<a href="<?php echo esc_url( admin_url( 'upload.php?page=masic-cleaner-logs' ) ); ?>" class="nav-tab">
			<?php esc_html_e( 'Activity Log', 'ma-smart-image-cleaner' ); ?>
		</a>
		<?php if ( masic_user_can_settings() ) : ?>
		<a href="<?php echo esc_url( admin_url( 'upload.php?page=masic-cleaner-settings' ) ); ?>" class="nav-tab">
			<?php esc_html_e( 'Settings', 'ma-smart-image-cleaner' ); ?>
		</a>
		<?php endif; ?>
	</nav>

	<!-- Info Notice -->
	<div class="notice notice-warning masic-trash-notice">
		<p>
			<span class="dashicons dashicons-warning"></span>
			<?php esc_html_e( 'Images in trash will be permanently deleted after 30 days. Restore them before then to keep them in your media library.', 'ma-smart-image-cleaner' ); ?>
		</p>
	</div>

	<!-- Bulk Actions -->
	<?php if ( masic_user_can_delete() && ! empty( $masic_results['items'] ) ) : ?>
	<div class="masic-bulk-actions">
		<form method="post" id="masic-bulk-form">
			<?php wp_nonce_field( 'masic_bulk_action', 'masic_bulk_nonce' ); ?>
			<select name="bulk_action" id="masic-bulk-action">
				<option value=""><?php esc_html_e( 'Bulk Actions', 'ma-smart-image-cleaner' ); ?></option>
				<option value="restore"><?php esc_html_e( 'Restore', 'ma-smart-image-cleaner' ); ?></option>
				<option value="delete"><?php esc_html_e( 'Delete Permanently', 'ma-smart-image-cleaner' ); ?></option>
			</select>
			<button type="button" class="button" id="masic-apply-bulk"><?php esc_html_e( 'Apply', 'ma-smart-image-cleaner' ); ?></button>
			<span class="masic-selected-count">
				<span id="masic-selected-num">0</span> <?php esc_html_e( 'selected', 'ma-smart-image-cleaner' ); ?>
			</span>
		</form>
	</div>
	<?php endif; ?>

	<!-- Trash Table -->
	<div class="masic-results-table">
		<?php if ( empty( $masic_results['items'] ) ) : ?>
			<div class="masic-no-results">
				<span class="dashicons dashicons-trash"></span>
				<p><?php esc_html_e( 'Trash is empty. Deleted images will appear here.', 'ma-smart-image-cleaner' ); ?></p>
			</div>
		<?php else : ?>
			<table class="wp-list-table widefat fixed striped">
				<thead>
					<tr>
						<?php if ( masic_user_can_delete() ) : ?>
						<td class="check-column">
							<input type="checkbox" id="masic-select-all">
						</td>
						<?php endif; ?>
						<th class="column-thumbnail"><?php esc_html_e( 'Image', 'ma-smart-image-cleaner' ); ?></th>
						<th class="column-filename"><?php esc_html_e( 'Filename', 'ma-smart-image-cleaner' ); ?></th>
						<th class="column-filesize"><?php esc_html_e( 'Size', 'ma-smart-image-cleaner' ); ?></th>
						<th class="column-deleted"><?php esc_html_e( 'Deleted', 'ma-smart-image-cleaner' ); ?></th>
						<th class="column-expires"><?php esc_html_e( 'Permanent Deletion', 'ma-smart-image-cleaner' ); ?></th>
						<th class="column-actions"><?php esc_html_e( 'Actions', 'ma-smart-image-cleaner' ); ?></th>
					</tr>
				</thead>
				<tbody>
					<?php foreach ( $masic_results['items'] as $masic_item ) : ?>
					<tr data-id="<?php echo esc_attr( $masic_item->ID ); ?>">
						<?php if ( masic_user_can_delete() ) : ?>
						<th class="check-column">
							<input type="checkbox" class="masic-item-check" value="<?php echo esc_attr( $masic_item->ID ); ?>">
						</th>
						<?php endif; ?>
						<td class="column-thumbnail">
							<?php if ( $masic_item->thumbnail_url ) : ?>
								<img src="<?php echo esc_url( $masic_item->thumbnail_url ); ?>" alt="<?php echo esc_attr( $masic_item->filename ); ?>" class="masic-thumbnail masic-trashed">
							<?php else : ?>
								<span class="dashicons dashicons-format-image masic-no-thumb"></span>
							<?php endif; ?>
						</td>
						<td class="column-filename">
							<strong><?php echo esc_html( $masic_item->filename ); ?></strong>
							<div class="masic-file-id">
								<?php
								printf(
									/* translators: %d: attachment ID */
									esc_html__( 'ID: %d', 'ma-smart-image-cleaner' ),
									intval( $masic_item->ID )
								);
								?>
							</div>
						</td>
						<td class="column-filesize">
							<?php echo esc_html( masic_format_file_size( $masic_item->file_size ) ); ?>
						</td>
						<td class="column-deleted">
							<?php echo esc_html( masic_format_relative_time( $masic_item->deleted_at ) ); ?>
						</td>
						<td class="column-expires">
							<?php if ( $masic_item->days_remaining <= 7 ) : ?>
								<span class="masic-expires-soon">
									<?php
									printf(
										/* translators: %d: days remaining */
										esc_html__( '%d days remaining', 'ma-smart-image-cleaner' ),
										intval( $masic_item->days_remaining )
									);
									?>
								</span>
							<?php else : ?>
								<?php
								printf(
									/* translators: %d: days remaining */
									esc_html__( '%d days remaining', 'ma-smart-image-cleaner' ),
									intval( $masic_item->days_remaining )
								);
								?>
							<?php endif; ?>
						</td>
						<td class="column-actions">
							<?php if ( masic_user_can_delete() ) : ?>
								<button type="button" class="button masic-restore-single" data-id="<?php echo esc_attr( $masic_item->ID ); ?>">
									<span class="dashicons dashicons-undo"></span>
									<?php esc_html_e( 'Restore', 'ma-smart-image-cleaner' ); ?>
								</button>
								<button type="button" class="button masic-permanent-delete" data-id="<?php echo esc_attr( $masic_item->ID ); ?>">
									<span class="dashicons dashicons-trash"></span>
									<?php esc_html_e( 'Delete', 'ma-smart-image-cleaner' ); ?>
								</button>
							<?php endif; ?>
						</td>
					</tr>
					<?php endforeach; ?>
				</tbody>
			</table>

			<!-- Pagination -->
			<?php if ( $masic_results['total_pages'] > 1 ) : ?>
			<div class="masic-pagination">
				<?php
				// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- paginate_links() returns safe HTML
				echo paginate_links( array(
					'base'      => add_query_arg( 'paged', '%#%' ),
					'format'    => '',
					'current'   => $masic_current_page,
					'total'     => $masic_results['total_pages'],
					'prev_text' => '&laquo; ' . __( 'Previous', 'ma-smart-image-cleaner' ),
					'next_text' => __( 'Next', 'ma-smart-image-cleaner' ) . ' &raquo;',
				) );
				?>
			</div>
			<?php endif; ?>
		<?php endif; ?>
	</div>
</div>
