<?php
/**
 * Settings page for MA Smart Image Cleaner
 *
 * @package MA_Smart_Image_Cleaner
 */

// Prevent direct access
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Check permissions
masic_check_permission();

// Get current settings
$masic_enable_auto_scan = get_option( 'masic_enable_auto_scan', false );
$masic_scan_frequency = get_option( 'masic_scan_frequency', 'manual' );
$masic_enable_elementor_scan = get_option( 'masic_enable_elementor_scan', true );
$masic_excluded_folders = get_option( 'masic_excluded_folders', '' );
$masic_excluded_file_types = get_option( 'masic_excluded_file_types', '' );
$masic_batch_size = get_option( 'masic_batch_size', 50 );
$masic_editor_can_view = get_option( 'masic_editor_can_view', false );

// Check if Elementor is active
$masic_elementor_active = defined( 'ELEMENTOR_VERSION' );
?>

<div class="wrap masic-wrap">
	<h1 class="wp-heading-inline">
		<span class="dashicons dashicons-admin-settings"></span>
		<?php esc_html_e( 'Settings', 'ma-smart-image-cleaner' ); ?>
	</h1>

	<!-- Navigation Tabs -->
	<nav class="nav-tab-wrapper masic-nav-tabs">
		<a href="<?php echo esc_url( admin_url( 'upload.php?page=masic-cleaner' ) ); ?>" class="nav-tab">
			<?php esc_html_e( 'Dashboard', 'ma-smart-image-cleaner' ); ?>
		</a>
		<a href="<?php echo esc_url( admin_url( 'upload.php?page=masic-cleaner-results' ) ); ?>" class="nav-tab">
			<?php esc_html_e( 'Scan Results', 'ma-smart-image-cleaner' ); ?>
		</a>
		<a href="<?php echo esc_url( admin_url( 'upload.php?page=masic-cleaner-trash' ) ); ?>" class="nav-tab">
			<?php esc_html_e( 'Trash', 'ma-smart-image-cleaner' ); ?>
		</a>
		<a href="<?php echo esc_url( admin_url( 'upload.php?page=masic-cleaner-logs' ) ); ?>" class="nav-tab">
			<?php esc_html_e( 'Activity Log', 'ma-smart-image-cleaner' ); ?>
		</a>
		<a href="<?php echo esc_url( admin_url( 'upload.php?page=masic-cleaner-settings' ) ); ?>" class="nav-tab nav-tab-active">
			<?php esc_html_e( 'Settings', 'ma-smart-image-cleaner' ); ?>
		</a>
	</nav>

	<div class="masic-settings-form">
		<form method="post" id="masic-settings-form">
			<?php wp_nonce_field( 'masic_save_settings', 'masic_settings_nonce' ); ?>

			<!-- Scan Settings -->
			<div class="masic-settings-section">
				<h2><?php esc_html_e( 'Scan Settings', 'ma-smart-image-cleaner' ); ?></h2>

				<table class="form-table">
					<tr>
						<th scope="row">
							<?php esc_html_e( 'Automatic Scanning', 'ma-smart-image-cleaner' ); ?>
						</th>
						<td>
							<label for="enable_auto_scan">
								<input type="checkbox" name="enable_auto_scan" id="enable_auto_scan" value="1" <?php checked( $masic_enable_auto_scan ); ?>>
								<?php esc_html_e( 'Enable automatic scheduled scans', 'ma-smart-image-cleaner' ); ?>
							</label>
							<p class="description">
								<?php esc_html_e( 'When enabled, the plugin will automatically scan your media library on the selected schedule.', 'ma-smart-image-cleaner' ); ?>
							</p>
						</td>
					</tr>

					<tr class="masic-frequency-row">
						<th scope="row">
							<label for="scan_frequency"><?php esc_html_e( 'Scan Frequency', 'ma-smart-image-cleaner' ); ?></label>
						</th>
						<td>
							<select name="scan_frequency" id="scan_frequency">
								<option value="manual" <?php selected( $masic_scan_frequency, 'manual' ); ?>><?php esc_html_e( 'Manual only', 'ma-smart-image-cleaner' ); ?></option>
								<option value="daily" <?php selected( $masic_scan_frequency, 'daily' ); ?>><?php esc_html_e( 'Daily', 'ma-smart-image-cleaner' ); ?></option>
								<option value="weekly" <?php selected( $masic_scan_frequency, 'weekly' ); ?>><?php esc_html_e( 'Weekly', 'ma-smart-image-cleaner' ); ?></option>
							</select>
						</td>
					</tr>

					<tr>
						<th scope="row">
							<label for="batch_size"><?php esc_html_e( 'Batch Size', 'ma-smart-image-cleaner' ); ?></label>
						</th>
						<td>
							<input type="number" name="batch_size" id="batch_size" value="<?php echo esc_attr( $masic_batch_size ); ?>" min="10" max="200" step="10">
							<p class="description">
								<?php esc_html_e( 'Number of images to process per batch. Lower values are safer for shared hosting. Range: 10-200.', 'ma-smart-image-cleaner' ); ?>
							</p>
						</td>
					</tr>
				</table>
			</div>

			<!-- Detection Settings -->
			<div class="masic-settings-section">
				<h2><?php esc_html_e( 'Detection Settings', 'ma-smart-image-cleaner' ); ?></h2>

				<table class="form-table">
					<tr>
						<th scope="row">
							<?php esc_html_e( 'Elementor Support', 'ma-smart-image-cleaner' ); ?>
						</th>
						<td>
							<label for="enable_elementor_scan">
								<input type="checkbox" name="enable_elementor_scan" id="enable_elementor_scan" value="1" <?php checked( $masic_enable_elementor_scan ); ?> <?php disabled( ! $masic_elementor_active ); ?>>
								<?php esc_html_e( 'Scan Elementor page builder data', 'ma-smart-image-cleaner' ); ?>
							</label>
							<?php if ( ! $masic_elementor_active ) : ?>
								<p class="description masic-notice-muted">
									<?php esc_html_e( 'Elementor is not installed or active.', 'ma-smart-image-cleaner' ); ?>
								</p>
							<?php else : ?>
								<p class="description">
									<?php esc_html_e( 'Detect images used in Elementor-built pages. Recommended if you use Elementor.', 'ma-smart-image-cleaner' ); ?>
								</p>
							<?php endif; ?>
						</td>
					</tr>
				</table>
			</div>

			<!-- Exclusions -->
			<div class="masic-settings-section">
				<h2><?php esc_html_e( 'Exclusions', 'ma-smart-image-cleaner' ); ?></h2>

				<table class="form-table">
					<tr>
						<th scope="row">
							<label for="excluded_folders"><?php esc_html_e( 'Excluded Folders', 'ma-smart-image-cleaner' ); ?></label>
						</th>
						<td>
							<input type="text" name="excluded_folders" id="excluded_folders" value="<?php echo esc_attr( $masic_excluded_folders ); ?>" class="large-text" placeholder="e.g., /logos, /branding">
							<p class="description">
								<?php esc_html_e( 'Comma-separated list of folder paths to exclude from scanning (relative to uploads directory).', 'ma-smart-image-cleaner' ); ?>
							</p>
						</td>
					</tr>

					<tr>
						<th scope="row">
							<label for="excluded_file_types"><?php esc_html_e( 'Excluded File Types', 'ma-smart-image-cleaner' ); ?></label>
						</th>
						<td>
							<input type="text" name="excluded_file_types" id="excluded_file_types" value="<?php echo esc_attr( $masic_excluded_file_types ); ?>" class="large-text" placeholder="e.g., svg, ico">
							<p class="description">
								<?php esc_html_e( 'Comma-separated list of file extensions to exclude from scanning.', 'ma-smart-image-cleaner' ); ?>
							</p>
						</td>
					</tr>
				</table>
			</div>

			<!-- Permissions -->
			<div class="masic-settings-section">
				<h2><?php esc_html_e( 'Permissions', 'ma-smart-image-cleaner' ); ?></h2>

				<table class="form-table">
					<tr>
						<th scope="row">
							<?php esc_html_e( 'Editor Access', 'ma-smart-image-cleaner' ); ?>
						</th>
						<td>
							<label for="editor_can_view">
								<input type="checkbox" name="editor_can_view" id="editor_can_view" value="1" <?php checked( $masic_editor_can_view ); ?>>
								<?php esc_html_e( 'Allow editors to view scan results (read-only)', 'ma-smart-image-cleaner' ); ?>
							</label>
							<p class="description">
								<?php esc_html_e( 'Editors will not be able to delete images, only view the scan results.', 'ma-smart-image-cleaner' ); ?>
							</p>
						</td>
					</tr>
				</table>
			</div>

			<p class="submit">
				<button type="submit" class="button button-primary" id="masic-save-settings">
					<?php esc_html_e( 'Save Settings', 'ma-smart-image-cleaner' ); ?>
				</button>
				<span class="spinner" id="masic-settings-spinner"></span>
			</p>
		</form>
	</div>

	<!-- Reset Section -->
	<div class="masic-settings-section masic-danger-zone">
		<h2><?php esc_html_e( 'Danger Zone', 'ma-smart-image-cleaner' ); ?></h2>
		<p class="description">
			<?php esc_html_e( 'These actions cannot be undone.', 'ma-smart-image-cleaner' ); ?>
		</p>
		<p>
			<button type="button" class="button masic-clear-data" id="masic-clear-scan-data">
				<?php esc_html_e( 'Clear Scan Data', 'ma-smart-image-cleaner' ); ?>
			</button>
			<span class="description">
				<?php esc_html_e( 'Removes all scan results. Does not affect your actual images.', 'ma-smart-image-cleaner' ); ?>
			</span>
		</p>
	</div>
</div>
