<?php
/**
 * Logs page for MA Smart Image Cleaner
 *
 * @package MA_Smart_Image_Cleaner
 */

// Prevent direct access
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// phpcs:ignore WordPress.Security.NonceVerification.Recommended -- This is a read-only page display
$masic_current_page = isset( $_GET['paged'] ) ? absint( $_GET['paged'] ) : 1;
$masic_results = masic_get_delete_logs( array(
	'paged'    => $masic_current_page,
	'per_page' => 20,
) );
?>

<div class="wrap masic-wrap">
	<h1 class="wp-heading-inline">
		<span class="dashicons dashicons-list-view"></span>
		<?php esc_html_e( 'Activity Log', 'ma-smart-image-cleaner' ); ?>
	</h1>

	<!-- Navigation Tabs -->
	<nav class="nav-tab-wrapper masic-nav-tabs">
		<a href="<?php echo esc_url( admin_url( 'upload.php?page=masic-cleaner' ) ); ?>" class="nav-tab">
			<?php esc_html_e( 'Dashboard', 'ma-smart-image-cleaner' ); ?>
		</a>
		<a href="<?php echo esc_url( admin_url( 'upload.php?page=masic-cleaner-results' ) ); ?>" class="nav-tab">
			<?php esc_html_e( 'Scan Results', 'ma-smart-image-cleaner' ); ?>
		</a>
		<a href="<?php echo esc_url( admin_url( 'upload.php?page=masic-cleaner-trash' ) ); ?>" class="nav-tab">
			<?php esc_html_e( 'Trash', 'ma-smart-image-cleaner' ); ?>
		</a>
		<a href="<?php echo esc_url( admin_url( 'upload.php?page=masic-cleaner-logs' ) ); ?>" class="nav-tab nav-tab-active">
			<?php esc_html_e( 'Activity Log', 'ma-smart-image-cleaner' ); ?>
		</a>
		<?php if ( masic_user_can_settings() ) : ?>
		<a href="<?php echo esc_url( admin_url( 'upload.php?page=masic-cleaner-settings' ) ); ?>" class="nav-tab">
			<?php esc_html_e( 'Settings', 'ma-smart-image-cleaner' ); ?>
		</a>
		<?php endif; ?>
	</nav>

	<p class="masic-page-description">
		<?php esc_html_e( 'Track all image deletion and restoration activities.', 'ma-smart-image-cleaner' ); ?>
	</p>

	<!-- Logs Table -->
	<div class="masic-results-table">
		<?php if ( empty( $masic_results['items'] ) ) : ?>
			<div class="masic-no-results">
				<span class="dashicons dashicons-list-view"></span>
				<p><?php esc_html_e( 'No activity logs yet. Deleted images will be recorded here.', 'ma-smart-image-cleaner' ); ?></p>
			</div>
		<?php else : ?>
			<table class="wp-list-table widefat fixed striped">
				<thead>
					<tr>
						<th class="column-id"><?php esc_html_e( 'ID', 'ma-smart-image-cleaner' ); ?></th>
						<th class="column-filename"><?php esc_html_e( 'Filename', 'ma-smart-image-cleaner' ); ?></th>
						<th class="column-filesize"><?php esc_html_e( 'Size', 'ma-smart-image-cleaner' ); ?></th>
						<th class="column-user"><?php esc_html_e( 'Deleted By', 'ma-smart-image-cleaner' ); ?></th>
						<th class="column-date"><?php esc_html_e( 'Deleted At', 'ma-smart-image-cleaner' ); ?></th>
						<th class="column-status"><?php esc_html_e( 'Status', 'ma-smart-image-cleaner' ); ?></th>
						<th class="column-actions"><?php esc_html_e( 'Actions', 'ma-smart-image-cleaner' ); ?></th>
					</tr>
				</thead>
				<tbody>
					<?php foreach ( $masic_results['items'] as $masic_log ) : ?>
					<tr data-id="<?php echo esc_attr( $masic_log->id ); ?>">
						<td class="column-id">
							<?php echo esc_html( $masic_log->attachment_id ); ?>
						</td>
						<td class="column-filename">
							<strong><?php echo esc_html( $masic_log->filename ); ?></strong>
						</td>
						<td class="column-filesize">
							<?php echo esc_html( masic_format_file_size( $masic_log->file_size ) ); ?>
						</td>
						<td class="column-user">
							<span class="dashicons dashicons-admin-users"></span>
							<?php echo esc_html( $masic_log->deleted_by_name ? $masic_log->deleted_by_name : __( 'Unknown', 'ma-smart-image-cleaner' ) ); ?>
						</td>
						<td class="column-date">
							<span class="dashicons dashicons-calendar-alt"></span>
							<?php echo esc_html( date_i18n( get_option( 'date_format' ) . ' ' . get_option( 'time_format' ), strtotime( $masic_log->deleted_at ) ) ); ?>
						</td>
						<td class="column-status">
							<?php if ( $masic_log->is_restored ) : ?>
								<span class="masic-status-badge masic-status-used">
									<?php esc_html_e( 'Restored', 'ma-smart-image-cleaner' ); ?>
								</span>
							<?php else : ?>
								<span class="masic-status-badge masic-status-unused">
									<?php esc_html_e( 'In Trash', 'ma-smart-image-cleaner' ); ?>
								</span>
								<div class="masic-days-remaining">
									<?php
									$masic_days = masic_get_days_until_deletion( $masic_log->deleted_at );
									printf(
										/* translators: %d: days remaining */
										esc_html__( '%d days until permanent deletion', 'ma-smart-image-cleaner' ),
										intval( $masic_days )
									);
									?>
								</div>
							<?php endif; ?>
						</td>
						<td class="column-actions">
							<?php if ( ! $masic_log->is_restored && masic_user_can_delete() ) : ?>
								<button type="button" class="button masic-restore-from-log" data-id="<?php echo esc_attr( $masic_log->attachment_id ); ?>">
									<span class="dashicons dashicons-undo"></span>
									<?php esc_html_e( 'Restore', 'ma-smart-image-cleaner' ); ?>
								</button>
							<?php elseif ( $masic_log->is_restored && $masic_log->restored_at ) : ?>
								<span class="masic-restored-date">
									<?php
									printf(
										/* translators: %s: date when restored */
										esc_html__( 'Restored %s', 'ma-smart-image-cleaner' ),
										esc_html( date_i18n( get_option( 'date_format' ), strtotime( $masic_log->restored_at ) ) )
									);
									?>
								</span>
							<?php endif; ?>
						</td>
					</tr>
					<?php endforeach; ?>
				</tbody>
			</table>

			<!-- Pagination -->
			<?php if ( $masic_results['total_pages'] > 1 ) : ?>
			<div class="masic-pagination">
				<?php
				// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- paginate_links() returns safe HTML
				echo paginate_links( array(
					'base'      => add_query_arg( 'paged', '%#%' ),
					'format'    => '',
					'current'   => $masic_current_page,
					'total'     => $masic_results['total_pages'],
					'prev_text' => '&laquo; ' . __( 'Previous', 'ma-smart-image-cleaner' ),
					'next_text' => __( 'Next', 'ma-smart-image-cleaner' ) . ' &raquo;',
				) );
				?>
			</div>
			<?php endif; ?>
		<?php endif; ?>
	</div>

	<!-- Info Notice -->
	<div class="notice notice-info masic-info-notice">
		<p>
			<strong><?php esc_html_e( 'Note:', 'ma-smart-image-cleaner' ); ?></strong>
			<?php esc_html_e( 'Images moved to trash are automatically deleted after 30 days. Restore them before then to keep them in your media library.', 'ma-smart-image-cleaner' ); ?>
		</p>
	</div>
</div>
