<?php
/**
 * Dashboard page for MA Smart Image Cleaner
 *
 * @package MA_Smart_Image_Cleaner
 */

// Prevent direct access
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$masic_stats = masic_get_stats();
$masic_scan_in_progress = get_option( 'masic_scan_in_progress', false );
$masic_scan_progress = get_option( 'masic_scan_progress', array() );
?>

<div class="wrap masic-wrap">
	<h1 class="wp-heading-inline">
		<span class="dashicons dashicons-images-alt2"></span>
		<?php esc_html_e( 'MA Smart Image Cleaner', 'ma-smart-image-cleaner' ); ?>
	</h1>

	<!-- Navigation Tabs -->
	<nav class="nav-tab-wrapper masic-nav-tabs">
		<a href="<?php echo esc_url( admin_url( 'upload.php?page=masic-cleaner' ) ); ?>" class="nav-tab nav-tab-active">
			<?php esc_html_e( 'Dashboard', 'ma-smart-image-cleaner' ); ?>
		</a>
		<a href="<?php echo esc_url( admin_url( 'upload.php?page=masic-cleaner-results' ) ); ?>" class="nav-tab">
			<?php esc_html_e( 'Scan Results', 'ma-smart-image-cleaner' ); ?>
		</a>
		<a href="<?php echo esc_url( admin_url( 'upload.php?page=masic-cleaner-trash' ) ); ?>" class="nav-tab">
			<?php esc_html_e( 'Trash', 'ma-smart-image-cleaner' ); ?>
		</a>
		<a href="<?php echo esc_url( admin_url( 'upload.php?page=masic-cleaner-logs' ) ); ?>" class="nav-tab">
			<?php esc_html_e( 'Activity Log', 'ma-smart-image-cleaner' ); ?>
		</a>
		<?php if ( masic_user_can_settings() ) : ?>
		<a href="<?php echo esc_url( admin_url( 'upload.php?page=masic-cleaner-settings' ) ); ?>" class="nav-tab">
			<?php esc_html_e( 'Settings', 'ma-smart-image-cleaner' ); ?>
		</a>
		<?php endif; ?>
	</nav>

	<div class="masic-dashboard">
		<!-- Stats Cards -->
		<div class="masic-stats-grid">
			<div class="masic-stat-card">
				<div class="masic-stat-icon masic-icon-total">
					<span class="dashicons dashicons-format-gallery"></span>
				</div>
				<div class="masic-stat-content">
					<span class="masic-stat-number"><?php echo esc_html( number_format( $masic_stats['total_images'] ) ); ?></span>
					<span class="masic-stat-label"><?php esc_html_e( 'Total Images', 'ma-smart-image-cleaner' ); ?></span>
				</div>
			</div>

			<div class="masic-stat-card">
				<div class="masic-stat-icon masic-icon-used">
					<span class="dashicons dashicons-yes-alt"></span>
				</div>
				<div class="masic-stat-content">
					<span class="masic-stat-number masic-status-used"><?php echo esc_html( number_format( $masic_stats['used_images'] ) ); ?></span>
					<span class="masic-stat-label"><?php esc_html_e( 'Used Images', 'ma-smart-image-cleaner' ); ?></span>
				</div>
			</div>

			<div class="masic-stat-card">
				<div class="masic-stat-icon masic-icon-unused">
					<span class="dashicons dashicons-warning"></span>
				</div>
				<div class="masic-stat-content">
					<span class="masic-stat-number masic-status-unused"><?php echo esc_html( number_format( $masic_stats['unused_images'] ) ); ?></span>
					<span class="masic-stat-label"><?php esc_html_e( 'Unused Images', 'ma-smart-image-cleaner' ); ?></span>
				</div>
			</div>
		</div>

		<!-- Storage Info -->
		<div class="masic-storage-section">
			<div class="masic-storage-card">
				<h3><?php esc_html_e( 'Storage Overview', 'ma-smart-image-cleaner' ); ?></h3>
				<div class="masic-storage-stats">
					<div class="masic-storage-item">
						<span class="masic-storage-label"><?php esc_html_e( 'Total Storage Used', 'ma-smart-image-cleaner' ); ?></span>
						<span class="masic-storage-value"><?php echo esc_html( masic_format_file_size( $masic_stats['total_storage'] ) ); ?></span>
					</div>
					<div class="masic-storage-item masic-savings">
						<span class="masic-storage-label"><?php esc_html_e( 'Potential Savings', 'ma-smart-image-cleaner' ); ?></span>
						<span class="masic-storage-value"><?php echo esc_html( masic_format_file_size( $masic_stats['potential_savings'] ) ); ?></span>
					</div>
				</div>
				<?php if ( $masic_stats['last_scan_date'] ) : ?>
				<div class="masic-last-scan">
					<span class="dashicons dashicons-clock"></span>
					<?php
					printf(
						/* translators: %s: relative time since last scan */
						esc_html__( 'Last scan: %s', 'ma-smart-image-cleaner' ),
						esc_html( masic_format_relative_time( $masic_stats['last_scan_date'] ) )
					);
					?>
				</div>
				<?php endif; ?>
			</div>
		</div>

		<!-- Scan Progress / Start Scan -->
		<?php if ( masic_user_can_scan() ) : ?>
		<div class="masic-scan-section">
			<div class="masic-scan-card" id="masic-scan-card">
				<?php if ( $masic_scan_in_progress && ! empty( $masic_scan_progress ) ) : ?>
					<div class="masic-scan-progress">
						<div class="masic-scan-header">
							<span class="dashicons dashicons-update masic-spinning"></span>
							<h3><?php esc_html_e( 'Scanning Full Media Library...', 'ma-smart-image-cleaner' ); ?></h3>
							<span class="masic-progress-percent" id="masic-progress-percent">
								<?php echo esc_html( round( ( $masic_scan_progress['scanned_images'] / max( 1, $masic_scan_progress['total_images'] ) ) * 100 ) ); ?>%
							</span>
						</div>
						<div class="masic-progress-bar">
							<div class="masic-progress-fill" id="masic-progress-fill" style="width: <?php echo esc_attr( ( $masic_scan_progress['scanned_images'] / max( 1, $masic_scan_progress['total_images'] ) ) * 100 ); ?>%"></div>
						</div>
						<div class="masic-progress-stats">
							<span id="masic-progress-text">
								<strong><?php echo esc_html( $masic_scan_progress['scanned_images'] ); ?></strong>
								<?php esc_html_e( 'of', 'ma-smart-image-cleaner' ); ?>
								<strong><?php echo esc_html( $masic_scan_progress['total_images'] ); ?></strong>
								<?php esc_html_e( 'images scanned', 'ma-smart-image-cleaner' ); ?>
							</span>
							<span class="masic-estimated-time" id="masic-estimated-time"></span>
						</div>
						<div class="masic-progress-current" id="masic-progress-current">
							<?php
							if ( ! empty( $masic_scan_progress['current_image'] ) ) {
								echo '📁 ' . esc_html__( 'Analyzing:', 'ma-smart-image-cleaner' ) . ' <code>' . esc_html( $masic_scan_progress['current_image'] ) . '</code>';
							}
							?>
						</div>
						<div class="masic-scan-actions">
							<?php if ( 'paused' === $masic_scan_progress['status'] ) : ?>
								<button type="button" class="button button-primary masic-btn-large" id="masic-resume-scan">
									<span class="dashicons dashicons-controls-play"></span>
									<?php esc_html_e( 'Resume Scan', 'ma-smart-image-cleaner' ); ?>
								</button>
							<?php else : ?>
								<button type="button" class="button masic-btn-large" id="masic-pause-scan">
									<span class="dashicons dashicons-controls-pause"></span>
									<?php esc_html_e( 'Pause Scan', 'ma-smart-image-cleaner' ); ?>
								</button>
							<?php endif; ?>
						</div>
					</div>
				<?php else : ?>
					<div class="masic-scan-start">
						<span class="dashicons dashicons-search masic-scan-icon"></span>
						<h3><?php esc_html_e( 'Ready to Scan Your Media Library', 'ma-smart-image-cleaner' ); ?></h3>
						<p><?php esc_html_e( 'Click the button below to scan all images in your WordPress Media Library. The scan will identify used and unused images.', 'ma-smart-image-cleaner' ); ?></p>
						<button type="button" class="button button-primary button-hero masic-btn-hero" id="masic-start-scan">
							<span class="dashicons dashicons-controls-play"></span>
							<?php esc_html_e( 'Full Library Scan', 'ma-smart-image-cleaner' ); ?>
						</button>
					</div>
				<?php endif; ?>
			</div>
		</div>
		<?php endif; ?>

		<!-- Quick Actions -->
		<div class="masic-quick-actions">
			<h3><?php esc_html_e( 'Quick Actions', 'ma-smart-image-cleaner' ); ?></h3>
			<div class="masic-actions-grid">
				<a href="<?php echo esc_url( admin_url( 'upload.php?page=masic-cleaner-results&status=unused' ) ); ?>" class="masic-action-link">
					<span class="dashicons dashicons-trash"></span>
					<?php esc_html_e( 'View Unused Images', 'ma-smart-image-cleaner' ); ?>
				</a>
				<a href="<?php echo esc_url( admin_url( 'upload.php?page=masic-cleaner-trash' ) ); ?>" class="masic-action-link">
					<span class="dashicons dashicons-undo"></span>
					<?php esc_html_e( 'View Trash', 'ma-smart-image-cleaner' ); ?>
				</a>
				<a href="<?php echo esc_url( admin_url( 'upload.php?page=masic-cleaner-logs' ) ); ?>" class="masic-action-link">
					<span class="dashicons dashicons-list-view"></span>
					<?php esc_html_e( 'View Activity Log', 'ma-smart-image-cleaner' ); ?>
				</a>
				<?php if ( masic_user_can_settings() ) : ?>
				<a href="<?php echo esc_url( admin_url( 'upload.php?page=masic-cleaner-settings' ) ); ?>" class="masic-action-link">
					<span class="dashicons dashicons-admin-settings"></span>
					<?php esc_html_e( 'Configure Settings', 'ma-smart-image-cleaner' ); ?>
				</a>
				<?php endif; ?>
			</div>
		</div>

		<!-- Info Notice -->
		<div class="notice notice-info masic-info-notice">
			<p>
				<strong><?php esc_html_e( 'Safety First:', 'ma-smart-image-cleaner' ); ?></strong>
				<?php esc_html_e( 'This plugin never auto-deletes images. All deletions go to WordPress Trash first, giving you time to restore any accidentally removed images.', 'ma-smart-image-cleaner' ); ?>
			</p>
		</div>

		<!-- Plugin Credits -->
		<div class="masic-credits">
			<p>
				MA Smart Image Cleaner v1.0.0 |
				<?php esc_html_e( 'Developed by', 'ma-smart-image-cleaner' ); ?>
				<a href="https://moheebarif.com" target="_blank" rel="noopener noreferrer">Moheeb Arif</a> |
				<a href="https://madigitalhub.co.uk" target="_blank" rel="noopener noreferrer">MA Digital Hub</a>
			</p>
		</div>
	</div>
</div>
