import {createSlice} from '@reduxjs/toolkit';
import {fetchCreateDiscount, fetchRewardCount, fetchRewards} from "./rewardsThunksAction";
import login from "../../../components/Login";

const initialState = {
    vouchers: [],
    activities: [],
    points: 0,
    points_reward: 0,
    activeReward: null,
    isShow: false,
    isSuccessAdd: false,
    rewardCount: null,
    lynkedLogin: false
};

const rewardsSlice = createSlice({
    name: 'rewardsSlice',
    initialState,
    reducers: {
        setActiveReward: (state, {payload}) => {
            state.activeReward = payload;
        },
        setIsSuccessAdd: (state, {payload}) => {
            state.isSuccessAdd = false;
        },
        setIsShow: (state, {payload}) => {
            state.isShow = payload;
        },
    },
    extraReducers: {
        [fetchRewards.fulfilled]: (state, {payload}) => {
            console.log(payload)
            if (payload) {
                const {vouchers, activities, points, points_reward} = payload;
                state.vouchers = vouchers;
                state.activities = activities;
                state.points = points;
                state.points_reward = points_reward;
                state.lynkedLogin = true;
            } else {
                state.lynkedLogin = false
            }
        },
        [fetchCreateDiscount.fulfilled]: (state, {payload}) => {
            state.isShow = false;
            state.isSuccessAdd = true;
        },
        [fetchRewardCount.fulfilled]: (state, {payload}) => {
            state.rewardCount = payload.vouchersCount;
        }
    }
});

export const {setActiveReward, setIsSuccessAdd, setIsShow} = rewardsSlice.actions;

export default rewardsSlice.reducer;
