import {useDispatch, useSelector} from "react-redux";

import {Arrow} from "../../shared/icons/arrow";
import Download from "./Download";
import PointsActivity from "./PointsActivity";
import VoucherInfo from "./VoucherInfo";
import Rewards from "./Rewards";
import WaysToRedeem from "./WaysToRedeem";
import WaysToEarn from "./WaysToEarn";
import {setType} from "../../store/reducers/general/generalSlice";
import {generalSelector, rewardsSelector} from "../../store/selectors";

import "./styles.scss";

const ModalDetails = ({isLogin, lynkedLogin, openModal, popupSettingsObj}) => {
    const dispatch = useDispatch();
    const {type, shopName} = useSelector(generalSelector);
    const {points} = useSelector(rewardsSelector);

    const clickBack = () => {
        dispatch(setType(type === "voucherInfo" ? "vouchers" : null));
    }

    function decodeHTMLEntities(text) {
        const textarea = document.createElement("textarea");
        textarea.innerHTML = text;
        return textarea.value;
    }

    return (
        <div className="lynked-reward-block lynked-lynked-reward-detail-block lynked-view-block" style={popupSettingsObj.position === 'right' ? {
            right: 0,
            background: popupSettingsObj.content_bg_color
        } : {left: 0, background: popupSettingsObj.content_bg_color}}>
                <div className="lynked-reward--header" style={{background: `${popupSettingsObj.header_bg_color}`}}>
                    <div className="lynked-point-back--wrapper">
                        <button className="lynked-reward-back" style={{backgroundColor: popupSettingsObj.header_label_color}} onClick={clickBack}>
                            <Arrow color={popupSettingsObj.header_title_color}/>
                        </button>
                        {isLogin ?
                            lynkedLogin ?
                                <h4 className="lynked-pointsBlock" style={{color: `${popupSettingsObj.header_title_color}`}}>Your
                                    Lynked Loyalty
                                    points: {points}</h4> :
                                <h4 style={{color: `${popupSettingsObj.header_title_color}`}}>{decodeHTMLEntities(shopName)}</h4>
                            : <h4 style={{color: `${popupSettingsObj.header_title_color}`}}>{decodeHTMLEntities(shopName)}</h4>
                        }
                    </div>
                </div>

                <div className="lynked-reward-content--wrapper">
                    {type === 'earn' && <WaysToEarn popupSettingsObj={popupSettingsObj}/>}
                    {type === 'redeem' && <WaysToRedeem popupSettingsObj={popupSettingsObj}/>}
                    {type === 'vouchers' &&
                        <Rewards popupSettingsObj={popupSettingsObj} />}
                    {type === 'voucherInfo' &&
                        <VoucherInfo popupSettingsObj={popupSettingsObj} />}
                    {type === 'download' && <Download popupSettingsObj={popupSettingsObj} isLogin={isLogin}/>}
                    {type === 'activity' &&
                        <PointsActivity popupSettingsObj={popupSettingsObj} />}

                </div>
                {isLogin ?
                    <div className="lynked-reward-footer" style={{background: popupSettingsObj.footer_bg_color}}>
                        <p className="lynked-card-description" style={{color: popupSettingsObj.footer_text_color, margin: 0}}>We reward
                            with Lynked Loyalty</p>
                    </div>
                    : <div className="lynked-info--footer" style={{background: popupSettingsObj.content_item_bg}}>
                        <a href={popupSettingsObj.lynked_register_url} className="lynked-joinNow"
                           style={{color: popupSettingsObj.content_text_color, background: popupSettingsObj.header_icon_color}}>Join
                            now</a>
                        <p className="lynked-card-description" style={{color: popupSettingsObj.content_text_color, margin: 0}}>Already
                            have an account?
                            <a href={popupSettingsObj.lynked_login_url} style={{color: popupSettingsObj.footer_bg_color}}>Sign
                                in</a>
                        </p>
                    </div>
                }
        </div>
    )
};

export default ModalDetails;
