const earnInfo = [
    {
        title: 'How to earn points online',
        description: 'Log into your account online using the same email as your Lynked app. Earn points as you spend—both in-store and online. Your points and rewards will automatically update in your Lynked app.',
    }, {
        title: 'How to earn points in store',
        description: 'Earn points in-store with your Lynked Loyalty app. Simply present your in-app barcode at checkout, and a staff member will scan it to add points to your account for every purchase.',
    },
]

const WaysToEarn = ({popupSettingsObj}) => {
    return (
        <div className="lynked-waysToEarn lynked-activeWays" style={{backgroundColor: popupSettingsObj.content_item_bg}}>
            <div className="lynked-title" style={{color: popupSettingsObj.content_text_color}}>Ways to earn points:</div>
            <div className="lynked-reward-content-description-wrapper">
                {earnInfo.map((item, i) => <div key={i} className={i === earnInfo.length - 1 ? "lynked-info--wrapper lynked-info--wrapper-last ": "lynked-info--wrapper"}>
                    <div className="lynked-order-info">
                        <div className={'lynked-order-info-number'} style={{backgroundColor: popupSettingsObj.footer_bg_color, color: popupSettingsObj.content_bg_color}}>{i+1}</div>
                        <p className={'lynked-order-info-title'} style={{color: popupSettingsObj.content_text_color}}>{item.title}</p>
                    </div>
                    <p className="lynked-points" style={{color: popupSettingsObj.content_text_color}}>{item.description} </p>
                </div>)}
            </div>
        </div>
    );
};

export default WaysToEarn;
