import {useEffect, useState} from "react";
import {useDispatch, useSelector} from "react-redux";

import {Success} from "../../../shared/icons/success";
import {generalSelector, rewardsSelector} from "../../../store/selectors";
import {Copy} from "../../../shared/icons/copy";
import Title from "../../Title";
import {VoucherIcon} from "../../../shared/icons/voucherIcon";
import {fetchCreateDiscount} from "../../../store/reducers/rewards/rewardsThunksAction";
import {setIsShow, setIsSuccessAdd} from "../../../store/reducers/rewards/rewardsSlice";

import "./styles.scss";

const VoucherInfo = ({popupSettingsObj}) => {
    const [isSuccess, setIsSuccess] = useState(false);
    const {activeReward, isShow, isSuccessAdd} = useSelector(rewardsSelector);
    const {currency} = useSelector(generalSelector);
    const dispatch = useDispatch();

    let activateTime = '';

    const { activated_after_day, activated_after_hour, code, reward, is_active} = activeReward;

    if (activated_after_day) {
        activateTime = activated_after_day > 1 ? ` ${activated_after_day} days` : 'a day';
    } else {
        activateTime = ` ${activated_after_hour} hour${activated_after_hour > 1 ? 's' : ''}`
    }

    const copyCode = () => {
        navigator.clipboard.writeText(code).then(r => {
            setIsSuccess(true);
            applyVoucher();

            const time = setTimeout(() => {
                setIsSuccess(false);
                clearTimeout(time);
            }, 1500);
        });
    }

    const applyVoucher = (isAdd) => {
        if (isAdd) {
            dispatch(setIsShow(true));
        }
        dispatch(fetchCreateDiscount({
            shop: window.location.hostname,
            code,
            reward,
            isAdd: !!isAdd
        })).then(()=> {
            if(window.location.href.includes("cart") || window.location.href.includes('checkout')) {
                !!isAdd && window.location.reload();
            }
        })
    }

    useEffect(() => {
        if(isSuccessAdd) {
            const id = setTimeout(() => {
                dispatch(setIsSuccessAdd(false));
                clearTimeout(id);
            }, 300);
        }
    }, isSuccessAdd)

    return (
        <div className="lynked-voucher-inside" style={{backgroundColor: popupSettingsObj.content_item_bg}}>
            <div className="lynked-reward-content-description-wrapper">
                <div className="lynked-pointWays" style={{border: `1px solid ${popupSettingsObj.footer_bg_color}`}}>
                    <div className="lynked-pointsWays-item" style={{backgroundColor: popupSettingsObj.header_bg_color}}>
                        <div className="lynked-pointsWays-icon" style={{backgroundColor: popupSettingsObj.header_icon_color}}><VoucherIcon color={popupSettingsObj.header_bg_color}/></div>
                        <div>
                            <Title text={`${currency}${reward} voucher`} color={popupSettingsObj.header_title_color}/>
                        </div>
                    </div>
                </div>
                {is_active ?
                    <div>
                        <div className="lynked-card-description lynked-discount-expl" style={{color: popupSettingsObj.content_text_color}}>
                            Apply this discount code at checkout!
                        </div>
                        <div className="lynked-copy-code--wrapper">
                            <input type="text" readOnly className="lynked-copy-code--input" value={code}/>
                            <button className="lynked-system-btn" onClick={copyCode}>
                                {isSuccess ? <Success color={popupSettingsObj.content_text_color}/> : <Copy color={popupSettingsObj.content_text_color}/>}
                            </button>
                        </div>
                        <div className="lynked-apply-voucher--btn" style={{background: popupSettingsObj.header_icon_color}} onClick={applyVoucher}>
                            {isShow && isSuccessAdd
                                ? <Success color={popupSettingsObj.content_text_color}/> : isShow
                                    ? <div className="lynked-lds-ring">
                                        <div></div>
                                        <div></div>
                                        <div></div>
                                        <div></div>
                                    </div>
                                    : <span style={{color: popupSettingsObj.content_text_color}}>Apply voucher</span>
                            }
                        </div>
                    </div>
                    : <div className="lynked-apply-voucher--btn lynked-inactive-voucher"
                           style={{color: popupSettingsObj.content_text_color, background: popupSettingsObj.header_icon_color}}>Will activate in {activateTime}</div>
                }
            </div>
        </div>
    );
};

export default VoucherInfo;
