import VouchersList from "../../VouchersList";
import {useSelector} from "react-redux";
import {rewardsSelector} from "../../../store/selectors";

const Rewards = ({popupSettingsObj}) => {
    const {vouchers} = useSelector(rewardsSelector);

    const activeVouchers = [];
    const inactiveVouchers = vouchers.reduce((acc, points) => {
        if (points.is_active) {
            activeVouchers.push(points);
        } else {
            acc.push(points);
        }

        return acc;
    }, []);

    return (
        <div className="lynked-vouchers lynked-activeWays" style={{backgroundColor: popupSettingsObj.content_item_bg}}>
            <div className="lynked-title" style={{color: popupSettingsObj.content_text_color}}>Your rewards:</div>
            <div className="lynked-reward-content-description-wrapper">
                {!!activeVouchers.length && <VouchersList vouchers={activeVouchers} popupSettingsObj={popupSettingsObj}/>}
                {!!inactiveVouchers.length && <VouchersList vouchers={inactiveVouchers} popupSettingsObj={popupSettingsObj}/>}
            </div>
        </div>    );
};

export default Rewards;
