import {VoucherIcon} from "../../../../shared/icons/voucherIcon";
import {Arrow} from "../../../../shared/icons/arrow";
import Title from "../../../Title";
import {useDispatch, useSelector} from "react-redux";
import {setType} from "../../../../store/reducers/general/generalSlice";
import {setActiveReward} from "../../../../store/reducers/rewards/rewardsSlice";
import {generalSelector} from "../../../../store/selectors";

const Voucher = ({voucher, popupSettingsObj}) => {
    const {reward} = voucher;
    const dispatch = useDispatch();
    const {currency} = useSelector(generalSelector);

    const handleClick = () => {
        dispatch(setType("voucherInfo"));
        dispatch(setActiveReward(voucher));
    }

    return (
        <div className="lynked-pointWays" style={{border: `1px solid ${popupSettingsObj.footer_bg_color}`}} onClick={handleClick}>
            <div className="lynked-pointsWays-item" style={{backgroundColor: popupSettingsObj.header_bg_color}}>
                <div className="lynked-pointsWays-icon" style={{backgroundColor: popupSettingsObj.header_icon_color}}><VoucherIcon color={popupSettingsObj.header_bg_color}/></div>
                <div>
                    <Title text={`${currency}${reward} voucher`} color={popupSettingsObj.header_title_color}/>
                </div>
            </div>
            <div className="lynked-pointsWays-arrow" style={{backgroundColor: popupSettingsObj.footer_bg_color}}>
                <Arrow color={popupSettingsObj.footer_text_color}/>
            </div>

        </div>
    )
}

export default Voucher;
