import {useSelector} from "react-redux"
    ;
import PointActivity from "./PointActivity";
import {rewardsSelector} from "../../../store/selectors";

const PointsActivity = ({popupSettingsObj}) => {
    const {activities} = useSelector(rewardsSelector)

    return (
        <div className={'lynked-points-activity'} style={{backgroundColor: popupSettingsObj.content_item_bg}}>
            <div className="lynked-title" style={{color: popupSettingsObj.content_text_color}}>Points activity</div>
            <div className="lynked-balance-block" style={{color: popupSettingsObj.content_text_color}}>
                Your points balance may not reflect your latest activity
            </div>
            <div className="lynked-points-list">
                {activities.map((activity, i) => <PointActivity key={i} {...activity} popupSettingsObj={popupSettingsObj} />) }
            </div>
        </div>

    );
};

export default PointsActivity;
