import {useSelector} from "react-redux";
import {generalSelector} from "../../../../store/selectors";

const PointActivity = ({point_add, point, date, time, vouchers, popupSettingsObj}) => {
    const {currency} = useSelector(generalSelector);

    return (
        <div className="lynked-point-item" style={{backgroundColor: popupSettingsObj.content_bg_color}}>
            <div className="lynked-activity-info">
                <div className="lynked-pointCount-item">
                    <span className="lynked-order-info" style={{color: popupSettingsObj.content_text_color}}>Placed an order</span>
                    {
                        point_add && <span className={'lynked-points-add'} style={{color: popupSettingsObj.content_text_color, backgroundColor: popupSettingsObj.header_icon_color}}>+{point} Points</span>
                    }
                </div>
                <div className={'lynked-point-item-date'} style={{color: popupSettingsObj.content_text_color}}>
                    <p className="lynked-time">{time}</p>
                    <p className="lynked-date">{date}</p>
                </div>
            </div>
            {vouchers && vouchers.length > 0 && vouchers.map((voucher, i) => <span className={'lynked-used-voucher'}
                style={{color: popupSettingsObj.content_text_color}}
                key={`${voucher.reward}-${i}`}>{currency}{voucher.reward} voucher used</span>)}
        </div>
    );
};

export default PointActivity;
