import ios from "../../../shared/img/ios.png"
import android from "../../../shared/img/android.png"

const description = ["Download Lynked Loyalty for iOS/Android.", "Create an account on the Lynked app with the same email used when shopping online.", "Log into your online shopping Lynked account.", "Ensure your online shopping email matches your Lynked iOS/Android app email. This is to ensure your online and instore loyalty profiles are connected.", "Now you can track & collect points online & in store."];

const Download = ({popupSettingsObj, isLogin}) => {
    return (
        <div className={isLogin ? "lynked-download lynked-download-isLogin" : "lynked-download"}
             style={{backgroundColor: popupSettingsObj.content_item_bg}}>
            <div className="lynked-title" style={{color: popupSettingsObj.content_text_color}}>Download Lynked on:</div>
            <div className="lynked-reward-content-description-wrapper">
                <div className="lynked-download--wrapper">
                    <a target="_blank" style={{color: popupSettingsObj.content_text_color}}
                       href="https://apps.apple.com/ua/app/lynked-loyalty/id1513972594">
                        <img src={ios} alt="Download Lynked app on IOS"/>
                    </a>
                    <a target="_blank" style={{color: popupSettingsObj.content_text_color}}
                       href="https://play.google.com/store/apps/details?id=com.lynkedreactnative">
                        <img src={android} alt="Download Lynked app on Android"/>
                    </a>
                </div>
                {description.map((desc, i) => <div key={i}
                                                   className={i === description.length - 1 ? "lynked-card-description lynked-card-description-last" : "lynked-card-description"}>
                    <div className={'lynked-card-description-number'} style={{
                        backgroundColor: popupSettingsObj.footer_bg_color,
                        color: popupSettingsObj.footer_text_color,
                    }}> {i + 1}</div>
                    <p className={'lynked-card-description-text'} style={{color: popupSettingsObj.content_text_color}}>{desc}</p>
                </div>)}
            </div>
        </div>
    );
};

export default Download;
