import {useDispatch, useSelector} from "react-redux";

import {Activity} from "../../shared/icons/activity";
import {Redeem} from "../../shared/icons/redeem";
import {Earn} from "../../shared/icons/earn";
import DownloadApp from "../DownloadApp";
import Title from "../Title";
import PointWay from "../PointWay";
import {Arrow} from "../../shared/icons/arrow";
import {generalSelector, rewardsSelector} from "../../store/selectors";

import "./styles.scss";
import {setType} from "../../store/reducers/general/generalSlice";
import {ModalLogo} from "../../shared/icons/modalLogo";
import {YourVoucherBtnIcon} from "../../shared/icons/yourVoucherBtnIcon";
import {DownloadIcon} from "../../shared/icons/download";

const Modal = ({isLogin, lynkedLogin, openModal, popupSettingsObj}) => {
    const dispatch = useDispatch();
    const {points, vouchers, points_reward} = useSelector(rewardsSelector);
    const {shopName} = useSelector(generalSelector);
    const {rewardCount} = useSelector(rewardsSelector);

    const handleCLick = (type) => {
        dispatch(setType(type));
    }

    function decodeHTMLEntities(text) {
        const textarea = document.createElement("textarea");
        textarea.innerHTML = text;
        return textarea.value;
    }

    return (
        <div className="lynked-reward-block lynked-main-reward-block lynked-view-block" style={popupSettingsObj.position === 'right' ? {
            right: 0,
            background: popupSettingsObj.content_bg_color
        } : {left: 0, background: popupSettingsObj.content_bg_color}}>
            <div className="lynked-reward--header" style={{background: `${popupSettingsObj.header_bg_color}`}}>
                {isLogin ?
                    lynkedLogin ?
                        <div>
                            <h4 style={{color: `${popupSettingsObj.header_label_color}`}}>Your {decodeHTMLEntities(shopName)} points!</h4>
                            <div className="lynked-point-logo-wrapper">
                                <h2 className="lynked-pointsBlock"
                                    style={{color: `${popupSettingsObj.header_title_color}`}}>{points}</h2>
                                <ModalLogo color={popupSettingsObj.header_icon_color}/>
                            </div>
                            <h4 className={'lynked-points-reward'}
                                style={{color: `${popupSettingsObj.header_title_color}`}}>Collect {points_reward} points to
                                unlock your next reward!</h4>
                        </div>
                        : <div>
                            <h4 style={{color: `${popupSettingsObj.header_label_color}`, marginTop: 0}}>Welcome to</h4>
                            <div className="lynked-point-logo-wrapper">
                                <h2 style={{
                                    color: `${popupSettingsObj.header_title_color}`,
                                    marginTop: '8px'
                                }}>{decodeHTMLEntities(shopName)}</h2>
                                <ModalLogo color={popupSettingsObj.header_icon_color}/>
                            </div>
                        </div>
                    :
                    <div>
                        <h4 style={{color: `${popupSettingsObj.header_label_color}`, marginTop: 0}}>Welcome to</h4>
                        <div className="lynked-point-logo-wrapper">
                            <h2 style={{
                                color: `${popupSettingsObj.header_title_color}`,
                                marginTop: '8px'
                            }}>{decodeHTMLEntities(shopName)}</h2>
                            <ModalLogo color={popupSettingsObj.header_icon_color}/>
                        </div>
                    </div>
                }
            </div>
            <div className="lynked-reward-content">
                <div className="lynked-reward-inside-block" style={{background: popupSettingsObj.content_bg_color}}>
                    {!isLogin || !lynkedLogin ?
                        <>
                            <div className="lynked-registration--wrapper"
                                 style={{background: popupSettingsObj.content_item_bg}}>
                                <div className="lynked-title" style={{color: popupSettingsObj.content_text_color}}>Join our loyalty
                                    program
                                </div>
                                <p className="lynked-card-description" style={{color: popupSettingsObj.content_text_color}}>Use Lynked
                                    Loyalty to collect rewards everytime you
                                    shop.</p>
                                <a href={`${popupSettingsObj.lynked_register_url}`} className="lynked-joinNow"
                                   style={{
                                       background: `${popupSettingsObj.header_icon_color}`,
                                       color: popupSettingsObj.content_text_color,
                                   }}>Join
                                    now</a>
                                <p className="lynked-card-description" style={{color: popupSettingsObj.content_text_color}}>Already have
                                    an
                                    account?<a
                                        href={`${popupSettingsObj.lynked_login_url}`}
                                        style={{color: `${popupSettingsObj.footer_bg_color}`}}>Sign in</a></p>
                            </div>
                        </>
                        : !!vouchers.length && <>
                        <div className="lynked-voucher--wrapper"
                             style={{background: popupSettingsObj.content_text_color}}>
                            {!!rewardCount && <div className="lynked-rewardCount lynked-rewardCountSmall">{rewardCount}</div>}
                            <div className="lynked-pointWays" onClick={() => handleCLick("vouchers")}>
                                <div className="lynked-vouchers-action-wrapper lynked-pointsWays-item-menu">
                                    <div className="lynked-pointsWays-icon"
                                         style={{backgroundColor: popupSettingsObj.content_bg_color}}>
                                        <YourVoucherBtnIcon color={popupSettingsObj.content_item_icon_color}/>
                                    </div>
                                    <Title text="Your vouchers" color={popupSettingsObj.content_bg_color}/>
                                </div>
                                <Arrow color={popupSettingsObj.content_bg_color}/>
                            </div>
                        </div>
                    </>
                    }
                    <div className="lynked-pointWays--wrapper">
                        <DownloadApp text="Download Lynked for iOS/Android" textColor={popupSettingsObj.content_text_color}
                                     iconBg={popupSettingsObj.content_bg_color} bgColor={popupSettingsObj.content_item_bg}
                                     arrowColor={popupSettingsObj.content_text_color}
                                     icon={<DownloadIcon color={popupSettingsObj.content_item_icon_color}/>}
                                     handlerClick={handleCLick}/>
                        <PointWay text="How to earn points" type="earn" textColor={popupSettingsObj.content_text_color}
                                  iconBg={popupSettingsObj.content_bg_color} bgColor={popupSettingsObj.content_item_bg}
                                  arrowColor={popupSettingsObj.content_text_color}
                                  icon={<Earn color={popupSettingsObj.content_item_icon_color}/>}
                                  onCLick={handleCLick}/>
                        <PointWay text="How to redeem rewards" textColor={popupSettingsObj.content_text_color}
                                  iconBg={popupSettingsObj.content_bg_color} bgColor={popupSettingsObj.content_item_bg}
                                  arrowColor={popupSettingsObj.content_text_color} type="redeem"
                                  icon={<Redeem color={popupSettingsObj.content_item_icon_color}/>} onCLick={handleCLick}/>

                        {isLogin && lynkedLogin &&
                            <PointWay text="Your activity" textColor={popupSettingsObj.content_text_color}
                                      iconBg={popupSettingsObj.content_bg_color} bgColor={popupSettingsObj.content_item_bg}
                                      arrowColor={popupSettingsObj.content_text_color}
                                      icon={<Activity color={popupSettingsObj.content_item_icon_color}/>} onCLick={handleCLick}
                                      type="activity"/>

                        }
                    </div>
                </div>
            </div>
            {isLogin && <div className="lynked-reward-footer" style={{background: popupSettingsObj.footer_bg_color}}>
                <p className="lynked-card-description" style={{color: popupSettingsObj.footer_text_color, margin: 0}}>We reward with
                    Lynked
                    Loyalty</p>
            </div>}

        </div>
    );
};

export default Modal;
