import React from 'react';
import {Arrow} from "../../shared/icons/arrow";
import Title from "../Title";

const DownloadApp = ({text, icon, handlerClick, textColor, bgColor, iconBg, arrowColor}) => {

    return (
        <div className="lynked-pointWays" style={{backgroundColor: `${bgColor}`}} onClick={() => handlerClick("download")}>
            <div className="lynked-pointsWays-item lynked-pointsWays-item-menu">
                <div className="lynked-pointsWays-icon" style={{backgroundColor: iconBg}}>
                    {icon}
                </div>

                <Title text={text} color={textColor}/>
            </div>
            <Arrow color={arrowColor}/>
        </div>
    );
};

export default DownloadApp;
