import {Provider} from "react-redux";

import Dashboard from "./Dashboard/Dashboard";
import {store} from "./store";
import {useEffect, useState} from "react";
import axios from "axios";

const App = () => {
    const [popupSettingsObj, setPopupSettingsObj] = useState({
        header_bg_color: '#2E4B4E',
        header_label_color: '#6CA6AA',
        header_icon_color: '#EDF403',
        header_title_color: '#ffffff',
        content_item_bg: '#ffffff',
        content_item_icon_color: '#2E4B4E',
        footer_bg_color: '#6CA6AA',
        content_text_color: '#2E4B4E',
        content_bg_color: '#E1EFF0',
        footer_text_color: '#E1EFF0',
        lynked_login_url: '',
        lynked_register_url: '',
        position: 'right'
    });

    const getModalColors = () => {
        axios.get('/wp-json/lynked/lynked-plugin-settings-get').then(res=>{
            const settings = {
                header_bg_color: res.data.settings.header_bg_color ?? '#2E4B4E',
                header_label_color: res.data.settings.header_label_color ?? '#6CA6AA',
                header_icon_color: res.data.settings.header_icon_color ?? '#EDF403',
                header_title_color: res.data.settings.header_title_color ?? '#ffffff',
                content_item_bg: res.data.settings.content_item_bg ?? '#ffffff',
                content_item_icon_color: res.data.settings.content_item_icon_color ?? '#2E4B4E',
                footer_bg_color: res.data.settings.footer_bg_color ?? '#6CA6AA',
                content_text_color: res.data.settings.content_text_color ?? '#2E4B4E',
                content_bg_color: res.data.settings.content_bg_color ?? '#E1EFF0',
                footer_text_color: res.data.settings.footer_text_color ?? '#E1EFF0',
                lynked_login_url: res.data.settings.lynked_login_url ?? res.data.default_login_url,
                lynked_register_url: res.data.settings.lynked_register_url ?? res.data.default_login_url,
                position: res.data.settings.position ?? 'right',
            }

            setPopupSettingsObj(settings)
        })
    }
    useEffect(() => {
        getModalColors()
    }, []);
    return (
        <div>
            <Provider store={store}>
                <Dashboard popupSettingsObj={popupSettingsObj}/>
            </Provider>
        </div>
    );
}

export default App;
