import logo from "../shared/img/logo.png";
import Step from "../components/Step";

import "./styles.scss";
import Login from "../components/Login";
import {useEffect, useState} from "react";
import axios from "axios";
import {ModalLogo} from "../shared/icons/modalLogo";
import PointWay from "../components/PointWay";
import {Earn} from "../shared/icons/earn";
import {Redeem} from "../shared/icons/redeem";
import {ModalOpenBtnIcon} from "../shared/icons/modalOpenBtnIcon";

const collectRewards = ["When checking out through your Shopify payment gateway customers need to create a customer account with your business.(or log into their existing customer account)", "The customer online account, and Lynked Loyalty app must use the same email address - this is what connects your store to a particular customer account allowing customers to collect points online and in your store.", "When a customer logs in to their account on your website with their email that matches their Lynked account, they will collect 1 point for every €/£/$ they spend online.", "Their points will be added to their Lynked Loyalty customer app on their mobile device which they can also use to collect points in your store."]

const Admin = () => {
    const [saved, setSaved] = useState(false)
    const [usingGF, setUsingGF] = useState(false)
    const [selectListFormId, setSelectListFormId] = useState([]);
    const [selectListFormFields, setSelectListFormFields] = useState([]);
    const [popupSettingsObj, setPopupSettingsObj] = useState({
        header_bg_color: '#2E4B4E',
        header_label_color: '#6CA6AA',
        header_icon_color: '#EDF403',
        header_title_color: '#ffffff',
        content_item_bg: '#ffffff',
        content_item_icon_color: '#2E4B4E',
        footer_bg_color: '#6CA6AA',
        content_text_color: '#2E4B4E',
        content_bg_color: '#E1EFF0',
        footer_text_color: '#E1EFF0',
        lynked_login_url: '',
        lynked_register_url: '',
        gf_form_id: '',
        gf_form_field: '',
        position: 'right'
    });

    const changePopupSettings = (key, value) => {
        setPopupSettingsObj({...popupSettingsObj, [key]: value});
    }

    const setModalColors = () => {
        axios.post('/wp-json/lynked/lynked-plugin-settings-save', popupSettingsObj).then(res => {
            setSaved(true)
            getModalColors()
            setTimeout(() => {
                setSaved(false)
            }, 3000)
        })
    }

    const getModalColors = () => {
        axios.get('/wp-json/lynked/lynked-plugin-settings-get').then(async res => {
            if (usingGF) {
                await res.data.settings.gf_form_id ? getAllForms() : null
            }
            const settings = {
                header_bg_color: res.data.settings.header_bg_color ?? '#2E4B4E',
                header_label_color: res.data.settings.header_label_color ?? '#6CA6AA',
                header_icon_color: res.data.settings.header_icon_color ?? '#EDF403',
                header_title_color: res.data.settings.header_title_color ?? '#ffffff',
                content_item_bg: res.data.settings.content_item_bg ?? '#ffffff',
                content_item_icon_color: res.data.settings.content_item_icon_color ?? '#2E4B4E',
                footer_bg_color: res.data.settings.footer_bg_color ?? '#6CA6AA',
                content_text_color: res.data.settings.content_text_color ?? '#2E4B4E',
                content_bg_color: res.data.settings.content_bg_color ?? '#E1EFF0',
                footer_text_color: res.data.settings.footer_text_color ?? '#E1EFF0',
                lynked_login_url: res.data.settings.lynked_login_url ?? res.data.default_login_url,
                lynked_register_url: res.data.settings.lynked_register_url ?? res.data.default_login_url,
                position: res.data.settings.position ?? 'right',
                gf_form_id: res.data.settings.gf_form_id ?? '',
                gf_form_field: res.data.settings.gf_form_field ?? '',
            }

            setPopupSettingsObj(settings)
        })
    }
    const isConnectedGravityForm = () => {
        axios.get('/wp-json/lynked/gf-info').then(res => {
            setUsingGF(res.data.exist)
            res.data.exist ? getAllForms() : null
        })
    }
    const getAllForms = () => {
        axios.get('/wp-json/lynked/gf-forms').then(res => {
            setSelectListFormId(res.data.forms.map(form => {
                return {value: form.id, label: form.title}
            }))
        })
    }

    const getAllFormsFields = (id) => {
        axios.get(`/wp-json/lynked/gf-fields?form_id=${id}`).then(res => {
            setSelectListFormFields(res.data.fields.map(field => {
                return field.inputs.map(inputs => {
                    return {value: inputs.id, label: inputs.label}
                })
            }).flat())
        })
    }

    const changeFormId = (id) => {
        changePopupSettings('gf_form_id', id)
        id && getAllFormsFields(id)
    }
    const changeFormField = (id) => {
        changePopupSettings('gf_form_field', id)
    }

    useEffect(() => {
        getAllFormsFields(popupSettingsObj.gf_form_id)
    }, [popupSettingsObj.gf_form_id])

    useEffect(() => {
        getModalColors()
        isConnectedGravityForm()
    }, []);

    return (
        <div>
            <div className="header">
                <img src={`${logo}`} alt="Lynked" className="lynked-logo"/>
            </div>

            <h2 className="lynked-title">Welcome to Lynked Loyalty</h2>
            <h3 className="title-h3 subtitle">Omnichannel customer loyalty for your business.</h3>

            <div className="lynked-description ">
                Connect your physical store and e-commerce customer loyalty programs together with Lynked loyalty. Your
                customers can collect loyalty rewards on their mobile device by shopping in your store and through your
                website.
            </div>

            <div className="setupInstruction--wrapper">
                <h3 className="title-h3">Setup Instruction</h3>
                <h4 className="title-h4 ">Let`s get started by following this guide</h4>

                <Step stepNumber={1}
                      description="To connect your e-commerce store to Lynked Loyalty, log in to your Lynked account below. You will be redirected to the Lynked dashboard where you manage your entire loyalty program, including in-store and e-comerce customers."/>

                <h3 className="title-h3 collect">How do customers collect rewards?</h3>

                <ol>
                    <li>Existing or new customers can download Lynked Loyalty for
                        <a className="link" target="_blank"
                           href="https://apps.apple.com/ua/app/lynked-loyalty/id1513972594">iOS</a>/<a
                            className="link withoutSpace" target="_blank"
                            href="https://play.google.com/store/apps/details?id=com.lynkedreactnative">Android</a> and
                        create an account.
                    </li>
                    {collectRewards.map((description, i) => {
                        return <li className="description" key={i}>{description}</li>;
                    })}
                </ol>
            </div>
            <div className="settings--popup">
                <h3 className="title-h3">Setting your Lynked PopUp</h3>
                <div className="settings--container">
                    <div className="settings--form">
                        <div className="colors-settings">
                            <div className="header-colors">
                                <h3 className="title-h3">Pop-up Header Colors settings</h3>
                                <div className="field-wrap">
                                    <div className="label">Select Header Background Color</div>
                                    <div className="color--inputs-wrap">
                                        <input type="color" className={'color-input'} value={popupSettingsObj.header_bg_color}
                                               onChange={e => changePopupSettings('header_bg_color', e.target.value)}/>
                                        <input className={'color-input'} style={{padding: '0 5px', marginLeft: '15px'}}
                                               type="text" value={popupSettingsObj.header_bg_color}
                                               onChange={e => changePopupSettings('header_bg_color', e.target.value)}/>
                                    </div>
                                </div>
                                <div className="field-wrap">
                                    <div className="label">Select Header Label Color
                                    </div>
                                    <div className="color--inputs-wrap">
                                        <input type="color" className={'color-input'}
                                               value={popupSettingsObj.header_label_color}
                                               onChange={e => changePopupSettings('header_label_color', e.target.value)}/>
                                        <input className={'color-input'} style={{padding: '0 5px', marginLeft: '15px'}}
                                               type="text" value={popupSettingsObj.header_label_color}
                                               onChange={e => changePopupSettings('header_label_color', e.target.value)}/>
                                    </div>
                                </div>
                                <div className="field-wrap">
                                    <div className="label">Select Header Title Color
                                    </div>
                                    <div className="color--inputs-wrap">
                                        <input type="color" className={'color-input'}
                                               value={popupSettingsObj.header_title_color}
                                               onChange={e => changePopupSettings('header_title_color', e.target.value)}/>
                                        <input className={'color-input'} style={{padding: '0 5px', marginLeft: '15px'}}
                                               type="text" value={popupSettingsObj.header_title_color}
                                               onChange={e => changePopupSettings('header_title_color', e.target.value)}/>
                                    </div>
                                </div>
                                <div className="field-wrap">
                                    <div className="label">Select Header Icon Color</div>
                                    <div className="color--inputs-wrap">
                                        <input type="color" className={'color-input'} value={popupSettingsObj.header_icon_color}
                                               onChange={e => changePopupSettings('header_icon_color', e.target.value)}/>
                                        <input className={'color-input'} style={{padding: '0 5px', marginLeft: '15px'}}
                                               type="text" value={popupSettingsObj.header_icon_color}
                                               onChange={e => changePopupSettings('header_icon_color', e.target.value)}/>
                                    </div>
                                </div>
                            </div>
                            <div className="main-colors">
                                <h3 className="title-h3">Pop-up Content Colors settings</h3>
                                <div className="field-wrap">
                                    <div className="label">Select Content Text Color</div>
                                    <div className="color--inputs-wrap">
                                        <input type="color" className={'color-input'} value={popupSettingsObj.content_text_color}
                                               onChange={e => changePopupSettings('content_text_color', e.target.value)}/>
                                        <input className={'color-input'} style={{padding: '0 5px', marginLeft: '15px'}}
                                               type="text" value={popupSettingsObj.content_text_color}
                                               onChange={e => changePopupSettings('content_text_color', e.target.value)}/>
                                    </div>
                                </div>
                                <div className="field-wrap">
                                    <div className="label">Select Content Background Color
                                    </div>
                                    <div className="color--inputs-wrap">
                                        <input type="color" className={'color-input'}
                                               value={popupSettingsObj.content_bg_color}
                                               onChange={e => changePopupSettings('content_bg_color', e.target.value)}/>
                                        <input className={'color-input'} style={{padding: '0 5px', marginLeft: '15px'}}
                                               type="text" value={popupSettingsObj.content_bg_color}
                                               onChange={e => changePopupSettings('content_bg_color', e.target.value)}/>
                                    </div>
                                </div>
                                <div className="field-wrap">
                                    <div className="label">Select Content Menu Button Background Color</div>
                                    <div className="color--inputs-wrap">
                                        <input type="color" className={'color-input'} value={popupSettingsObj.content_item_bg}
                                               onChange={e => changePopupSettings('content_item_bg', e.target.value)}/>
                                        <input className={'color-input'} style={{padding: '0 5px', marginLeft: '15px'}}
                                               type="text" value={popupSettingsObj.content_item_bg}
                                               onChange={e => changePopupSettings('content_item_bg', e.target.value)}/>
                                    </div>
                                </div>
                                <div className="field-wrap">
                                    <div className="label">Select Content Menu Button Icon Color</div>
                                    <div className="color--inputs-wrap">
                                        <input type="color" className={'color-input'}
                                               value={popupSettingsObj.content_item_icon_color}
                                               onChange={e => changePopupSettings('content_item_icon_color', e.target.value)}/>
                                        <input className={'color-input'} style={{padding: '0 5px', marginLeft: '15px'}}
                                               type="text" value={popupSettingsObj.content_item_icon_color}
                                               onChange={e => changePopupSettings('content_item_icon_color', e.target.value)}/>
                                    </div>
                                </div>
                                <div className="field-wrap">
                                    <div className="label">Select Footer Background Color</div>
                                    <div className="color--inputs-wrap">
                                        <input type="color" className={'color-input'}
                                               value={popupSettingsObj.footer_bg_color}
                                               onChange={e => changePopupSettings('footer_bg_color', e.target.value)}/>
                                        <input className={'color-input'} style={{padding: '0 5px', marginLeft: '15px'}}
                                               type="text" value={popupSettingsObj.footer_bg_color}
                                               onChange={e => changePopupSettings('footer_bg_color', e.target.value)}/>
                                    </div>
                                </div>
                                <div className="field-wrap">
                                    <div className="label">Select Footer Text Color</div>
                                    <div className="color--inputs-wrap">
                                        <input type="color" className={'color-input'}
                                               value={popupSettingsObj.footer_text_color}
                                               onChange={e => changePopupSettings('footer_text_color', e.target.value)}/>
                                        <input className={'color-input'} style={{padding: '0 5px', marginLeft: '15px'}}
                                               type="text" value={popupSettingsObj.footer_text_color}
                                               onChange={e => changePopupSettings('footer_text_color', e.target.value)}/>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div className="field-wrap">
                            <div className="label">Select PopUp position</div>
                            <div className="input-wrap" onClick={() => changePopupSettings('position', 'right')}>
                                <input type="radio" name={'position'} checked={popupSettingsObj.position === 'right'}
                                       value={'right'}
                                       onChange={e => changePopupSettings('position', e.target.value)}/>
                                <p>Bottom Right</p>
                            </div>
                            <div className="input-wrap" onClick={() => changePopupSettings('position', 'left')}>
                                <input type="radio" name={'position'} checked={popupSettingsObj.position === 'left'}
                                       value={'left'}
                                       onChange={e => changePopupSettings('position', e.target.value)}/>
                                <p>Bottom Left</p>
                            </div>
                        </div>
                        <div className="field-wrap">
                            <div className="label">Enter Your Join Now Url</div>
                            <div className="color--inputs-wrap">
                                <input type="text" style={{width: '50%'}} value={popupSettingsObj.lynked_register_url}
                                       onChange={(e) => {
                                           changePopupSettings('lynked_register_url', e.currentTarget.value)
                                       }}/>

                            </div>
                        </div>
                        <div className="field-wrap">
                            <div className="label">Enter Your Sign In Url</div>
                            <div className="color--inputs-wrap">

                                <input type="text" style={{width: '50%'}} value={popupSettingsObj.lynked_login_url}
                                       onChange={(e) => {
                                           changePopupSettings('lynked_login_url', e.currentTarget.value)
                                       }}/>
                            </div>
                        </div>
                        {usingGF ? (<>
                            <div className="field-wrap">
                                <div className="label">Select Your Form ID</div>
                                <div className="color--inputs-wrap">
                                    <select value={popupSettingsObj.gf_form_id}
                                            onChange={(e) => changeFormId(e.target.value)}>
                                        <option selected key={0} value={''}>Select Form Id</option>
                                        {selectListFormId.map(form => <option key={form.value}
                                                                              value={form.value}>{form.label}</option>)}
                                    </select>
                                </div>
                            </div>
                            <div className="field-wrap">
                                <div className="label">Select Your Field ID</div>
                                <div className="color--inputs-wrap">
                                    <select value={popupSettingsObj.gf_form_field}
                                            onChange={(e) => changeFormField(e.target.value)}>
                                        <option selected key={0} value={''}>Select Field Id</option>
                                        {selectListFormFields.map(form => <option key={form.value}
                                                                                  value={form.value}>{form.label}</option>)}
                                    </select>
                                </div>
                            </div>
                        </>) : null}
                    </div>
                    <div className="popup--show">
                        <div className="lynked-reward-block main-reward-block lynked-view-block"
                             style={popupSettingsObj.position === 'right' ? {
                                 right: 0,
                                 background: popupSettingsObj.content_bg_color
                             } : {
                                 left: 0,
                                 background: popupSettingsObj.content_bg_color
                             }}>
                            <div className="lynked-reward--header" style={{background: `${popupSettingsObj.header_bg_color}`}}>
                                <div className="closeModal">
                                    <ModalLogo color={popupSettingsObj.header_icon_color}/>
                                </div>
                                <div>
                                    <h4 style={{color: `${popupSettingsObj.header_label_color}`}}>Your Shop Name points!</h4>
                                    <div className="lynked-point-logo-wrapper">
                                        <h2 className="pointsBlock"
                                            style={{color: `${popupSettingsObj.header_title_color}`}}>20</h2>

                                    </div>
                                </div>
                            </div>
                            <div className="lynked-reward-content">
                                <div className="lynked-reward-inside-block">
                                    <div className="lynked-pointWays--wrapper">
                                        <PointWay text="How to earn points" type="earn"
                                                  icon={<Earn color={popupSettingsObj.content_item_icon_color}/>}
                                                  iconBg={popupSettingsObj.content_bg_color}
                                                  arrowColor={popupSettingsObj.content_text_color}
                                                  onCLick={() => {
                                                  }}
                                                  textColor={popupSettingsObj.content_text_color}
                                                  bgColor={popupSettingsObj.content_item_bg}/>
                                        <PointWay text="How to redeem rewards" iconBg={popupSettingsObj.content_bg_color}
                                                  type="redeem" icon={<Redeem color={popupSettingsObj.content_item_icon_color}/>}
                                                  arrowColor={popupSettingsObj.content_text_color}
                                                  onCLick={() => {
                                                  }} bgColor={popupSettingsObj.content_item_bg}
                                                  textColor={popupSettingsObj.content_text_color}/>
                                    </div>
                                </div>
                            </div>
                            <div className="lynked-reward-footer" style={{background: popupSettingsObj.footer_bg_color}}>
                                <p className="lynked-card-description" style={{color: popupSettingsObj.footer_text_color}}>We reward
                                    with Lynked Loyalty</p>
                            </div>

                        </div>
                        <div className="lynked-rewards--wrapper"
                             style={popupSettingsObj.position === 'right' ? {right: 0} : {left: 0}}>
                            <div className={`lynked-rewards--btn lynked-closeBlock`}
                                 style={{background: `${popupSettingsObj.header_bg_color}`}}>
                                <div className="lynked-reward--btn">
                                    <ModalOpenBtnIcon color={popupSettingsObj.header_icon_color}/>
                                    <span style={{color: `${popupSettingsObj.header_title_color}`}}>Rewards</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div className="save--wrap">
                    <button className="save--btn" disabled={saved}
                            onClick={setModalColors}>{saved ? 'Saved' : 'Save PopUp Settings'}</button>
                </div>

            </div>

            <Login/>
        </div>
    )
}

export default Admin;
