(() => {
    let scrollPosition = 0;

    function lockBodyScroll() {
        if (document.body.dataset.maladetaModalOpen) {
            return;
        }

        scrollPosition = window.scrollY || document.documentElement.scrollTop || 0;
        document.body.dataset.maladetaModalOpen = 'true';
        document.documentElement.classList.add('lueira-embed-locked');
        document.body.classList.add('lueira-embed-locked');
    }

    function unlockBodyScroll() {
        delete document.body.dataset.maladetaModalOpen;
        document.documentElement.classList.remove('lueira-embed-locked');
        document.body.classList.remove('lueira-embed-locked');
        window.scrollTo(0, scrollPosition);
    }

    function openModal(modal) {
        if (!modal) {
            return;
        }

        modal.classList.add('is-active');
        modal.removeAttribute('hidden');
        modal.setAttribute('aria-hidden', 'false');
        const iframe = modal.querySelector('iframe[data-lueira-embed-src]');
        if (iframe && iframe.dataset.lueiraEmbedSrc && iframe.src !== iframe.dataset.lueiraEmbedSrc) {
            iframe.src = iframe.dataset.lueiraEmbedSrc;
        }
        lockBodyScroll();
    }

    const closeModal = (modal) => {
        if (!modal) {
            return;
        }

        modal.classList.remove('is-active');
        modal.setAttribute('aria-hidden', 'true');
        modal.setAttribute('hidden', 'hidden');
        const iframe = modal.querySelector('iframe[data-lueira-embed-src]');
        if (iframe) {
            iframe.src = 'about:blank';
        }

        if (document.querySelector('[data-lueira-embed].is-active') === null) {
            unlockBodyScroll();
        }
    }

    document.addEventListener('click', (event) => {
        const targetButton = event.target.closest('[data-lueira-embed-target]');
        let modalId;
        let modal;
        if (targetButton) {
            modalId = targetButton.getAttribute('data-lueira-embed-target');
            modal = document.getElementById(modalId);
            openModal(modal);
            return;
        }

        const dismissTrigger = event.target.closest('[data-lueira-embed-dismiss]');
        let modalToCloseId;
        let modalElement;
        if (dismissTrigger) {
            modalToCloseId = dismissTrigger.getAttribute('data-lueira-embed-dismiss');
            modalElement = modalToCloseId ? document.getElementById(modalToCloseId) : dismissTrigger.closest('[data-lueira-embed]');
            closeModal(modalElement);
        }
    });

    document.addEventListener('keydown', (event) => {
        if (event.key === 'Escape') {
            const activeModal = document.querySelector('[data-lueira-embed].is-active');
            if (activeModal) {
                closeModal(activeModal);
            }
        }
    });
})();
