# Lueira Embed

Contributors: alvaroarino
Requires at least: 5.0
Tested up to: 6.8
Stable Tag: 1.0.2
License: GPL-2.0-or-later

A WordPress plugin that provides a shortcode to embed Lueira marketplace activities in a responsive modal overlay.

## Description

Lueira Embed allows you to easily embed activities from the Lueira marketplace into your WordPress posts and pages using a simple shortcode. The plugin displays a button that opens a modal window containing an iframe with the embedded activity.

## Features

- **Easy Integration**: Simple shortcode implementation
- **Responsive Design**: Modal adapts to different screen sizes
- **Accessibility**: ARIA-compliant modal with keyboard navigation
- **Security**: Sandboxed iframe with appropriate security restrictions
- **Customizable**: Configurable button text and CSS classes
- **Admin Settings**: Configurable host URL through WordPress admin
- **Multi-language Support**: Language parameter for localized content

## Installation

1. Upload the plugin files to the `/wp-content/plugins/lueira/` directory
2. Activate the plugin through the 'Plugins' menu in WordPress
3. Go to Settings > Lueira Embed to configure the host URL (optional)

## Configuration

### Admin Settings

Navigate to **Settings > Lueira Embed** in your WordPress admin to configure:

- **Embed Host URL**: The base URL for the Lueira marketplace (default: <https://store.lueira.com>)

## Usage

### Basic Shortcode

```
[lueira id="cd2j3bkk7mdnur3r857g" module="school" product_type="private"]
```

### Shortcode Parameters

| Parameter | Required | Default | Description |
|-----------|----------|---------|-------------|
| `id` | Yes | - | The activity ID to embed |
| `module` | Yes | - | The module type (e.g., "school", "rent") |
| `product_type` | No | - | Optional product type (e.g., "private", "group-package") included when available |
| `lang` | No | "es" | Language code for localized content, default is "es" |
| `button_text` | No | "View activity" | Text displayed on the button |
| `class` | No | - | Additional CSS classes for the button |

### Examples

#### School Activity (Private)

```
[lueira id="456" module="school" product_type="private" button_text="View Activity"]
```

#### School Group Package in English

```
[lueira id="789" module="school" product_type="group-package" lang="en" class="btn-primary" button_text="Join Group Package"]
```

#### Rent Bundle with Custom Styling

```
[lueira id="101" module="rent" product_type="bundle" lang="es" button_text="Ver Actividad" class="lueira-embed__trigger--accent"]
```

## Generated URL Structure

The plugin generates URLs in the following format:

```
{host_url}/{lang}/embed/{module}/{product_type?}/{activity_id}
```

For example:

- `https://store.lueira.com/en/embed/school/private/123` (with product type)
- `https://store.lueira.com/es/embed/rent/456` (without product type)

## Styling

The plugin includes default CSS for the modal and button. You can customize the appearance by:

1. Adding custom CSS classes via the `class` parameter
2. Overriding the plugin's CSS in your theme
3. Modifying the included `modal.css` file

### CSS Classes

- `.lueira-embed-button-wrapper` - Button container
- `.lueira-embed-trigger` - The trigger button
- `.lueira-embed` - Modal container
- `.lueira-embed__backdrop` - Modal backdrop
- `.lueira-embed__dialog` - Modal dialog
- `.lueira-embed__close` - Close button

## Browser Compatibility

- Modern browsers (Chrome, Firefox, Safari, Edge)
- Mobile responsive design
- Accessibility compliant (ARIA attributes)

## Security Features

The embedded iframe includes the following security sandbox attributes:

- `allow-same-origin`
- `allow-scripts`
- `allow-popups`
- `allow-forms`
- `allow-top-navigation-by-user-activation`

## Requirements

- WordPress 5.0 or higher
- PHP 7.4 or higher

## Changelog

### Version 1.0.2

- Allow the shortcode to omit `product_type` and adjust the embed URL automatically.

### Version 1.0.0

- Initial release
- Shortcode implementation with modal overlay
- Admin settings page
- Responsive design
- Multi-language support
- Security sandbox for iframe

## Support

For support and feature requests, please contact Maladeta Studio.

## License

This plugin is licensed under the GPL-2.0-or-later license. See `LICENSE` for full terms.

## Author

**Maladeta Studio**

- Website: [Maladeta Studio](https://maladeta.com)
- Text Domain: `lueira`

---

*This plugin provides seamless integration between WordPress and the Lueira marketplace platform.*
