<?php

/**
 * Receiver address.
 */

namespace EnTqlReceiverAddress;

/**
 * Get address from cart|checkout page.
 * Class EnTqlReceiverAddress
 * @package EnTqlReceiverAddress
 */
if (!class_exists('EnTqlReceiverAddress')) {

    class EnTqlReceiverAddress
    {
        static public $woocommerce_version;

        /**
         * Receiver address
         * @return array
         */
        static public function get_address()
        {
            self::en_get_woo_version_number();

            return [
                'receiverZip' => strlen(WC()->customer->get_shipping_postcode()) > 0 ? WC()->customer->get_shipping_postcode() : WC()->customer->get_billing_postcode(),
                'receiverState' => strlen(WC()->customer->get_shipping_state()) > 0 ? WC()->customer->get_shipping_state() : WC()->customer->get_billing_state(),
                'receiverCountryCode' => strlen(WC()->customer->get_shipping_country()) > 0 ? WC()->customer->get_shipping_country() : WC()->customer->get_billing_country(),
                'receiverCity' => strlen(WC()->customer->get_shipping_city()) > 0 ? WC()->customer->get_shipping_city() : WC()->customer->get_billing_city(),
                'addressLine' => strlen(WC()->customer->get_shipping_address_1()) > 0 ? WC()->customer->get_shipping_address_1() : WC()->customer->get_shipping_address_2(),
            ];
        }

        /**
         * Declared woo version publically
         */
        static public function en_get_woo_version_number()
        {
            if (!function_exists('get_plugins')) {
                require_once(ABSPATH . 'wp-admin/includes/plugin.php');
            }
            $plugin_folder = get_plugins('/' . 'woocommerce');
            $plugin_file = 'woocommerce.php';
            (isset($plugin_folder[$plugin_file]['Version'])) ?
                self::$woocommerce_version = $plugin_folder[$plugin_file]['Version'] : '';
        }
    }

}