<?php

/**
 * App Name settings.
 */

namespace EnTqlQuoteSettingsDetail;

/**
 * Get and save settings.
 * Class EnTqlQuoteSettingsDetail
 * @package EnTqlQuoteSettingsDetail
 */
if (!class_exists('EnTqlQuoteSettingsDetail')) {

    class EnTqlQuoteSettingsDetail
    {
        static public $en_tql_accessorial = [];

        /**
         * Set quote settings detail
         */
        static public function en_tql_get_quote_settings()
        {
            $accessorials = [];
            $en_settings = json_decode(EN_TQL_SET_QUOTE_SETTINGS, true);
            $en_settings['liftgate_delivery_option'] == 'yes' ? $accessorials['accessorials'][] = 'LGDEL' : "";
            $en_settings['liftgate_delivery'] == 'yes' ? $accessorials['accessorials'][] = 'LGDEL' : "";
            $en_settings['residential_delivery'] == 'yes' ? $accessorials['residentialDelivery'] = 'Y' : "";
            $accessorials['handlingUnitWeight'] = $en_settings['handling_unit_weight'];
            $accessorials['maxWeightPerHandlingUnit'] = $en_settings['max_handling_unit_weight'];
            $accessorials['handling_fee_markup'] = $en_settings['handling_fee'];

            return $accessorials;
        }

        /**
         * Set quote settings detail
         */
        static public function en_tql_always_accessorials()
        {
            $accessorials = [];
            $en_settings = self::en_tql_quote_settings();
            $en_settings['liftgate_delivery'] == 'yes' ? $accessorials[] = 'L' : "";
            $en_settings['residential_delivery'] == 'yes' ? $accessorials[] = 'R' : "";

            return $accessorials;
        }

        /**
         * Set quote settings detail
         */
        static public function en_tql_quote_settings()
        {
            $enable_carriers = get_option('en_tql_carriers');
            $enable_carriers = (isset($enable_carriers) && strlen($enable_carriers) > 0) ?
                json_decode($enable_carriers, true) : [];
            $rating_method = get_option('en_quote_settings_rating_method_tql');
            $quote_settings_label = get_option('en_quote_settings_custom_label_tql');

            $quote_settings = [
                'transit_days' => get_option('en_quote_settings_show_delivery_estimate_tql'),
                'own_freight' => get_option('en_quote_settings_own_arrangment_tql'),
                'own_freight_label' => get_option('en_quote_settings_text_for_own_arrangment_tql'),
                'total_carriers' => get_option('en_quote_settings_number_of_options_tql'),
                'rating_method' => (strlen($rating_method)) > 0 ? $rating_method : "Cheapest",
                'en_settings_label' => ($rating_method == "average_rate" || $rating_method == "Cheapest") ? $quote_settings_label : "",
                'handling_unit_weight' => get_option('en_quote_settings_handling_unit_weight_tql'),
                'max_handling_unit_weight' => get_option('en_quote_settings_max_handling_unit_weight_tql'),
                'handling_fee' => get_option('en_quote_settings_handling_fee_tql'),
                'enable_carriers' => $enable_carriers,
                'liftgate_delivery' => get_option('en_quote_settings_liftgate_delivery_tql'),
                'liftgate_delivery_option' => get_option('tql_liftgate_delivery_as_option'),
                'residential_delivery' => get_option('en_quote_settings_residential_delivery_tql'),
                'liftgate_resid_delivery' => get_option('en_woo_addons_liftgate_with_auto_residential'),
                'handling_weight' => get_option('en_quote_settings_handling_unit_weight_tql'),
                'maximum_handling_weight' => get_option('en_quote_settings_max_handling_unit_weight_tql'),
            ];

            return $quote_settings;
        }

        /**
         * Get quote settings detail
         * @param array $en_settings
         * @return array
         */
        static public function en_tql_compare_accessorial($en_settings)
        {
            self::$en_tql_accessorial[] = ['S'];
            $en_settings['liftgate_delivery_option'] == 'yes' ? self::$en_tql_accessorial[] = ['L'] : "";

            return self::$en_tql_accessorial;
        }

    }

}