<?php

/**
 * Curl http request.
 */

namespace EnTqlCurl;

use EnTqlConfig\EnTqlConfig;

/**
 * Generic http request.
 * Class EnTqlCurl
 * @package EnTqlCurl
 */
if (!class_exists('EnTqlCurl')) {

    class EnTqlCurl {

        /**
         * @param string $url
         * @param array $post_data
         * @param string $method
         * @param string string $step_for
         * @return string|encoded
         */
        static public function en_tql_sent_http_request($url, $post_data, $method, $step_for = '') {
            $curl_response = '';
            $en_time_start = 0;

            if (strlen($url) > 0 && is_array($post_data) && !empty($post_data)) {

                $post_data = self::remove_extra_request_data($post_data);
                $cachable_data = self::create_cachable_data($post_data);
                $cache_key = self::create_cache_key($cachable_data);
                $cache_response = get_transient($cache_key);

                if (false === $cache_response || $step_for == 'Plan') {
                    // Eniture Execution Time
                    $en_time_start = microtime(true);

                    // Eniture Debug Mood
                    do_action("eniture_debug_mood", EN_TQL_NAME . " $step_for Request ", $post_data);

                    $method == 'POST' ? $post_data = http_build_query($post_data) : '';

                    // Eniture Debug Mood
                    do_action("eniture_debug_mood", EN_TQL_NAME . " $step_for Build Query ", $post_data);

                    $response = wp_remote_post($url, [
                        'method' => $method,
                        'timeout' => 60,
                        'redirection' => 5,
                        'blocking' => true,
                        'body' => $post_data,
                            ]
                    );
                    $curl_response = wp_remote_retrieve_body($response);
                    set_transient($cache_key, $curl_response, 12 * HOUR_IN_SECONDS);
                    $headers = wp_remote_retrieve_headers($response);
                    self::eniture_check_rate_limit_headers($headers);
                } else {
                    $curl_response = $cache_response;
                }
            }

            // Eniture Debug Mood
            do_action("eniture_debug_mood", EN_TQL_NAME . " $step_for Response ", json_decode($curl_response));

            // Eniture Execution Time
            $en_time_end = microtime(true) - $en_time_start;
            do_action("eniture_debug_mood", EN_TQL_NAME . " $step_for Execution Time ", $en_time_end);

            return $curl_response;
        }

        static public function remove_extra_request_data($request_data)
        {
            $extra_params = ['en_fdo_meta_data'];
            foreach ($extra_params as $param) {
                if (!isset($request_data[$param])) continue;

                $items = isset($request_data[$param]['items']) ? $request_data[$param]['items'] : [];
                foreach ($items as $key => $item) {
                    unset($items[$key]['attributes'], $items[$key]['meta_data']);
                }

                $request_data[$param]['items'] = $items;
                break;
            }

            return $request_data;
        }

        static public function eniture_check_rate_limit_headers($headers)
        {
            $rate_limit_flag = isset($headers['X-RateLimit-Flag']) ? filter_var($headers['X-RateLimit-Flag'], FILTER_VALIDATE_BOOLEAN) : false;

            if ($rate_limit_flag) {
                if (isset($headers['X-RateLimit-Reset'])) {
                    update_option('eniture_show_rate_limit_notice_with_time', 'yes');
                    update_option('eniture_rate_limit_reset_timestamp', $headers['X-RateLimit-Reset']);
                } else {
                    update_option('eniture_show_rate_limit_notice_without_time', 'yes');
                }
            } else {
                update_option('eniture_show_rate_limit_notice_with_time', 'no');
                update_option('eniture_show_rate_limit_notice_without_time', 'no');
            }
        }

        static public function create_cachable_data($request_data)
        {
            $cachable_data = [];

            $cachable_data['wordpress_version'] = get_bloginfo('version');
            $cachable_data['woocommerce_version'] = isset($request_data['woocommerce_version']) ? $request_data['woocommerce_version'] : '';
            $cachable_data['plugin_version'] = isset($request_data['plugin_version']) ? $request_data['plugin_version'] : '';
            $cachable_data['acessLevel'] = isset($request_data['acessLevel']) ? $request_data['acessLevel'] : '';
            $cachable_data['originAddresses'] = isset($request_data['originAddresses']) ? $request_data['originAddresses'] : '';
            $cachable_data['destinationAddress'] = isset($request_data['destinationAddress']) ? $request_data['destinationAddress'] : '';
            $cachable_data['eniureLicenceKey'] = isset($request_data['eniureLicenceKey']) ? $request_data['eniureLicenceKey'] : '';
            $cachable_data['ServerName'] = isset($request_data['ServerName']) ? $request_data['ServerName'] : '';

            $cachable_data['addressLine'] = isset($request_data['addressLine']) ? $request_data['addressLine'] : '';
            $cachable_data['receiverCity'] = isset($request_data['receiverCity']) ? $request_data['receiverCity'] : '';
            $cachable_data['receiverState'] = isset($request_data['receiverState']) ? $request_data['receiverState'] : '';
            $cachable_data['receiverZip'] = isset($request_data['receiverZip']) ? $request_data['receiverZip'] : '';
            $cachable_data['receiverCountryCode'] = isset($request_data['receiverCountryCode']);
            $cachable_data['originAddress'] = isset($request_data['originAddress']) ? $request_data['originAddress'] : '';
            $cachable_data['accessorials'] = isset($request_data['accessorials']) ? $request_data['accessorials'] : '';

            $cachable_data['commdityDetails'] = isset($request_data['commdityDetails']) ? $request_data['commdityDetails'] : '';
            $cachable_data['doNesting'] = isset($request_data['doNesting']) ? $request_data['doNesting'] : '';
            $cachable_data['suspend_residential'] = isset($request_data['suspend_residential']) ? $request_data['suspend_residential'] : '';
            $cachable_data['residential_detecion_flag'] = isset($request_data['residential_detecion_flag']) ? $request_data['residential_detecion_flag'] : '';
            $cachable_data['liftGateAsAnOption'] = isset($request_data['liftGateAsAnOption']) ? $request_data['liftGateAsAnOption'] : '';
            $cachable_data['handlingUnitWeight'] = isset($request_data['handlingUnitWeight']) ? $request_data['handlingUnitWeight'] : '';
            $cachable_data['maxWeightPerHandlingUnit'] = isset($request_data['maxWeightPerHandlingUnit']) ? $request_data['maxWeightPerHandlingUnit'] : '';
            $cachable_data['modifyShipmentDateTime'] = isset($request_data['modifyShipmentDateTime']) ? $request_data['modifyShipmentDateTime'] : '';
            $cachable_data['instorPickupLocalDelEnable'] = isset($request_data['instorPickupLocalDelEnable']) ? $request_data['instorPickupLocalDelEnable'] : '';

            if (isset($request_data['autoResidentials']) && $request_data['autoResidentials'] == 1) {
                $cachable_data['autoResidentials'] = $request_data['autoResidentials'];
                $cachable_data['addressLine'] = $request_data['addressLine'];
                $cachable_data['addressLine2'] = (isset($request_data['addressLine2'])) ? $request_data['addressLine2'] : '';
                $cachable_data['defaultRADAddressType'] = $request_data['defaultRADAddressType'];
                $cachable_data['poboxAddressValidation'] = $request_data['poboxAddressValidation'];
            }

            if (isset($request_data['standardPackaging']) && $request_data['standardPackaging'] == 1) {
                $cachable_data['standardPackaging'] = $request_data['standardPackaging'];
                $cachable_data['pallet'] = $request_data['pallet'];
            }

            $cachable_data['clientId'] = isset($request_data['clientId']) ? $request_data['clientId'] : '';
            $cachable_data['traxUsername'] = isset($request_data['traxUsername']) ? $request_data['traxUsername'] : '';
            $cachable_data['traxPassword'] = isset($request_data['traxPassword']) ? $request_data['traxPassword'] : '';
            $cachable_data['subscriptionKey'] = isset($request_data['subscriptionKey']) ? $request_data['subscriptionKey'] : '';
            $cachable_data['licenseKey'] = isset($request_data['licenseKey']) ? $request_data['licenseKey'] : '';

            return $cachable_data;
        }

        static public function create_cache_key($request_data)
        {
            $request_build_query = http_build_query($request_data);
            return md5('eniture_tql_' . $request_build_query);
        }

    }

}