<?php

namespace EnTqlFdo;

if (!class_exists('EnTqlFdo')) {

    class EnTqlFdo {

        static public $en_fdo_meta_data;

        /**
         * arrange cart objects.
         * @param type $package
         * @return array
         */
        static public function en_cart_package($en_package, $key) {
            self::$en_fdo_meta_data['plugin_type'] = 'ltl';
            self::$en_fdo_meta_data['plugin_name'] = 'tql';
            $accessorials['residential'] = get_option('en_quote_settings_residential_delivery_tql') == 'yes' ? true : false;
            $accessorials['residential_pickup'] = isset($en_package['originAddress'][$key]['residentialPickup']) && $en_package['originAddress'][$key]['residentialPickup'] == 'Y' ? true : false;
            $accessorials['liftgate'] = get_option('en_quote_settings_liftgate_delivery_tql') == 'yes' ? true : false;
            $accessorials['liftgate_pickup'] = isset($en_package['originAddress'][$key]['liftgatePickup']) && $en_package['originAddress'][$key]['liftgatePickup'] == 'Y' ? true : false;
            self::$en_fdo_meta_data['accessorials'] = $accessorials;

            (isset($en_package['commdityDetails'][$key])) ? self::en_package_items($en_package['commdityDetails'][$key]) : '';
            (isset($en_package['originAddress'][$key])) ? self::en_package_address($en_package['originAddress'][$key]) : '';

            return self::$en_fdo_meta_data;
        }

        /**
         * arrange items.
         * @param type $items
         */
        static public function en_package_items($items) {
            self::$en_fdo_meta_data['items'] = [];
            foreach ($items as $item_key => $item_data) {
                $productId = $productName = $piecesOfLineItem = $lineItemPrice = $lineItemWeight = $lineItemLength = $lineItemWidth = $lineItemHeight = $ptype = $productType = $productSku = $productClass = $attributes = $variantId = '';
                $attributes = [];
                extract($item_data);

                $meta_data = [];
                if (!empty($attributes)) {
                    foreach ($attributes as $attr_key => $attr_value) {
                        $meta_data[] = [
                            'key' => $attr_key,
                            'value' => !empty($attr_value) && is_string($attr_value) ? str_replace(array("'", '"'), '', $attr_value) : '',
                        ];

                        $attributes[$attr_key] = !empty($attr_value) && is_string($attr_value) ? str_replace(array("'", '"'), '', $attr_value) : '';
                    }
                }

                $productName = is_string($productName) && !empty($productName) ? str_replace(array("'", '"'), '', $productName) : '';

                $item = [
                    'id' => $productId,
                    'name' => $productName,
                    'quantity' => $piecesOfLineItem,
                    'price' => $lineItemPrice,
                    'weight' => $lineItemWeight,
                    'length' => $lineItemLength,
                    'width' => $lineItemWidth,
                    'height' => $lineItemHeight,
                    'type' => $ptype,
                    'product' => $productType,
                    'sku' => $productSku,
                    'attributes' => $attributes,
                    'shipping_class' => $productClass,
                    'variant_id' => $variantId,
                    'meta_data' => $meta_data,
                ];

                // Hook for flexibility adding to package
                $item = apply_filters('en_fdo_package', $item, $item_data);
                self::$en_fdo_meta_data['items'][$item_key] = $item;
            }
        }

        /**
         * Get address.
         * @param array $address
         */
        static public function en_package_address($address) {
            $selection_for_address = [
                'id' => 'id',
                'senderCity' => 'city',
                'senderState' => 'state',
                'senderZip' => 'zip',
                'senderCountryCode' => 'country',
                'senderLocation' => 'location',
                'senderAddressLine' => 'address',
            ];

            // Get result
            $sender_location_address = array_combine($selection_for_address, array_intersect_key($address, $selection_for_address));
            self::$en_fdo_meta_data['address'] = $sender_location_address;
        }

    }

}