<?php

/**
 * App Name details.
 */

namespace EnTqlConfig;

use EnTqlConnectionSettings\EnTqlConnectionSettings;
use EnTqlQuoteSettingsDetail\EnTqlQuoteSettingsDetail;

/**
 * Config values.
 * Class EnTqlConfig
 * @package EnTqlConfig
 */
if (!class_exists('EnTqlConfig')) {

    class EnTqlConfig {

        /**
         * Save config settings
         */
        static public function do_config() {
            define('EN_TQL_PLAN', get_option('en_tql_plan_number'));
            !empty(get_option('en_tql_plan_message')) ? define('EN_TQL_PLAN_MESSAGE', get_option('en_tql_plan_message')) : define('EN_TQL_PLAN_MESSAGE', EN_TQL_704);
            define('EN_TQL_NAME', 'TQL');
            define('EN_TQL_PLUGIN_URL', plugins_url());
            define('EN_TQL_ABSPATH', ABSPATH);
            define('EN_TQL_DIR', plugins_url(EN_TQL_MAIN_DIR));
            define('EN_TQL_DIR_FILE', plugin_dir_url(EN_TQL_MAIN_FILE));
            define('EN_TQL_FILE', plugins_url(EN_TQL_MAIN_FILE));
            define('EN_TQL_BASE_NAME', plugin_basename(EN_TQL_MAIN_FILE));
            define('EN_TQL_SERVER_NAME', self::en_get_server_name());

            define('EN_TQL_DECLARED_ZERO', 0);
            define('EN_TQL_DECLARED_ONE', 1);
            define('EN_TQL_DECLARED_ARRAY', []);
            define('EN_TQL_DECLARED_FALSE', false);
            define('EN_TQL_DECLARED_TRUE', true);
            define('EN_TQL_SHIPPING_NAME', 'tql');

            $weight_threshold = get_option('en_weight_threshold_lfq');
            $weight_threshold = isset($weight_threshold) && $weight_threshold > 0 ? $weight_threshold : 150;
            define('EN_TQL_SHIPMENT_WEIGHT_EXCEEDS_PRICE', $weight_threshold);
            define('EN_TQL_SHIPMENT_WEIGHT_EXCEEDS', get_option('en_plugins_return_LTL_quotes'));
            if (!defined('EN_TQL_ROOT_URL')){
                define('EN_TQL_ROOT_URL', 'https://eniture.com');
            }

            define('EN_TQL_ROOT_URL_PRODUCTS', EN_TQL_ROOT_URL . '/products/');
            define('EN_TQL_RAD_URL', EN_TQL_ROOT_URL . '/woocommerce-residential-address-detection/');
            define('EN_TQL_SUPPORT_URL', esc_url('https://support.eniture.com/'));
            define('EN_TQL_DOCUMENTATION_URL', EN_TQL_ROOT_URL . '/woocommerce-tql-ltl-freight');

            define('EN_TQL_ROOT_URL_QUOTES', 'https://ws078.eniture.com');

            define('EN_TQL_HITTING_API_URL', EN_TQL_ROOT_URL_QUOTES . '/tql/quotes.php');
            define('EN_TQL_ADDRESS_HITTING_URL', EN_TQL_ROOT_URL_QUOTES . '/addon/google-location.php');
            define('EN_TQL_PLAN_HITTING_URL', EN_TQL_ROOT_URL_QUOTES . '/web-hooks/subscription-plans/create-plugin-webhook.php?');
            define('EN_TQL_ORDER_EXPORT_HITTING_URL', 'https://analytic-data.eniture.com/index.php');

            define('EN_TQL_SET_CONNECTION_SETTINGS', wp_json_encode(EnTqlConnectionSettings::en_set_connection_settings_detail()));
            define('EN_TQL_GET_CONNECTION_SETTINGS', wp_json_encode(EnTqlConnectionSettings::en_get_connection_settings_detail()));
            define('EN_TQL_SET_QUOTE_SETTINGS', wp_json_encode(EnTqlQuoteSettingsDetail::en_tql_quote_settings()));
            define('EN_TQL_GET_QUOTE_SETTINGS', wp_json_encode(EnTqlQuoteSettingsDetail::en_tql_get_quote_settings()));

            $en_app_set_quote_settings = json_decode(EN_TQL_SET_QUOTE_SETTINGS, true);

            define('EN_TQL_ALWAYS_ACCESSORIAL', wp_json_encode(EnTqlQuoteSettingsDetail::en_tql_always_accessorials($en_app_set_quote_settings)));
            define('EN_TQL_ACCESSORIAL', wp_json_encode(EnTqlQuoteSettingsDetail::en_tql_compare_accessorial($en_app_set_quote_settings)));
        }

        /**
         * Get Host
         * @param string $url
         * @return type
         */
        static public function en_get_host($url) {
            $parse_url = parse_url(trim($url));
            if (isset($parse_url['host'])) {
                $host = $parse_url['host'];
            } else {
                $path = explode('/', $parse_url['path']);
                $host = $path[0];
            }
            return trim($host);
        }

        /**
         * Get Domain Name
         */
        static public function en_get_server_name() {
            global $wp;
            $wp_request = (isset($wp->request)) ? $wp->request : '';
            $url = home_url($wp_request);
            return self::en_get_host($url);
        }

        /**
         * Return woocomerce and wwe ltl plugin versions
         */
        static public function en_get_woo_version_number()
        {
            if (!function_exists('get_plugins')) require_once(ABSPATH . 'wp-admin/includes/plugin.php');

            $plugin_folder = get_plugins('/' . 'woocommerce');
            $plugin_file = 'woocommerce.php';
            $plugin_folders = get_plugins('/' . 'ltl-freight-quotes-tql-edition');
            $plugin_files = 'ltl-freight-quotes-tql-edition.php';

            $wc_plugin = (isset($plugin_folder[$plugin_file]['Version'])) ? $plugin_folder[$plugin_file]['Version'] : "";
            $tql_plugin = (isset($plugin_folders[$plugin_files]['Version'])) ? $plugin_folders[$plugin_files]['Version'] : "";

            return array(
                'woocommerce_version' => $wc_plugin,
                'plugin_version' => $tql_plugin
            );
        }

    }

}
