<?php

/**
 * App Name load classes.
 */

namespace EnTqlLoad;

use EnTqlOrderWidget\EnTqlOrderWidget;
use EnTqlCsvExport\EnTqlCsvExport;
use EnTqlConfig\EnTqlConfig;
use EnTqlCreateLTLClass\EnTqlCreateLTLClass;
use EnTqlLocationAjax\EnTqlLocationAjax;
use EnTqlMessage\EnTqlMessage;
use EnTqlOrderRates\EnTqlOrderRates;
use EnTqlOrderScript\EnTqlOrderScript;
use EnTqlPlans\EnTqlPlans;
use EnTqlWarehouse\EnTqlWarehouse;
use EnTqlTestConnection\EnTqlTestConnection;

/**
 * Load classes.
 * Class EnTqlLoad
 * @package EnTqlLoad
 */
if (!class_exists('EnTqlLoad')) {

    class EnTqlLoad
    {
        /**
         * Load classes of App Name plugin
         */
        static public function Load()
        {
            new EnTqlMessage();
            new EnTqlPlans();
            EnTqlConfig::do_config();
            new \EnTqlCarrierShippingRates();

            if (is_admin()) {
                new EnTqlCreateLTLClass();
                new EnTqlWarehouse();
                new EnTqlTestConnection();
                new EnTqlLocationAjax();
                new EnTqlOrderRates();
                new EnTqlOrderScript();
                !class_exists('EnOrderWidget') ? new EnTqlOrderWidget() : '';
                !class_exists('EnCsvExport') ? new EnTqlCsvExport() : '';
            }
        }

    }

}
