<?php

/**
 * Quote settings detail array.
 */

namespace EnTqlQuoteSettings;

if (!class_exists('EnTqlQuoteSettings')) {

    class EnTqlQuoteSettings
    {

        /**
         * Quote Settings Html
         * @return array
         */
        static public function Load()
        {

            $en_settings = json_decode(EN_TQL_SET_QUOTE_SETTINGS, true);
            $number_of_options = [];
            if (isset($en_settings['enable_carriers']) && !empty($en_settings['enable_carriers'])) {
                for ($c = 1; $c <= count($en_settings['enable_carriers']); $c++) {
                    $number_of_options[$c] = __($c, $c);
                }
            }

            $ltl_enable = get_option('en_plugins_return_LTL_quotes');
            $weight_threshold_class = $ltl_enable == 'yes' ? 'show_en_weight_threshold_lfq' : 'hide_en_weight_threshold_lfq';
            $weight_threshold = get_option('en_weight_threshold_lfq');
            $weight_threshold = isset($weight_threshold) && $weight_threshold > 0 ? $weight_threshold : 150;

            // Backup rates
            if (empty(get_option('tql_backup_rates_category'))) {
                update_option('tql_backup_rates_category', 'fixed_rate');
            }

            if (empty(get_option('tql_backup_rates_display'))) {
                update_option('tql_backup_rates_display', 'no_other_rates');
            }

            $settings = array(
                'en_quote_settings_start_tql' => [
                    'name' => __('', 'woocommerce-settings-tql'),
                    'type' => 'title',
                    'id' => 'en_quote_settings_tql',
                ],
                /**
                 * ==================================================================
                 * Rating Method Start
                 * ==================================================================
                 */
                'en_quote_settings_rating_method_tql' => [
                    'name' => __('Rating Method ', 'woocommerce-settings-tql'),
                    'type' => 'select',
                    'desc' => __('Displays only the cheapest returned Rate.', 'woocommerce-settings-tql'),
                    'id' => 'en_quote_settings_rating_method_tql',
                    'options' => [
                        'Cheapest' => __('Cheapest', 'Cheapest'),
                        'cheapest_options' => __('Cheapest Options', 'cheapest_options'),
                        'average_rate' => __('Average Rate', 'average_rate')
                    ]
                ],
                'en_quote_settings_number_of_options_tql' => [
                    'name' => __('Number Of Options ', 'woocommerce-settings-tql'),
                    'type' => 'select',
                    'default' => '3',
                    'desc' => __('Number of options to display in the shopping cart.', 'woocommerce-settings-tql'),
                    'id' => 'en_quote_settings_number_of_options_tql',
                    'options' => $number_of_options
                ],
                'en_quote_settings_custom_label_tql' => [
                    'name' => __('Label As ', 'woocommerce-settings-tql'),
                    'type' => 'text',
                    'desc' => __('What the user sees during checkout, e.g "Freight" leave blank to display the carrier name.', 'woocommerce-settings-tql'),
                    'id' => 'en_quote_settings_custom_label_tql'
                ],
                /**
                 * ==================================================================
                 * Rating Method End
                 * ==================================================================
                 */
                'en_quote_settings_show_delivery_estimate_tql' => [
                    'name' => __('Show Delivery Estimate ', 'woocommerce-settings-tql'),
                    'type' => 'checkbox',
                    'id' => 'en_quote_settings_show_delivery_estimate_tql'
                ],
                'residential_delivery_options_label' => [
                    'name' => __('Residential Delivery', 'woocommerce-settings-tql'),
                    'type' => 'text',
                    'class' => 'hidden',
                    'id' => 'en_quote_settings_residential_label_tql'
                ],
                'en_quote_settings_residential_delivery_tql' => [
                    'name' => __('', 'woocommerce-settings-tql'),
                    'type' => 'checkbox',
                    'desc' => 'Always quote as residential delivery.',
                    'id' => 'en_quote_settings_residential_delivery_tql'
                ],
                /**
                 * ==================================================================
                 * Auto-detect residential addresses notification
                 * ==================================================================
                 */
                'avaibility_auto_residential' => [
                    'name' => __('', 'woocommerce-settings-tql'),
                    'type' => 'text',
                    'class' => 'hidden',
                    'desc' => "Click <a target='_blank' href='" . EN_TQL_RAD_URL . "'>here</a> to add the Auto-detect residential addresses module. (<a target='_blank' href='https://eniture.com/woocommerce-residential-address-detection/#documentation'>Learn more</a>)",
                    'id' => 'en_quote_settings_availability_auto_residential_tql'
                ],
                'liftgate_delivery_options_label' => [
                    'name' => __('Lift Gate Delivery ', 'woocommerce-settings-tql'),
                    'type' => 'text',
                    'class' => 'hidden',
                    'id' => 'en_quote_settings_liftgate_label_tql'
                ],
                'en_quote_settings_liftgate_delivery_tql' => [
                    'name' => __('', 'woocommerce-settings-tql'),
                    'type' => 'checkbox',
                    'class' => 'liftgate_accessorial_action',
                    'desc' => 'Always quote lift gate delivery.',
                    'id' => 'en_quote_settings_liftgate_delivery_tql',
                ],
                'tql_liftgate_delivery_as_option' => [
                    'name' => __('', 'woocommerce-settings-tql'),
                    'type' => 'checkbox',
                    'class' => 'liftgate_accessorial_action',
                    'desc' => __('Offer lift gate delivery as an option.', 'woocommerce-settings-tql'),
                    'id' => 'tql_liftgate_delivery_as_option',
                ],
                'en_woo_addons_liftgate_with_auto_residential' => [
                    'name' => __('', 'woocommerce-settings-tql'),
                    'type' => 'checkbox',
                    'class' => 'liftgate_accessorial_action en_woo_addons_liftgate_with_auto_residential_tql',
                    'desc' => __('Always include lift gate delivery when a residential address is detected.', 'woocommerce-settings-tql'),
                    'id' => 'en_woo_addons_liftgate_with_auto_residential',
                ],
                /**
                 * ==================================================================
                 * Liftgate notification
                 * ==================================================================
                 */
                'avaibility_lift_gate' => [
                    'name' => __('', 'woocommerce-settings-tql'),
                    'type' => 'text',
                    'class' => 'hidden',
                    'desc' => "Click <a target='_blank' href='" . EN_TQL_RAD_URL . "'>here</a> to add the Residential Address Detection module. (<a target='_blank' href='https://eniture.com/woocommerce-residential-address-detection/#documentation'>Learn more</a>)",
                    'id' => 'en_quote_settings_availability_liftgate_tql'
                ],
                'en_quote_settings_handling_unit_weight_heading_tql' => array(
                    'name' => __('Handling Unit ', 'woocommerce-settings-tql'),
                    'type' => 'text',
                    'class' => 'hidden',
                    'id' => 'en_quote_settings_handling_unit_weight_heading_tql'
                ),
                'en_quote_settings_handling_unit_weight_tql' => [
                    'name' => __('Weight of Handling Unit ', 'woocommerce-settings-tql'),
                    'type' => 'text',
                    'desc' => 'Enter in pounds the weight of your pallet, skid, crate or other type of handling unit.',
                    'id' => 'en_quote_settings_handling_unit_weight_tql'
                ],
                'en_quote_settings_max_handling_unit_weight_tql' => array(
                    'name' => __('Maximum Weight per Handling Unit  ', 'woocommerce-settings-tql'),
                    'type' => 'text',
                    'desc' => 'Enter in pounds the maximum weight that can be placed on the handling unit.',
                    'id' => 'en_quote_settings_max_handling_unit_weight_tql'
                ),
                'en_quote_settings_handling_fee_tql' => [
                    'name' => __('Handling Fee / Markup ', 'woocommerce-settings-tql'),
                    'type' => 'text',
                    'desc' => 'Amount excluding tax. Enter an amount, e.g 3.75, or a percentage, e.g, 5%. Leave blank to disable.',
                    'id' => 'en_quote_settings_handling_fee_tql'
                ],
                'en_quote_settings_enable_logs_tql' => [
                    'name' => __("Enable Logs  ", 'woocommerce-settings-dayross'),
                    'type' => 'checkbox',
                    'desc' => 'When checked, the Logs page will contain up to 25 of the most recent transactions.',
                    'id' => 'en_quote_settings_enable_logs_tql'
                ],    
                'en_quote_settings_own_arrangment_tql' => [
                    'name' => __('Allow For Own Arrangement ', 'woocommerce-settings-tql'),
                    'type' => 'checkbox',
                    'desc' => __('<span class="description">Adds an option in the shipping cart for users to indicate that they will make and pay for their own LTL shipping arrangements.</span>', 'woocommerce-settings-wwe_quetes'),
                    'id' => 'en_quote_settings_own_arrangment_tql'
                ],
                'en_quote_settings_text_for_own_arrangment_tql' => [
                    'name' => __('Text For Own Arrangement ', 'woocommerce-settings-tql'),
                    'type' => 'text',
                    'desc' => '',
                    'default' => "I'll arrange my own freight",
                    'id' => 'en_quote_settings_text_for_own_arrangment_tql'
                ],
                'en_quote_settings_allow_other_plugins_tql' => [
                    'name' => __('Show WooCommerce Shipping Options ', 'woocommerce-settings-tql'),
                    'type' => 'select',
                    'default' => 'yes',
                    'desc' => __('Enabled options on WooCommerce Shipping page are included in quote results.', 'woocommerce-settings-tql'),
                    'id' => 'en_quote_settings_allow_other_plugins_tql',
                    'options' => [
                        'yes' => __('YES', 'YES'),
                        'no' => __('NO', 'NO'),
                    ]
                ],
                'en_plugins_return_LTL_quotes' => [
                    'name' => __('Return LTL quotes when an order parcel shipment weight exceeds the weight threshold ', 'woocommerce-settings-tql'),
                    'type' => 'checkbox',
                    'desc' => '<span class="description" >When checked, the LTL Freight Quote will return quotes when an order’s total weight exceeds the weight threshold (the maximum permitted by WWE and UPS), even if none of the products have settings to indicate that it will ship LTL Freight. To increase the accuracy of the returned quote(s), all products should have accurate weights and dimensions. </span>',
                    'id' => 'en_plugins_return_LTL_quotes'
                ],
                // Weight threshold for LTL freight
                'en_weight_threshold_lfq' => [
                    'name' => __('Weight threshold for LTL Freight Quotes ', 'woocommerce-settings-tql'),
                    'type' => 'text',
                    'default' => $weight_threshold,
                    'class' => $weight_threshold_class,
                    'id' => 'en_weight_threshold_lfq'
                ],
                'en_suppress_parcel_rates' => array(
                    'name' => __("", 'woocommerce-settings-tql'),
                    'type' => 'radio',
                    'default' => 'display_parcel_rates',
                    'options' => array(
                        'display_parcel_rates' => __("Continue to display parcel rates when the weight threshold is met.", 'woocommerce-settings-tql'),
                        'suppress_parcel_rates' => __("Suppress parcel rates when the weight threshold is met.", 'woocommerce-settings-tql'),
                    ),
                    'class' => 'en_suppress_parcel_rates',
                    'id' => 'en_suppress_parcel_rates',
                ),
                /**
                 * ==================================================================
                 * When plugin fail return to rate
                 * ==================================================================
                 */
                'en_quote_settings_clear_both_tql' => [
                    'title' => __('', 'woocommerce'),
                    'name' => __('', 'woocommerce-settings-tql'),
                    'desc' => '',
                    'id' => 'en_quote_settings_clear_both_tql',
                    'css' => '',
                    'type' => 'title',
                ],
                'en_quote_settings_unable_retrieve_shipping_tql' => [
                    'name' => __('Checkout options if the plugin fails to return a rate ', 'woocommerce-settings-tql'),
                    'type' => 'text',
                    'class' => 'hidden',
                    'id' => 'en_quote_settings_unable_retrieve_shipping_tql',
                ],
                'enable_backup_rates_tql' => array(
                    'name' => __('', 'woocommerce-settings-tql-quotes'),
                    'type' => 'checkbox',
                    'desc' => __('Present the user with a backup shipping rate.', 'woocommerce-settings-tql-quotes'),
                    'id' => 'enable_backup_rates_tql',
                ),
                'tql_backup_rates_label' => array(
                    'name' => __('', 'woocommerce-settings-tql-quotes'),
                    'type' => 'text',
                    'desc' => 'Label for backup shipping rate (Maximum of 50 characters).',
                    'id' => 'tql_backup_rates_label'
                ),
                'tql_backup_rates_category' => array(
                    'name' => __('', 'woocommerce-settings-tql-quotes'),
                    'type' => 'radio',
                    'default' => 'fixed_rate',
                    'options' => array(
                        'fixed_rate' => __('', 'woocommerce'),
                        'percentage_of_cart_price' => __('', 'woocommerce'),
                        'function_of_weight' => __('', 'woocommerce'),
                    ),
                    'id' => 'tql_backup_rates_category',
                ),
                'tql_backup_rates_carrier_fails_to_return_response' => array(
                    'name' => __('', 'woocommerce-settings-tql-quotes'),
                    'type' => 'checkbox',
                    'desc' => __('Display the backup rate if the carrier fails to return a response.', 'woocommerce-settings-tql-quotes'),
                    'id' => 'tql_backup_rates_carrier_fails_to_return_response',
                ),
                'tql_backup_rates_carrier_returns_error' => array(
                    'name' => __('', 'woocommerce-settings-tql-quotes'),
                    'type' => 'checkbox',
                    'desc' => __('Display the backup rate if the carrier returns an error.', 'woocommerce-settings-tql-quotes'),
                    'id' => 'tql_backup_rates_carrier_returns_error',
                ),
                'tql_backup_rates_display' => array(
                    'name' => __('', 'woocommerce-settings-tql-quotes'),
                    'type' => 'radio',
                    'default' => 'no_other_rates',
                    'options' => array(
                        'no_plugin_rates' => __('Display the backup rate if the plugin fails to return a rate.', 'woocommerce'),
                        'no_other_rates' => __('Display the backup rate only if no rates, from any shipping method, are presented.', 'woocommerce'),
                    ),
                    'id' => 'tql_backup_rates_display',
                ),
                'en_quote_settings_end_tql' => [
                    'type' => 'sectionend',
                    'id' => 'en_quote_settings_end_tql'
                ],
            );

            return $settings;
        }

    }

}