<?php

namespace EnTqlDistance;

use EnTqlCurl\EnTqlCurl;

if (!class_exists('EnTqlDistance')) {

    class EnTqlDistance
    {

        static public function get_address($map_address, $en_access_level, $en_destination_address = [])
        {
            $post_data = array(
                'acessLevel' => $en_access_level,
                'address' => $map_address,
                'originAddresses' => $map_address,
                'destinationAddress' => (isset($en_destination_address)) ? $en_destination_address : '',
                'eniureLicenceKey' => get_option('en_connection_settings_license_key_tql'),
                'ServerName' => EN_TQL_SERVER_NAME,
            );

            // Eniture debug mode
            do_action("eniture_debug_mood", "Multi Warehouse Distance Request (TQL)", $post_data);

            return EnTqlCurl::en_tql_sent_http_request(EN_TQL_ADDRESS_HITTING_URL, $post_data, 'POST', 'Address');
        }

    }

}