<?php
/**
 * App Name tabs.
 */

use EnTqlConnectionSettings\EnTqlConnectionSettings;
use EnTqlCarriers\EnTqlCarriers;

if (!class_exists('EnTqlTab')) {
    /**
     * Tabs show on admin side.
     * Class EnTqlTab
     */
    class EnTqlTab extends WC_Settings_Page
    {
        /**
         * Hook for call.
         */
        public function en_load()
        {
            $this->id = 'tql';
            add_filter('woocommerce_settings_tabs_array', [$this, 'add_settings_tab'], 50);
            add_action('woocommerce_sections_' . $this->id, [$this, 'output_sections']);
            add_action('woocommerce_settings_' . $this->id, [$this, 'output']);
            add_action('woocommerce_settings_save_' . $this->id, [$this, 'save']);
        }

        /**
         * Setting Tab For Woocommerce
         * @param $settings_tabs
         * @return string
         */
        public function add_settings_tab($settings_tabs)
        {
            $settings_tabs[$this->id] = __('TQL', 'woocommerce-settings-tql');
            return $settings_tabs;
        }

        /**
         * Setting Sections
         * @return array
         */
        public function get_sections()
        {
            $sections = array(
                '' => __('Connection Settings', 'woocommerce-settings-tql'),
                'section-1' => __('Carriers', 'woocommerce-settings-tql'),
                'section-2' => __('Quote Settings', 'woocommerce-settings-tql'),
                'section-3' => __('Warehouses', 'woocommerce-settings-tql'),
                // fdo va
                'section-5' => __('FreightDesk Online', 'woocommerce-settings-tql'),
                'section-6' => __('Validate Addresses', 'woocommerce-settings-tql'),
                'section-4' => __('User Guide', 'woocommerce-settings-tql'),
            );

            // Logs data
            $enable_logs = get_option('en_quote_settings_enable_logs_tql');
            if ($enable_logs == 'yes') {
                $sections['en-logs'] = 'Logs';
            }
 
            $sections = apply_filters('en_tql_add_sections', $sections);
            $sections = apply_filters('en_woo_addons_sections', $sections, EN_TQL_SHIPPING_NAME);
            $sections = apply_filters('en_woo_pallet_addons_sections', $sections, EN_TQL_SHIPPING_NAME);
            return apply_filters('woocommerce_get_sections_' . $this->id, $sections);
        }


        /**
         * Display all pages on wc settings tabs
         * @param $section
         * @return array
         */
        public function get_settings($section = null)
        {
            ob_start();
            switch ($section) {
                case 'section-1' :
                    EnTqlCarriers::en_load();
                    $settings = [];
                    break;

                case 'section-2' :
                    echo '<div class="en_tql_quote_settings en_tql_wrapper">';
                    $settings = \EnTqlQuoteSettings\EnTqlQuoteSettings::Load();
                    break;

                case 'section-3':
                    EnLocation::en_load();
                    $settings = [];
                    break;

                case 'section-4' :
                    \EnTqlUserGuide\EnTqlUserGuide::en_load();
                    $settings = [];
                    break;
                // fdo va
                case 'section-5' :
                    \EnTqlFreightdeskOnline\EnTqlFreightdeskOnline::en_load();
                    $settings = [];
                    break;

                case 'section-6' :
                    \EnTqlValidateAddress\EnTqlValidateAddress::en_load();
                    $settings = [];
                    break;

                case 'en-logs' :
                    require_once 'logs/en-logs.php';
                    $settings = [];
                    break;  

                default:
                    $settings = EnTqlConnectionSettings::en_load();
                    break;
            }

            $settings = apply_filters('en_tql_add_settings', $settings, $section);
            $settings = apply_filters('en_woo_addons_settings', $settings, $section, EN_TQL_SHIPPING_NAME);
            $settings = apply_filters('en_woo_pallet_addons_settings', $settings, $section, EN_TQL_SHIPPING_NAME);
            $settings = $this->avaibility_addon($settings);
            return apply_filters('woocommerce-settings-tql', $settings, $section);
        }

        /**
         * RAD addon activated or not
         * @param array type $settings
         * @return array type
         */
        function avaibility_addon($settings)
        {
            if (!function_exists('is_plugin_active')) {
                require_once(EN_TQL_ABSPATH . '/wp-admin/includes/plugin.php');
            }

            if (is_plugin_active('residential-address-detection/residential-address-detection.php')) {
                unset($settings['avaibility_lift_gate']);
                unset($settings['avaibility_auto_residential']);
            }

            return $settings;
        }

        /**
         * WooCommerce Settings Tabs
         * @global $current_section
         */
        public function output()
        {
            global $current_section;
            $settings = $this->get_settings($current_section);

            // backup rates
            $backup_rates_fields = ['tql_backup_rates_fixed_rate', 'tql_backup_rates_cart_price_percentage', 'tql_backup_rates_weight_function'];
            foreach ($backup_rates_fields as $field) {
                if (isset($_POST[$field])) update_option($field, $_POST[$field]);
            }

            WC_Admin_Settings::output_fields($settings);
        }

        /**
         * Woocommerce Save Settings
         * @global $current_section
         */
        public function save()
        {
            global $current_section;
            $settings = $this->get_settings($current_section);
            WC_Admin_Settings::save_fields($settings);
        }
    }

    $en_tab = new EnTqlTab();
    return $en_tab->en_load();
}
