<?php

/**
 * Test connection details.
 */

namespace EnTqlConnectionSettings;

use EnTqlConfig\EnTqlConfig;

/**
 * Add array for test connection.
 * Class EnTqlConnectionSettings
 * @package EnTqlConnectionSettings
 */
if (!class_exists('EnTqlConnectionSettings')) {

    class EnTqlConnectionSettings
    {

        static $get_connection_details = [];

        /**
         * Connection settings template.
         * @return array
         */
        static public function en_load()
        {
            echo '<div class="en_tql_connection_settings en_tql_wrapper">';
            
            $start_settings = [
                'en_connection_settings_start_tql' => [
                    'name' => __('', 'woocommerce-settings-tql'),
                    'type' => 'title',
                    'id' => 'en_connection_settings_tql',
                ],
            ];

            // App Name Connection Settings Detail
            $eniture_settings = self::en_set_connection_settings_detail();

            $end_settings = [
                'en_connection_settings_end_tql' => [
                    'type' => 'sectionend',
                    'id' => 'en_connection_settings_end_tql'
                ]
            ];

            $settings = array_merge($start_settings, $eniture_settings, $end_settings);

            return $settings;
        }

        /**
         * Connection Settings Detail
         * @return array
         */
        static public function en_get_connection_settings_detail()
        {
            $connection_request = self::en_static_request_detail();
            $en_request_indexing = json_decode(EN_TQL_SET_CONNECTION_SETTINGS, true);
            foreach ($en_request_indexing as $key => $value) {
                $saved_connection_detail = get_option($key);
                $connection_request[$value['eniture_action']] = $saved_connection_detail;
                strlen($saved_connection_detail) > 0 ?
                    self::$get_connection_details[$value['eniture_action']] = $saved_connection_detail : '';
            }

            add_filter('en_tql_reason_quotes_not_returned', [__CLASS__, 'en_tql_reason_quotes_not_returned'], 99, 1);

            return $connection_request;
        }

        /**
         * Saving reasons to show proper error message on the cart or checkout page
         * When quotes are not returning
         * @param array $reasons
         * @return array
         */
        static public function en_tql_reason_quotes_not_returned($reasons)
        {
            return empty(self::$get_connection_details) ? array_merge($reasons, [EN_TQL_711]) : $reasons;
        }

        /**
         * Static Detail Set
         * @return array
         */
        static public function en_static_request_detail()
        {
            $woo_and_plugin_versions = EnTqlConfig::en_get_woo_version_number();

            return
                [
                    'wordpress_version' => get_bloginfo('version'),
                    'woocommerce_version' => isset($woo_and_plugin_versions['woocommerce_version']) ? $woo_and_plugin_versions['woocommerce_version'] : '',
                    'plugin_version' => isset($woo_and_plugin_versions['plugin_version']) ? $woo_and_plugin_versions['plugin_version'] : '',
                    'serverName' => EN_TQL_SERVER_NAME,
                    'platform' => 'WordPress',
                    'carrierType' => 'LTL',
                    'carrierName' => 'tql',
                    'carrierMode' => 'pro',
                    'requestVersion' => '2.0',
                    'requestKey' => time()
                ];
        }

        /**
         * Connection Settings Detail Set
         * @return array
         */
        static public function en_set_connection_settings_detail()
        {
            return
                [
                    'en_connection_settings_client_id_tql' => [
                        'eniture_action' => 'clientId',
                        'name' => __('Client Id ', 'woocommerce-settings-tql'),
                        'type' => 'text',
                        'desc' => __('', 'woocommerce-settings-tql'),
                        'id' => 'en_connection_settings_client_id_tql'
                    ],
                    'en_connection_settings_trax_username_tql' => [
                        'eniture_action' => 'traxUsername',
                        'name' => __('Trax Username ', 'woocommerce-settings-tql'),
                        'type' => 'text',
                        'desc' => __('', 'woocommerce-settings-tql'),
                        'id' => 'en_connection_settings_trax_username_tql'
                    ],
                    'en_connection_settings_trax_password_tql' => [
                        'eniture_action' => 'traxPassword',
                        'name' => __('Trax Password ', 'woocommerce-settings-tql'),
                        'type' => 'text',
                        'desc' => __('', 'woocommerce-settings-tql'),
                        'id' => 'en_connection_settings_trax_password_tql'
                    ],
                    'en_connection_settings_subscription_key_tql' => [
                        'eniture_action' => 'subscriptionKey',
                        'name' => __('Subscription Key ', 'woocommerce-settings-tql'),
                        'type' => 'text',
                        'desc' => __('', 'woocommerce-settings-tql'),
                        'id' => 'en_connection_settings_subscription_key_tql'
                    ],
                    'en_connection_settings_license_key_tql' => [
                        'eniture_action' => 'licenseKey',
                        'name' => __('Eniture API Key ', 'woocommerce-settings-tql'),
                        'type' => 'text',
                        'desc' => __('Obtain a Eniture API Key from <a href="' . EN_TQL_ROOT_URL_PRODUCTS . '" target="_blank" >eniture.com </a>', 'woocommerce-settings-tql'),
                        'id' => 'en_connection_settings_license_key_tql'
                    ],
                ];
        }

    }

}