<?php

/**
 * Test Connection request.
 */

namespace EnTqlTestConnection;

use EnTqlCurl\EnTqlCurl;

/**
 * Test connection request.
 * Class EnTqlTestConnection
 * @package EnTqlTestConnection
 */
if (!class_exists('EnTqlTestConnection')) {

    class EnTqlTestConnection {

        /**
         * Hook in ajax handlers.
         */
        public function __construct() {
            add_action('wp_ajax_nopriv_en_tql_test_connection', [$this, 'en_tql_test_connection']);
            add_action('wp_ajax_en_tql_test_connection', [$this, 'en_tql_test_connection']);
        }

        /**
         * Handle Connection Settings Ajax Request
         */
        public function en_tql_test_connection() {
            if (!(current_user_can('manage_options') || current_user_can('manage_woocommerce')) || !wp_verify_nonce($_POST['wp_nonce'], 'en_tql_admin_nonce')) {
                echo wp_json_encode(array('error' => true, 'message' => 'Unauthorized Access.'));;
                exit;
            }

            $en_post_data = [];
            if (isset($_POST['en_post_data']) && !empty($_POST['en_post_data'])) {
                parse_str(sanitize_text_field($_POST['en_post_data']), $en_post_data);
            }

            $en_request_indexing = json_decode(EN_TQL_SET_CONNECTION_SETTINGS, true);
            $en_connection_request = json_decode(EN_TQL_GET_CONNECTION_SETTINGS, true);

            foreach ($en_post_data as $en_request_name => $en_request_value) {
                $en_connection_request[$en_request_indexing[$en_request_name]['eniture_action']] = $en_request_value;
            }

            $en_connection_request['carrierMode'] = 'test';
            $en_connection_request = apply_filters('en_tql_add_connection_request', $en_connection_request);

            echo EnTqlCurl::en_tql_sent_http_request(
                    EN_TQL_HITTING_API_URL, $en_connection_request, 'POST', 'Connection'
            );
            exit;
        }

    }

}