<?php

/**
 * Carriers show.
 */

namespace EnTqlCarriers;

/**
 * Show and update carriers.
 * Class EnTqlCarriers
 * @package EnTqlCarriers
 */
if (!class_exists('EnTqlCarriers')) {

    class EnTqlCarriers {

        /**
         * Show Carriers
         */
        static public function en_load() {
            self::en_save_carriers();
            $en_tql_carriers = EnTqlCarriers::en_tql_carriers();
            echo '<div class="en_tql_carriers">';
            echo '<form method="post">';
            echo force_balance_tags('<p>Identifies which carriers are included in the quote response, not what is displayed in the shopping cart. Identify what displays in the shopping cart in the Quote Settings. For example, you may include quote responses from all carriers, but elect to only show the cheapest three in the shopping cart.  <br> <br> Not all carriers service all origin and destination points. If a carrier doesn`t service the ship to address, it is automatically omitted from the quote response. Consider conferring with your TQL representative if you`d like to narrow the number of carrier responses.</p>');
            echo '<table>';
            echo '<tr>';
            echo force_balance_tags('<th>Carrier Name</th>');
            echo force_balance_tags('<th>Logo</th>');
            echo force_balance_tags('<th> <input type="checkbox" id="en_tql_total_carriers"> </th>');
            echo '</tr>';
            $en_checked_carriers = get_option('en_tql_carriers');
            $en_checked_carriers = (isset($en_checked_carriers) && strlen($en_checked_carriers) > 0) ? json_decode($en_checked_carriers, true) : self::getCarriers();

            foreach ($en_tql_carriers as $key => $value) {
                $en_tql_carrier = in_array($value['en_standard_carrier_alpha_code'], $en_checked_carriers) ? "checked='checked'" : '';
                echo '<tr>';
                echo '<td> ' . esc_attr($value['en_tql_carrier_name']) . ' </td>';
                echo '<td> <img alt="carriers"  src="' . esc_attr(EN_TQL_DIR_FILE) . '/admin/tab/carriers/assets/' . esc_attr($value['en_tql_carrier_logo']) . '"> </td>';
                echo '<td> <input type="checkbox" class="en_tql_carrier" name="en_tql_carrier[]" value="' . esc_attr($value['en_standard_carrier_alpha_code']) . '" ' . $en_tql_carrier . '> </td>';
                echo '</tr>';
            }

            echo '</form>';
            echo '</table>';
            echo '</div>';
        }

        /**
         * Carriers Save Data
         */
        static public function en_save_carriers() {
            if (isset($_POST['en_tql_carrier']) && (!empty($_POST['en_tql_carrier']))) {
                $en_tql_carrier = array_map('sanitize_text_field', $_POST['en_tql_carrier']);
                update_option('en_tql_carriers', wp_json_encode($en_tql_carrier));
                echo "<script type='text/javascript'>
                window.location=document.location.href;
            </script>";
            }
        }

        /**
         * Carriers Data
         */
        static public function en_tql_carriers() {
            $carrier = [
                [
                    'en_standard_carrier_alpha_code' => 'PYLE',
                    'en_tql_carrier_name' => 'A Duie PYLE',
                    'en_tql_carrier_logo' => 'pyle.jpg'
                ],
                [
                    'en_standard_carrier_alpha_code' => 'AACT',
                    'en_tql_carrier_name' => 'AAA Cooper Transportation',
                    'en_tql_carrier_logo' => 'AACT.png'
                ],
                [
                    'en_standard_carrier_alpha_code' => 'ABFS',
                    'en_tql_carrier_name' => 'ABF Freight',
                    'en_tql_carrier_logo' => 'ABFS.png'
                ],
                [
                    'en_standard_carrier_alpha_code' => 'AVRT',
                    'en_tql_carrier_name' => 'Averitt Express',
                    'en_tql_carrier_logo' => 'avrt.png'
                ],
                [
                    'en_standard_carrier_alpha_code' => 'CLNI',
                    'en_tql_carrier_name' => 'Clear Lane Freight Systems',
                    'en_tql_carrier_logo' => 'clni.png'
                ],
                [
                    'en_standard_carrier_alpha_code' => 'CNWY',
                    'en_tql_carrier_name' => 'XPO Logistics',
                    'en_tql_carrier_logo' => 'cnwy.png'
                ],
                [
                    'en_standard_carrier_alpha_code' => 'DAFG',
                    'en_tql_carrier_name' => 'Dayton Freight',
                    'en_tql_carrier_logo' => 'DAFG.png'
                ],
                [
                    'en_standard_carrier_alpha_code' => 'DHRN',
                    'en_tql_carrier_name' => 'Dohrn Transfer Company',
                    'en_tql_carrier_logo' => 'DHRN.png'
                ],
                [
                    'en_standard_carrier_alpha_code' => 'EXLA',
                    'en_tql_carrier_name' => 'Estes Express',
                    'en_tql_carrier_logo' => 'exla.png'
                ],
                [
                    'en_standard_carrier_alpha_code' => 'fxfe',
                    'en_tql_carrier_name' => 'Fedex Freight Priority',
                    'en_tql_carrier_logo' => 'fxfe.png'
                ],
                [
                    'en_standard_carrier_alpha_code' => 'FWDN',
                    'en_tql_carrier_name' => 'Forward Air, Inc',
                    'en_tql_carrier_logo' => 'fwdn.png'
                ],
                [
                    'en_standard_carrier_alpha_code' => 'FCSY',
                    'en_tql_carrier_name' => 'Frontline Freight Inc',
                    'en_tql_carrier_logo' => 'fcsy.png'
                ],
                [
                    'en_standard_carrier_alpha_code' => 'HMES',
                    'en_tql_carrier_name' => 'USF Holland',
                    'en_tql_carrier_logo' => 'hmes.png'
                ],
                [
                    'en_standard_carrier_alpha_code' => 'MIDW',
                    'en_tql_carrier_name' => 'Midwest Motor Express',
                    'en_tql_carrier_logo' => 'midw.png'
                ],
                [
                    'en_standard_carrier_alpha_code' => 'NPME',
                    'en_tql_carrier_name' => 'New Penn Motor Express',
                    'en_tql_carrier_logo' => 'npme.png'
                ],
                [
                    'en_standard_carrier_alpha_code' => 'ODFL',
                    'en_tql_carrier_name' => 'Old Dominion Freight Lines',
                    'en_tql_carrier_logo' => 'ODFL.png'
                ],
                [
                    'en_standard_carrier_alpha_code' => 'PITD',
                    'en_tql_carrier_name' => 'Pitt Ohio Express, LLC',
                    'en_tql_carrier_logo' => 'pitd.png'
                ],
                [
                    'en_standard_carrier_alpha_code' => 'RETL',
                    'en_tql_carrier_name' => 'USF Reddaway',
                    'en_tql_carrier_logo' => 'retl.png'
                ],
                [
                    'en_standard_carrier_alpha_code' => 'RDFS',
                    'en_tql_carrier_name' => 'Roadrunner Freight',
                    'en_tql_carrier_logo' => 'RDFS.png'
                ],
                [
                    'en_standard_carrier_alpha_code' => 'SAIA',
                    'en_tql_carrier_name' => 'Saia LTL Freight',
                    'en_tql_carrier_logo' => 'SAIA.png'
                ],
                [
                    'en_standard_carrier_alpha_code' => 'SEFL',
                    'en_tql_carrier_name' => 'Southeastern Freight Lines',
                    'en_tql_carrier_logo' => 'SEFL.png'
                ],
                [
                    'en_standard_carrier_alpha_code' => 'SMTL',
                    'en_tql_carrier_name' => 'Southwestern Motor Transport',
                    'en_tql_carrier_logo' => 'smtl.png'
                ],
                [
                    'en_standard_carrier_alpha_code' => 'UPGF',
                    'en_tql_carrier_name' => 'TForce',
                    'en_tql_carrier_logo' => 'upgf.png'
                ],
                [
                    'en_standard_carrier_alpha_code' => 'WARD',
                    'en_tql_carrier_name' => 'Ward Trucking',
                    'en_tql_carrier_logo' => 'ward.png'
                ],
                [
                    'en_standard_carrier_alpha_code' => 'XGSI',
                    'en_tql_carrier_name' => 'Xpress Global Systems',
                    'en_tql_carrier_logo' => 'xgsi.png'
                ]
            ];

            return $carrier;
        }

        public static function getCarriers(){
            $carriers_arr = ['PYLE','AACT','ABFS','AVRT','CLNI','CNWY','DAFG','DHRN','EXLA','fxfe','FWDN','FCSY','HMES','MIDW','NPME','ODFL','PITD','RETL','RDFS','SAIA','SEFL','SMTL','UPGF','WARD','XGSI'];
            update_option('en_tql_carriers', wp_json_encode($carriers_arr));
            return $carriers_arr;
        }

    }

}
