jQuery(document).ready(function () {

    // Weight threshold for LTL freight
    en_weight_threshold_limit();

    // Common settings.
    jQuery('#en_connection_settings_client_id_tql').closest('table').attr('id', 'en_tql_connection_settings');
    jQuery('#en_quote_settings_rating_method_tql').closest('table').attr('id', 'en_tql_quote_settings');
    jQuery("#order_shipping_line_items .shipping .display_meta").css('display', 'none');
    jQuery('#en_quote_settings_custom_label_tql').attr('maxlength', '50');
    jQuery('#en_quote_settings_handling_unit_weight_tql, #en_quote_settings_max_handling_unit_weight_tql').attr('maxlength', '7')

    // Carriers Tab
    if (jQuery('.en_tql_carriers').length > 0) {
        // Making the function to check when no checkbox was checked.
        jQuery('.en_tql_carriers').next('.submit').find('.button-primary, .is-primary').on('click', function (event) {
            jQuery('.en_settings_message').remove();
            let en_tql_carrier = jQuery('.en_tql_carriers .en_tql_carrier').is(':checked');
            if (!en_tql_carrier) {
                let en_carrier_error_msg = 'Please select at least one carrier service.';
                jQuery('.subsubsub').next('.clear').after('<div class="notice notice-error en_settings_message"><p><strong>Error! </strong>' + en_carrier_error_msg + '</p></div>');
                jQuery('#en_settings_message').delay(200).animate({scrollTop: 0}, 1000);
                jQuery('html, body').animate({scrollTop: 0}, 'slow');
                return false;
            }
        });
    }

    // Quote Settings Tab
    if (jQuery('#en_tql_quote_settings').length > 0) {
        // Always include lift gate delivery when a residential address is detected.
        jQuery(".en_woo_addons_liftgate_with_auto_residential_tql").attr("disabled", true);

        // Liftgate accessorials action perfrom on click
        jQuery(".liftgate_accessorial_action").on("click", function () {
            var id = jQuery(this).attr("id");
            if (id == "en_quote_settings_liftgate_delivery_tql") {
                jQuery("#tql_liftgate_delivery_as_option").prop({checked: false});
                jQuery("#en_woo_addons_liftgate_with_auto_residential").prop({checked: false});

            } else if (id == "tql_liftgate_delivery_as_option" ||
                id == "en_woo_addons_liftgate_with_auto_residential") {
                jQuery("#en_quote_settings_liftgate_delivery_tql").prop({checked: false});
            }
        });

        jQuery('#en_quote_settings_rating_method_tql').on('change', function () {
            en_tql_action_rating_method();
        });

        // On page load Action perform related Rating Method
        en_tql_action_rating_method();

        jQuery("#en_quote_settings_residential_delivery_tql," +
            "#en_quote_settings_handling_unit_weight_tql," +
            "#en_quote_settings_max_handling_unit_weight_tql," +
            "#en_quote_settings_availability_auto_residential_tql," +
            "#en_quote_settings_liftgate_delivery_tql," +
            "#tql_liftgate_delivery_as_option," +
            "#en_quote_settings_availability_liftgate_tql," +
            "#en_woo_addons_liftgate_with_auto_residential").closest('tr').addClass("en_quote_settings_sub_options");

        // Making the generic function regarding validation which will work for all text fields.
        jQuery('#en_tql_quote_settings').parents().find('.button-primary, .is-primary').on('click', function (event) {

            let en_validate_settings = {};
            let en_data_error = true;

            en_validate_settings['#en_quote_settings_handling_fee_tql'] = {
                'en_data_type': 'isNumeric',
                'en_after_decimal': 2,
                'en_add_percentage': true,
                'en_minus_sign': true,
                'en_max_length': false,
                'en_error_msg': 'Handling fee format should be 100.20 or 10% and only 2 digits are allowed after decimal point.',
            };

            en_validate_settings['#en_quote_settings_handling_unit_weight_tql'] = {
                'en_data_type': 'isNumeric',
                'en_after_decimal': 2,
                'en_add_percentage': false,
                'en_minus_sign': false,
                'en_max_length': false,
                'en_error_msg': 'Weight of Handling Unit format should be 100.20 or 10 and only 2 digits are allowed after decimal point.',
            };

            en_validate_settings['#en_quote_settings_max_handling_unit_weight_tql'] = {
                'en_data_type': 'isNumeric',
                'en_after_decimal': 2,
                'en_add_percentage': false,
                'en_minus_sign': false,
                'en_max_length': false,
                'en_error_msg': 'Maximum Weight per Handling Unit format should be 100.20 or 10 and only 2 digits are allowed after decimal point.',
            };

            jQuery('.en_settings_message').remove();

            jQuery.each(en_validate_settings, function (index, item) {

                let is_data = jQuery(index).val();

                let is_regex_after_decimal = typeof item.en_after_decimal !== undefined ? item.en_after_decimal : '';
                let is_regex_add_percentage = typeof item.en_add_percentage !== undefined && item.en_add_percentage ? '%?' : '';
                let is_regex_minus_sign = typeof item.en_minus_sign !== undefined && item.en_minus_sign ? '-?' : '';
                let is_regex_en_max_length = typeof item.en_max_length !== undefined && item.en_max_length ? item.en_max_length : 0;
                // let is_data_regex = typeof item.en_data_type !== undefined && item.en_data_type == 'isNumeric' ? '^' + is_regex_minus_sign + '\\d*(?:\\.?\\d{0,' + is_regex_after_decimal + '}?)' + is_regex_add_percentage + '$' : '';

                let is_data_regex = '';
                if (typeof item.en_data_type !== undefined) {
                    switch (item.en_data_type) {
                        case "isNumeric":
                            is_data_regex = '^' + is_regex_minus_sign + '\\d*(?:\\.?\\d{0,' + is_regex_after_decimal + '}?)' + is_regex_add_percentage + '$';
                            // is_data_regex = '^' + is_regex_minus_sign + '\\d+(?:\\.?\\d{0,' + is_regex_after_decimal + '}?)' + is_regex_add_percentage + '$';
                            break;
                    }
                }

                let en_error_msg = typeof item.en_error_msg !== undefined ? item.en_error_msg : '';

                let is_data_valid = is_validate_regex(is_data, is_data_regex);
                if (!is_data_valid) {
                    en_data_error = false;
                    const next_elem = (jQuery('.subsubsub').next('.clear'))?.length ? '.clear' : '#en-woo-review-plugin';
                    jQuery('.subsubsub').next(next_elem).after('<div class="notice notice-error en_settings_message"><p><strong>Error! </strong>' + en_error_msg + '</p></div>');
                }
            });

            if (!en_data_error) {
                jQuery('#en_settings_message').delay(200).animate({scrollTop: 0}, 1000);
                jQuery('html, body').animate({scrollTop: 0}, 'slow');
                return false;
            }

            // backup rates validation
            if (!tqlBackupRatesValidations()) return false;
        });
    }

    // Connection Settings Tab
    if (jQuery('#en_tql_connection_settings').length > 0) {
        jQuery('#en_connection_settings_client_id_tql').attr('title', 'Client Id');
        jQuery('#en_connection_settings_trax_username_tql').attr('title', 'Trax Username');
        jQuery('#en_connection_settings_trax_password_tql').attr('title', 'Trax Password');
        jQuery('#en_connection_settings_subscription_key_tql').attr('title', 'Subscription Key');
        jQuery('#en_connection_settings_license_key_tql').attr('title', 'Eniture API Key');

        jQuery('#en_tql_connection_settings').before("<div class='en_warning_message'><p>Note! You must have an LTL Freight enabled TQL account to use this application. If you do not have one, call 877.226.9950, or <a href='https://www.tql.com/' target='_blank' >register</a> online.</p></div>");

        jQuery('#wpfooter').hide();

        /**
         * Add en_location_error class on connection settings page
         */
        jQuery('#en_tql_connection_settings input[type="text"]').each(function () {
            if (jQuery(this).parent().find('.en_connection_error').length < 1) {
                jQuery(this).after('<span class="en_connection_error"></span>');
            }
        });

        //Append "Test Connection" Btn
        jQuery('.woocommerce-save-button').before('<button name="en_tql_test_connection" class="button-primary en_tql_test_connection components-button is-primary" id="en_tql_test_connection" type="submit" value="Test Connection">Test Connection</button>');

        jQuery('.en_tql_connection_settings .button-primary, .en_tql_connection_settings .is-primary').on('click', function (event) {

            let validate = en_validate_input('#en_tql_connection_settings');

            if (validate === false) {
                return false;
            }

            if (event.target.id == 'en_tql_test_connection') {
                let connection_fields = jQuery('#en_tql_connection_settings input').serialize();
                let client_id = jQuery('#en_connection_settings_client_id_tql').val();
                let user_name = jQuery('#en_connection_settings_trax_username_tql').val();
                let password = jQuery('#en_connection_settings_trax_password_tql').val();
                let subscription_key = jQuery('#en_connection_settings_subscription_key_tql').val();
                let license_key = jQuery('#en_connection_settings_license_key_tql').val();

                var dataString = 'en_connection_settings_client_id_tql=' + client_id
                    + '&en_connection_settings_trax_username_tql=' + user_name
                    + '&en_connection_settings_trax_password_tql=' + password
                    + '&en_connection_settings_subscription_key_tql=' + subscription_key
                    + '&en_connection_settings_license_key_tql=' + license_key;
                let postForm = {
                    'action': 'en_tql_test_connection',
                    'en_post_data': dataString,
                    'wp_nonce': en_tql_admin_script.nonce
                };

                let params = {
                    en_ajax_loading_id: '#en_connection_settings_client_id_tql,#en_connection_settings_trax_username_tql,#en_connection_settings_trax_password_tql,#en_connection_settings_subscription_key_tql,#en_connection_settings_license_key_tql',
                };

                en_ajax_request(params, postForm, en_action_test_connection);
                return false;
            }
        });
    }
    // fdo va
    jQuery('#fd_online_id_tql').click(function (e) {
        var postForm = {
            'action': 'tql_fd',
            'company_id': jQuery('#freightdesk_online_id').val(),
            'disconnect': jQuery('#fd_online_id_tql').attr("data"),
            'wp_nonce': en_tql_admin_script.nonce
        }
        var id_lenght = jQuery('#freightdesk_online_id').val();
        var disc_data = jQuery('#fd_online_id_tql').attr("data");
        if(typeof (id_lenght) != "undefined" && id_lenght.length < 1) {
            jQuery(".en_connection_message").remove();
            jQuery('.user_guide_fdo').before('<div class="notice notice-error en_connection_message"><p><strong>Error!</strong> FreightDesk Online ID is Required.</p></div>');
            return;
        }
        jQuery.ajax({
            type: "POST",
            url: ajaxurl,
            data: postForm,
            beforeSend: function () {
                jQuery('#freightdesk_online_id').css('background',
                    'rgba(255, 255, 255, 1) url("' + EN_TQL_DIR_FILE + '' +
                    '/admin/tab/location/assets/images/processing.gif") no-repeat scroll 50% 50%');
            },
            success: function (data_response) {
                if(typeof (data_response) == "undefined"){
                    return;
                }
                var fd_data = JSON.parse(data_response);
                jQuery('#freightdesk_online_id').css('background', '#fff');
                jQuery(".en_connection_message").remove();
                if((typeof (fd_data.is_valid) != 'undefined' && fd_data.is_valid == false) || (typeof (fd_data.status) != 'undefined' && fd_data.is_valid == 'ERROR')) {
                    jQuery('.user_guide_fdo').before('<div class="notice notice-error en_connection_message"><p><strong>Error! ' + fd_data.message + '</strong></p></div>');
                }else if(typeof (fd_data.status) != 'undefined' && fd_data.status == 'SUCCESS') {
                    jQuery('.user_guide_fdo').before('<div class="notice notice-success en_connection_message"><p><strong>Success! ' + fd_data.message + '</strong></p></div>');
                    window.location.reload(true);
                }else if(typeof (fd_data.status) != 'undefined' && fd_data.status == 'ERROR') {
                    jQuery('.user_guide_fdo').before('<div class="notice notice-error en_connection_message"><p><strong>Error! ' + fd_data.message + '</strong></p></div>');
                }else if (fd_data.is_valid == 'true') {
                    jQuery('.user_guide_fdo').before('<div class="notice notice-error en_connection_message"><p><strong>Error!</strong> FreightDesk Online ID is not valid.</p></div>');
                } else if (fd_data.is_valid == 'true' && fd_data.is_connected) {
                    jQuery('.user_guide_fdo').before('<div class="notice notice-error en_connection_message"><p><strong>Error!</strong> Your store is already connected with FreightDesk Online.</p></div>');

                } else if (fd_data.is_valid == true && fd_data.is_connected == false && fd_data.redirect_url != null) {
                    window.location = fd_data.redirect_url;
                } else if (fd_data.is_connected == true) {
                    jQuery('#con_dis').empty();
                    jQuery('#con_dis').append('<a href="#" id="fd_online_id_tql" data="disconnect" class="button-primary">Disconnect</a>')
                }
            }
        });
        e.preventDefault();
    });
    /**
     * When click on select all carriers checkbox
     */
    jQuery("#en_tql_total_carriers").on('click', function () {
        jQuery('.en_tql_carriers input:checkbox').not(this).prop('checked', this.checked);
    });

    /**
     * carrier checkbox
     */
    jQuery(".en_tql_carrier").on('click', function () {
        en_tql_carriers();
    });

    en_tql_carriers();

    // Review plugin button
    if (jQuery('.tql_plan_notice').length > 0 || jQuery('.en_tql_wrapper').length > 0) {
        const review_plugin_html = '<div id="en-woo-review-plugin"><a href="https://wordpress.org/support/plugin/ltl-freight-quotes-tql-edition/reviews/#new-post" target="_blank" class="button button-primary is-primary">Review this plugin</a></div>';

        if (jQuery('ul.subsubsub').length > 0) {
            jQuery('.subsubsub').after(review_plugin_html);
        } else {
            jQuery('li a:contains("Connection Settings")').closest('ul').after(review_plugin_html);
        }
    }

    // Product variants settings
    jQuery(document).on("click", '._nestedMaterials', function(e) {
        const checkbox_class = jQuery(e.target).attr("class");
        const name = jQuery(e.target).attr("name");
        const checked = jQuery(e.target).prop('checked');

        if (checkbox_class?.includes('_nestedMaterials')) {
            const id = name?.split('_nestedMaterials')[1];
            setNestMatDisplay(id, checked);
        }
    });

    // Callback function to execute when mutations are observed
    const handleMutations = (mutationList) => {
        let childs = [];
        for (const mutation of mutationList) {
            childs = mutation?.target?.children;
            if (childs?.length) setNestedMaterialsUI();
          }
    };
    const observer = new MutationObserver(handleMutations),
        targetNode = document.querySelector('.woocommerce_variations.wc-metaboxes'),
        config = { childList: true, subtree: true };
    if (targetNode) observer.observe(targetNode, config);

    // Blocked stores notification
    tqlBlockedStoresNotifications();
    // Backup rates settings
    tqlBackupRatesSettings();
});

// Weight threshold for LTL freight
if (typeof en_weight_threshold_limit != 'function') {
    function en_weight_threshold_limit() {
        // Weight threshold for LTL freight
        jQuery("#en_weight_threshold_lfq").keypress(function (e) {
            if (String.fromCharCode(e.keyCode).match(/[^0-9]/g) || !jQuery("#en_weight_threshold_lfq").val().match(/^\d{0,3}$/)) return false;
        });

        jQuery('#en_plugins_return_LTL_quotes').on('change', function () {
            if (jQuery('#en_plugins_return_LTL_quotes').prop("checked")) {
                jQuery('tr.en_weight_threshold_lfq').css('display', 'table-row');
            } else {
                jQuery('tr.en_weight_threshold_lfq').css('display', 'none');
            }
        });

        jQuery("#en_plugins_return_LTL_quotes").closest('tr').addClass("en_plugins_return_LTL_quotes_tr");
        // Weight threshold for LTL freight
        var weight_threshold_class = jQuery("#en_weight_threshold_lfq").attr("class");
        jQuery("#en_weight_threshold_lfq").closest('tr').addClass("en_weight_threshold_lfq " + weight_threshold_class);

        // Weight threshold for LTL freight is empty
        if (jQuery('#en_weight_threshold_lfq').length && !jQuery('#en_weight_threshold_lfq').val().length > 0) {
            jQuery('#en_weight_threshold_lfq').val(150);
        }
    }
}
// Update plan
if (typeof en_update_plan_tql != 'function') {
    function en_update_plan_tql(input) {
        let action = jQuery(input).attr('data-action');
        jQuery.ajax({
            type: "POST",
            url: ajaxurl,
            data: {action: action},
            success: function (data_response) {
                window.location.reload(true);
            }
        });
    }
}
if (typeof is_validate_regex != 'function') {
    function is_validate_regex(is_data, is_data_regex) {
        return jQuery.trim(is_data).match(new RegExp(is_data_regex)) ? true : false;
    }
}

/**
 * ==============================================================
 *  Carrier Tab
 * ==============================================================
 */

/**
 * click on carrier checkbox
 */
if (typeof en_action_test_connection != 'function') {
    function en_action_test_connection(params, response) {
        let en_message = '';
        let data = JSON.parse(response);
        let en_class_name = 'notice notice-error en_connection_message';
        jQuery('.en_connection_message').remove();
        let data_severity = typeof data.severity !== undefined ? data.severity : '';
        let data_severity_type = 'Error! ';

        switch (data_severity) {
            case 'SUCCESS':
                en_message = data.Message;
                data_severity_type = 'Success! ';
                en_class_name = 'notice notice-success en_connection_message';
                break;
            case 'ERROR':
                en_message = data.Message;
                break;
            default:
                en_message = 'Unknown error';
                break;
        }

        jQuery('.en_warning_message').after('<div class="' + en_class_name + '"><p><strong>' + data_severity_type + '</strong>' + en_message + '</p></div>');
    }
}

/**
 * When click on carriers checkbox
 */
if (typeof en_tql_carriers != 'function') {
    function en_tql_carriers() {
        if (jQuery('.en_tql_carrier:checked').length == jQuery('.en_tql_carrier').length) {
            jQuery('#en_tql_total_carriers').prop('checked', true);
        } else {
            jQuery('#en_tql_total_carriers').prop('checked', false);
        }
    }
}

/**
 * ==============================================================
 *  Quote Settings Tab
 * ==============================================================
 */

/**
 * Action perform related Rating Method
 */
if (typeof en_tql_action_rating_method != 'function') {
    function en_tql_action_rating_method() {
        let en_rating_method = jQuery('#en_quote_settings_rating_method_tql').val();
        let en_selecter_number_of_options = jQuery('#en_quote_settings_number_of_options_tql');
        let en_selecter_custom_label = jQuery('#en_quote_settings_custom_label_tql');
        let en_rating_method_desc = 'Displays a least expensive option.';
        jQuery('#en_quote_settings_number_of_options_tql').next('.description').text('Number of options to display in the shopping cart.');

        switch (en_rating_method) {
            case 'Cheapest':
                en_selecter_number_of_options.closest('tr').hide();
                en_selecter_custom_label.closest('tr').show();
                en_rating_method_desc = 'Displays a least expensive option.';
                break;

            case 'cheapest_options':
                en_selecter_number_of_options.closest('tr').show();
                en_selecter_custom_label.closest('tr').hide();
                en_rating_method_desc = 'Displays a list of a specified number of least expensive options.';
                break;

            case 'average_rate':
                jQuery('#en_quote_settings_number_of_options_tql').next('.description').text('Number of options to include in the calculation of the average.');
                en_selecter_number_of_options.closest('tr').show();
                en_selecter_custom_label.closest('tr').show();
                en_rating_method_desc = 'Displays a single rate based on an average of a specified number of least expensive options.';
                break;
        }

        jQuery('#en_quote_settings_rating_method_tql').next('.description').text(en_rating_method_desc);
    }
}

/**
 * Eniture Validation Form JS
 */
if (typeof en_validate_input != 'function') {
    function en_validate_input(form_id) {
        let has_err = true;
        jQuery(form_id + " input[type='text']").each(function () {

            let input = jQuery(this).val();
            let response = en_validate_string(input);
            let errorText = jQuery(this).attr('title');
            let optional = jQuery(this).data('optional');

            let en_error_element = jQuery(this).parent().find('.en_location_error,.en_connection_error');
            jQuery(en_error_element).html('');

            optional = (optional === undefined) ? 0 : 1;
            errorText = (errorText != undefined) ? errorText : '';

            if ((optional == 0) && (response == false || response == 'empty')) {
                errorText = (response == 'empty') ? errorText + ' is required.' : 'Invalid input.';
                jQuery(en_error_element).html(errorText);
            }
            has_err = (response != true && optional == 0) ? false : has_err;
        });
        return has_err;
    }
}

/**
 * Validate Input String
 */
if (typeof en_validate_string != 'function') {
    function en_validate_string(string) {
        if (string == '')
            return 'empty';
        else
            return true;

    }
}

/**
 * Variable exist
 */
if (typeof en_is_var_exist != 'function') {
    function en_is_var_exist(index, item) {
        return typeof item[index] != 'undefined' ? true : false;
    }
}

/**
 * Ajax common resource
 * @param params.en_ajax_loading_id The loading Path Id
 * @param params.en_ajax_disabled_id The disabled Path Id
 * @param params.en_ajax_loading_msg_btn The message show on button during load
 */
if (typeof en_ajax_request != 'function') {
    function en_ajax_request(params, data, call_back_function) {
        jQuery.ajax({
            type: "POST",
            url: ajaxurl,
            data: data,
            beforeSend: function () {

                (typeof params.en_ajax_loading_id != 'undefined' &&
                    params.en_ajax_loading_id.length > 0) ?
                    jQuery(params.en_ajax_loading_id).css('background',
                        'rgba(255, 255, 255, 1) url("' + EN_TQL_DIR_FILE + '' +
                        '/admin/tab/location/assets/images/processing.gif") no-repeat scroll 50% 50%') : "";

                (typeof params.en_ajax_disabled_id != 'undefined' &&
                    params.en_ajax_disabled_id.length > 0) ?
                    jQuery(params.en_ajax_disabled_id).prop({disabled: true}) : "";

                (typeof params.en_ajax_loading_msg_btn != 'undefined' &&
                    params.en_ajax_loading_msg_btn.length > 0) ?
                    jQuery(params.en_ajax_loading_msg_btn).addClass('spinner_disable').val("Loading ..") : "";

                (typeof params.en_ajax_loading_msg_ok_btn != 'undefined' &&
                    params.en_ajax_loading_msg_ok_btn.length > 0) ?
                    jQuery(params.en_ajax_loading_msg_ok_btn).addClass('spinner_disable').text("Loading ..") : "";
            },
            success: function (response) {
                (typeof params.en_ajax_loading_id != 'undefined' &&
                    params.en_ajax_loading_id.length > 0) ?
                    jQuery(params.en_ajax_loading_id).removeAttr('style') : "";

                (typeof params.en_ajax_disabled_id != 'undefined' &&
                    params.en_ajax_disabled_id.length > 0) ?
                    jQuery(params.en_ajax_disabled_id).prop({disabled: false}) : "";

                (typeof params.en_ajax_loading_msg_btn != 'undefined' &&
                    params.en_ajax_loading_msg_btn.length > 0) ?
                    jQuery(params.en_ajax_loading_msg_btn).removeClass('spinner_disable').val("Save") : "";

                (typeof params.en_ajax_loading_msg_ok_btn != 'undefined' &&
                    params.en_ajax_loading_msg_ok_btn.length > 0) ?
                    jQuery(params.en_ajax_loading_msg_ok_btn).removeClass('spinner_disable').text("Ok") : "";

                return call_back_function(params, response);
            },
            error: function (jqXHR, textStatus, errorThrown) {
                console.log(textStatus, errorThrown);
            }
        });
    }
}

if (typeof setNestedMaterialsUI != 'function') {
    function setNestedMaterialsUI() {
        const nestedMaterials = jQuery('._nestedMaterials');
        const productMarkups = jQuery('._en_product_markup');

        if (productMarkups?.length) {
            for (const markup of productMarkups) {
                jQuery(markup).attr('maxlength', '7');

                jQuery(markup).keypress(function (e) {
                    if (!String.fromCharCode(e.keyCode).match(/^[0-9.%-]+$/))
                        return false;
                });
            }
        }

        if (nestedMaterials?.length) {
            for (let elem of nestedMaterials) {
                const className = elem.className;

                if (className?.includes('_nestedMaterials')) {
                    const checked = jQuery(elem).prop('checked'),
                        name = jQuery(elem).attr('name'),
                        id = name?.split('_nestedMaterials')[1];
                    setNestMatDisplay(id, checked);
                }
            }
        }
    }
}

if (typeof setNestMatDisplay != 'function') {
    function setNestMatDisplay (id, checked) {

        jQuery(`input[name="_nestedPercentage${id}"]`).attr('min', '0');
        jQuery(`input[name="_nestedPercentage${id}"]`).attr('max', '100');
        jQuery(`input[name="_nestedPercentage${id}"]`).attr('maxlength', '3');
        jQuery(`input[name="_maxNestedItems${id}"]`).attr('min', '0');
        jQuery(`input[name="_maxNestedItems${id}"]`).attr('max', '100');
        jQuery(`input[name="_maxNestedItems${id}"]`).attr('maxlength', '3');

        jQuery(`input[name="_nestedPercentage${id}"], input[name="_maxNestedItems${id}"]`).keypress(function (e) {
            if (!String.fromCharCode(e.keyCode).match(/^[0-9]+$/))
                return false;
        });

        jQuery(`input[name="_nestedPercentage${id}"]`).closest('p').css('display', checked ? '' : 'none');
        jQuery(`select[name="_nestedDimension${id}"]`).closest('p').css('display', checked ? '' : 'none');
        jQuery(`input[name="_maxNestedItems${id}"]`).closest('p').css('display', checked ? '' : 'none');
        jQuery(`select[name="_nestedStakingProperty${id}"]`).closest('p').css('display', checked ? '' : 'none');
    }
}

if (typeof tqlBlockedStoresNotifications != 'function') {
    function tqlBlockedStoresNotifications() {
        if (typeof en_tql_admin_script !== 'undefined' && en_tql_admin_script.eniture_show_rate_limit_notice_with_time === 'yes') {
            const resetTimestamp = parseInt(en_tql_admin_script.eniture_rate_limit_reset_timestamp, 10);
            const currentTimestamp = parseInt(en_tql_admin_script.eniture_rate_limit_currnet_timestamp, 10);
            let countdownSeconds = resetTimestamp - currentTimestamp;
    
            if (countdownSeconds > 0) {
                if (jQuery('#eniture-tql-ltl-rate-limit-notice').length === 0) {
                    jQuery('.tql_plan_notice').after('<div id="eniture-tql-ltl-rate-limit-notice" class="notice notice-error is-dismissible"><p id="eniture-tql-ltl-rate-limit-message"></p></div>');
                }
    
                function enitureResetNoticeFormatTime(seconds) {
                    const minutes = Math.floor(seconds / 60);
                    const secs = seconds % 60;
                    return minutes > 0 ? `${minutes} minute(s) ${secs} second(s)` : `${secs} second(s)`;
                }
    
                let enitureResetIntervalId;
                function enitureResetUpdateNotice() {
                    if (countdownSeconds <= 0) {
                        clearInterval(enitureResetIntervalId);
                        jQuery('#eniture-tql-ltl-rate-limit-notice').fadeOut();
                        return;
                    }
    
                    jQuery('#eniture-tql-ltl-rate-limit-message').text(`The API transaction limit has been exceeded, and your store has been temporarily blocked due to excessive requests. It will automatically unblock in ${enitureResetNoticeFormatTime(countdownSeconds)}. To request an increased API transaction limit, please contact support@eniture.com.`);
                    countdownSeconds--;
                }
    
                enitureResetUpdateNotice();
                enitureResetIntervalId = setInterval(enitureResetUpdateNotice, 1000);
            }
        }
    }
}

if (typeof tqlBackupRatesSettings != 'function') {
    function tqlBackupRatesSettings() {
        jQuery('input[name*="tql_backup_rates_category"]').closest('tr').addClass("tql_backup_rates_category");
        // backup rates as a fixed rate
        jQuery(".tql_backup_rates_category input[value*='fixed_rate']").after('Backup rate as a fixed rate. <br /><input type="text" style="margin-top: 10px" name="tql_backup_rates_fixed_rate" id="tql_backup_rates_fixed_rate" title="Backup Rates" maxlength="50" value="' + en_tql_admin_script.tql_backup_rates_fixed_rate + '"> <br> <span class="description"> Enter a value for the fixed rate. (e.g. 10.00)</span><br />');
        // backup rates as a percentage of cart price
        jQuery(".tql_backup_rates_category input[value*='percentage_of_cart_price']").after('Backup rate as a percentage of Cart price. <br /><input type="text" style="margin-top: 10px" name="tql_backup_rates_cart_price_percentage" id="tql_backup_rates_cart_price_percentage" title="Backup Rates" maxlength="50" value="' + en_tql_admin_script.tql_backup_rates_cart_price_percentage + '"> <br> <span class="description"> Enter a percentage for the backup rate. (e.g. 10.0%)</span><br />');
        // backup rates as a function of cart weight
        jQuery(".tql_backup_rates_category input[value*='function_of_weight']").after('Backup rate as a function of the Cart weight. <br /><input type="text" style="margin-top: 10px" name="tql_backup_rates_weight_function" id="tql_backup_rates_weight_function" title="Backup Rates" maxlength="50" value="' + en_tql_admin_script.tql_backup_rates_weight_function + '"> <br> <span class="description"> Enter a rate per pound to use for the backup rate. (e.g. 2.00)</span><br />');

        jQuery('#tql_backup_rates_label').attr('maxlength', '50');
        jQuery('#tql_backup_rates_fixed_rate, #tql_backup_rates_cart_price_percentage, #tql_backup_rates_weight_function').attr('maxlength', '10');
        jQuery('#tql_backup_rates_carrier_fails_to_return_response, #tql_backup_rates_carrier_returns_error').closest('td').css('padding', '0px 10px');

        jQuery("#tql_backup_rates_fixed_rate, #tql_backup_rates_weight_function").keypress(function (e) {
            if (!String.fromCharCode(e.keyCode).match(/^[0-9\d\.\s]+$/i)) return false;
        });
        jQuery("#tql_backup_rates_cart_price_percentage").keypress(function (e) {
            if (!String.fromCharCode(e.keyCode).match(/^[0-9\d\.%\s]+$/i)) return false;
        });
        jQuery('#tql_backup_rates_fixed_rate, #tql_backup_rates_cart_price_percentage, #tql_backup_rates_weight_function').keyup(function () {
            var val = jQuery(this).val();
            var regex = /\./g;
            var count = (val.match(regex) || []).length;
            
            if (count > 1) {
                val = val.replace(/\.+$/, '');
                jQuery(this).val(val);
            }
        });
    }
}

if (typeof tqlBackupRatesValidations != 'function') {
    function tqlBackupRatesValidations() {
        if (jQuery('#enable_backup_rates_tql').is(':checked')) {
            let error_msg = '', field_id = '';
            if (jQuery('#tql_backup_rates_label').val() == '') {
                error_msg = 'Backup rates label field is empty.';
                field_id = 'tql_backup_rates_label';
            }

            const number_regex = /^([0-9]{1,7})$|(\.[0-9]{1,2})$/;
            const cart_price_regex = /^([0-9]{1,3}%?)$|(\.[0-9]{1,2})%?$/;
    
            if (!error_msg) {
                const backup_rates_type = jQuery('input[name="tql_backup_rates_category"]:checked').val();
                if (backup_rates_type == 'fixed_rate' && jQuery('#tql_backup_rates_fixed_rate').val() == '') {
                    error_msg = 'Backup rates as a fixed rate field is empty.';
                    field_id = 'tql_backup_rates_fixed_rate';
                } else if (backup_rates_type == 'percentage_of_cart_price' && jQuery('#tql_backup_rates_cart_price_percentage').val() == '') {
                    error_msg = 'Backup rates as a percentage of cart price field is empty.';
                    field_id = 'tql_backup_rates_cart_price_percentage';
                } else if (backup_rates_type == 'function_of_weight' && jQuery('#tql_backup_rates_weight_function').val() == '') {
                    error_msg = 'Backup rates as a function of weight field is empty.';
                    field_id = 'tql_backup_rates_weight_function';
                } else if (jQuery('#tql_backup_rates_fixed_rate').val() != '' && !number_regex.test(jQuery('#tql_backup_rates_fixed_rate').val())) {
                    error_msg = 'Backup rates as a fixed rate format should be 100.20 or 10.';
                    field_id = 'tql_backup_rates_fixed_rate';
                } else if (jQuery('#tql_backup_rates_cart_price_percentage').val() != '' && !cart_price_regex.test(jQuery('#tql_backup_rates_cart_price_percentage').val())) {
                    error_msg = 'Backup rates as a percentage of cart price format should be 100.20 or 10%.';
                    field_id = 'tql_backup_rates_cart_price_percentage';
                } else if (jQuery('#tql_backup_rates_weight_function').val() != '' && !number_regex.test(jQuery('#tql_backup_rates_weight_function').val())) {
                    error_msg = 'Backup rates as a function of weight format should be 100.20 or 10.';
                    field_id = 'tql_backup_rates_weight_function';
                }
            }
    
            if (error_msg) {
                jQuery('.tql_plan_notice').after('<div class="notice notice-error en_settings_message"><p><strong>Error! </strong>' + error_msg + '</p></div>');
                jQuery('#en_settings_message').delay(200).animate({scrollTop: 0}, 1000);
                jQuery('html, body').animate({scrollTop: 0}, 'slow');
                return false;
            }
        }

        return true;
    }
}