document.addEventListener('DOMContentLoaded', function () {
    const popup = document.getElementById('loycott-optin-popup');
    popup.style.display = 'block';

    document.getElementById('loycott-plugin-optin-accept').addEventListener('click', function () {
        // Send AJAX request for opt-in acceptance.
        fetch(loycottPluginAjax.ajaxurl, {
            method: 'POST',
            headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
            body: 'action=loycott_optin&optin=1'
        }).then(response => response.json())
          .then(data => {
              if (data.success) {
                  popup.remove();
              } else {
                  alert('Error: ' + data.data);
              }
          });
    });

    document.getElementById('loycott-plugin-optin-decline').addEventListener('click', function () {
        // Send AJAX request for opt-in decline.
        fetch(loycottPluginAjax.ajaxurl, {
            method: 'POST',
            headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
            body: 'action=loycott_optin&optin=0'
        }).then(response => response.json())
          .then(data => {
              if (!data.success) {
                  alert('Plugin deactivated.');
              }
              popup.remove();
          });
    });
});
