<?php
if ( ! defined( 'ABSPATH' ) ) {
exit; // Exit if accessed directly
}

require_once __DIR__ . '/actions.php';




add_action('admin_print_styles', 'loycott_wizard_add_styles');

function loycott_wizard_add_styles() {
	if ( ! isset( $_GET['loycott_wizard'] ) ) {
		return;
	}

	if ( ! isset( $_GET['loycott_wizard_nonce'] ) || ! wp_verify_nonce( sanitize_text_field( wp_unslash( $_GET['loycott_wizard_nonce'] ) ), 'loycott_wizard_action' ) ) {
		wp_die( esc_html__( 'Invalid request.', 'loycott-loyalty' ) );
	}

	wp_enqueue_style( 'loycott-wizard', plugin_dir_url( __FILE__ ) . 'css/default.css', array(), '1.0' );
	wp_enqueue_style( 'bootstrap-4-css', plugin_dir_url( __FILE__ ) . 'css/bootstrap.min.css', array(), '1.0' );
}


add_action('admin_enqueue_scripts', 'loycott_wizard_add_scripts');

function loycott_wizard_add_scripts() {
	if ( ! isset( $_GET['loycott_wizard'] ) ) {
		return;
	}

	if ( ! isset( $_GET['loycott_wizard_nonce'] ) || ! wp_verify_nonce( sanitize_text_field( wp_unslash( $_GET['loycott_wizard_nonce'] ) ), 'loycott_wizard_action' ) ) {
		wp_die( esc_html__( 'Invalid request.', 'loycott-loyalty' ) );
	}

	wp_enqueue_script( 'loycott-wizard', plugin_dir_url( __FILE__ ) . 'js/default.js', array(), 1.0 );
	wp_localize_script( 'loycott-wizard', 'loycottobj', array( 'ajax_url' => admin_url( 'admin-ajax.php' ) ) );
	wp_enqueue_script( 'bootstrap-4-js', plugin_dir_url( __FILE__ ) . 'js/bootstrap.min.js', array(), 1.0 );
}



add_action('admin_init', 'loycott_wizard_head_init');

function loycott_wizard_head_init() {
	if ( ! isset( $_GET['loycott_wizard'] ) ) {
		return;
	}

	if ( ! isset( $_GET['loycott_wizard_nonce'] ) || ! wp_verify_nonce( sanitize_text_field( wp_unslash( $_GET['loycott_wizard_nonce'] ) ), 'loycott_wizard_action' ) ) {
		wp_die( esc_html__( 'Invalid request.', 'loycott-loyalty' ) );
	}

	do_action('admin_print_styles');
	do_action('admin_print_scripts');

	loycott_wizard_container();
	exit;
}


function loycott_wizard_container() {
$current_user = wp_get_current_user();

	?>
	<div class="container">
	<div class="card">
		





		<div class="main active">
			<div class="image">
				<span><img src="<?php echo esc_html(LOYCOTT_DIR_URL . '/inc/wizard/img/logo.png'); ?>"></span>
			</div>
			<div class="heading">
				<h3><?php esc_html_e('Loycott Wizard', 'loycott-loyalty'); ?></h3>
			</div>
			<p>
				<?php esc_html_e('Welcome to Loycott Loyalty Setup Wizard. Press Setup to continue the loyalty configuration. It will only take 1 minute.', 'loycott-loyalty'); ?>
			</p>
		 

		<!-- 	<div class="input-text">
				<div class="form-check">
					<input class="form-check-input" type="radio" name="flexRadioDefault" id="flexRadioDefault1" checked>
					<label class="form-check-label" for="flexRadioDefault1">
						Trial
					</label>
				</div>
				<div class="form-check">
					<input class="form-check-input" type="radio" name="flexRadioDefault" id="flexRadioDefault2">
					<label class="form-check-label" for="flexRadioDefault2">
						Full Version
					</label>
				</div>
			</div> -->
		 
			<div class="button">
				<button class="next-btn">Next</button> 
			</div>
		</div>



<div class="main">
			<div class="image">
				<span><img src="<?php echo esc_url(LOYCOTT_DIR_URL . '/inc/wizard/img/logo.png'); ?>"></span>
			</div>
			<div class="heading">
				<h3><?php esc_html_e('License Type', 'loycott-loyalty'); ?></h3>
			</div>
			<div class="input-text">
				



								<div class='col text-center'>
									<input type="radio" name="license_type" id="img1" class="d-none imgbgchk" value="single" checked>
									<label for="img1">
										<img src="<?php echo esc_url(LOYCOTT_DIR_URL . '/inc/wizard/img/Single.png'); ?>" alt="Image 1">
										<div class="tick_container">
										  <div class="tick">L</div>
										</div>
									</label>
								</div>



								<div class='col text-center'>
									<input type="radio" name="license_type" id="img2" class="d-none imgbgchk" value="agency">
									<label for="img2">
										<img src="<?php echo esc_url(LOYCOTT_DIR_URL . '/inc/wizard/img/Agency.png'); ?>" alt="Image 1">
										<div class="tick_container">
										  <div class="tick">L</div>
									  </div>
								  </label>
							  </div>

			</div>
			
			

		   
	   
			<div class="button">
				<button class="prev-btn">Previous</button>
				<button class="next-btn">Next</button>
			</div>
		</div>





	
		<div class="main">
			<div class="image">
				<span><img src="<?php echo esc_url(LOYCOTT_DIR_URL . '/inc/wizard/img/logo.png'); ?>"></span>
			</div>
			<div class="heading">
				<h3><?php esc_html_e('Please complete all the details', 'loycott-loyalty'); ?></h3>
			</div>
			<div class="input-text">
					 <?php 
				$full_name = $current_user->user_firstname . ' ' . $current_user->user_lastname; 
						if ('' == $full_name ) {
						  $full_name = '';  
						}
						?>
				<input type="text" name="pcname" id="pcname" placeholder="<?php esc_html_e('Full Name', 'loycott-loyalty'); ?>" require="required" value="<?php echo esc_attr($full_name); ?>">
			</div>
			<div class="input-text">
				<input type="text" name="pcusername" id="pcusername" placeholder="<?php esc_html_e('Email', 'loycott-loyalty'); ?>" require="required" value="<?php echo esc_attr(get_option('admin_email')); ?>">
			</div>
				 <div class="input-text">
				<input type="password" name="pcpassword" id="pcpassword" placeholder="<?php esc_html_e('Password', 'loycott-loyalty'); ?>" require="required">
			</div>
			<div class="input-text">
				<input type="text" name="pccompanyname" id="pccompanyname" placeholder="<?php esc_html_e('Company Name', 'loycott-loyalty'); ?>" require="required" value="<?php echo esc_attr(get_option('blogname')); ?>">
			</div>
			  <div class="input-text">
				<input type="text" name="pcaddress" id="pcaddress" placeholder="<?php esc_html_e('Address', 'loycott-loyalty'); ?>" require="required" value="<?php echo esc_attr(get_option('woocommerce_store_address')); ?>, <?php echo esc_attr(get_option('woocommerce_store_city')); ?>">
			</div>
				<div class="input-text">
				<input type="text" name="pczipcode" id="pczipcode" placeholder="<?php esc_html_e('Zip Code', 'loycott-loyalty'); ?>" require="required" value="<?php echo esc_attr(get_option('woocommerce_store_postcode')); ?>">
			</div>
			   <div class="input-text">
				<input type="text" name="pcvat" id="pcvat" placeholder="<?php esc_html_e('VAT', 'loycott-loyalty'); ?>" value="" require="required">
			</div>
					<div class="input-text">

				<?php 
 $countries_obj   = new WC_Countries();
	$countries   = $countries_obj->__get('countries');

	woocommerce_form_field('pccountry', array(
	'type'       => 'select',
	'class'      => array( 'chzn-drop' ),
	'label'      =>'',
	'placeholder'    => __('Select Country', 'loycott-loyalty'),
	'options'    => $countries,
	), wc_get_base_location()['country']  
	);

				?>
			</div>
			<input type="hidden" name="domain" id="domain"  require="required" value="<?php echo esc_html(sanitize_text_field(isset($_SERVER['SERVER_NAME']) ? wp_unslash($_SERVER['SERVER_NAME']) : '')); ?>">
			<input type="hidden" name="externalcallurl" id="externalcallurl"  externalcall="required" value="https://www.boomsservices.com/subscriptions/wordpress/initreg.php">
			<input type="hidden" name="externalcallresponse" id="externalcallresponse" value="key">
			<input type="hidden" name="externalcallurl2" id="externalcallurl2"  externalcall="required" value="<?php echo esc_url(LOYCOTT_APIURL . 'createcompanyandstore.php'); ?>">
			<input type="hidden" name="externalcallresponse2" id="externalcallresponse2" value="company_id">
			<?php wp_nonce_field('loycott_wizard_action', 'loycott_wizard_nonce'); ?>
		   
	   
			<div class="button">
				<button class="prev-btn">Previous</button>
				<button class="next-btn">Next</button>
			</div>
		</div>





	 <div class="main">
			<div class="image">
				<span><img src="<?php echo esc_url(LOYCOTT_DIR_URL . '/inc/wizard/img/logo.png'); ?>"></span>
			</div>
			<div class="heading">
				<h3><?php esc_html_e('Do you want to add unlimited conditions?', 'loycott-loyalty'); ?></h3>
				
			</div>
			
			<div class="">

				<button class="next-btn skip"><?php esc_html_e('No', 'loycott-loyalty'); ?></button>

				<a class="button" href="<?php echo esc_url( wp_nonce_url(get_site_url() . '/?loycott_upgrade_page', 'loycott_upgrade_action', '_wpnonce') ); ?>" class="submit"><?php esc_html_e('Upgrade', 'loycott-loyalty'); ?></a>

			</div>
		</div>

		
		<div class="main">
			<div class="image">
				<span><img src="<?php echo esc_url(LOYCOTT_DIR_URL . '/inc/wizard/img/logo.png'); ?>"></span>
			</div>
			<div class="heading">
				<h3><?php esc_html_e('You are Ready!', 'loycott-loyalty'); ?></h3>
				
			</div>
			
			<div class="button">
				<a href="<?php echo esc_url(get_site_url() . '/wp-admin/admin.php?page=loycott-plugin-settings&tab=conditions'); ?>" class="submit">Create your first Condition</a>
			  
			</div>
		</div>








		<div class="main">
			<div class="final-step">
				<div class="check-sign">
					<svg class="checkmark" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 52 52">
					<circle class="checkmark__circle" cx="26" cy="26" r="25" fill="none"/>
					<path class="checkmark__check" fill="none" d="M14.1 27.2l7.1 7.2 16.7-16.8"/>
					</svg>
					
				</div>
				<h3>Verify your E-mail Address</h3>
				<p>Thanks Mr. <span id="s_name"></span> we have sent you a confirmation email,please click 
				on the link to confirm your email address.</p>
			</div>
			
		</div>   




		
		
		
		
		
	</div>
</div>

	<?php 
}


function loycott_loyalty_auto_start_wizard() {
	   //  update_option( "loycott_wizard_auto_initiated", false );

	$initiated = get_option( 'loycott_wizard_auto_initiated' );
	if (!$initiated) {
		 update_option( 'loycott_wizard_auto_initiated', true );
		wp_redirect(admin_url('?loycott_wizard'));


		//http://loycott-testing/wp-admin/admin.php?page=boomsloyalty-plugin-settings&tab=license
						exit;

	  //  header("Location: ".get_site_url()."/wp-admin/?loycott_wizard");
	   

	}
}

add_action('admin_init', 'loycott_loyalty_auto_start_wizard');



?>
