<?php
if ( ! defined( 'ABSPATH' ) ) {
exit; // Exit if accessed directly
}

function loycott_wizard_external_call() {
   // Verify nonce for security
	if ( ! isset( $_POST['loycott_wizard_nonce'] ) || ! wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['loycott_wizard_nonce'] ) ), 'loycott_wizard_action' ) ) {
	   wp_send_json_error( 'Security check failed' );
	   wp_die();
	}
   
   $externalcallurl = '';
   $externalcallresponse = '';
   $externalcallurl2 = '';
   $externalcallresponse2 = '';
   $data_to_post = array();
   
	if (isset($_POST['externalcallurl'])) {
	   $externalcallurl = sanitize_text_field(wp_unslash($_POST['externalcallurl']));
	}
   
	if (isset($_POST['externalcallresponse'])) {
	   $externalcallresponse = sanitize_text_field(wp_unslash($_POST['externalcallresponse']));
	}

	if (isset($_POST['externalcallurl2'])) {
	   $externalcallurl2 = sanitize_text_field(wp_unslash($_POST['externalcallurl2']));
	}
   
	if (isset($_POST['externalcallresponse2'])) {
	   $externalcallresponse2 = sanitize_text_field(wp_unslash($_POST['externalcallresponse2']));
	}
   // Explicitly list and sanitize only the required fields
   $required_fields = array(
	   'pcusername',
	   'pccompanyname',
	   'pcaddress',
	   'pccountry',
	   'domain',
	   'pczipcode',
	   'pcvat',
   );

	foreach ($required_fields as $field) {
		if (isset($_POST[$field])) {
			$data_to_post[$field] = sanitize_text_field(wp_unslash($_POST[$field]));
		}
	}


   $response = loycott_wizard_post_query($externalcallurl, $data_to_post);

	if ($response) {
	 $response = json_decode($response, true);
		if ($response['key']) {
			 $loycott_license_options = get_option('loycott_license_option_name'); 
			if (!is_array($loycott_license_options)) {
			  $loycott_license_options = array();
			}

		  $loycott_license_options['license_key_0'] = $response['key'];
		  $loycott_license_options['email_0'] = $data_to_post['pcusername'];
		  $loycott_license_options['domain_0'] = isset($_SERVER['SERVER_NAME']) ? sanitize_text_field(wp_unslash($_SERVER['SERVER_NAME'])) : '';


		  update_option( 'loycott_license_option_name', $loycott_license_options  );

		}
	}



		  $loycott_license_options = get_option('loycott_license_option_name'); 

		  $key = $loycott_license_options['license_key_0'];

		  $email  = $loycott_license_options['email_0'];
		  $domain = $loycott_license_options['domain_0']; 

		  $data2 = array();

		  $data2 = array(
		'key' => $key,
		'domain' => $domain,
		'licenseemail' => $email,
		'title' => $data_to_post['pccompanyname'],
		'address' => $data_to_post['pcaddress'],
		'location' => $data_to_post['pccountry'],
		'country' => $data_to_post['pccountry'],
		'phone' => $data_to_post['pccountry'],
		'email' => $data_to_post['pcusername'],
		'website' => $data_to_post['domain'],
		'zip_code' => $data_to_post['pczipcode'],
		'cid' => 0,
		'sid ' => 0,
		'uid' => 0,
		'store_type' => 17,
		'city' => '',
		'logo' => $logo,
		'vat' => $data_to_post['pcvat'],
		);

	$response2 = loycott_wizard_post_query($externalcallurl2, $data2);

		  if ($response2) {
		   $response2 = json_decode($response2, true);
			 
		  }

	echo wp_json_encode($response); //returning this value but still shows 0

	wp_die();
}

add_action( 'wp_ajax_nopriv_loycott_wizard_external_call', 'loycott_wizard_external_call' );
add_action( 'wp_ajax_loycott_wizard_external_call', 'loycott_wizard_external_call' );




function loycott_wizard_post_query( $url, $data_to_post ) {


		 $response = wp_remote_post($url, array(
			'method' => 'POST',
			'body' => $data_to_post,
			'sslverify' => false, // Use with caution, consider using a valid SSL certificate in production
			));

			$json = array();
	if (is_wp_error($response)) {
	$error_message = $response->get_error_message();
	return "Error: $error_message";
	} else {
	$body = wp_remote_retrieve_body($response);
	$json = json_decode($body, true);
	return $body;
	// Process the $json response as needed
	}
}
function loycott_wizard_get_domain( $url ) {
	$pieces = wp_parse_url($url);
  $domain = isset($pieces['host']) ? $pieces['host'] : $pieces['path'];
	if (preg_match('/(?P<domain>[a-z0-9][a-z0-9\-]{1,63}\.[a-z\.]{2,6})$/i', $domain, $regs)) {
	  return $regs['domain'];
	}
  return false;
}

function loycott_upgrade_url() {
	// Verify nonce for security
	if ( isset($_GET['loycott_upgrade_page']) && isset($_GET['_wpnonce']) && wp_verify_nonce( sanitize_key( $_GET['_wpnonce'] ), 'loycott_upgrade_action' ) ) {
		$loycott_license_options = get_option('loycott_license_option_name'); 
		$license = isset($loycott_license_options['license_key_0']) ? $loycott_license_options['license_key_0'] : '';

		// Redirect with sanitized parameters
		wp_redirect( esc_url_raw( 'https://www.boomsservices.com/subscriptions/wordpress/upgradepageprod.php?licensekey=' . urlencode($license) . '&url=' . urlencode(get_site_url() . '/wp-admin/admin.php?page=loycott-plugin-settings&tab=conditions') ) );
		exit;
	}
}

add_action('init', 'loycott_upgrade_url');
