<?php
if ( ! defined( 'ABSPATH' ) ) {
exit; // Exit if accessed directly
}
add_action( 'woocommerce_thankyou', 'loycott_auto_complete_order', 20, 1 );
function loycott_auto_complete_order( $order_id ) {
	$loycott_settings_options = get_option( 'loycott_settings_option_name' ); // Array of All Options
	$autocompleteoption = $loycott_settings_options['autocompleteoption'];

	if ('yes' == $autocompleteoption) {
		if (!$order_id) {
			return;
		}

		// Get an instance of the WC_Product object
		$order = wc_get_order($order_id);

		// No updated status for orders delivered with Bank wire, Cash on delivery and Cheque payment methods.
		if ($order->has_status('processing') || $order->has_status( 'on-hold' )) {
			$order->update_status('completed');
		}
	}
}
