<?php
if ( ! defined( 'ABSPATH' ) ) {
exit; // Exit if accessed directly
}

add_action( 'admin_menu', 'loycott_settings_add_plugin_page');


function loycott_settings_add_plugin_page() {
add_menu_page(
esc_html__('Loycott', 'loycott-loyalty'), // page_title
esc_html__('Loycott', 'loycott-loyalty'), // menu_title
'manage_options', // capability
'loycott-plugin-settings', // menu_slug
'loycott_settings_create_admin_page', // function
LOYCOTT_DIR_URL . 'imgs/icon.svg', // icon_url
3 // position
);
	if (loycott_packageLic() == '1') {
	add_submenu_page(
	'loycott-plugin-settings', //parent_slug
	esc_html__('Customers', 'loycott-loyalty'), //page title
	esc_html__('Customers', 'loycott-loyalty'), //menu_title
	'manage_options', //capability
	'admin.php?page=loycott-plugin-settings&tab=customers' //function
	);
	}
}








function loycott_settings_create_admin_page() {
$loycott_settings_options = get_option( 'loycott_settings_option_name' );
$loycott_license_options = get_option( 'loycott_license_option_name' );
$loycott_business_options = get_option( 'loycott_business_option_name' );
$loycott_store_options = get_option( 'loycott_store_option_name' );

$lng = 'eng';


// check user capabilities
	if ( ! current_user_can( 'manage_options' ) ) {
	return;
	}

//Get the active tab from the $_GET param
$default_tab = null;
$tab = isset($_GET['tab']) ? sanitize_text_field(wp_unslash($_GET['tab'])) : $default_tab;

$usercategory = loycott_return_login_details('category');
wp_nonce_field('loycott_save_business_action', 'loycott_save_business_nonce');

	?>
<div class="wrap">
<h1>Loycott Loyalty</h1>

<nav class="nav-tab-wrapper">
<a href="?page=loycott-plugin-settings" class="nav-tab 
<?php 
	if (null === $tab) :
		?>
 nav-tab-active<?php endif; ?>"><?php esc_html_e('General', 'loycott-loyalty'); ?></a>
<a href="?page=loycott-plugin-settings&tab=license" class="nav-tab 
<?php 
	if ('license' === $tab) :
		?>
 nav-tab-active<?php endif; ?>"><?php esc_html_e('API Key', 'loycott-loyalty'); ?></a>
<a href="?page=loycott-plugin-settings&tab=business" class="nav-tab 
<?php 
	if ('business' === $tab) :
		?>
 nav-tab-active<?php endif; ?>"><?php esc_html_e('Your Business', 'loycott-loyalty'); ?></a>
<a href="?page=loycott-plugin-settings&tab=othersettings" class="nav-tab 
<?php 
	if ('othersettings' === $tab) :
		?>
 nav-tab-active<?php endif; ?>"><?php esc_html_e('Misc Settings', 'loycott-loyalty'); ?></a>
<a href="?page=loycott-plugin-settings&tab=conditions" class="nav-tab 
<?php 
	if ('conditions' === $tab) :
		?>
 nav-tab-active<?php endif; ?>"><?php esc_html_e('Conditions', 'loycott-loyalty'); ?></a>
<a href="?page=loycott-plugin-settings&tab=customers" class="nav-tab 
<?php 
	if ('customers' === $tab) :
		?>
 nav-tab-active<?php endif; ?>"><?php esc_html_e('Members', 'loycott-loyalty'); ?></a>

 <a href="<?php echo esc_url( wp_nonce_url(admin_url('?loycott_wizard=1'), 'loycott_wizard_action', 'loycott_wizard_nonce') ); ?>" class="nav-tab"><?php esc_html_e('Setup Wizard', 'loycott-loyalty'); ?></a>


</nav>

<div class="tab-content">
<?php 

	// Handle business form submission
	if (isset($_POST['save_business'])) {
		if (!isset($_POST['loycott_save_business_nonce']) || !wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['loycott_save_business_nonce'])), 'loycott_save_business_action')) {
			wp_die(esc_html__('Invalid nonce verification', 'loycott-loyalty'));
		}
		
		// Sanitize and validate business form data
		$business_data = array(
			'title_0' => isset($_POST['title_0']) ? sanitize_text_field(wp_unslash($_POST['title_0'])) : '',
			'address_0' => isset($_POST['address_0']) ? sanitize_text_field(wp_unslash($_POST['address_0'])) : '',
			'location_0' => isset($_POST['location_0']) ? sanitize_text_field(wp_unslash($_POST['location_0'])) : '',
			'city_0' => isset($_POST['city_0']) ? sanitize_text_field(wp_unslash($_POST['city_0'])) : '',
			'zip_code_0' => isset($_POST['zip_code_0']) ? sanitize_text_field(wp_unslash($_POST['zip_code_0'])) : '',
			'country_0' => isset($_POST['country_0']) ? sanitize_text_field(wp_unslash($_POST['country_0'])) : '',
			'phone_0' => isset($_POST['phone_0']) ? sanitize_text_field(wp_unslash($_POST['phone_0'])) : '',
			'email_1' => isset($_POST['email_1']) ? sanitize_email(wp_unslash($_POST['email_1'])) : '',
			'website_0' => isset($_POST['website_0']) ? esc_url_raw(wp_unslash($_POST['website_0'])) : '',
			'vat_0' => isset($_POST['vat_0']) ? sanitize_text_field(wp_unslash($_POST['vat_0'])) : '',
			'cid_0' => isset($_POST['cid_0']) ? absint($_POST['cid_0']) : 0,
			'sid_1' => isset($_POST['sid_1']) ? absint($_POST['sid_1']) : 0,
		);
		
		// Validate required fields
		$required_fields = array('title_0', 'address_0', 'city_0', 'zip_code_0', 'country_0', 'phone_0', 'email_1', 'website_0');
		$validation_errors = array();
		
		foreach ($required_fields as $field) {
			if (empty($business_data[$field])) {
				/* translators: %s: field name */
				$validation_errors[] = sprintf(esc_html__('Field %s is required', 'loycott-loyalty'), $field);
			}
		}
		
		// Validate email
		if (!empty($business_data['email_1']) && !is_email($business_data['email_1'])) {
			$validation_errors[] = esc_html__('Please enter a valid email address', 'loycott-loyalty');
		}
		
		// Validate website URL
		if (!empty($business_data['website_0']) && !filter_var($business_data['website_0'], FILTER_VALIDATE_URL)) {
			$validation_errors[] = esc_html__('Please enter a valid website URL', 'loycott-loyalty');
		}
		
		if (!empty($validation_errors)) {
			foreach ($validation_errors as $error) {
				add_settings_error('loycott_business', 'validation_error', $error, 'error');
			}
		} else {
			// Process the business data here (call your business save function)
			// Example: loycott_save_business_data($business_data);
		}
	}
	
	// Handle condition form submission
	if (isset($_POST['save_condition'])) {
		if (!isset($_POST['loycott_save_condition_nonce']) || !wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['loycott_save_condition_nonce'])), 'loycott_save_condition_action')) {
			wp_die(esc_html__('Invalid nonce verification', 'loycott-loyalty'));
		}
		
		// Sanitize and validate condition form data
		$condition_data = array(
			'ctitle' => isset($_POST['ctitle']) ? sanitize_text_field(wp_unslash($_POST['ctitle'])) : '',
			'redemption_type' => isset($_POST['redemption_type']) ? absint($_POST['redemption_type']) : 1,
			'redemption_value' => isset($_POST['redemption_value']) ? sanitize_text_field(wp_unslash($_POST['redemption_value'])) : '',
			'cpoints' => isset($_POST['cpoints']) ? absint($_POST['cpoints']) : 0,
			'cid_1' => isset($_POST['cid_1']) ? absint($_POST['cid_1']) : 0,
		);
		
		// Validate required fields
		if (empty($condition_data['ctitle'])) {
			add_settings_error('loycott_conditions', 'validation_error', esc_html__('Condition title is required', 'loycott-loyalty'), 'error');
		}
		
		if ($condition_data['cpoints'] <= 0) {
			add_settings_error('loycott_conditions', 'validation_error', esc_html__('Points must be a positive number', 'loycott-loyalty'), 'error');
		}
		
		// Validate redemption type
		if (!in_array($condition_data['redemption_type'], array(1, 2, 3), true)) {
			add_settings_error('loycott_conditions', 'validation_error', esc_html__('Invalid redemption type', 'loycott-loyalty'), 'error');
		}
		
		// Process the condition data here (call your condition save function)
		// Example: loycott_save_condition_data($condition_data);
	}
	
	// Handle member edit form submission
	if (isset($_POST['membutton'])) {
		if (!isset($_POST['loycott_edit_member_nonce']) || !wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['loycott_edit_member_nonce'])), 'loycott_edit_member_action')) {
			wp_die(esc_html__('Invalid nonce verification', 'loycott-loyalty'));
		}
		
		$member_phone = isset($_POST['memphone']) ? sanitize_text_field(wp_unslash($_POST['memphone'])) : '';
		$member_email = isset($_POST['mememail']) ? sanitize_email(wp_unslash($_POST['mememail'])) : '';
		
		if (empty($member_phone)) {
			add_settings_error('loycott_members', 'validation_error', esc_html__('Phone number is required', 'loycott-loyalty'), 'error');
		}
		
		if (!empty($member_email) && !is_email($member_email)) {
			add_settings_error('loycott_members', 'validation_error', esc_html__('Please enter a valid email address', 'loycott-loyalty'), 'error');
		}
		
		// Process the member data here (call your member update function)
		// Example: loycott_update_member_email($member_phone, $member_email);
	}
	switch ($tab) :
		case 'license':
			?>
	<div class="loycott-license-tab-wrapper">

		<?php $license_label = esc_html__('Please insert your API Key details here', 'loycott-loyalty'); ?>
<p><?php echo esc_html($license_label); ?></p>
<P><?php echo wp_kses_post(loycott_litValidLic()); ?></P>
	<?php settings_errors(); ?>
<form method="post" action="options.php">
	<?php
		settings_fields( 'loycott_license_option_group' );
		do_settings_sections( 'boomsloyalty-plugin-license-admin' );
		submit_button();
			?>
</form>
		<?php $licType = loycott_packageLicLit(); ?>
<p><?php esc_html_e('License Type:', 'loycott-loyalty'); ?> <?php echo esc_html($licType); ?> &nbsp;
	<?php
			if (( strstr($licType, 'Free') ) || ( strstr($licType, 'Trial') ) ) {
				$loycott_license_options = get_option( 'loycott_license_option_name' ); // Array of All Options
				$license_key_0 = $loycott_license_options['license_key_0']; 
				if ( isset( $_GET['_wpnonce'] ) && wp_verify_nonce( sanitize_text_field( wp_unslash( $_GET['_wpnonce'] ) ), 'loycott_action_nonce' ) ) {
					// Sanitize GET parameters before building query string
					$sanitized_get = array();
					if ( isset( $_GET['page'] ) ) {
						$sanitized_get['page'] = sanitize_key( $_GET['page'] );
					}
					if ( isset( $_GET['tab'] ) ) {
						$sanitized_get['tab'] = sanitize_key( $_GET['tab'] );
					}
					$returnurl = admin_url( sprintf( 'admin.php?%s', http_build_query( $sanitized_get ) ) );
				}

				?>
<a class="button button-primary" href="<?php echo esc_html(get_site_url()) . '/?loycott_upgrade_page'; ?>" target="_blank"><?php esc_html_e('Upgrade', 'loycott-loyalty'); ?></a>
		<?php
			}
			?>
</p>
</div>
		<?php
			break;
		case 'business':
			?>
					<div class="loycott-business-tab-wrapper">

		<?php $business_label = esc_html__('Please insert your business info here', 'loycott-loyalty'); ?>
<p><?php echo esc_html($business_label); ?></p>
<P><?php echo wp_kses_post(loycott_litValidLic()); ?></P>
<div class="loycott-info-message"><?php esc_html_e('Your business info below will appear to Loycott mobile application (Android & iPhone) that your customers may download free, in order to be able also to check their balance at your e-shop, to view their transactions and redemptions at your e-shop and at last to view what they can redeem/win.', 'loycott-loyalty'); ?></div>
	<?php settings_errors(); ?>
	<?php do_action('loycott_before_form_rendered'); ?>
<form method="post">
	<?php
			
		$other_attributes = array( 'name' => 'save_business' );
		$cid = '0';
		$title_0 = '';
		$address_0 = '';
		$location_0 = '';
		$zip_code_0 = '';
		$country_0 = '';
		$phone_0 = '';
		$email_1 = '';
		$website_0 = '';
		$vat_0 = '';
		$city_0 = '';
			if (is_array(loycott_getCompany()) || is_object(loycott_getCompany())) {
				foreach (loycott_getCompany() as $company) {
					$cid = $company['company_id'];
					$title_0 = $company['title'];
					$address_0 = $company['address'];
					$location_0 = $company['location'];
					$zip_code_0 = $company['zip_code'];
					$country_0 = $company['country'];
					$phone_0 = $company['phone'];
					$email_1 = $company['cemail'];
					$website_0 = $company['cwebsite'];
					$vat_0 = $company['cvat'];
					$city_0 = $company['city'];
				}
			}

			?>
<table width="100%" cellpadding="2" cellspacing="2" border="0">
<tr><td><strong><?php esc_html_e('Company Title', 'loycott-loyalty'); ?>:</strong></td><td><input required type ="text"  class="regular-text" name="title_0" id="title_0" value="<?php echo esc_html($title_0); ?>"><div class="loycott-tooltip">i
<span class="tooltiptext"><?php esc_html_e('Your Company Name. This is how will appear also inside Loycott mobile app for iOS and Android', 'loycott-loyalty'); ?></span>
</div></td></tr>
<tr><td><strong><?php esc_html_e('Address', 'loycott-loyalty'); ?>:</strong></td><td> <input required type ="text"  class="regular-text" name="address_0" id="address_0" value="<?php echo esc_html($address_0); ?>"><div class="loycott-tooltip">i
<span class="tooltiptext"><?php esc_html_e('Your Business Address', 'loycott-loyalty'); ?></span>
</div></td></tr>
<tr style="display:none;"><td><strong><?php esc_html_e('Location', 'loycott-loyalty'); ?>:</strong></td><td> <input required type ="text"  class="regular-text" name="location_0" id="location_0" value="<?php echo esc_html($location_0); ?>"></td></tr>
<tr><td><strong><?php esc_html_e('City', 'loycott-loyalty'); ?>:</strong></td><td> <input required type ="text"  class="regular-text" name="city_0" id="city_0" value="<?php echo esc_html($city_0); ?>"><div class="loycott-tooltip">i
<span class="tooltiptext"><?php esc_html_e('The city where your business is located', 'loycott-loyalty'); ?></span>
</div></td></tr>
<tr><td><strong><?php esc_html_e('Zip Code', 'loycott-loyalty'); ?>:</strong></td><td> <input required type ="text"  class="regular-text" name="zip_code_0" id="zip_code_0" value="<?php echo esc_html($zip_code_0); ?>" ><div class="loycott-tooltip">i
<span class="tooltiptext"><?php esc_html_e('Business Zip Code', 'loycott-loyalty'); ?></span>
</div></td></tr>
<tr><td><strong><?php esc_html_e('Country', 'loycott-loyalty'); ?>:</strong></td><td> <input required type ="text"  class="regular-text" name="country_0" id="country_0" value="<?php echo esc_html($country_0); ?>"><div class="loycott-tooltip">i
<span class="tooltiptext"><?php esc_html_e('Business Country', 'loycott-loyalty'); ?></span>
</div></td></tr>
<tr><td><strong><?php esc_html_e('Phone', 'loycott-loyalty'); ?>:</strong></td><td> <input required type ="text"  class="regular-text" name="phone_0" id="phone_0" value="<?php echo esc_html($phone_0); ?>"><div class="loycott-tooltip">i
<span class="tooltiptext"><?php esc_html_e('Business Phone Number', 'loycott-loyalty'); ?></span>
</div></td></tr>
<tr><td><strong><?php esc_html_e('Company Email', 'loycott-loyalty'); ?>:</strong></td><td> <input required type ="text"  class="regular-text" name="email_1" id="email_1" value="<?php echo esc_html($email_1); ?>"><div class="loycott-tooltip">i
<span class="tooltiptext"><?php esc_html_e('Business email address', 'loycott-loyalty'); ?></span>
</div></td></tr>
<tr><td><strong><?php esc_html_e('Website', 'loycott-loyalty'); ?>:</strong></td><td> <input required type ="text"  class="regular-text" name="website_0" id="website_0" value="<?php echo esc_html($website_0); ?>"><div class="loycott-tooltip">i
<span class="tooltiptext"><?php esc_html_e('Your Business website url', 'loycott-loyalty'); ?></span>
</div></td></tr>

<tr><td><strong><?php esc_html_e('VAT', 'loycott-loyalty'); ?>:</strong></td><td> <input required type ="text"  class="regular-text" name="vat_0" id="vat_0" value="<?php echo esc_html($vat_0); ?>"><div class="loycott-tooltip">i
<span class="tooltiptext"><?php esc_html_e('VAT (If you have one)', 'loycott-loyalty'); ?></span>
</div></td></tr>
<tr><td><strong><?php esc_html_e('Logo', 'loycott-loyalty'); ?>:</strong></td><td> </td></tr>
</table>

	<?php
			if ( isset( $_POST['submit_image_selector'] ) && isset( $_POST['image_attachment_id'] ) ) :
				if (isset($_POST['loycott_image_selector_nonce']) &&
				wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['loycott_image_selector_nonce'])), 'loycott_image_selector_action') ) {
			   update_option( 'loycott_media_selector_attachment_id', absint( sanitize_text_field(wp_unslash($_POST['image_attachment_id'])) ) );
				}
		endif;
		wp_enqueue_media();
			?>
	<form method='post'>
<?php wp_nonce_field('loycott_image_selector_action', 'loycott_image_selector_nonce'); ?>
<div class='image-preview-wrapper'>
<img id='image-preview' src='<?php echo esc_url(wp_get_attachment_url( get_option( 'loycott_media_selector_attachment_id' ) )); ?>' width='200'>
</div>
<input id="upload_image_button" type="button" class="button" value="<?php esc_html_e( 'Upload image', 'loycott-loyalty' ); ?>" />
<input type='hidden' name='image_attachment_id' id='image_attachment_id' value='<?php echo esc_html(get_option( 'loycott_media_selector_attachment_id' )); ?>'>
<input type="submit" name="submit_image_selector" value="Save" class="button-primary">
</form>
	

<br><br>
<input type="submit" name="save_business" class="button button-primary" id="save_business" value="Save Business Data">
<input type = "hidden" name="cid_0" id="cid_0" value="<?php echo esc_html($cid); ?>">
<input type = "hidden" name="sid_1" id="sid_1" value="<?php echo esc_html(loycott_getStore($cid)); ?>">
</form>

</div>
	<?php
			break;
		case 'conditions':
			?>
	<div class="loycott-conditions-tab-wrapper">

		<?php $ly_label = esc_html__('Please insert your ecommerce loyalty conditions here', 'loycott-loyalty'); ?>
	<?php settings_errors(); ?>
<form method="post" action="options.php">
	<?php
		settings_fields( 'loycott_loyalty_option_group' );
		do_settings_sections( 'boomsloyalty-plugin-loyalty-admin' );
		$other_attributes1 = array( 'name' => 'save_status' );
		submit_button( __( 'Set Status', 'loycott-loyalty' ), 'primary', 'save_status', true, $other_attributes1);

		$cid = '0';

			if (is_array(loycott_getCompany()) || is_object(loycott_getCompany())) {
				foreach (loycott_getCompany() as $company) {
					$cid = $company['company_id'];

				}
			}

			?>
<p>
<p><?php echo esc_html($ly_label); ?> &nbsp;<a href="#" onclick="helperWindow('conditions.php','Help');"><?php esc_html_e('info', 'loycott-loyalty'); ?></a></p>
<P><?php echo wp_kses_post(loycott_litValidLic()); ?></p>

	<?php loycott_list_all_conditions(); ?>
</p>


<p><input  type="button" name="addnew" id="loycott_add_new_toggle" value="Add New" class="button button-primary"></p>

<div class="loyalty-add-new-condition">
<h2><?php esc_html_e('Add New Condition', 'loycott-loyalty'); ?></h2>
<form method="post">
<?php wp_nonce_field('loycott_save_condition_action', 'loycott_save_condition_nonce'); ?>
<table class="form-table" role="presentation">
<tbody>
<tr>
<td><?php esc_html_e('Title', 'loycott-loyalty'); ?></th>
<td>
<input class="regular-text" type="text" name="ctitle" id="ctitle">
<div class="loycott-tooltip">i
<span class="tooltiptext"><?php esc_html_e('Condition name . This is how will appear to your customers.', 'loycott-loyalty'); ?></span>
</div></a>
</td>
</tr>
<tr>
<td><?php esc_html_e('Redemption Type', 'loycott-loyalty'); ?></th>
<td>
	<select  class="regular-text" id="redemption_type" name="redemption_type">
		<option value="1"><?php esc_html_e('Percentage', 'loycott-loyalty'); ?></option>
		<option value="2"><?php esc_html_e('Fixed Amount', 'loycott-loyalty'); ?></option>
		<option value="3"><?php esc_html_e('Other Offer', 'loycott-loyalty'); ?></option>
	</select><div class="loycott-tooltip">i
<span class="tooltiptext"><?php esc_html_e('Select here the type of your Loyalty condition. For example: Select “Percentage” if your Discount is in percentage. i.e. “10% Discount” or Select “Fixed Amount” if your Discount is in currency/euro etc. i.e. “20 euro Discount” or Select “Other offer” if your Discount is in item. i.e. “1 free t-shirt”', 'loycott-loyalty'); ?></span>
</div>
</td>
</tr>
<tr>
<td><?php esc_html_e('Redemption Value', 'loycott-loyalty'); ?></th>
	<td>
		<input class="regular-text" type="text" name="redemption_value" id="redemption_value">
		<div class="loycott-tooltip">i
<span class="tooltiptext">
<?php 
esc_html_e('Enter here the value of your Loyalty condition. For example:
Enter 10 if your Discount is in “Percentage”. i.e. “10% Discount”
Enter 25 if your Discount is in “Percentage”. i.e. “25% Discount”
Enter 20 if your Discount is in “Fixed amount”. i.e. “20 euro Discount”
Leave blank if your Discount is “Other offer”. i.e. “1 free t-shirt”', 'loycott-loyalty'); 
?>
	</span>
</div>

	</td>
</tr>
<tr>
	<td><?php esc_html_e('Points', 'loycott-loyalty'); ?></th>
		<td>
			<input class="regular-text" type="text" name="cpoints" id="cpoints">
			<div class="loycott-tooltip">i
<span class="tooltiptext">
<?php 
esc_html_e('Enter the number of points that your customer must redeem in order to win one of your loyalty conditions. For example:

Enter 150 points. That means that in order for your client to win “10% Discount” must redeem from his/her balance 150 points
Enter 200 points. That means that in order for your client to win “20 euro Discount” must redeem from his/her balance 200 points
Enter 300 points. That means that in order for your client to win “1 free t-shirt” must redeem from his/her balance 300 points', 'loycott-loyalty'); 
?>
	</span>
</div>
		</td>
	</tr>
	<tr>
		<td><input type="submit" name="save_condition" id="save_condition" class="button button-primary" value="<?php esc_html_e('Add', 'loycott-loyalty'); ?>"></td>
			<td>
				<input type = "hidden" name="cid_1" id="cid_1" value="<?php echo esc_attr($cid); ?>">
			</td>
		</tr>
	</tbody>
</table>
</form>
</div>


</div>
	<?php
			break;
		case 'othersettings':
			?>
					<div class="loycott-misc-tab-wrapper">

		<?php $connection_label = esc_html__('Set the system messages language and the Autocomplete Order option', 'loycott-loyalty'); ?>
<p><?php echo esc_html($connection_label); ?></p>
<P><?php echo wp_kses_post(loycott_litValidLic()); ?></P>
	<?php settings_errors(); ?>
<form method="post" action="options.php">
	<?php
		settings_fields( 'loycott_settings_option_group' );
		do_settings_sections( 'loycott-plugin-settings-admin' );
			?>
<input type="submit" name="save_settings" class="button button-primary" id="save_settings" value="Save">
</form>
</div>
		<?php
			break;
		case 'customers':
			?>
			<div class="loycott-customers-tab-wrapper">




<P><?php echo wp_kses_post(loycott_litValidLic()); ?></P>
	<?php
		$licType = loycott_packageLicLit();
			if (( strstr($licType, 'Free') ) || ( strstr($licType, 'Trial') ) ) {
			$loycott_license_options = get_option( 'loycott_license_option_name' ); // Array of All Options
			$license_key_0 = $loycott_license_options['license_key_0']; 
				?>
<p><?php esc_html_e('This type of license supports only view 1 customer, 1 transaction and 1 redemption. Press', 'loycott-loyalty'); ?>  <a class="button button-primary" href="<?php echo esc_html(get_site_url()) . '/?loycott_upgrade_page'; ?>" target="_blank"><?php esc_html_e('Upgrade', 'loycott-loyalty'); ?></a></p>
		<?php
			}
			?>
<div class="tab">
<button class="tablinks active" id="membersHandler" ><?php esc_html_e('Members', 'loycott-loyalty'); ?></button>
<button class="tablinks" id="transactionsHandler" ><?php esc_html_e('Transactions', 'loycott-loyalty'); ?></button>
<button class="tablinks" id="redemptionsHandler"><?php esc_html_e('Redemptions', 'loycott-loyalty'); ?></button>
</div>
<!-- Tab content -->
<div id="Members" class="tabcontent" style="display:block;">
<h3><?php esc_html_e('Members List', 'loycott-loyalty'); ?></h3>
<p>
<table width="100%" id="memberstbl">
<thead>
<tr>
<th colspan=9>
<form action="<?php echo isset($_SERVER['REQUEST_URI']) ? esc_url( sanitize_text_field(wp_unslash($_SERVER['REQUEST_URI']) )) : ''; ?>" method="post"
	name="searchForm" id="searchForm">
	<?php wp_nonce_field('loycott_search_form_action', 'loycott_search_form_nonce'); ?>
	<?php
			if (isset($_POST['searchbtn'])) {
				if (!isset($_POST['loycott_search_form_nonce']) || !wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['loycott_search_form_nonce'])), 'loycott_search_form_action')) {
					wp_die('Invalid nonce verification');
				}
			}
			?>
	<input type="text" name="searchCustomer" class="regular-text" id="searchCustomer"
	placeholder="<?php esc_attr_e('enter name, phone or email', 'loycott-loyalty'); ?>">
	<input class="button " type="submit" name="searchbtn" id="searchbtn"
	value="<?php esc_attr_e('Search', 'loycott-loyalty'); ?>">
</th>
</form>
</tr>
<tr>
<th><?php esc_html_e('Customer', 'loycott-loyalty'); ?></th>
<th><?php esc_html_e('Phone', 'loycott-loyalty'); ?>
</td>
<th><?php esc_html_e('Email', 'loycott-loyalty'); ?>
</td>
<th><?php esc_html_e('Points', 'loycott-loyalty'); ?>
</td>
<th colspan=5 style="text-align: center;"><?php esc_html_e('Actions', 'loycott-loyalty'); ?></th>
</tr>
</thead>
<tbody>
	<?php $i = 1; ?>
	<?php
		$searchTerm = '';
			if (isset($_POST['searchCustomer']) && trim(sanitize_text_field(wp_unslash($_POST['searchCustomer']))) != '') {
				if ( isset($_POST['searchbtn']) &&
				isset($_POST['loycott_search_form_nonce']) &&
				wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['loycott_search_form_nonce'])), 'loycott_search_form_action') ) {
			   $searchTerm = sanitize_text_field(wp_unslash($_POST['searchCustomer']));
				}
			}
			?>
		<?php 
			if (is_array(loycott_getCompanyMembers($searchTerm)) || is_object(loycott_getCompanyMembers($searchTerm))) {
				?>
			<?php foreach (loycott_getCompanyMembers($searchTerm) as $row) : ?>
<tr>
<td><?php echo esc_html($row['CUSTOMER']); ?></td>
<td><?php echo esc_html($row['PHONE']); ?></td>
<td><?php echo esc_html($row['EMAIL']); ?></td>
<td><?php echo esc_html($row['points']); ?></td>
<td align="center">
<input class="button fiveup" type="button"
data-action="edit" data-phone="<?php echo esc_attr(sanitize_text_field(wp_unslash($row['PHONE']))); ?>" value="Edit">
</td>
<td align="center">
<input class="button fiveup" type="button"
data-action="amt" data-phone="<?php echo esc_attr($row['PHONE']); ?>" value="Member Transactions">
</td>
<td align="center">
<input class="button fiveup" type="button"
data-action="amr" data-phone="<?php echo esc_attr($row['PHONE']); ?>" value="Member Redemptions">
</td>
<td align="center">
<input class="button fiveup" type="button"
data-action="mt" data-phone="<?php echo esc_attr($row['PHONE']); ?>" value="New Transaction">
</td>
<td align="center">
<input class="button fiveup" type="button"
data-action="mr" data-phone="<?php echo esc_attr($row['PHONE']); ?>" data-points="<?php echo esc_attr($row['points']); ?>"
value="New Redemption">
</td>
</tr>

		<?php $i++; ?>
	<?php endforeach; ?>
		<?php } ?>
</tbody>
</table>

</p>
	<?php if (isset($_REQUEST['a']) && wp_verify_nonce(isset($_REQUEST['_wpnonce']) ? sanitize_text_field(wp_unslash($_REQUEST['_wpnonce'])) : '', 'loycott_action_nonce')) { ?>
		<?php if (esc_html(sanitize_text_field(wp_unslash($_REQUEST['a']))) == 'edit') { ?>
<p>
<form method="post" action="<?php echo isset($_SERVER['REQUEST_URI']) ? esc_url(sanitize_text_field(wp_unslash($_SERVER['REQUEST_URI']))) : ''; ?>">
	<?php wp_nonce_field('loycott_edit_member_action', 'loycott_edit_member_nonce'); ?>
	<table width="100%" id="memberstbl">
		<thead>
			<tr>
				<th><?php esc_html_e('Change the member Email', 'loycott-loyalty'); ?></th>
			</tr>
		</thead>
		<tbody>
				<tr>
				<td>
				<input readonly type="text" name="memphone" class="regular-text" id="memphone"
				value="<?php echo isset( $_REQUEST['phone'] ) ? esc_attr( sanitize_text_field(wp_unslash( $_REQUEST['phone'] )) ) : ''; ?>">
				</td>
				</tr>
				<tr>
					<td>
						<?php 
						if (is_array(loycott_memberDetails(esc_attr(sanitize_text_field(wp_unslash($_REQUEST['phone']))))) || is_object(loycott_memberDetails(esc_attr(sanitize_text_field(wp_unslash($_REQUEST['phone'])))))) {

							?>
							<input type="text" name="mememail" class="regular-text" id="mememail"
							value="<?php echo esc_attr(loycott_memberDetails(( esc_attr(sanitize_text_field(wp_unslash($_REQUEST['phone']))) ))['email']); ?>">
						<?php } ?>
					</td>
				</tr>
				<tr>
					<td>

						<input type="submit" name="membutton" class="button fiveup"
						id="membutton" value="Submit">
					</td>
				</tr>
			</tbody>
		</table>
	</form>
</p>

				<?php } ?>
				<?php } ?>

		<?php if (isset($_REQUEST['a']) && wp_verify_nonce(isset($_REQUEST['_wpnonce']) ? sanitize_text_field(wp_unslash($_REQUEST['_wpnonce'])) : '', 'loycott_action_nonce')) { ?>
	<?php if (esc_html(sanitize_text_field(wp_unslash($_REQUEST['a']))) == 'amt') { ?>
<p>
<table width="100%" id="memberstbl">
<thead>
<tr>
	<th><?php esc_html_e('Date', 'loycott-loyalty'); ?></th>
	<th><?php esc_html_e('Member', 'loycott-loyalty'); ?>
	</td>
	<th><?php esc_html_e('Points', 'loycott-loyalty'); ?>
	</td>
	<th><?php esc_html_e('Store', 'loycott-loyalty'); ?>
	</td>
	<th></th>
</tr>
</thead>
<tbody>
	<?php $i = 1; ?>
	<?php
	$t_searchPhone = '';
					if (isset($_REQUEST['phone']) && trim(sanitize_text_field(wp_unslash($_REQUEST['phone']))) != '') {
						$t_searchPhone = sanitize_text_field(wp_unslash($_REQUEST['phone']));
					}
					?>
	<?php 
					if (is_array(loycott_getCompanyTransactions($t_searchPhone, '1')) || is_object(loycott_getCompanyTransactions($t_searchPhone, '1'))) {
						?>
		<?php foreach (loycott_getCompanyTransactions($t_searchPhone, '1') as $row) : ?>
		<tr>
			<td><?php echo esc_html($row['trndate']); ?></td>
			<td><?php echo esc_html($row['first_name']) . ' ' . esc_html($row['last_name']); ?></td>
			<td><?php echo esc_html($row['points']); ?></td>
			<td><?php echo esc_html($row['title']); ?></td>
			<td>&nbsp;</td>
		</tr>
		<?php $i++; ?>
	<?php endforeach; ?>
					<?php } ?>
</tbody>
</table>
</p>
	<?php } ?>
	<?php } ?>

		<?php if (isset($_REQUEST['a']) && wp_verify_nonce(isset($_REQUEST['_wpnonce']) ? sanitize_text_field(wp_unslash($_REQUEST['_wpnonce'])) : '', 'loycott_action_nonce')) { ?>
	<?php if (esc_html(sanitize_text_field(wp_unslash($_REQUEST['a']))) == 'amr') { ?>
<p>
<table width="100%" id="memberstbl">
<thead>
<tr>
	<th><?php esc_html_e('Date', 'loycott-loyalty'); ?></th>
	<th><?php esc_html_e('Member', 'loycott-loyalty'); ?>
	</td>
	<th><?php esc_html_e('Points', 'loycott-loyalty'); ?>
	</td>
	<th><?php esc_html_e('Condition', 'loycott-loyalty'); ?>
	</td>
	<th><?php esc_html_e('Store', 'loycott-loyalty'); ?>
	</td>
	<th></th>
</tr>
</thead>
<tbody>
	<?php $i = 1; ?>
	<?php
	$t_searchPhone = '';
					if (isset($_REQUEST['phone']) && trim(esc_html(sanitize_text_field(wp_unslash($_REQUEST['phone'])))) != '') {
						$t_searchPhone = esc_html(sanitize_text_field(wp_unslash($_REQUEST['phone'])));
					}
					?>
	<?php 
					if (is_array(loycott_getCompanyTransactions($t_searchPhone, '2')) || is_object(loycott_getCompanyTransactions($t_searchPhone, '2'))) {
						?>
		<?php foreach (loycott_getCompanyTransactions($t_searchPhone, '2') as $row) : ?>
		<tr>
			<td><?php echo esc_html($row['trndate']); ?></td>
			<td><?php echo esc_html($row['first_name']) . ' ' . esc_html($row['last_name']); ?></td>
			<td><?php echo esc_html($row['points']); ?></td>
			<td><?php echo esc_html($row['condTitle']); ?></td>
			<td><?php echo esc_html($row['title']); ?></td>
			<td>&nbsp;</td>
		</tr>
		<?php $i++; ?>
	<?php endforeach; ?>
					<?php } ?>
</tbody>
</table>
</p>
	<?php } ?>
	<?php } ?>

		<?php if (isset($_REQUEST['a']) && wp_verify_nonce(isset($_REQUEST['_wpnonce']) ? sanitize_text_field(wp_unslash($_REQUEST['_wpnonce'])) : '', 'loycott_action_nonce')) { ?>
	<?php if (esc_html(sanitize_text_field(wp_unslash($_REQUEST['a']))) == 'mt') { ?>
<p>
<table width="100%" id="memberstbl">
<thead>
<tr>
	<th><?php esc_html_e('Enter the transaction details', 'loycott-loyalty'); ?></th>
</tr>
</thead>
<tbody>
<tr>
	<td><input type="text" name="trphone" class="regular-text" id="trphone"
		value="<?php echo isset($_REQUEST['phone']) ? esc_html(sanitize_text_field(wp_unslash($_REQUEST['phone']))) : ''; ?>"></td>
	</tr>
	<tr>
		<td><input type="text" name="trpoints" class="regular-text" id="trpoints"
			placeholder="<?php esc_attr_e('enter points', 'loycott-loyalty'); ?>"></td>
		</tr>
		<tr>
			<td><input type="text" name="trcomment" class="regular-text" id="trcomment"
				placeholder="<?php esc_attr_e('enter comment', 'loycott-loyalty'); ?>"></td>
			</tr>
			<tr>
				<td>
					<form method="post"
					action="<?php echo isset($_SERVER['HTTP_HOST']) && isset($_SERVER['REQUEST_URI']) ? esc_url('https://' . sanitize_text_field(wp_unslash($_SERVER['HTTP_HOST'])) . sanitize_text_field(wp_unslash($_SERVER['REQUEST_URI']))) : ''; ?>">
					<?php wp_nonce_field('loycott_transaction_action', 'loycott_transaction_nonce'); ?>
					<input type="submit" name="trbutton" class="button fiveup"
					id="trbutton" value="Submit">
				</form>
			</td>
		</tr>
	</tbody>
</table>
</p>

	<?php } ?>
	<?php } ?>
		<?php if (isset($_REQUEST['a']) && wp_verify_nonce(isset($_REQUEST['_wpnonce']) ? sanitize_text_field(wp_unslash($_REQUEST['_wpnonce'])) : '', 'loycott_action_nonce')) { ?>
	<?php if (esc_html(sanitize_text_field(wp_unslash($_REQUEST['a']))) == 'mr') { ?>
<p>
<table width="100%" id="memberstbl">
<thead>
<tr>
	<th><?php esc_html_e('Enter the redemption details', 'loycott-loyalty'); ?></th>
</tr>
</thead>
<tbody>
<tr>
	<td><input type="text" name="rephone" class="regular-text" id="rephone"
		value="<?php echo esc_html(sanitize_text_field(wp_unslash($_REQUEST['phone']))); ?>"></td>
	</tr>
	<tr>
		<td>
			<select name="recondition" id="recondition">
					<?php 
					$points = isset( $_REQUEST['points'] ) ? absint( $_REQUEST['points'] ) : 0;
					$conditions = loycott_getConditionsForCustomer( $points );
					if ( is_array( $conditions ) || is_object( $conditions ) ) { 
						?>
					<?php foreach ( $conditions as $row ) : ?>

						<option value="<?php echo esc_attr($row['ccid']); ?>"><?php echo esc_html($row['cctitle']); ?></option>
						<?php $i++; ?>
					<?php endforeach; ?>
				<?php } ?>
			</select>
		</td>
	</tr>
	<tr>
		<td><input type="text" name="recomment" class="regular-text" id="recomment"
			placeholder="<?php esc_attr_e('enter comment', 'loycott-loyalty'); ?>"></td>
		</tr>
		<tr>
			<td>
			<form method="post" action="<?php echo isset($_SERVER['REQUEST_URI']) ? esc_url(sanitize_text_field(wp_unslash($_SERVER['REQUEST_URI']))) : ''; ?>">
				<?php wp_nonce_field('loycott_redemption_action', 'loycott_redemption_nonce'); ?>
				<input type="submit" name="rebutton" class="button fiveup"
				id="rebutton" value="<?php esc_attr_e('Submit', 'loycott-loyalty'); ?>">
			</td>
		</form>
	</tr>
</tbody>
</table>
</p>

	<?php } ?>
	<?php } ?>

</div>

<div id="Transactions" class="tabcontent">
<h3><?php esc_html_e('Transactions List', 'loycott-loyalty'); ?></h3>
<p>
<table width="100%" id="memberstbl">
<thead>
<tr>
<th colspan=5>
<form action="<?php echo isset($_SERVER['HTTP_HOST']) && isset($_SERVER['REQUEST_URI']) ? esc_url('https://' . sanitize_text_field(wp_unslash($_SERVER['HTTP_HOST'])) . sanitize_text_field(wp_unslash($_SERVER['REQUEST_URI']))) : ''; ?>" method="post"
	name="searchTrnForm" id="searchTrnForm">
	<?php wp_nonce_field('loycott_transaction_search_action', 'loycott_transaction_search_nonce'); ?>
	<input type="text" name="trnsearchPhone" class="regular-text" id="trnsearchPhone"
	placeholder="<?php esc_attr_e('enter phone', 'loycott-loyalty'); ?>">
	<input class="button" type="submit" name="searchbtn1" id="searchbtn1"
	value="<?php esc_attr_e('Search', 'loycott-loyalty'); ?>">
	<input type="hidden" name="trntab" class="regular-text" id="trntab" value="1">
</form>
</th>
</tr>
<tr>
<th><?php esc_html_e('Date', 'loycott-loyalty'); ?></th>
<th><?php esc_html_e('Member', 'loycott-loyalty'); ?>
</td>
<th><?php esc_html_e('Points', 'loycott-loyalty'); ?>
</td>
<th><?php esc_html_e('Store', 'loycott-loyalty'); ?>
</td>
<th></th>
</tr>
</thead>
<tbody>
		<?php $i = 1; ?>
		<?php
		$t_searchPhone = '';
			if (isset($_POST['trnsearchPhone']) && trim(sanitize_text_field(wp_unslash($_POST['trnsearchPhone']))) != '') {
				if ( isset($_POST['searchbtn1']) &&
				isset($_POST['loycott_transaction_search_nonce']) &&
				wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['loycott_transaction_search_nonce'])), 'loycott_transaction_search_action') ) {
			   $t_searchPhone = sanitize_text_field(wp_unslash($_POST['trnsearchPhone']));
				}
			}
			?>
		<?php 
			if (is_array(loycott_getCompanyTransactions($t_searchPhone, '1')) || is_object(loycott_getCompanyTransactions($t_searchPhone, '1'))) {
				?>
			<?php foreach (loycott_getCompanyTransactions($t_searchPhone, '1') as $row) : ?>
<tr>
	<td><?php echo esc_html($row['trndate']); ?></td>
	<td><?php echo esc_html($row['first_name']) . ' ' . esc_html($row['last_name']); ?></td>
	<td><?php echo esc_html($row['points']); ?></td>
	<td><?php echo esc_html($row['title']); ?></td>
	<td>&nbsp;</td>
</tr>
<?php $i++; ?>
<?php endforeach; ?>
		<?php } ?>
</tbody>
</table>
</p>
</div>

<div id="Redemptions" class="tabcontent">
<h3><?php esc_html_e('Redemptions List', 'loycott-loyalty'); ?></h3>
<p>
<table width="100%" id="memberstbl">
<thead>
<tr>
<th colspan=5>
<form action="<?php echo isset($_SERVER['HTTP_HOST']) && isset($_SERVER['REQUEST_URI']) ? esc_url('https://' . sanitize_text_field(wp_unslash($_SERVER['HTTP_HOST'])) . sanitize_text_field(wp_unslash($_SERVER['REQUEST_URI']))) : ''; ?>" method="post"
	name="searchRedempForm" id="searchRedempForm">
	<?php wp_nonce_field('loycott_redemption_search_action', 'loycott_redemption_search_nonce'); ?>
	<input type="text" name="redempsearchPhone" class="regular-text" id="redempsearchPhone"
	placeholder="<?php esc_attr_e('enter phone', 'loycott-loyalty'); ?>">
	<input class="button " type="submit" name="searchbtn2" id="searchbtn2"
	value="<?php esc_attr_e('Search', 'loycott-loyalty'); ?>">
	<input type="hidden" name="rdmtab" class="regular-text" id="rdmtab" value="1">
</form>
</th>
</tr>
<tr>
<th><?php esc_html_e('Date', 'loycott-loyalty'); ?></th>
<th><?php esc_html_e('Member', 'loycott-loyalty'); ?>
</td>
<th><?php esc_html_e('Points', 'loycott-loyalty'); ?>
</td>
<th><?php esc_html_e('Condition', 'loycott-loyalty'); ?>
</td>
<th><?php esc_html_e('Store', 'loycott-loyalty'); ?>
</td>
<th>&nbsp;</th>
</tr>
</thead>
<tbody>
	<?php $i = 1; ?>
	<?php
		$r_searchPhone = '';
		if ( isset( $_POST['searchbtn2'] ) ) {
			if ( ! isset( $_POST['loycott_redemption_search_nonce'] ) || ! wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['loycott_redemption_search_nonce'] ) ), 'loycott_redemption_search_action' ) ) {
				wp_die( esc_html__( 'Invalid nonce specified', 'loycott-loyalty' ), esc_html__( 'Error', 'loycott-loyalty' ), array(
					'response'  => 403,
					'back_link' => true,
				) );
			}
			if ( isset( $_POST['redempsearchPhone'] ) && '' !== trim( sanitize_text_field( wp_unslash( $_POST['redempsearchPhone'] ) ) ) ) {
				$r_searchPhone = sanitize_text_field( wp_unslash( $_POST['redempsearchPhone'] ) );
			}
		}
			?>
		<?php 
			if (is_array(loycott_getCompanyTransactions($r_searchPhone, '2')) || is_object(loycott_getCompanyTransactions($r_searchPhone, '2'))) {
				?>
			<?php foreach (loycott_getCompanyTransactions($r_searchPhone, '2') as $row) : ?>
<tr>
	<td><?php echo esc_html($row['trndate']); ?></td>
	<td><?php echo esc_html($row['first_name']) . ' ' . esc_html($row['last_name']); ?></td>
	<td><?php echo esc_html($row['points']); ?></td>
	<td><?php echo esc_html($row['condTitle']); ?></td>
	<td><?php echo esc_html($row['title']); ?></td>
	<td>
	</td>
</tr>
<?php $i++; ?>
<?php endforeach; ?>
		<?php } ?>
</tbody>
</table>

</div>




</div>
	<?php
			break;

		default:
			?>
				<div class="loycott-general-tab-wrapper">

<div class="loycott-general-licenses">
<div class="loycott-banner-card free">
<img src="<?php echo esc_url(LOYCOTT_DIR_URL . 'imgs/free.svg'); ?>"/>
</div>
<div class="loycott-banner-card premium">
<img src="<?php echo esc_url(LOYCOTT_DIR_URL . 'imgs/premium.svg'); ?>"/>

</div>
<div class="loycott-banner-card reseller">
<img src="<?php echo esc_url(LOYCOTT_DIR_URL . 'imgs/enterprise.svg'); ?>"/>

</div>
	<?php 
	//echo promotext();






			?>

</div>
<div class="loycott-footer-manage-licenses">
Manage your licenses: <a class="button button-primary" href="https://www.boomsservices.com/subscriptions" target="_blank"><?php esc_html_e('Admin', 'loycott-loyalty'); ?></a>
</div>
</div>
	<?php
			break;
endswitch; 
	?>

</div>
</div>
<?php
}






add_action( 'admin_init', 'loycott_settings_page_init');


function loycott_settings_page_init() {
//Users
register_setting(
'loycott_settings_option_group', // option_group
'loycott_settings_option_name', // option_name
'loycott_settings_sanitize' // sanitize_callback
);

add_settings_section(
'loycott_settings_setting_section', // id
'Other Settings', // title
'loycott_settings_section_info', // callback
'loycott-plugin-settings-admin' // page
);

add_settings_field(
'booms_sms_lang_2', // id
'Language', // title
'loycott_sms_lang_2_callback', // callback
'loycott-plugin-settings-admin', // page
'loycott_settings_setting_section' // section
);

add_settings_field(
'autocompleteoption', // id
'Auto complete order', // title
'loycott_autocomplete_order_callback', // callback
'loycott-plugin-settings-admin', // page
'loycott_settings_setting_section' // section
);

add_settings_field(
'tos', // id
'Terms of service for clients <br><small>(If filled, it appears in cart of the client)</small>', // title
'loycott_tos_callback' , // callback
'loycott-plugin-settings-admin', // page
'loycott_settings_setting_section' // section
);

//License
register_setting(
'loycott_license_option_group', // option_group
'loycott_license_option_name', // option_name
'loycott_license_sanitize' // sanitize_callback
);

add_settings_section(
'loycott_settings_license_section', // id
'License', // title
'loycott_license_section_info', // callback
'boomsloyalty-plugin-license-admin' // page
);

add_settings_field(
'license_key_0', // id
'API key', // title
'loycott_license_key_0_callback', // callback
'boomsloyalty-plugin-license-admin', // page
'loycott_settings_license_section' // section
);



add_settings_field(
'email_0', // id
'Registration Email', // title
'loycott_email_0_callback', // callback
'boomsloyalty-plugin-license-admin', // page
'loycott_settings_license_section' // section
);

add_settings_field(
'domain_0', // id
'Shop Domain Name', // title
'loycott_domain_0_callback', // callback
'boomsloyalty-plugin-license-admin', // page
'loycott_settings_license_section' // section
);

//Business

register_setting(
'loycott_business_option_group', // option_group
'loycott_business_option_name', // option_name
'loycott_business_sanitize' // sanitize_callback
);

add_settings_section(
'loycott_settings_business_section', // id
'Business Information', // title
'loycott_business_section_info', // callback
'boomsloyalty-plugin-business-admin' // page
);

add_settings_field(
'title_0', // id
'Company Title', // title
'loycott_title_0_callback', // callback
'boomsloyalty-plugin-business-admin', // page
'loycott_settings_business_section' // section
);
add_settings_field(
'address_0', // id
'Address', // title
'loycott_address_0_callback', // callback
'boomsloyalty-plugin-business-admin', // page
'loycott_settings_business_section' // section
);
add_settings_field(
'location_0', // id
'Location', // title
'loycott_location_0_callback', // callback
'boomsloyalty-plugin-business-admin', // page
'loycott_settings_business_section' // section
);
add_settings_field(
'country_0', // id
'Country', // title
'loycott_country_0_callback', // callback
'boomsloyalty-plugin-business-admin', // page
'loycott_settings_business_section' // section
);

add_settings_field(
'phone_0', // id
'Phone', // title
'loycott_phone_0_callback' , // callback
'boomsloyalty-plugin-business-admin', // page
'loycott_settings_business_section' // section
);

add_settings_field(
'email_1', // id
'Company Email', // title
'loycott_email_1_callback', // callback
'boomsloyalty-plugin-business-admin', // page
'loycott_settings_business_section' // section
);
add_settings_field(
'website_0', // id
'Website', // title
'loycott_website_0_callback', // callback
'boomsloyalty-plugin-business-admin', // page
'loycott_settings_business_section' // section
);

add_settings_field(
'zip_code_0', // id
'Zip Code', // title
'loycott_zip_code_0_callback', // callback
'boomsloyalty-plugin-business-admin', // page
'loycott_settings_business_section' // section
);

add_settings_field(
'vat_0', // id
'V.A.T', // title
'loycott_vat_0_callback', // callback
'boomsloyalty-plugin-business-admin', // page
'loycott_settings_business_section' // section
);


//Store

register_setting(
'loycott_store_option_group', // option_group
'loycott_store_option_name', // option_name
'loycott_store_sanitize' // sanitize_callback
);

add_settings_section(
'loycott_settings_store_section', // id
'Store Information', // title
'loycott_store_section_info', // callback
'boomsloyalty-plugin-store-admin' // page
);

add_settings_field(
'title_1', // id
'Store Title', // title
'loycott_title_1_callback', // callback
'boomsloyalty-plugin-store-admin', // page
'loycott_settings_store_section' // section
);
add_settings_field(
'address_1', // id
'Address', // title
'loycott_address_1_callback', // callback
'boomsloyalty-plugin-store-admin', // page
'loycott_settings_store_section' // section
);
add_settings_field(
'phone_1', // id
'Phone', // title
'loycott_phone_1_callback', // callback
'boomsloyalty-plugin-store-admin', // page
'loycott_settings_store_section' // section
);
add_settings_field(
'location_1', // id
'Location', // title
'loycott_location_1_callback', // callback
'boomsloyalty-plugin-store-admin', // page
'loycott_settings_store_section' // section
);
add_settings_field(
'country_1', // id
'Country', // title
'loycott_country_1_callback', // callback
'boomsloyalty-plugin-store-admin', // page
'loycott_settings_store_section' // section
);
add_settings_field(
'zip_code_1', // id
'Zip Code ', // title
'loycott_zip_code_1_callback', // callback
'boomsloyalty-plugin-store-admin', // page
'loycott_settings_store_section' // section
);

add_settings_field(
'store_type_0', // id
'', // title
'store_type_0_callback', // callback
'boomsloyalty-plugin-store-admin', // page
'loycott_settings_store_section' // section
);

register_setting(
'loycott_loyalty_option_group', // option_group
'loycott_loyalty_option_name', // option_name
'loycott_loyalty_sanitize' // sanitize_callback
);

add_settings_section(
'loycott_loyalty_section', // id
'Loyalty Administrator', // title
'loycott_loyalty_section_info', // callback
'boomsloyalty-plugin-loyalty-admin' // page
);

add_settings_field(
'enableloyalty', // id
esc_html__('Enable Loyalty', 'loycott-loyalty'), // title
'loycott_enable_loyalty_callback', // callback
'boomsloyalty-plugin-loyalty-admin', // page
'loycott_loyalty_section' // section
);
}



?>
