<?php

if ( ! defined( 'ABSPATH' ) ) {
exit; // Exit if accessed directly
}

add_action( 'wp_ajax_loycott_refresh_conditions_table', 'loycott_refresh_conditions_table' );

function loycott_refresh_conditions_table() {

	loycott_list_all_conditions();
	wp_die();
}




add_action('wp_ajax_createCompany', 'loycott_createCompany');
add_action('wp_ajax_nopriv_createCompany', 'loycott_createCompany');
function loycott_createCompany() {
	// Verify nonce for security
	if ( ! isset( $_POST['loycott_nonce'] ) || ! wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['loycott_nonce'] ) ), 'loycott_ajax_nonce' ) ) {
		wp_send_json_error( 'Security check failed' );
		wp_die();
	}

	$title_0 = isset($_POST['dataForPHP'][0]) ? sanitize_text_field(wp_unslash($_POST['dataForPHP'][0])) : '';
	$address_0 = isset($_POST['dataForPHP'][1]) ? sanitize_text_field(wp_unslash($_POST['dataForPHP'][1])) : '';
	$location_0 = isset($_POST['dataForPHP'][2]) ? sanitize_text_field(wp_unslash($_POST['dataForPHP'][2])) : '';
	$country_0 = isset($_POST['dataForPHP'][3]) ? sanitize_text_field(wp_unslash($_POST['dataForPHP'][3])) : '';
	$phone_0 = isset($_POST['dataForPHP'][4]) ? sanitize_text_field(wp_unslash($_POST['dataForPHP'][4])) : '';
	$email_1 = isset($_POST['dataForPHP'][5]) ? sanitize_text_field(wp_unslash($_POST['dataForPHP'][5])) : '';
	$website_0 = isset($_POST['dataForPHP'][6]) ? sanitize_text_field(wp_unslash($_POST['dataForPHP'][6])) : '';
	$zip_code_0 = isset($_POST['dataForPHP'][7]) ? sanitize_text_field(wp_unslash($_POST['dataForPHP'][7])) : '';
	$cid_0 = isset($_POST['dataForPHP'][8]) ? sanitize_text_field(wp_unslash($_POST['dataForPHP'][8])) : '';
	$sid_1 = isset($_POST['dataForPHP'][9]) ? sanitize_text_field(wp_unslash($_POST['dataForPHP'][9])) : '';
	$store_type_0 = isset($_POST['dataForPHP'][10]) ? sanitize_text_field(wp_unslash($_POST['dataForPHP'][10])) : '';
	$city_0 = isset($_POST['dataForPHP'][11]) ? sanitize_text_field(wp_unslash($_POST['dataForPHP'][11])) : '';
	$logo = isset($_POST['dataForPHP'][12]) ? sanitize_text_field(wp_unslash($_POST['dataForPHP'][12])) : '';
	$vat = isset($_POST['dataForPHP'][13]) ? sanitize_text_field(wp_unslash($_POST['dataForPHP'][13])) : '';


	$loycott_license_options = get_option( 'loycott_license_option_name' ); // Array of All Options
	$license_key_0 = $loycott_license_options['license_key_0']; 
	$domain_0 = $loycott_license_options['domain_0']; 
	$email_0 = $loycott_license_options['email_0']; 

	
	$post = array(
		'key' => $license_key_0,
		'domain' => $domain_0,
		'licenseemail' => $email_0,
		'title' => $title_0,
		'address' => $address_0,
		'location' => $location_0,
		'country' => $country_0,
		'phone' => $phone_0,
		'email' => $email_1,
		'website' => $website_0,
		'zip_code' => $zip_code_0,
		'cid' => $cid_0,
		'sid' => $sid_1,
		'uid' => 0,
		'store_type' => $store_type_0,
		'city' => $city_0,
		'logo' => $logo,
		'vat' => $vat,
		);

		 $json = array();
	$response = wp_remote_post(loycott_apiurl . 'createcompanyandstore.php', array(
			'method' => 'POST',
			'body' => $post,
			'sslverify' => false, // Use with caution, consider using a valid SSL certificate in production
			));

			$json = array();
	if (is_wp_error($response)) {
	$error_message = $response->get_error_message();
	echo esc_html("Error: $error_message");
	} else {
	$body = wp_remote_retrieve_body($response);
	$json = json_decode($body, true);

	// Process the $json response as needed
	}
			   //echo $response;

		$x = $json['company'];

		$_SESSION['cid'] = $x;
		echo wp_json_encode($response);
				//echo json_encode($post);

		wp_die();
}




add_action('wp_ajax_createCondition', 'loycott_createCondition');
add_action('wp_ajax_nopriv_createCondition', 'loycott_createCondition');
function loycott_createCondition() {
	// Verify nonce for security
	if ( ! isset( $_POST['loycott_nonce'] ) || ! wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['loycott_nonce'] ) ), 'loycott_ajax_nonce' ) ) {
		wp_send_json_error( 'Security check failed' );
		wp_die();
	}

	$title_2 = isset($_POST['dataForPHP'][0]) ? sanitize_text_field(wp_unslash($_POST['dataForPHP'][0])) : '';
	$redemption_value = isset($_POST['dataForPHP'][1]) ? sanitize_text_field(wp_unslash($_POST['dataForPHP'][1])) : '';
	$redemption_type = isset($_POST['dataForPHP'][2]) ? sanitize_text_field(wp_unslash($_POST['dataForPHP'][2])) : '';
	$points = isset($_POST['dataForPHP'][3]) ? absint($_POST['dataForPHP'][3]) : 0;
	$cid_1 = isset($_POST['dataForPHP'][4]) ? absint($_POST['dataForPHP'][4]) : 0;

	$loycott_license_options = get_option( 'loycott_license_option_name' ); // Array of All Options
	$license_key_0 = $loycott_license_options['license_key_0']; 
	$domain_0 = $loycott_license_options['domain_0']; 
	$email_0 = $loycott_license_options['email_0']; 

	
	$post = array(
		'key' => $license_key_0,
		'domain' => $domain_0,
		'licenseemail' => $email_0,
		'cid' => $cid_1,
		'title' => $title_2,
		'redemption_type' => $redemption_type,
		'redemption_value' => $redemption_value,
		'points' => $points,
		 );

		$json = array();
	$response = wp_remote_post(loycott_apiurl . 'createcondition.php', array(
			'method' => 'POST',
			'body' => $post,
			'sslverify' => false, // Use with caution, consider using a valid SSL certificate in production
			));

			$json = array();
	if (is_wp_error($response)) {
	$error_message = $response->get_error_message();
	echo esc_html("Error: $error_message");
	} else {
	$body = wp_remote_retrieve_body($response);
	$json = json_decode($body, true);

	// Process the $json response as needed
	}

	 /*   echo $postResult;
		wp_die();*/
		
		$x = $json['condition'];
				  //   echo $x;

	if ('Your license type does not accept more conditions' != $x) {
		loycott_list_all_conditions();

	} else {
		   
		echo esc_html($x);
	}

		
	   

		wp_die();
}




add_action('wp_ajax_deleteCondition', 'loycott_deleteCondition');
add_action('wp_ajax_nopriv_deleteCondition', 'loycott_deleteCondition');
function loycott_deleteCondition() {
   
	// Verify nonce for security
	if ( ! isset( $_POST['loycott_nonce'] ) || ! wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['loycott_nonce'] ) ), 'loycott_ajax_nonce' ) ) {
		wp_send_json_error( 'Security check failed' );
		wp_die();
	}

	$ccid = isset($_POST['ccid']) ? absint($_POST['ccid']) : 0;

	$loycott_license_options = get_option( 'loycott_license_option_name' ); // Array of All Options
	$license_key_0 = $loycott_license_options['license_key_0']; 
	$domain_0 = $loycott_license_options['domain_0']; 
	$email_0 = $loycott_license_options['email_0']; 

	
	$post = array(
		'key' => $license_key_0,
		'domain' => $domain_0,
		'licenseemail' => $email_0,
		'ccid' => $ccid,
		 );

		 $json = array();
	$response = wp_remote_post(loycott_apiurl . 'deletecondition.php', array(
			'method' => 'POST',
			'body' => $post,
			'sslverify' => false, // Use with caution, consider using a valid SSL certificate in production
			));

			$json = array();
	if (is_wp_error($response)) {
	$error_message = $response->get_error_message();
	echo esc_html("Error: $error_message");
	} else {
	$body = wp_remote_retrieve_body($response);
	$json = json_decode($body, true);

	// Process the $json response as needed
	}
		
		$x = $json['condition'];
		 loycott_list_all_conditions();
		//echo $x;
		wp_die();
}





add_action('wp_ajax_create_admin_transaction', 'loycott_create_admin_transaction');
add_action('wp_ajax_nopriv_create_admin_transaction', 'loycott_create_admin_transaction');
function loycott_create_admin_transaction() {
	$x = '';

	// Verify nonce for security
	if ( ! isset( $_POST['loycott_nonce'] ) || ! wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['loycott_nonce'] ) ), 'loycott_ajax_nonce' ) ) {
		wp_send_json_error( 'Security check failed' );
		wp_die();
	}

	$points = isset($_POST['dataForPHP'][0]) ? absint($_POST['dataForPHP'][0]) : 0;
	$comment = isset($_POST['dataForPHP'][1]) ? sanitize_text_field(wp_unslash($_POST['dataForPHP'][1])) : '';
	$phone = isset($_POST['dataForPHP'][2]) ? sanitize_text_field(wp_unslash($_POST['dataForPHP'][2])) : '';
   

	$token = loycott_authorization();

	$post = array(
		'phone' => $phone,
		'points' => $points,
		'comment' => $comment,
		'token' => $token,
	);
	 $json = array();
	$response = wp_remote_post(loycott_apiurl . 'createtransaction.php', array(
			'method' => 'POST',
			'body' => $post,
			'sslverify' => false, // Use with caution, consider using a valid SSL certificate in production
			));

			$json = array();
	if (is_wp_error($response)) {
	$error_message = $response->get_error_message();
	echo esc_html("Error: $error_message");
	} else {
	$body = wp_remote_retrieve_body($response);
	$json = json_decode($body, true);

	// Process the $json response as needed
	}
}

add_action('wp_ajax_create_admin_redemption', 'loycott_create_admin_redemption');
add_action('wp_ajax_nopriv_create_admin_redemption', 'loycott_create_admin_redemption');
function loycott_create_admin_redemption() {
	$x = '';

	// Verify nonce for security
	if ( ! isset( $_POST['loycott_nonce'] ) || ! wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['loycott_nonce'] ) ), 'loycott_ajax_nonce' ) ) {
		wp_send_json_error( 'Security check failed' );
		wp_die();
	}

	$condition = isset($_POST['dataForPHP'][0]) ? absint($_POST['dataForPHP'][0]) : 0;
	$comment = isset($_POST['dataForPHP'][1]) ? sanitize_text_field(wp_unslash($_POST['dataForPHP'][1])) : '';
	$phone = isset($_POST['dataForPHP'][2]) ? sanitize_text_field(wp_unslash($_POST['dataForPHP'][2])) : '';

		
	$token = loycott_authorization();

	$post = array(
		'phone' => $phone,
		'condition' => $condition,
		'comment' => $comment,
		'token' => $token,
	);
	$json = array();
	$response = wp_remote_post(loycott_apiurl . 'createredemption.php', array(
			'method' => 'POST',
			'body' => $post,
			'sslverify' => false, // Use with caution, consider using a valid SSL certificate in production
			));

			$json = array();
	if (is_wp_error($response)) {
	$error_message = $response->get_error_message();
	echo esc_html("Error: $error_message");
	} else {
	$body = wp_remote_retrieve_body($response);
	$json = json_decode($body, true);

	// Process the $json response as needed
	}
}


//frontend//


function loycott_ajax_add_bal() {
	  //  error_log(json_encode($_POST));

	global $woocommerce;
	// Verify nonce for security
	if ( ! isset( $_POST['loycott_nonce'] ) || ! wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['loycott_nonce'] ) ), 'loycott_ajax_nonce' ) ) {
		wp_send_json_error( 'Security check failed' );
		wp_die();
	}

	$phone = isset($_POST['phone']) ? sanitize_text_field(wp_unslash($_POST['phone'])) : '';
	$points = 0;
	$response = json_decode(loycott_return_user_balance_booms_2($phone), true);
	if (isset($response['points']) && !empty($response['points'])) {
		$points = $response['points'];
	}


	$token = loycott_authorization();

	$post = array(
		'token' => $token,
		'maxpoints' => $points,
	);
	
	$json = array();
	$body = '';
	$response = wp_remote_post(loycott_apiurl . 'companyloyaltyforcustomer.php', array(
			'method' => 'POST',
			'body' => $post,
			'sslverify' => false, // Use with caution, consider using a valid SSL certificate in production
			));

			$json = array();
	if (is_wp_error($response)) {
	$error_message = $response->get_error_message();
	echo esc_html("Error: $error_message");
	} else {
	$body = wp_remote_retrieve_body($response);
	$json = json_decode($body, true);

	// Process the $json response as needed
	}
   WC()->session->set( 'loyaltyscheme', $body );
	WC()->session->set( 'maxpoints', $points );



	echo esc_html($points);
	wp_die();
}



add_action( 'wp_ajax_add_bal', 'loycott_ajax_add_bal' );
add_action( 'wp_ajax_nopriv_add_bal', 'loycott_ajax_add_bal' );



function loycott_ajax_add_retecode() {
	// Verify nonce for security
	if ( ! isset( $_REQUEST['loycott_nonce'] ) || ! wp_verify_nonce( sanitize_text_field( wp_unslash( $_REQUEST['loycott_nonce'] ) ), 'loycott_ajax_nonce' ) ) {
		wp_send_json_error( 'Security check failed' );
		wp_die();
	}
	
	if (!isset($_REQUEST['phone']) || ''==$_REQUEST['phone']) {
		wc_add_notice( esc_html__('The "Loyalty phone number" cannot be empty', 'loycott-loyalty'), 'error' );
	} else {

		$loycott_settings_options = get_option( 'loycott_settings_option_name' ); // Array of All Options
		$booms_sms_lang_2 = $loycott_settings_options['booms_sms_lang_2'];


		$x = '';

		$post = array(
		'phone' => sanitize_text_field(wp_unslash($_REQUEST['phone'])),
		'lng'   => $booms_sms_lang_2,
		);
		 $json = array();
	$response = wp_remote_post(loycott_apiurl . 'getecode.php', array(
			'method' => 'POST',
			'body' => $post,
			'sslverify' => false, // Use with caution, consider using a valid SSL certificate in production
			));

			$json = array();
		if (is_wp_error($response)) {
			$error_message = $response->get_error_message();
			echo esc_html("Error: $error_message");
		} else {
			$body = wp_remote_retrieve_body($response);
			$json = json_decode($body, true);

			// Process the $json response as needed
		}

		foreach ($json as $key => $value) {
			$x = $value->e_code;
		}

		WC()->session->set( 'e_code', $x );
		WC()->session->set( 'lphone', sanitize_text_field(wp_unslash($_REQUEST['phone'])) );
		WC()->session->set( 'phone', sanitize_text_field(wp_unslash($_REQUEST['phone'])) );
		return $x;

	}
}

add_action( 'wp_ajax_add_retecode', 'loycott_ajax_add_retecode' );
add_action( 'wp_ajax_nopriv_add_retecode', 'loycott_ajax_add_retecode' );



function loycott_ajax_add_lc() {
	$x = '';
	
	// Verify nonce for security
	if ( ! isset( $_REQUEST['loycott_nonce'] ) || ! wp_verify_nonce( sanitize_text_field( wp_unslash( $_REQUEST['loycott_nonce'] ) ), 'loycott_ajax_nonce' ) ) {
		wp_send_json_error( 'Security check failed' );
		wp_die();
	}

	$token = loycott_authorization();

	$post = array(
		'token' => $token,
		'maxpoints' => isset($_REQUEST['maxpoints']) ? absint($_REQUEST['maxpoints']) : 0,
	);
	 $json = array();
	 $body='';
	$response = wp_remote_post(loycott_apiurl . 'companyloyaltyforcustomer.php', array(
			'method' => 'POST',
			'body' => $post,
			'sslverify' => false, // Use with caution, consider using a valid SSL certificate in production
			));

			$json = array();
	if (is_wp_error($response)) {
	$error_message = $response->get_error_message();
	echo esc_html("Error: $error_message");
	} else {
	$body = wp_remote_retrieve_body($response);
	$json = json_decode($body, true);

	// Process the $json response as needed
	}
	WC()->session->set( 'loyaltyscheme', $body );
	WC()->session->set( 'maxpoints', isset($_REQUEST['maxpoints']) ? intval($_REQUEST['maxpoints']) : 0 );

	wp_die();
}
add_action( 'wp_ajax_add_lc', 'loycott_ajax_add_lc' );
add_action( 'wp_ajax_nopriv_add_lc', 'loycott_ajax_add_lc' );
