<?php
/**
 * Plugin Name: Loycott -  Loyalty Rewards for WooCommerce
 * Text Domain: loycott-loyalty
 * Domain Path:       /languages
 * Domain Path: /languages
 * Plugin URI: https://www.loycott.com/loyalty-rewards-woocommerce
 * Description: Loycott Loyalty Plugin for WooCommerce
 * Version: 1.0.9
 * Author: Loycott
 * Author URI: https://www.loycott.com
 * License:     GPLv2 or later
 * Copyright: © 2025 Loycott.
 * License URI: http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * Requires Plugins: woocommerce
 */
if ( ! defined( 'WPINC' ) ) {
	die;
}

define('LOYCOTT_DIR', plugin_dir_path( __FILE__ ) );
define('LOYCOTT_FILE', __DIR__ );
define('LOYCOTT_DIR_URL', plugin_dir_url(__FILE__) );




require_once __DIR__ . '/inc/tweaks/headers.php';
require_once __DIR__ . '/inc/assets/localisation.php';
require_once __DIR__ . '/inc/frontend/autocomplete.php';
require_once __DIR__ . '/inc/admin/ajax.calls.php';

require_once __DIR__ . '/inc/admin/settings_info.php';
require_once __DIR__ . '/inc/admin/settings_callbacks.php';
require_once __DIR__ . '/inc/admin/settings_page.php';
require_once __DIR__ . '/inc/admin/settings_sanitize.php';
require_once __DIR__ . '/inc/wizard/default.php';
require_once __DIR__ . '/inc/helpers/basic.php';

define('LOYCOTT_APIURL', 'https://www.loyapps.com/apiprodwp/');

//ADMIN
add_filter('plugin_action_links_' . plugin_basename(__FILE__), 'loycott_booms_settings_page');


function loycott_booms_settings_page( $links ) {
	$links[] = '<a href="admin.php?page=loycott-plugin-settings">' . esc_html('Settings', 'loycott-loyalty') . '</a>';

	return $links;
}


function loycott_register_my_session() {
	session_start();
}

add_action('init', 'loycott_register_my_session');



add_action( 'send_headers', 'send_frame_options_header', 10, 0 );

function loycott_remove_bulk_actions() {
	if ( ! is_admin() ) {
	   return;
	}
   add_filter( 'bulk_actions-edit-shop_order', '__return_empty_array', 100 );
}






class LoycottPluginSettings {

	private $loycott_settings_options;
	private $loycott_license_options;


	
//Admin page html callback
//Print out html for admin page
}
if ( is_admin() ) {
	$loycott_settings = new LoycottPluginSettings();
}







add_action( 'woocommerce_order_status_completed', 'loycott_update_order_woo' , 10, 2);


function loycott_update_order_woo( $order_id, $order ) {
	  //$order = wc_get_order( $order_id );
	  $oo = $order->get_id();
	  $f_name = $order->get_billing_first_name();
	  $l_name = $order->get_billing_last_name();
	  $phone = $order->get_billing_phone();
	  $email = $order->get_billing_email();
	  $zipcode = $order->get_billing_postcode();

	  $key_name = get_post_custom_values('loyaltyphone', $oo);
	  $lphone = $key_name[0];

	  $key_name = get_post_custom_values('countrycodes', $oo);
	  $countrycode = loycott_mapping_countrycodes($key_name[0]);


	  $key_name = get_post_custom_values('condition', $oo);
	  $condition = $key_name[0];

	  $amt = round($order->get_total());

	  loycott_add_booms_points($oo, $f_name, $l_name, $zipcode, $lphone, $email, $amt, $countrycode);

	  loycott_redeem_booms_points($order_id, $lphone, $condition);
}


function loycott_add_booms_points( $order_id, $firstname, $lastname, $zipcode, $phone, $email, $amt, $countrycode ) {
	
	/**
	 * Check if WooCommerce is activated
	 */
	if ( class_exists( 'woocommerce' ) ) {             
			

		$cid = loycott_return_login_details('company');
		$uid = loycott_return_login_details('user');
				
		$password = '123456';
				
		loycott_add_update_booms_user($firstname, $lastname, $zipcode, $password, $phone, $email, $cid, $countrycode);
			
		$store = loycott_return_store($cid);
		$comment = 'Order ID #' . $order_id;

		loycott_create_transaction($phone, $cid, $store, $uid, $amt, $comment, $order_id);           
	} 
}

function loycott_redeem_booms_points( $order_id, $phone, $condition ) {
	
	/**
	 * Check if WooCommerce is activated
	 */
	if ( class_exists( 'woocommerce' ) ) {             


		$cid = loycott_return_login_details('company');
		$uid = loycott_return_login_details('user');
				
			
		$exploded = explode('|', $condition);
		list($points, $loyaltyprogram, $val, $ccid, $v2) = $exploded;

		if (( $ccid != '0' ) && ( trim($ccid) != '' )) {
				loycott_create_redemption($phone, $cid, $ccid, '', $order_id);
		}
	} 
}


function loycott_authorization() {
		$x = '';
		$loycott_license_options = get_option('loycott_license_option_name', array()); // Array of All Options
		$license = isset($loycott_license_options['license_key_0']) ? $loycott_license_options['license_key_0'] : '';
		$domain = isset($loycott_license_options['domain_0']) ? $loycott_license_options['domain_0'] : '';
		$email = isset($loycott_license_options['email_0']) ? $loycott_license_options['email_0'] : '';
	


		$post = array(
			'key' => $license,
			'domain' => $domain,
			'licenseemail' => $email,
		);
	

	$loycott_existing_customer = apply_filters('loycott_existing_customer', false);
	$url_to_post = 'eauth.php';

		if ($loycott_existing_customer) {

			$login_credentials  = apply_filters('loycott_existing_customer_credentials', array( 'username'=>'', 'password'=>'' ));


			$post = array(
			'username' => $login_credentials['username'],
			'password' => $login_credentials['password'],
			);
			$url_to_post = 'auth.php';

		}





		
			$response = wp_remote_post(LOYCOTT_APIURL . $url_to_post, array(
			'method' => 'POST',
			'body' => $post,
			'sslverify' => false, // Use with caution, consider using a valid SSL certificate in production
			));

			$json = array();
	if (is_wp_error($response)) {
	$error_message = $response->get_error_message();
	wp_die('Error: ' . esc_html($error_message));
	} else {
	$body = wp_remote_retrieve_body($response);
	$json = json_decode($body, true);
				


	
	// Process the $json response as needed
	}


	try {
		if (!isset($json['token'])) {
			$x = '';

		} else {
			$x = $json['token'];
		}
	} catch (Exception $e) {
		$x = '';
	}

	return $x;
}

function loycott_return_login_details( $type ) {
	$x = '';
	$token = loycott_authorization();
	$post = array(
		'token' => $token,
	);
	$json = array();
	$response = wp_remote_post(LOYCOTT_APIURL . 'ecompanyauth.php', array(
			'method' => 'POST',
			'body' => $post,
			'sslverify' => false, // Use with caution, consider using a valid SSL certificate in production
			));

			$json = array();
	if (is_wp_error($response)) {
	$error_message = $response->get_error_message();
	wp_die('Error: ' . esc_html($error_message));
	} else {
	$body = wp_remote_retrieve_body($response);
	$json = json_decode($body, true);

	// Process the $json response as needed
	}

	try {
		if (!isset($json['company'])) {
			$x = '';
		} else {
			if ($type=='company') {
				$x = $json['company']['cid'];
			}
			if ($type=='user') {
				$x = $json['company']['uid'];
			}
			if ($type=='logo') {
				$x = $json['company']['logo'];
			}
			if ($type=='category') {
				$x = $json['company']['usercategoryid'];
			}
			if ($type=='enddt') {
				$d = $json['company']['end_date'];

				if ($d == '0') {
					$x = '<span style="color:blue">' . esc_html__('Your licence is unlimited', 'loycott-loyalty') . '</span>';
				} elseif (strtotime($d) > strtotime('today')) {
						/* translators: %s: License expiration date in d/m/Y format */
						$x = '<span style="color:green">' . sprintf(esc_html__('Your licence is active till %s', 'loycott-loyalty'), gmdate('d/m/Y', strtotime($d))) . '</span>';
				} else {
					$x = '<span style="color:red">' . esc_html__('Your licence has expired or the username/password are not valid.', 'loycott-loyalty') . '</span>';
				}
			}
		}
	} catch (Exception $e) {
		$x = '';
	}

	return $x;
}

function loycott_return_store( $company ) {
	$x = '';


	$token = loycott_authorization();

	$post = array(
		'token' => $token,
	);
	 $json = array();
	$response = wp_remote_post(LOYCOTT_APIURL . 'companystore.php', array(
			'method' => 'POST',
			'body' => $post,
			'sslverify' => false, // Use with caution, consider using a valid SSL certificate in production
			));

			$json = array();
	if (is_wp_error($response)) {
	$error_message = $response->get_error_message();
	wp_die('Error: ' . esc_html($error_message));
	} else {
	$body = wp_remote_retrieve_body($response);
	$json = json_decode($body, true);

	// Process the $json response as needed
	}

	$x = $json['loyalty']['store'];

	return $x;
}
function loycott_add_update_booms_user( $firstname, $lastname, $zipcode, $password, $phone, $email, $company, $countrycode ) {
	$x = '';

	$token = loycott_authorization();

	$post = array(
		'firstname' => $firstname,
		'lastname' => $lastname,
		'gender' => '0',
		'birthdate' => '0000-00-00',
		'zipcode' => $zipcode,
		'email'  => $email,
		'password' => $password,
		'notification' => '1',
		'phone' => $phone,
		'countrycode' => $countrycode,
		'token' => $token,
	);
	
	 $json = array();
	$response = wp_remote_post(LOYCOTT_APIURL . 'wpcreatecustomer.php', array(
			'method' => 'POST',
			'body' => $post,
			'sslverify' => false, // Use with caution, consider using a valid SSL certificate in production
			));

			$json = array();
	if (is_wp_error($response)) {
	$error_message = $response->get_error_message();
	wp_die('Error: ' . esc_html($error_message));
	} else {
	$body = wp_remote_retrieve_body($response);
	$json = json_decode($body, true);

	// Process the $json response as needed
	}
}

function loycott_create_transaction( $phone, $company, $store, $user, $points, $comment, $order_id ) {
	$x = '';

	$token = loycott_authorization();

	$post = array(
		'phone' => $phone,
		'points' => $points,
		'comment' => $comment,
		'token' => $token,
	);
	 $json = array();
	$response = wp_remote_post(LOYCOTT_APIURL . 'createtransaction.php', array(
			'method' => 'POST',
			'body' => $post,
			'sslverify' => false, // Use with caution, consider using a valid SSL certificate in production
			));

			$json = array();
	if (is_wp_error($response)) {
	$error_message = $response->get_error_message();
	wp_die('Error: ' . esc_html($error_message));
	} else {
	$body = wp_remote_retrieve_body($response);
	$json = json_decode($body, true);

	// Process the $json response as needed
	}
}

function loycott_create_redemption( $phone, $company, $condition, $comment, $order_id ) {
	$x = '';


	$token = loycott_authorization();

	$post = array(
		'phone' => $phone,
		'condition' => $condition,
		'comment' => $comment,
		'token' => $token,
	);
	 $json = array();
	$response = wp_remote_post(LOYCOTT_APIURL . 'createredemption.php', array(
			'method' => 'POST',
			'body' => $post,
			'sslverify' => false, // Use with caution, consider using a valid SSL certificate in production
			));

			$json = array();
	if (is_wp_error($response)) {
	$error_message = $response->get_error_message();
	wp_die('Error: ' . esc_html($error_message));
	} else {
	$body = wp_remote_retrieve_body($response);
	$json = json_decode($body, true);

	// Process the $json response as needed
	}
}



function loycott_return_user_balance_booms( $phone ) {
	$x = '';

	$token = loycott_authorization();

	
	$post = array(
		'phone' => $phone,
		'token' => $token,
	);
	 $json = array();
	$response = wp_remote_post(LOYCOTT_APIURL . 'balancecheck.php', array(
			'method' => 'POST',
			'body' => $post,
			'sslverify' => false, // Use with caution, consider using a valid SSL certificate in production
			));

			$json = array();
	if (is_wp_error($response)) {
	$error_message = $response->get_error_message();
	wp_die('Error: ' . esc_html($error_message));
	} else {
	$body = wp_remote_retrieve_body($response);
	$json = json_decode($body, true);

	// Process the $json response as needed
	}

	$x = $json['loyalty']['points'];

  
	if (!empty($phone)) {
	WC()->session->set( 'phone', $phone );
	WC()->session->set( 'lphone', $phone );
		
	}

	return $x;
}

function loycott_company_loyalty_for_customer( $company, $points ) {
	$x = '';

		
	$token = loycott_authorization();

	$post = array(
		'token' => $token,
	);
	 $json = array();
	$response = wp_remote_post(LOYCOTT_APIURL . 'companyloyaltyforcustomer.php', array(
			'method' => 'POST',
			'body' => $post,
			'sslverify' => false, // Use with caution, consider using a valid SSL certificate in production
			));

			$json = array();
	if (is_wp_error($response)) {
	$error_message = $response->get_error_message();
	wp_die('Error: ' . esc_html($error_message));
	} else {
	$body = wp_remote_retrieve_body($response);
	$json = json_decode($body, true);

	// Process the $json response as needed
	}

	$x = $json['loyalty'];

	return $x;
}
function loycott_verify_nonce_on_checkout() {
	if (isset($_POST['loycott_loyalty_option_choice']) && '0' !== $_POST['loycott_loyalty_option_choice']) {
		if (!isset($_POST['loycott_display_button_nonce']) ||
			!wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['loycott_display_button_nonce'])), 'loycott_display_button_action')) {
			wc_add_notice(__('There was a problem validating your loyalty program request. Please try again.', 'loycott-loyalty'), 'error');
		}
	}
}
add_action('woocommerce_checkout_process', 'loycott_verify_nonce_on_checkout');

function loycott_loyalty_button() {
global $woocommerce;
	if ( is_admin() ) {
return;
	}

$loycott_loyalty_options = get_option( 'loycott_loyalty_option_name', array() ); // Array of All Options
$enableloyalty = isset($loycott_loyalty_options['enableloyalty']) ? $loycott_loyalty_options['enableloyalty'] : 'no';
$loycott_settings_options = get_option( 'loycott_settings_option_name', array() );
$tos = isset($loycott_settings_options['tos']) ? $loycott_settings_options['tos'] : '';
wp_nonce_field('loycott_display_button_action', 'loycott_display_button_nonce');

	if ('yes' == $enableloyalty) {

		
			
		


		$chosen = WC()->session->get('loycott_loyalty_option_choice');
		$chosen = empty($chosen) ? WC()->checkout->get_value('loycott_loyalty_option_choice') : $chosen;
		$chosen = empty($chosen) ? '0' : $chosen;


		$loyaltyscheme = WC()->session ? WC()->session->get('loyaltyscheme') : null;

		if (isset($loyaltyscheme)) {
			$lo = loycott_getLoyaltyValues();
		} else {
			$withoutredemption_label = __('Without Redemption', 'loycott-loyalty');
			$lo = array( '0' => ' ' . $withoutredemption_label );
		}

		$args = array(
		'type' => 'radio',
		'class' => array( 'form-row-wide', 'update_totals_on_change' ),
		'options' => $lo,
		'default' => $chosen,
		);

		$token = loycott_authorization();

		$usercategory = loycott_return_login_details( 'category');

		$loyaltyprogram_label = __('Loyalty Program', 'loycott-loyalty');
		$loyaltyprogramphone_label = __('Your phone used on loyalty', 'loycott-loyalty');
		$pointscheck_label = __('Points check', 'loycott-loyalty');
		$pointscheck_consent_label = __('In order to be a member of Loyalty and earn and redeem points please download our application to verify it is you! Then get a new code from the app an enter it in the box below to proceed.', 'loycott-loyalty');

		 $otp_helper_label = esc_html__('Use our Loycott app get a new code and enter it in the box below to proceed.', 'loycott-loyalty');

		$mypoints_label = __('My points', 'loycott-loyalty');
		$selectredemption_label = __('Choose redemption', 'loycott-loyalty');
		$loycott_existing_customer = apply_filters('loycott_existing_customer', false);
		if ($loycott_existing_customer) {
			$usercategory = '10';

		}

		if (( $usercategory != '' ) && ( $usercategory != '0' )) {
			$order_button_text = apply_filters('woocommerce_order_button_text', __('Place order', 'loycott-loyalty'));
			?>
	 
		  <tr class="loycott-woocommerce-layout-table-row">
			<td colspan="2">
				<strong>
					<?php echo esc_html($loyaltyprogram_label); ?>      
					</strong>
				</td>
		</tr>
		  <tr class="loycott-woocommerce-layout-table-row">
			<td colspan="2">
				<?php echo esc_html($loyaltyprogramphone_label); ?>
				</td>
		</tr>
		  <tr class="loycott-woocommerce-layout-table-row">

			<td colspan="2" nowrap class="loycott-phone-wrapper">
	<?php 
	$shop_country = wc_get_base_location()['country'];


			?>
<select name="countrycodes" id="countrycodes">
<?php
$shop_country = wc_get_base_location()['country'];
$selected = '';

			foreach (loycott_countries_list() as $country_code => $value) : 
				$selected = ( $country_code === $shop_country ) ? 'selected' : '';
				?>
<option value="<?php echo esc_attr($value); ?>" <?php echo esc_attr($selected); ?>><?php echo esc_html($country_code) . ' ' . esc_html($value); ?></option>
<?php 
endforeach;
			?>
</select>


			<?php


			woocommerce_form_field('lphone', array(
			'type' => 'text',
			'class' => array(
				'my-field-class form-row-half',
			),
			'label' => '',
			'placeholder' => 'Phone',
			),
		 WC()->session->get('phone'));

			?>



	   </td></tr>
		  <tr class="loycott-woocommerce-layout-table-row">
		<td colspan="2"><?php echo esc_html($pointscheck_consent_label) ; ?></td></tr>
		<tr>
			<td colspan="2"><?php echo esc_html($mypoints_label); ?></td>
		</tr>
		  <tr class="loycott-woocommerce-layout-table-row">
			<td colspan="2"><input width="100%" readonly type="text" name="points" id="points" class="input-text form-control" value="<?php echo esc_attr(WC()->session->get('maxpoints')); ?>">
				<input type="hidden" name="token" id="token" value="<?php echo esc_html($token); ?>"></td>
			</tr>
		  <tr class="loycott-woocommerce-layout-table-row">
			<td colspan="2"><strong><?php echo esc_html($selectredemption_label); ?></strong></td></tr>
		  <tr class="loycott-woocommerce-layout-table-row">
			<td colspan="2">
		<?php
			woocommerce_form_field('loycott_loyalty_option_choice', $args, $chosen);
			?>


		</td>
	</tr>
			<?php 

			$posted = array();
			if ( isset( $_POST['post_data'] ) && isset( $_POST['loycott_display_button_nonce'] ) && wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['loycott_display_button_nonce'] ) ), 'loycott_display_button_action' ) ) {
				parse_str( wp_unslash( $_POST['post_data'] ), $posted_data );
				$posted = array_map( 'sanitize_text_field', $posted_data );
			} elseif ( ! empty( $_POST ) && isset( $_POST['loycott_display_button_nonce'] ) && wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['loycott_display_button_nonce'] ) ), 'loycott_display_button_action' ) ) {
				$posted = array_map( 'sanitize_text_field', wp_unslash( $_POST ) );
			}


			?>
		<?php if (isset($posted['loycott_loyalty_option_choice']) && ( '0' != $posted['loycott_loyalty_option_choice'] ) ) : ?>
		  <tr class="loycott-woocommerce-layout-table-row">
			<td colspan="2">
				<span class="loycott-otp-header"><?php echo esc_html_e('OTP code', 'loycott-loyalty'); ?></span>
				<span class="loycott-download-app"><a href="https://play.google.com/store/apps/details?id=com.booms.loycott" target="_blank"><img src="<?php echo esc_url(LOYCOTT_DIR_URL . '/imgs/google_play.png'); ?>"></a></span>
				<span class="loycott-download-app"><a href="https://apps.apple.com/gr/app/loycott/id6446788807?l=el" target="_blank"><img src="<?php echo esc_url( LOYCOTT_DIR_URL . '/imgs/app_store.png' ); ?>"></a></span>
			</td> 
			
</tr>
		  <tr class="loycott-woocommerce-layout-table-row">
			<td colspan="2">
			<input type="text" name="sms" id="sms" class="input-text form-control" placeholder="<?php esc_html_e('Your OTP Code..', 'loycott-loyalty'); ?>">
				
				<a class='request-otp-btn button btn'>Request SMS</a>
			<span class="loycott-helper-tip"><?php echo esc_html($otp_helper_label); ?></span>
		</td>
	</tr>
		<?php if (isset($tos) && $tos!='') : ?>
		  <tr class="loycott-woocommerce-layout-table-row">
				<td colspan="2"><input type="checkbox" name="accepttos" id="accepttos"><?php echo esc_html($tos); ?></td></tr>
		<?php endif; ?>
			<input type="text" name="sms" id="sms" class="input-text form-control" placeholder="<?php echo esc_attr__('Your OTP Code..', 'loycott-loyalty'); ?>">
			<td colspan="2"><hr></td></tr>
	 <?php endif; ?>

			<?php
		
		}
		
		
	}
}
add_action( 'woocommerce_review_order_after_order_total', 'loycott_loyalty_button' );

/**

* Update the value given in custom field

*/

add_action('woocommerce_checkout_update_order_meta', 'loycott_update_order_meta');

function loycott_update_order_meta( $order_id ) {
	if (!isset($_POST['loycott_display_button_nonce']) || !wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['loycott_display_button_nonce'])), 'loycott_display_button_action')) {
		wc_add_notice(__('There was a problem validating your request. Please try again.', 'loycott-loyalty'), 'error');

	}   
	if (!empty($_POST['lphone'])) {
		update_post_meta($order_id, 'loyaltyphone', sanitize_text_field(wp_unslash($_POST['lphone'])));
	}
	if (!empty($_POST['countrycodes'])) {
		update_post_meta($order_id, 'countrycodes', sanitize_text_field(wp_unslash($_POST['countrycodes'])));
	}
	if (!empty(WC()->session->get('loycott_loyalty_option_choice'))) {
		update_post_meta($order_id, 'condition', sanitize_text_field(WC()->session->get('loycott_loyalty_option_choice')));
	}
}


add_action( 'wp_footer', 'loycott_enqueue_scripts' );
function loycott_enqueue_scripts() {
	global $woocommerce;
   
	if (is_checkout()) {
		wp_register_script('loycott-js', plugin_dir_url(__FILE__) . 'js/loycott.js', array(), '1.0.5', true);
		wp_enqueue_script('loycott-js');
		
		wp_localize_script('loycott-js', 'loycottParams', array(
			'ajaxurl' => admin_url('admin-ajax.php'),
			'nonce' => wp_create_nonce('loycott_validation_nonce'),
			'wc_params' => isset($wc_add_to_cart_params) ? $wc_add_to_cart_params : array(),
		));
	}
	  wp_enqueue_style('loycott-css', plugin_dir_url(__FILE__) . 'css/loycott.css', array(), '1.0.5', 'all' );
}


add_action( 'admin_enqueue_scripts', 'loycott_admin_enqueue_scripts' );
function loycott_admin_enqueue_scripts() {
   

		 wp_register_script( 'loycott-admin-js', plugin_dir_url(__FILE__) . 'js/loycott.admin.js', array(), '1.0.5', true );
		 wp_enqueue_script( 'loycott-admin-js' );

		
	
	  wp_enqueue_style('loycott-admin-css', plugin_dir_url(__FILE__) . 'css/loycott.admin.css', array(), '1.0.5', 'all' );
}
add_action( 'woocommerce_cart_calculate_fees', 'loycott_calculate_discount_fees', 20, 1 );
  
function loycott_calculate_discount_fees( $cart ) {
   
	if ( is_admin() && ! defined( 'DOING_AJAX' ) ) {
return;
	}
   
	
   $radio = WC()->session->get( 'loycott_loyalty_option_choice' );

   $string = $radio;
	if (false !== strpos($string, '|')) {
		$exploded = explode('|', $string);
		$new_radio =  end($exploded);

		//var_dump($exploded);
		list($points, $loyaltyprogram) = $exploded;

		$fee_label = __('Discount because of redemption', 'loycott-loyalty');
		$points_label = __('Points', 'loycott-loyalty');
		
		if ( $radio ) {
			$cart->add_fee( $fee_label . ' (' . $loyaltyprogram . ' - ' . $points_label . ': ' . $points . ')' , -$new_radio );
		}
	}

   WC()->session->set( 'loycott_loyalty_option_choice', $radio);
}
  
add_action( 'woocommerce_checkout_update_order_review', 'loycott_checkout_radio_choice_set_session' );
  
function loycott_checkout_radio_choice_set_session( $posted_data ) {
	if (
		empty($_POST['loycott_display_button_nonce']) ||
		!wp_verify_nonce(
			sanitize_text_field(wp_unslash($_POST['loycott_display_button_nonce'])),
			'loycott_display_button_action'
		)
	) {
		wc_add_notice(__('There was a problem validating your request. Please try again.', 'loycott-loyalty'), 'error');
	}
	
	parse_str( $posted_data, $output );
	if ( isset( $output['loycott_loyalty_option_choice'] ) ) {
		WC()->session->set( 'loycott_loyalty_option_choice', $output['loycott_loyalty_option_choice'] );
	}
}



function loycott_getLoyaltyValues() {
	

	$withoutredemption_label = __('Without redemption', 'loycott-loyalty');
	$lpoints_label = __('πόντοι', 'loycott-loyalty');
	
	$someJSON = WC()->session->get( 'loyaltyscheme' ); 


		$lo = array();
	

	if (isset($someJSON)) {
		   
	   $someObject = json_decode($someJSON);
	   $lo = array( '0'=> $withoutredemption_label );
		if (is_array($someObject) || is_object($someObject)) {
				
			foreach ($someObject as $key => $value) {

				if (!isset($value->error)) {
					$discount = 0;
					$arr1 = array();

					if ($value->redemption_type == '1') {
						$discount = esc_attr(WC()->cart->cart_contents_total) * ( $value->redemption_value / 100 );
					}
					if ($value->redemption_type == '2') {
						$discount = $value->redemption_value;
					}
					if ($value->redemption_type == '3') {
						$discount = 0;
					}

					$discount = $value->points . '|' . $value->cctitle . '|' . $value->redemption_type . '|' . $value->ccid . '|' . $discount;

					$arr1 = array( $discount => $value->cctitle . ' (' . $value->points . ' ' . $lpoints_label . ')' );
					$lo = $lo + $arr1;
				}
			}
				
		}
			
	} else {   
		$lo = array( '0'=> $withoutredemption_label );
	}
		
		WC()->session->set( 'lo', $lo );
		return $lo;
}









function loycott_return_user_balance_booms_2( $phone ) {

	$token = loycott_authorization();
	$body = '';
	
	$x = '';

	$post = array(
		'phone' => $phone,
		'token' => $token,
	);
	if (!empty($phone)) {
	WC()->session->set( 'phone', $phone );
	WC()->session->set( 'lphone', $phone );
		
	}
	 $json = array();
	$response = wp_remote_post(LOYCOTT_APIURL . 'balancecheck.php', array(
			'method' => 'POST',
			'body' => $post,
			'sslverify' => false, // Use with caution, consider using a valid SSL certificate in production
			));

			$json = array();
	if (is_wp_error($response)) {
	$error_message = $response->get_error_message();
	wp_die('Error: ' . esc_html($error_message));
	} else {
	$body = wp_remote_retrieve_body($response);
	$json = json_decode($body, true);

	// Process the $json response as needed
	}


	return $body;
}




add_action('woocommerce_checkout_process', 'loycott_otp_code_check', 9999, 0);

function loycott_otp_code_check() { 

	if (!isset($_POST['loycott_display_button_nonce']) || !wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['loycott_display_button_nonce'])), 'loycott_display_button_action')) {
		wc_add_notice(__('There was a problem validating your request. Please try again.', 'loycott-loyalty'), 'error');
		return;
	}
	$sms = isset($_POST['sms']) ? sanitize_text_field(wp_unslash($_POST['sms'])) : '';
	$post = array(
		'phone' => isset($_POST['lphone']) ? sanitize_text_field(wp_unslash($_POST['lphone'])) : '',
		);
		 $json = array();
	$response = wp_remote_post(LOYCOTT_APIURL . 'getecode.php', array(
			'method' => 'POST',
			'body' => $post,
			'sslverify' => false, // Use with caution, consider using a valid SSL certificate in production
			));

			$json = array();
	if (is_wp_error($response)) {
	$error_message = $response->get_error_message();
	wp_die('Error: ' . esc_html($error_message));
	} else {
		$body = wp_remote_retrieve_body($response);
		$json = json_decode($body);

		// Process the $json response as needed
	}

		$e_code = null;
	foreach ($json as $key => $value) {
		$e_code = $value->e_code;
	}


	$chosen = WC()->checkout->get_value( 'loycott_loyalty_option_choice' );

	if (( isset($chosen) && ( '0' != $chosen ) && ( '' != $chosen ) )  && ( $e_code != $sms )) {
		   $wrongcode_label = __( 'Your  code is not valid' , 'loycott-loyalty' );
		   wc_add_notice($wrongcode_label, 'error' );
	}
}

function loycott_request_validation_otp() {
	check_ajax_referer('loycott_validation_nonce', 'nonce');
	
	if (!isset($_POST['phone'])) {
		wp_send_json_error('Phone number is required');
		wp_die();
	}

	$post = array(
		'phone' => sanitize_text_field(wp_unslash($_POST['phone'])),
	);
		 $json = array();
		 $response = wp_remote_post(LOYCOTT_APIURL . 'codegen.php', array(
			'method' => 'POST',
			'body' => $post,
			'sslverify' => false, // Use with caution, consider using a valid SSL certificate in production
			));

			$json = array();
	if (is_wp_error($response)) {
	$error_message = $response->get_error_message();
	wp_die('Error: ' . esc_html($error_message));
	} else {
	$body = wp_remote_retrieve_body($response);
	//$json = json_decode($body);
			
		echo esc_html($body);
				

	// Process the $json response as needed
	}



	
	wp_die();
}

add_action('wp_ajax_nopriv_loycott_request_validation_otp', 'loycott_request_validation_otp');
add_action('wp_ajax_loycott_request_validation_otp', 'loycott_request_validation_otp');

function loycott_getLoyaltyConditionsForCompany() {

	$token = loycott_authorization();
   // print_r($token);
	$post = array(
		'token' => $token,
		);
		 $json = array();
	$response = wp_remote_post(LOYCOTT_APIURL . 'companyloyalty.php', array(
			'method' => 'POST',
			'body' => $post,
			'sslverify' => false, // Use with caution, consider using a valid SSL certificate in production
			));
	

	
		
	
	

			$json = array();
	if (is_wp_error($response)) {
	$error_message = $response->get_error_message();
	wp_die('Error: ' . esc_html($error_message));
	} else {
	$body = wp_remote_retrieve_body($response);
	$json = json_decode($body, true);
				
				


	// Process the $json response as needed
	}
		//print_r($postResult);


	if (!isset($json['loyalty'])) {
		$x = '';
	} elseif ($json != null) {
			$x = $json['loyalty'];
	} else {
		$x = '';
	}

		
		return $x;
}

function loycott_validateLic() {
	$loycott_license_options = get_option( 'loycott_license_option_name', array() ); // Array of All Options
	$license_key_0 = isset($loycott_license_options['license_key_0']) ? $loycott_license_options['license_key_0'] : '';
	$domain_0 = isset($loycott_license_options['domain_0']) ? $loycott_license_options['domain_0'] : '';
	$email_0 = isset($loycott_license_options['email_0']) ? $loycott_license_options['email_0'] : '';

	$post = array(
		'key' => $license_key_0,
		'domain' => $domain_0,
		'email' => $email_0,
		);
		 $json = array();
	$response = wp_remote_post(LOYCOTT_APIURL . 'genlic.php', array(
			'method' => 'POST',
			'body' => $post,
			'sslverify' => false, // Use with caution, consider using a valid SSL certificate in production
			));

			$json = array();
	if (is_wp_error($response)) {
	$error_message = $response->get_error_message();
	wp_die('Error: ' . esc_html($error_message));
	} else {
	$body = wp_remote_retrieve_body($response);
	$json = json_decode($body, true);

	// Process the $json response as needed
	}

		$x = $json['licencekey'];

		return $x;
}

function loycott_packageLic() {
	$loycott_license_options = get_option( 'loycott_license_option_name' , array()); // Array of All Options
	$license_key_0 = array_key_exists('license_key_0', $loycott_license_options) ? $loycott_license_options['license_key_0'] : '';
	$domain_0 = array_key_exists('domain_0', $loycott_license_options) ? $loycott_license_options['domain_0'] : '';
	$email_0 = array_key_exists('email_0', $loycott_license_options) ? $loycott_license_options['email_0'] : '';

	$post = array(
		'key' => $license_key_0,
		'domain' => $domain_0,
		'email' => $email_0,
	);
	$json = array();
	$response = wp_remote_post(LOYCOTT_APIURL . 'licpck.php', array(
			'method' => 'POST',
			'body' => $post,
			'sslverify' => false, // Use with caution, consider using a valid SSL certificate in production
			));

			$json = array();
	if (is_wp_error($response)) {
	$error_message = $response->get_error_message();
	wp_die('Error: ' . esc_html($error_message));
	} else {
	$body = wp_remote_retrieve_body($response);
	$json = json_decode($body, true);

	// Process the $json response as needed
	}

	$x = $json['valid'];

	return $x;
}

function loycott_packageLicLit() {
		$loycott_license_options = get_option( 'loycott_license_option_name', array() ); // Array of All Options
		$license_key_0 = isset($loycott_license_options['license_key_0']) ? $loycott_license_options['license_key_0'] : '';
		$domain_0 = isset($loycott_license_options['domain_0']) ? $loycott_license_options['domain_0'] : '';
		$email_0 = isset($loycott_license_options['email_0']) ? $loycott_license_options['email_0'] : '';

	$post = array(
		'key' => $license_key_0,
		'domain' => $domain_0,
		'email' => $email_0,
	);
	$json = array();
	$response = wp_remote_post(LOYCOTT_APIURL . 'licpcklit.php', array(
			'method' => 'POST',
			'body' => $post,
			'sslverify' => false, // Use with caution, consider using a valid SSL certificate in production
			));

			$json = array();
	if (is_wp_error($response)) {
	$error_message = $response->get_error_message();
	wp_die('Error: ' . esc_html($error_message));
	} else {
	$body = wp_remote_retrieve_body($response);
	$json = json_decode($body, true);

	// Process the $json response as needed
	}

	$x = $json['lit'];

	return $x;
}
function loycott_getValidLic() {

	loycott_validateLic();
	
	$loycott_license_options = get_option( 'loycott_license_option_name', array() ); // Array of All Options
	$license_key_0 = isset($loycott_license_options['license_key_0']) ? $loycott_license_options['license_key_0'] : '';
	$domain_0 = isset($loycott_license_options['domain_0']) ? $loycott_license_options['domain_0'] : '';
	$email_0 = isset($loycott_license_options['email_0']) ? $loycott_license_options['email_0'] : '';
		
	$post = array(
		'key' => $license_key_0,
		'domain' => $domain_0,
		'email' => $email_0,
		);
		 $json = array();
	$response = wp_remote_post(LOYCOTT_APIURL . 'vllic.php', array(
			'method' => 'POST',
			'body' => $post,
			'sslverify' => false, // Use with caution, consider using a valid SSL certificate in production
			));

			$json = array();
	if (is_wp_error($response)) {
	$error_message = $response->get_error_message();
	wp_die('Error: ' . esc_html($error_message));
	} else {
	$body = wp_remote_retrieve_body($response);
	$json = json_decode($body, true);

	// Process the $json response as needed
	}
		
		$x = $json['valid'];

		return $x;
}

function loycott_getCompany() {

	$loycott_license_options = get_option( 'loycott_license_option_name', array() ); // Array of All Options
	$license_key_0 = isset($loycott_license_options['license_key_0']) ? $loycott_license_options['license_key_0'] : '';
	$domain_0 = isset($loycott_license_options['domain_0']) ? $loycott_license_options['domain_0'] : '';
	$email_0 = isset($loycott_license_options['email_0']) ? $loycott_license_options['email_0'] : '';

	$post = array(
		'key' => $license_key_0,
		'domain' => $domain_0,
		'email' => $email_0,
		);
		$json = array();
	$response = wp_remote_post(LOYCOTT_APIURL . 'getcompanyandstore.php', array(
			'method' => 'POST',
			'body' => $post,
			'sslverify' => false, // Use with caution, consider using a valid SSL certificate in production
			));

			$json = array();
	if (is_wp_error($response)) {
	$error_message = $response->get_error_message();
	wp_die('Error: ' . esc_html($error_message));
	} else {
	$body = wp_remote_retrieve_body($response);
	$json = json_decode($body, true);

	// Process the $json response as needed
	}

	if (!isset($json['company'])) {
		$x = '';
	} elseif ($json != null) {
			$x = $json['company'];
	} else {
		$x = '';
	}

		return $json;
}

function loycott_getStore( $cid_1 ) {

	$loycott_license_options = get_option( 'loycott_license_option_name', array() ); // Array of All Options
	$license_key_0 = isset($loycott_license_options['license_key_0']) ? $loycott_license_options['license_key_0'] : '';
	$domain_0 = isset($loycott_license_options['domain_0']) ? $loycott_license_options['domain_0'] : '';
	$email_0 = isset($loycott_license_options['email_0']) ? $loycott_license_options['email_0'] : '';
		
	$post = array(
		'key' => $license_key_0,
		'domain' => $domain_0,
		'email' => $email_0,
		'cid' => $cid_1,
		);
	   $json = array();
	$response = wp_remote_post(LOYCOTT_APIURL . 'getstore.php', array(
			'method' => 'POST',
			'body' => $post,
			'sslverify' => false, // Use with caution, consider using a valid SSL certificate in production
			));

			$json = array();
	if (is_wp_error($response)) {
	$error_message = $response->get_error_message();
	wp_die('Error: ' . esc_html($error_message));
	} else {
	$body = wp_remote_retrieve_body($response);
	$json = json_decode($body, true);

	// Process the $json response as needed
	}
		
		$x = $json['store'];

		return $x;
}

function loycott_getUser() {

	$loycott_license_options = get_option( 'loycott_license_option_name', array() ); // Array of All Options
	$license_key_0 = isset($loycott_license_options['license_key_0']) ? $loycott_license_options['license_key_0'] : '';
	$domain_0 = isset($loycott_license_options['domain_0']) ? $loycott_license_options['domain_0'] : '';
	$email_0 = isset($loycott_license_options['email_0']) ? $loycott_license_options['email_0'] : '';

	$loycott_settings_options = get_option( 'loycott_settings_option_name', array() ); // Array of All Options
	$booms_username_0 = isset($loycott_settings_options['booms_username_0']) ? $loycott_settings_options['booms_username_0'] : ''; // Booms Username
	$booms_password_1 = isset($loycott_settings_options['booms_password_1']) ? $loycott_settings_options['booms_password_1'] : ''; // Booms Password
		
	$post = array(
		'key' => $license_key_0,
		'domain' => $domain_0,
		'email' => $email_0,
		'username' => $booms_username_0,
		);
		$json = array();
	$response = wp_remote_post(LOYCOTT_APIURL . 'getuser.php', array(
			'method' => 'POST',
			'body' => $post,
			'sslverify' => false, // Use with caution, consider using a valid SSL certificate in production
			));

			$json = array();
	if (is_wp_error($response)) {
	$error_message = $response->get_error_message();
	wp_die('Error: ' . esc_html($error_message));
	} else {
	$body = wp_remote_retrieve_body($response);
	$json = json_decode($body, true);

	// Process the $json response as needed
	}
		
		$x = $json['user'];

		return $x;
}

function loycott_litValidLic() {
	$licType = loycott_packageLicLit();

	$lic = loycott_getValidLic();
	$class = '';
	$lit = '';

	if ($lic=='0') {
		$class='notvalid';
		$lit = esc_html__('Your API Key is not valid', 'loycott-loyalty');
	} else {
				$class='valid';

		/* translators: %s: License type */
		/* translators: %s: License type */
		$lit = sprintf(esc_html__('Your API Key is valid (%s)', 'loycott-loyalty'), $licType);
	}

	//$class = "notvalid";
	ob_start();
	?>
		<div class="license-wrap-checker <?php echo esc_html($class); ?>">
			<?php echo esc_html($lit); ?>
			<?php if ($class == 'notvalid') : ?>
				<a class="button button-light complete-license" href="<?php echo esc_url(admin_url('admin.php?page=loycott-plugin-settings&tab=license')); ?>"><?php esc_html_e('Complete your API Key', 'loycott-loyalty'); ?></a>
				<?php endif; ?>
		</div>
	<?php

	return ob_get_clean();
}




function loycott_fillCountries() {
	$post = array(
		'key' => '0000',
		'domain' => '000',
		'email' => '000',
	);
	$json = array();
	$response = wp_remote_post(LOYCOTT_APIURL . 'ecountrycodes.php', array(
			'method' => 'POST',
			'body' => $post,
			'sslverify' => false, // Use with caution, consider using a valid SSL certificate in production
			));

			$json = array();
	if (is_wp_error($response)) {
	$error_message = $response->get_error_message();
	wp_die('Error: ' . esc_html($error_message));
	} else {
	$body = wp_remote_retrieve_body($response);
	$json = json_decode($body, true);

	// Process the $json response as needed
	}

	$x = $json['countries'];

   //var_dump($x);

	return $x;
}





function loycott_getCompanyMembers( $searchTerm ) {


	$token = loycott_authorization();

	$loycott_license_options = get_option( 'loycott_license_option_name', array() ); // Array of All Options
	$license_key_0 = isset($loycott_license_options['license_key_0']) ? $loycott_license_options['license_key_0'] : '';
	$domain_0 = isset($loycott_license_options['domain_0']) ? $loycott_license_options['domain_0'] : '';
	$email_0 = isset($loycott_license_options['email_0']) ? $loycott_license_options['email_0'] : '';

	$post = array(
		'token' => $token,
		'search' => $searchTerm,
		'key' => $license_key_0,
		'domain' => $domain_0,
		'licenseemail' => $email_0,
		);
		$json = array();
	$response = wp_remote_post(LOYCOTT_APIURL . 'customerlist.php', array(
			'method' => 'POST',
			'body' => $post,
			'sslverify' => false, // Use with caution, consider using a valid SSL certificate in production
			));

			$json = array();
	if (is_wp_error($response)) {
	$error_message = $response->get_error_message();
	wp_die('Error: ' . esc_html($error_message));
	} else {
	$body = wp_remote_retrieve_body($response);
	$json = json_decode($body, true);

	// Process the $json response as needed
	}


	if (!isset($json['customers'])) {
		$x = '';
	} elseif ($json != null) {
			$x = $json['customers'];
	} else {
		$x = '';
	}

		
		return $x;
}


function loycott_getCompanyTransactions( $searchPhone, $type ) {

	$loycott_license_options = get_option( 'loycott_license_option_name' ); // Array of All Options
	$license_key_0 = $loycott_license_options['license_key_0'];
	$domain_0 = $loycott_license_options['domain_0'];
	$email_0 = $loycott_license_options['email_0'];


	$token = loycott_authorization();

	$post = array(
		'token' => $token,
		'transactiontype' => $type,
		'phone' => $searchPhone,
		'key' => $license_key_0,
		'domain' => $domain_0,
		'licenseemail' => $email_0,
		);
	   $json = array();
	  // echo json_encode($post);
	$response = wp_remote_post(LOYCOTT_APIURL . 'ectransactions.php', array(
			'method' => 'POST',
			'body' => $post,
			'sslverify' => false, // Use with caution, consider using a valid SSL certificate in production
			));

			$json = array();
	if (is_wp_error($response)) {
	$error_message = $response->get_error_message();
	wp_die('Error: ' . esc_html($error_message));
	} else {
	$body = wp_remote_retrieve_body($response);
	$json = json_decode($body, true);

	// Process the $json response as needed
	}


	if (!isset($json['transactions'])) {
		$x = '';
	} elseif ($json != null) {
			$x = $json['transactions'];
	} else {
		$x = '';
	}

		
		return $x;
}


add_action('woocommerce_thankyou', 'loycott_clearData', 10, 1);

add_action('woocommerce_thankyou', 'loycott_show_Loyalty');

function loycott_clearData( $order_id ) {
	WC()->session->set( 'loycott_loyalty_option_choice', null);
}

function loycott_show_Loyalty( $order_id ) {
	$redemption_label = __('With your order you redeemed', 'loycott-loyalty');
	$thepoints_label = __('points' , 'loycott-loyalty');
	$win_label = __('and won ', 'loycott-loyalty');

	$oo = wc_get_order( $order_id );
	
	$condition = get_post_meta( $order_id, 'condition', true ) ;
	
	$lcarr = explode('|' , $condition);

	if (isset( $lcarr[1])) {
		$lcond = $lcarr[1];
	}
	if (isset($lcarr[3])) {
		if ($lcarr[3]!=0) {
			echo '<p class="pthanks">' . esc_html($redemption_label) . ' <strong> ' . esc_html($lcarr[0]) . esc_html($thepoints_label) . ' </strong> ' . esc_html($win_label) . ' <strong>' . esc_html($lcarr[1]) . '</strong>! </p>';
		}
	}
}
add_filter( 'woocommerce_email_order_meta_fields', 'loycott_woocommerce_email_order_meta_fields_func', 10, 3 );
function loycott_woocommerce_email_order_meta_fields_func( $fields, $sent_to_admin, $order ) {

	$redemption_label = __('With your order you redeemed', 'loycott-loyalty');
	$thepoints_label = __('points' , 'loycott-loyalty');
	$win_label = __('and won', 'loycott-loyalty');

	$order_id = $order->get_id();
	
	$condition = get_post_meta( $order_id, 'condition', true ) ;
	
	$lcarr = explode('|' , $condition);

	$lcond = $lcarr[1];

	
	$fields['delivery_instructions'] = array(
		'label' => esc_html__( 'Delivery date', 'loycott-loyalty' ),
		'value' => '<p class="pthanks">' . $redemption_label . ' <strong> ' . $lcarr[0] . ' ' . $thepoints_label . ' </strong> ' . $win_label . ' <strong>' . $lcarr[1] . '</strong>! </p>',
	);

	return $fields;
}

function loycott_getConditionsForCustomer( $maxpoints ) {
	
	$x = array();


	$token = loycott_authorization();

	$post = array(
		'token' => $token,
		'maxpoints' => $maxpoints,
	);
	 $json = array();
	$response = wp_remote_post(LOYCOTT_APIURL . 'companyloyaltyforcustomer.php', array(
			'method' => 'POST',
			'body' => $post,
			'sslverify' => false, // Use with caution, consider using a valid SSL certificate in production
			));

			$json = array();
	if (is_wp_error($response)) {
	$error_message = $response->get_error_message();
	wp_die('Error: ' . esc_html($error_message));
	} else {
	$body = wp_remote_retrieve_body($response);
	$json = json_decode($body, true);

	// Process the $json response as needed
	}

	if (!isset($json)) {
		$x = array();
	} elseif ($json != null) {
			$x = $json;
	} else {
		$x = '';
	}

		
		return $x;
}



function loycott_memberDetails( $phone ) {
	$x = array();

		
	$token = loycott_authorization();

	$post = array(
		'token' => $token,
		'phone' => $phone,
	);
	 $json = array();
	$response = wp_remote_post(LOYCOTT_APIURL . 'userdetails.php', array(
			'method' => 'POST',
			'body' => $post,
			'sslverify' => false, // Use with caution, consider using a valid SSL certificate in production
			));

			$json = array();
	if (is_wp_error($response)) {
	$error_message = $response->get_error_message();
	wp_die('Error: ' . esc_html($error_message));
	} else {
	$body = wp_remote_retrieve_body($response);
	$json = json_decode($body, true);

	// Process the $json response as needed
	}

	if (!isset($json)) {
		$x = array();
	} elseif ($json != null) {
			$x = $json;
	} else {
		$x = array();
	}

		return $x;
}

add_action('wp_ajax_updatemember', 'loycott_updatemember');
add_action('wp_ajax_nopriv_updatemember', 'loycott_updatemember');
function loycott_updatemember() {
	// Verify nonce
	if (!isset($_POST['loycott_ajax_nonce']) || !wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['loycott_ajax_nonce'])), 'loycott_ajax_nonce')) {
		wp_send_json_error('Security check failed');
		wp_die();
	}
	
	$x = '';

	$email = isset($_POST['dataForPHP'][0]) ? sanitize_text_field(wp_unslash($_POST['dataForPHP'][0])) : '';
	$phone = isset($_POST['dataForPHP'][1]) ? sanitize_text_field(wp_unslash($_POST['dataForPHP'][1])) : '';

		
	$token = loycott_authorization();

	$post = array(
		'phone' => $phone,
		'email' => $email,
		'token' => $token,
	);
	 $json = array();
	$response = wp_remote_post(LOYCOTT_APIURL . 'updatecustomermobile.php', array(
			'method' => 'POST',
			'body' => $post,
			'sslverify' => false, // Use with caution, consider using a valid SSL certificate in production
			));

			$json = array();
	if (is_wp_error($response)) {
	$error_message = $response->get_error_message();
	wp_die('Error: ' . esc_html($error_message));
	} else {
	$body = wp_remote_retrieve_body($response);
	$json = json_decode($body, true);

	// Process the $json response as needed
	}
}

function loycott_promotext() {
	$post = array();
	 $json = array();
	$response = wp_remote_post(LOYCOTT_APIURL . 'promotext.php', array(
			'method' => 'POST',
			'body' => $post,
			'sslverify' => false, // Use with caution, consider using a valid SSL certificate in production
			));

			$json = array();
	if (is_wp_error($response)) {
	$error_message = $response->get_error_message();
	wp_die('Error: ' . esc_html($error_message));
	} else {
	$body = wp_remote_retrieve_body($response);
	$json = json_decode($body, true);

	// Process the $json response as needed
	}

	$x = $json['promotext'];

	return $x;
}


function loycott_list_all_conditions() {

	?>
	<table width="100%" id="conditionstbl" >
			<thead>
				<tr>
					<th>ID</th>
					<th>Title</th>
					<th>Redemption Type</th>
					<th>Value</th>
					<th>Amount</th>
					<th>&nbsp;</th>
				</tr>
			</thead>
			<tbody>
				<?php $i = 1; ?>
				<?php 
				if (is_array(loycott_getLoyaltyConditionsForCompany()) || is_object(loycott_getLoyaltyConditionsForCompany())) {

					?>
					<?php foreach (loycott_getLoyaltyConditionsForCompany() as $row) : ?>
						<tr>
							<td><?php echo esc_html($i); ?></td>
							<td><?php echo esc_html($row['cctitle']); ?></td>
							<td>
							<?php 
							if (esc_html($row['redemption_type'])=='1') {
echo esc_html__('Percentage', 'loycott-loyalty');
							} elseif ($row['redemption_type']=='2') {
								echo esc_html__('Fixed Amount', 'loycott-loyalty');
							} elseif (esc_html($row['redemption_type'])=='3') {
								echo esc_html__('Other Offer', 'loycott-loyalty'); } 
							?>
							</td>
							<td><?php echo esc_html($row['redemption_value']); ?></td>
							<td><?php echo esc_html($row['points']); ?></td>
							<td>
									<a  class="button button-danger loycott-delete-condition" name="delc<?php echo esc_html($row['ccid']); ?>" id="delc<?php echo esc_html($row['ccid']); ?>" c-id="<?php echo esc_html($row['ccid']); ?>"><?php esc_html_e('Delete', 'loycott-loyalty'); ?></a>
								
							</td>
						</tr>
						<?php $i++; ?>
					<?php endforeach; ?>
				<?php } ?>
			</tbody>
		</table>
	<?php
}




function loycott_countries_list() {
	$json_string = '{"AF":"+93","AX":"+358","AL":"+355","DZ":"+213","AS":"+1684","AD":"+376","AO":"+244","AI":"+1264","AQ":"+672","AG":"+1268","AR":"+54","AM":"+374","AW":"+297","AU":"+61","AT":"+43","AZ":"+994","BS":"+1242","BH":"+973","BD":"+880","BB":"+1246","BY":"+375","BE":"+32","BZ":"+501","BJ":"+229","BM":"+1441","BT":"+975","BO":"+591","BA":"+387","BW":"+267","BR":"+55","IO":"+246","BN":"+673","BG":"+359","BF":"+226","BI":"+257","KH":"+855","CM":"+237","CA":"+1","CV":"+238","KY":"+ 345","CF":"+236","TD":"+235","CL":"+56","CN":"+86","CX":"+61","CC":"+61","CO":"+57","KM":"+269","CG":"+242","CD":"+243","CK":"+682","CR":"+506","CI":"+225","HR":"+385","CU":"+53","CY":"+357","CZ":"+420","DK":"+45","DJ":"+253","DM":"+1767","DO":"+1849","EC":"+593","EG":"+20","SV":"+503","GQ":"+240","ER":"+291","EE":"+372","ET":"+251","FK":"+500","FO":"+298","FJ":"+679","FI":"+358","FR":"+33","GF":"+594","PF":"+689","GA":"+241","GM":"+220","GE":"+995","DE":"+49","GH":"+233","GI":"+350","GR":"+30","GL":"+299","GD":"+1473","GP":"+590","GU":"+1671","GT":"+502","GG":"+44","GN":"+224","GW":"+245","GY":"+595","HT":"+509","VA":"+379","HN":"+504","HK":"+852","HU":"+36","IS":"+354","IN":"+91","ID":"+62","IR":"+98","IQ":"+964","IE":"+353","IM":"+44","IL":"+972","IT":"+39","JM":"+1876","JP":"+81","JE":"+44","JO":"+962","KZ":"+77","KE":"+254","KI":"+686","KP":"+850","KR":"+82","KW":"+965","KG":"+996","LA":"+856","LV":"+371","LB":"+961","LS":"+266","LR":"+231","LY":"+218","LI":"+423","LT":"+370","LU":"+352","MO":"+853","MK":"+389","MG":"+261","MW":"+265","MY":"+60","MV":"+960","ML":"+223","MT":"+356","MH":"+692","MQ":"+596","MR":"+222","MU":"+230","YT":"+262","MX":"+52","FM":"+691","MD":"+373","MC":"+377","MN":"+976","ME":"+382","MS":"+1664","MA":"+212","MZ":"+258","MM":"+95","NA":"+264","NR":"+674","NP":"+977","NL":"+31","AN":"+599","NC":"+687","NZ":"+64","NI":"+505","NE":"+227","NG":"+234","NU":"+683","NF":"+672","MP":"+1670","NO":"+47","OM":"+968","PK":"+92","PW":"+680","PS":"+970","PA":"+507","PG":"+675","PY":"+595","PE":"+51","PH":"+63","PN":"+872","PL":"+48","PT":"+351","PR":"+1939","QA":"+974","RO":"+40","RU":"+7","RW":"+250","RE":"+262","BL":"+590","SH":"+290","KN":"+1869","LC":"+1758","MF":"+590","PM":"+508","VC":"+1784","WS":"+685","SM":"+378","ST":"+239","SA":"+966","SN":"+221","RS":"+381","SC":"+248","SL":"+232","SG":"+65","SK":"+421","SI":"+386","SB":"+677","SO":"+252","ZA":"+27","SS":"+211","GS":"+500","ES":"+34","LK":"+94","SD":"+249","SR":"+597","SJ":"+47","SZ":"+268","SE":"+46","CH":"+41","SY":"+963","TW":"+886","TJ":"+992","TZ":"+255","TH":"+66","TL":"+670","TG":"+228","TK":"+690","TO":"+676","TT":"+1868","TN":"+216","TR":"+90","TM":"+993","TC":"+1649","TV":"+688","UG":"+256","UA":"+380","AE":"+971","GB":"+44","US":"+1","UY":"+598","UZ":"+998","VU":"+678","VE":"+58","VN":"+84","VG":"+1284","VI":"+1340","WF":"+681","YE":"+967","ZM":"+260","ZW":"+263"}';
	$json_decoded = json_decode($json_string, true);
	return $json_decoded;
}

function loycott_mapping_countrycodes( $country_code ) {
	$json_file_path = plugin_dir_path(__FILE__) . 'data/country-codes.json';
	$json_string = file_get_contents($json_file_path);
	$json_decoded = json_decode($json_string, true);

$code_found = false;
$code_to_return = '';
	foreach ($json_decoded['countries'] as $country ) {
		if ($country['country'] == $country_code) {

	$code_to_return = $country['code'];
	break;
		}
	}

return $code_to_return;
}


//add_action("wp_footer", "loycott_mapping_countrycodes");
function loycott_admin_settings_scripts() {
	// Check if we're on the specific admin page.
	$screen = get_current_screen();

	// Replace 'your-plugin-slug' with your actual plugin page slug.
	if ( isset( $screen->id ) && $screen->id === 'toplevel_page_loycott-plugin-settings' ) {
		// Register the script.
		wp_register_script(
			'loycott-admin-settings-js', // Handle
			plugin_dir_url( __FILE__ ) . 'js/loycott-admin-settings.js', // Script URL
			array( 'jquery' ), // Dependencies
			'1.0.0', // Version
			true // Load in footer
		);

		// Enqueue the script.
		wp_enqueue_script( 'loycott-admin-settings-js' );

		// Optionally, localize the script to pass data from PHP to JS.
		wp_localize_script( 'loycott-admin-settings-js', 'loycottadminjs', array(
			'ajaxUrl' => admin_url( 'admin-ajax.php' ),
			'nonce'   => wp_create_nonce( 'loycott_ajax_nonce' ),
			'savedAttachment' => get_option( 'loycott_media_selector_attachment_id', 0 ),
		));
	}
}
add_action( 'admin_enqueue_scripts', 'loycott_admin_settings_scripts' );

// Hook to trigger on plugin activation.
register_activation_hook(__FILE__, 'loycott_plugin_activation');
function loycott_plugin_activation() {
	// Set an option to trigger the opt-in notice.
	add_option('loycott_show_optin', true);
}

// Hook to show the opt-in popup in the admin area.
add_action('admin_notices', 'loycott_optin_notice');
function loycott_optin_notice() {
	if (!get_option('loycott_show_optin')) {
		return;
	}
	?>
	 <div id="loycott-optin-popup" style="display:none;">
		<div style="position:fixed; top:0; left:0; width:100%; height:100%; background:rgba(0,0,0,0.5); z-index:9999;">
			<div style="position:relative; top:50%; left:50%; transform:translate(-50%, -50%); background:white; padding:20px; border-radius:8px; text-align:center; max-width:400px;">
				<h2>Welcome to Loycott Plugin!</h2>
				<p>
					This plugin communicates with <strong>www.loyapps.com</strong> to enable registration on our platform. 
					During registration, your website URL will be sent to our servers.<br><br>
					Additionally, when an order is completed, the customer's <strong>first name</strong>, 
					<strong>last name</strong>, and <strong>phone number</strong> will be sent to <strong>www.loyapps.com</strong> 
					to assign loyalty points to the customer.<br><br>
					By opting in, you agree to these terms and data processing activities.
				</p>
				<button id="loycott-plugin-optin-accept" class="button button-primary">Opt-in</button>
				<button id="loycott-plugin-optin-decline" class="button">Decline & Deactivate</button>
			</div>
		</div>
	</div>
	<?php
}

// Enqueue the JavaScript file.
add_action('admin_enqueue_scripts', 'loycott_enqueue_optin_scripts');
function loycott_enqueue_optin_scripts( $hook_suffix ) {
	// Enqueue only on the admin dashboard pages.
	wp_enqueue_script(
		'loycott-optin-script',
		plugin_dir_url(__FILE__) . 'js/plugin-optin.js', // Path to the external JS file.
		array( 'jquery' ), // Dependencies (if any).
		'1.0', // Version.
		true   // Load in the footer.
	);

	// Pass the `ajaxurl` variable to the script.
	wp_localize_script('loycott-optin-script', 'loycottPluginAjax', array(
		'ajaxurl' => admin_url('admin-ajax.php'),
	));
}

// Handle the opt-in choice via AJAX.
add_action('wp_ajax_loycott_optin', 'loycott_optin_handle');
function loycott_optin_handle() {
	// Verify nonce
	if (!isset($_POST['loycott_ajax_nonce']) || !wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['loycott_ajax_nonce'])), 'loycott_ajax_nonce')) {
		wp_send_json_error('Security check failed');
		wp_die();
	}
	
	$optin = isset($_POST['optin']) ? (int) $_POST['optin'] : 0;

	if ($optin === 1) {
		// User opted in.
		update_option('loycott_show_optin', false);
		wp_send_json_success('Opt-in accepted.');
	} else {
		// User declined. Disable the plugin.
		deactivate_plugins(plugin_basename(__FILE__));
		delete_option('loycott_show_optin');
		wp_send_json_error('Opt-in declined. Plugin deactivated.');
	}
}
?>
