<?php
/**
 * LoyCart POS Modals Template
 *
 * This file contains the HTML for all modals used by the POS app.
 * It is included by the main loycart-pos.php file.
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}
?>

<!-- POS Settings Modal -->
<div id="pos-settings-modal" class="modal" role="dialog" aria-labelledby="pos-settings-title">
  <div class="modal-content" style="max-width: 620px;">
    <div class="modal-header">
      <h3 id="pos-settings-title"><?php esc_html_e('POS Settings', 'loycart-pos'); ?></h3>
      <button class="modal-close" aria-label="<?php esc_attr_e('Close modal', 'loycart-pos'); ?>">×</button>
    </div>
    <div class="modal-body">
      <!-- Tab Navigation -->
      <ul class="pos-settings-tabs" style="display:flex;gap:8px;margin-bottom:16px;list-style:none;padding:0;">
        <li class="tab-link active" data-tab="credit" style="cursor:pointer;padding:6px 16px;border-radius:6px 6px 0 0;background:var(--background-alt);border:1px solid var(--border);border-bottom:none;">Store Credit</li>
        <li class="tab-link" data-tab="receipt" style="cursor:pointer;padding:6px 16px;border-radius:6px 6px 0 0;background:var(--background-alt);border:1px solid var(--border);border-bottom:none;">Receipt</li>
        <li class="tab-link" data-tab="appearance" style="cursor:pointer;padding:6px 16px;border-radius:6px 6px 0 0;background:var(--background-alt);border:1px solid var(--border);border-bottom:none;">Appearance</li>
      </ul>
      <!-- Tab Content -->
      <div class="tab-content tab-credit" style="display:block;">
        <fieldset style="border:1px solid var(--border); border-radius:8px; padding:12px; margin-bottom: 16px;">
          <legend style="padding:0 6px; color: var(--text-muted); font-size: 12px; text-transform: uppercase; letter-spacing: .03em;">
            <?php esc_html_e('Store Credit (Coupons)', 'loycart-pos'); ?>
          </legend>
          <div class="modal-form-group">
            <label for="pos-setting-credit-enabled" style="display:flex; align-items:center; gap:8px;">
              <input type="checkbox" id="pos-setting-credit-enabled"> <?php esc_html_e('Enable Store Credit', 'loycart-pos'); ?>
            </label>
            <p class="help-text" style="margin:6px 0 0; color: var(--text-muted); font-size: 12px;"><?php esc_html_e('Award and manage store credit via WooCommerce fixed_cart coupons, restricted by customer email.', 'loycart-pos'); ?></p>
          </div>
          <div class="modal-form-group">
            <label for="pos-setting-earn-percent"><?php esc_html_e('Earn Rate (%)', 'loycart-pos'); ?></label>
            <input type="number" id="pos-setting-earn-percent" class="pos-input" step="0.1" min="0" placeholder="2">
          </div>
          <div class="modal-form-group">
            <label for="pos-setting-exc-earn" style="display:flex; align-items:center; gap:8px;">
              <input type="checkbox" id="pos-setting-exc-earn"> <?php esc_html_e('Exclude Sale Items (Earning)', 'loycart-pos'); ?>
            </label>
          </div>
          <div class="modal-form-group">
            <label for="pos-setting-exc-redeem" style="display:flex; align-items:center; gap:8px;">
              <input type="checkbox" id="pos-setting-exc-redeem"> <?php esc_html_e('Exclude Sale Items (Redeeming)', 'loycart-pos'); ?>
            </label>
            <p class="help-text" style="margin:6px 0 0; color: var(--text-muted); font-size: 12px;"><?php esc_html_e('When enabled, existing credit coupons are updated to disallow redeeming on sale items.', 'loycart-pos'); ?></p>
          </div>
        </fieldset>
      </div>
      <div class="tab-content tab-receipt" style="display:none;">
        <fieldset style="border:1px solid var(--border); border-radius:8px; padding:12px; margin-bottom: 16px;">
          <legend style="padding:0 6px; color: var(--text-muted); font-size: 12px; text-transform: uppercase; letter-spacing: .03em;">
            <?php esc_html_e('Receipt', 'loycart-pos'); ?>
          </legend>
          <div class="modal-form-group">
            <label for="pos-setting-paper-width"><?php esc_html_e( 'Receipt Paper Width', 'loycart-pos' ); ?></label>
            <select id="pos-setting-paper-width" class="pos-input">
              <option value="80mm">80mm (Receipt)</option>
              <option value="58mm">58mm (Receipt)</option>
              <option value="A4">A4 (Full Page)</option>
              <option value="Letter">US Letter (Full Page)</option>
            </select>
          </div>
          <div class="modal-form-group">
            <label for="pos-setting-store-name"><?php esc_html_e('Store Name (POS Receipt)', 'loycart-pos'); ?></label>
            <input type="text" id="pos-setting-store-name" class="pos-input" placeholder="">
          </div>
          <div class="modal-form-group">
            <p>Edit the Store Address in WooCommerce Settings - General.</p>
          </div>
          <div class="modal-form-group">
            <label for="pos-setting-store-phone"><?php esc_html_e('Store Phone (POS Receipt)', 'loycart-pos'); ?></label>
            <input type="text" id="pos-setting-store-phone" class="pos-input" placeholder="">
          </div>
          <div class="modal-form-group">
            <label for="pos-setting-receipt-footer"><?php esc_html_e('Receipt Footer Message', 'loycart-pos'); ?></label>
            <textarea id="pos-setting-receipt-footer" class="pos-input" rows="3" placeholder="<?php esc_attr_e('Thank you for your purchase!', 'loycart-pos'); ?>"></textarea>
          </div>
          <div class="modal-form-group" style="margin-top: 8px;">
    <label for="pos-setting-usb-direct-print" style="display:flex; align-items:center; gap:8px;">
        <input type="checkbox" id="pos-setting-usb-direct-print"> 
        <?php esc_html_e('Enable experimental USB direct printing (ESC/POS raw mode)', 'loycart-pos'); ?>
    </label>
    <p class="help-text" style="margin:6px 0 0; color: var(--text-muted); font-size: 12px;">
        <?php esc_html_e('When enabled, the receipt modal shows advanced USB controls to send raw print commands directly to compatible printers — primarily older thermal receipt printers using ESC/POS, but also some legacy dot-matrix, impact, or ribbon printers that accept raw data and no longer have usable modern drivers. Results vary widely depending on the printer model, browser, operating system, and USB permissions. Modern printers and non-ESC/POS devices usually work better with standard HTML/browser printing.', 'loycart-pos'); ?>
    </p>
</div>
        </fieldset>
      </div>
      <div class="tab-content tab-appearance" style="display:none;">
        <fieldset style="border:1px solid var(--border); border-radius:8px; padding:12px; margin-bottom: 16px;">
          <legend style="padding:0 6px; color: var(--text-muted); font-size: 12px; text-transform: uppercase; letter-spacing: .03em;">
            <?php esc_html_e('Appearance & Visibility', 'loycart-pos'); ?>
          </legend>
          <div class="modal-form-group">
            <label for="pos-setting-products-per-page"><?php esc_html_e('Products Per Page', 'loycart-pos'); ?></label>
            <input type="number" id="pos-setting-products-per-page" class="pos-input" min="1" max="200" step="1" value="24" placeholder="24">
            <p class="help-text" style="margin:6px 0 0; color: var(--text-muted); font-size: 12px;">
              <?php esc_html_e('Number of products to show per page in the POS grid (default: 24).', 'loycart-pos'); ?>
            </p>
          </div>
          <div class="modal-form-group">
            <label for="pos-setting-default-sort"><?php esc_html_e('Default Sort By', 'loycart-pos'); ?></label>
            <select id="pos-setting-default-sort" class="pos-input">
              <option value="popular"><?php esc_html_e('Popular', 'loycart-pos'); ?></option>
              <option value="name_asc"><?php esc_html_e('Name (A-Z)', 'loycart-pos'); ?></option>
              <option value="name_desc"><?php esc_html_e('Name (Z-A)', 'loycart-pos'); ?></option>
              <option value="price_asc"><?php esc_html_e('Price (Low-High)', 'loycart-pos'); ?></option>
              <option value="price_desc"><?php esc_html_e('Price (High-Low)', 'loycart-pos'); ?></option>
              <option value="sale"><?php esc_html_e('On Sale', 'loycart-pos'); ?></option>
              <option value="newest"><?php esc_html_e('Newest', 'loycart-pos'); ?></option>
            </select>
            <p class="help-text" style="margin:6px 0 0; color: var(--text-muted); font-size: 12px;">
              <?php esc_html_e('Default sorting for the POS product grid.', 'loycart-pos'); ?>
            </p>
          </div>
           <div class="modal-form-group">
            <label for="pos-setting-default-theme"><?php esc_html_e('Default Theme', 'loycart-pos'); ?></label>
            <select id="pos-setting-default-theme" class="pos-input">
              <option value="light"><?php esc_html_e('Light', 'loycart-pos'); ?></option>
              <option value="dark"><?php esc_html_e('Dark', 'loycart-pos'); ?></option>
            </select>
          </div>
          <div class="modal-form-group">
            <label for="pos-setting-show-theme-toggle" style="display:flex; align-items:center; gap:8px;">
              <input type="checkbox" id="pos-setting-show-theme-toggle"> <?php esc_html_e('Show Theme Toggle', 'loycart-pos'); ?>
            </label>
          </div>
          <div class="modal-form-group">
            <label for="pos-setting-show-notifications" style="display:flex; align-items:center; gap:8px;">
              <input type="checkbox" id="pos-setting-show-notifications"> <?php esc_html_e('Show Notifications', 'loycart-pos'); ?>
            </label>
            <p class="help-text" style="margin:6px 0 0; color: var(--text-muted); font-size: 12px;">
              <?php esc_html_e('Show notification messages in the POS header (default: hidden).', 'loycart-pos'); ?>
            </p>
          </div>
            <div class="modal-form-group">
              <label for="pos-setting-auto-redirect-pos" style="display:flex; align-items:center; gap:8px;">
                <input type="checkbox" id="pos-setting-auto-redirect-pos"> <?php esc_html_e('Auto-redirect to POS after login', 'loycart-pos'); ?>
              </label>
              <p class="help-text" style="margin:6px 0 0; color: var(--text-muted); font-size: 12px;">
                <?php esc_html_e('When enabled, admin users with WooCommerce access will be redirected to the POS page immediately after logging in. Disable to revert to normal login flow.', 'loycart-pos'); ?>
              </p>
            </div>
        </fieldset>
      </div>
      <script>
        (function($){
          $(document).on('click', '.pos-settings-tabs .tab-link', function(){
            var tab = $(this).data('tab');
            $('.pos-settings-tabs .tab-link').removeClass('active');
            $(this).addClass('active');
            $('.tab-content').hide();
            $('.tab-' + tab).show();
          });
        })(jQuery);
      </script>
    </div>
    <div class="modal-footer" style="display:flex;justify-content:space-between;align-items:center;gap:16px;padding:20px 24px 24px 24px;flex-wrap:wrap;min-height:72px;">
      <button type="button" class="button modal-close" style="flex:1 1 120px;max-width:180px;">Close</button>
      <button type="button" id="pos-settings-save" class="button button-primary" style="flex:1 1 160px;max-width:220px;">Save Settings</button>
    </div>
  </div>
</div>
<!-- end POS Settings Modal -->




<div id="refund-order-lookup-modal" class="modal" role="dialog" aria-labelledby="refund-modal-title">
  <div class="modal-content">
    <div class="modal-header">
      <h3 id="refund-modal-title"><?php esc_html_e( 'Find Original Order for Refund', 'loycart-pos' ); ?></h3>
      <button class="modal-close" aria-label="<?php esc_attr_e( 'Close modal', 'loycart-pos' ); ?>">×</button>
    </div>
    <div class="modal-body">

      <div id="manual-order-lookup-section" class="modal-form-group">
        <label for="manual-order-id-input"><?php esc_html_e( 'Enter Order ID Manually (from receipt)', 'loycart-pos' ); ?></label>
        <div style="display: flex; gap: 10px;">
          <input type="number" id="manual-order-id-input" class="pos-input" placeholder="<?php esc_attr_e( 'e.g., 12345', 'loycart-pos' ); ?>">
          <button id="process-manual-order-id" class="button button-secondary"><?php esc_html_e( 'Use ID', 'loycart-pos' ); ?></button>
        </div>
      </div>


      <div id="customer-order-history-container" style="display: none;">
        <h4><?php esc_html_e( 'Recent Orders for this Customer', 'loycart-pos' ); ?></h4>
        <div class="refund-filters-container">
          <div class="search-wrapper filter-control">
            <label for="refund-order-search"><?php esc_html_e( 'Search Order', 'loycart-pos' ); ?></label>
            <input type="search" id="refund-order-search" class="pos-input" placeholder="<?php esc_attr_e( 'Search by Order # or Name', 'loycart-pos' ); ?>" autocomplete="off">
          </div>
          <div class="filter-control">
            <label for="refund-status-select"><?php esc_html_e( 'Refund Status', 'loycart-pos' ); ?></label>
            <select id="refund-status-select" class="pos-input">
              <option value="all"><?php esc_html_e( 'All Orders', 'loycart-pos' ); ?></option>
              <option value="not_refunded" selected><?php esc_html_e( 'Not Refunded', 'loycart-pos' ); ?></option>
              <option value="partially_refunded"><?php esc_html_e( 'Partial Refund', 'loycart-pos' ); ?></option>
              <option value="fully_refunded"><?php esc_html_e( 'Fully Refunded', 'loycart-pos' ); ?></option>
            </select>
          </div>
          <div class="filter-control">
            <label for="refund-date-filter"><?php esc_html_e( 'Date Filter', 'loycart-pos' ); ?></label>
            <input type="date" id="refund-date-filter" class="pos-input" aria-label="<?php esc_attr_e( 'Filter by date', 'loycart-pos' ); ?>">
          </div>
        </div>
        <div id="customer-order-history-wrapper">
          <div id="customer-order-history-list">
            
          </div>
        </div>    
        <div id="refund-order-pagination" class="pagination-controls" style="padding: 10px 0; border-top: 1px solid var(--border);">
          <div class="pagination-info" style="font-size: 13px;">
            <?php esc_html_e( 'Page', 'loycart-pos' ); ?> <span id="refund-current-page">1</span> <?php esc_html_e( 'of', 'loycart-pos' ); ?> <span id="refund-total-pages">1</span>
          </div>
          <div class="pagination-buttons">
            <button id="refund-prev-page" class="page-button" disabled>
              <span class="dashicons dashicons-arrow-left-alt2"></span>
            </button>
            <button id="refund-next-page" class="page-button" disabled>
              <span class="dashicons dashicons-arrow-right-alt2"></span>
            </button>
          </div>
        </div>

      </div>
    </div>
  </div>
</div>




<div id="refund-reason-modal" class="modal" role="dialog" aria-labelledby="refund-reason-title">
  <div class="modal-content" style="max-width: 450px;">
    <div class="modal-header">
      <h3 id="refund-reason-title"><?php esc_html_e( 'Reason for Refund', 'loycart-pos' ); ?></h3>
      <button class="modal-close" aria-label="<?php esc_attr_e( 'Close modal', 'loycart-pos' ); ?>">×</button>
    </div>
    <div class="modal-body">
      <p><?php esc_html_e( 'Please provide a reason for this refund. This will be added to the order notes.', 'loycart-pos' ); ?></p>
      <div class="modal-form-group">
        <label for="refund-reason-textarea"><?php esc_html_e( 'Refund Reason (Required)', 'loycart-pos' ); ?></label>
        <textarea id="refund-reason-textarea" class="pos-input" rows="4" placeholder="<?php esc_attr_e( 'e.g., Item was damaged, wrong size...', 'loycart-pos' ); ?>"></textarea>
      </div>
    </div>
    <div class="modal-footer">
      <button id="submit-refund-with-reason" class="button button-primary">
        <?php esc_html_e( 'Process Refund', 'loycart-pos' ); ?>
      </button>
      <button class="modal-close button button-secondary">
        <?php esc_html_e( 'Cancel', 'loycart-pos' ); ?>
      </button>
    </div>
  </div>
</div>

<div id="refund-complete-modal" class="modal" role="dialog" aria-labelledby="refund-complete-title">
  <div class="modal-content" style="max-width: 400px;">
    <div class="modal-header">
      <h3 id="refund-complete-title"><?php esc_html_e( 'Refund Complete', 'loycart-pos' ); ?></h3>
    </div>
    <div class="modal-body" style="text-align: center;">
      <p style="font-size: 16px;"><?php esc_html_e( 'Return to Customer:', 'loycart-pos' ); ?></p>
      <div id="refund-amount-display" class="summary-value large-total" style="font-size: 2.5em; margin: 10px 0;">
      </div>
    </div>
    <div class="modal-footer">
      <button id="refund-print-receipt" class="button button-secondary">
        <?php esc_html_e( 'Print Refund Receipt', 'loycart-pos' ); ?>
      </button>
      <button id="refund-modal-done" class="button button-primary">
        <?php esc_html_e( 'Done / New Sale', 'loycart-pos' ); ?>
      </button>
    </div>
  </div>
</div>


<div id="shipping-confirm-modal" class="modal" role="dialog" aria-labelledby="shipping-confirm-title">
  <div class="modal-content" style="max-width: 450px;">
    <div class="modal-header">
      <h3 id="shipping-confirm-title"><?php esc_html_e( 'Does this order require shipping?', 'loycart-pos' ); ?></h3>
      <button class="modal-close" aria-label="<?php esc_attr_e( 'Close modal', 'loycart-pos' ); ?>">×</button>
    </div>
    <div class="modal-footer" style="justify-content: space-between;">
      <button id="confirm-no-shipping" class="addshipping-button">
        <?php esc_html_e( 'No Shipping ', 'loycart-pos' ); ?>
      </button>
      <div style="display: flex; gap: 10px;">
        <button id="confirm-add-shipping" class="addshipping-button">
          <?php esc_html_e( 'Add Shipping', 'loycart-pos' ); ?>
        </button>
      </div>
    </div>
  </div>
</div>


<div id="advanced-pending-payment-modal" class="modal" role="dialog" aria-labelledby="advanced-pending-title">
  <div class="modal-content">
    <div class="modal-header">
      <h3 id="advanced-pending-title"><?php esc_html_e( 'Pending Payment Options', 'loycart-pos' ); ?></h3>
      <button class="modal-close" aria-label="<?php esc_attr_e( 'Close modal', 'loycart-pos' ); ?>">×</button>
    </div>

    <div class="modal-body">
      <p id="advanced-pending-message" style="font-size: 14px; line-height: 1.6; text-align: center; margin-bottom: 20px;"></p>
      <div id="pending-payment-instructions" class="payment-instructions"></div>
      <div class="pending-options-grid">
        <button class="pos-button button-primary" data-action="complete">
          <strong><?php esc_html_e( 'Mark as \'Completed\'', 'loycart-pos' ); ?></strong>
          <small><?php esc_html_e( '(Trusted Customer - Goods Released)', 'loycart-pos' ); ?></small>
        </button>
        <button class="pos-button button-secondary" data-action="on-hold">
          <strong><?php esc_html_e( 'Place Order \'On Hold\'', 'loycart-pos' ); ?></strong>
          <small><?php esc_html_e( '(Awaiting Payment - Stock Reserved)', 'loycart-pos' ); ?></small>
        </button>
        <button class="pos-button button-secondary" data-action="hold-in-pos">
          <strong><?php esc_html_e( 'Hold in POS', 'loycart-pos' ); ?></strong>
          <small><?php esc_html_e( '(For Later - No Stock Reduction)', 'loycart-pos' ); ?></small>
        </button>
      </div>
    </div>
    <div class="modal-footer">
      <button class="modal-close button button-secondary"><?php esc_html_e( 'Cancel', 'loycart-pos' ); ?></button>
    </div>
  </div>
</div>




<div id="order-note-modal" class="modal" role="dialog" aria-labelledby="order-note-modal-title">
  <div class="modal-content">
    <div class="modal-header">
      <h3 id="order-note-modal-title"><?php esc_html_e( 'Add a Note to the Order', 'loycart-pos' ); ?></h3>
      <button class="modal-close" aria-label="<?php esc_attr_e( 'Close modal', 'loycart-pos' ); ?>">×</button>
    </div>
    <div class="modal-body">
      <div class="modal-form-group">
        <label for="order-note-textarea"><?php esc_html_e( 'This note will be added to the order details and is visible to store managers.', 'loycart-pos' ); ?></label>
        <textarea id="order-note-textarea" class="pos-input" rows="5" placeholder="<?php esc_attr_e( 'e.g., Customer request...', 'loycart-pos' ); ?>"></textarea>
      </div>
    </div>
    <div class="modal-footer">
      <button id="save-order-note" class="button button-primary"><?php esc_html_e( 'Save Note', 'loycart-pos' ); ?></button>
      <button class="modal-close button button-secondary"><?php esc_html_e( 'Cancel', 'loycart-pos' ); ?></button>
    </div>
  </div>
</div>


<div id="card-confirm-modal" class="modal" role="dialog" aria-labelledby="card-confirm-modal-title">
  <div class="modal-content">
    <div class="modal-header">
      <h3 id="card-confirm-modal-title"><?php esc_html_e( 'Card Payment Confirmation', 'loycart-pos' ); ?></h3>
      <button class="modal-close" aria-label="<?php esc_attr_e( 'Close modal', 'loycart-pos' ); ?>">×</button>
    </div>
    <div class="modal-body">
      <p><?php esc_html_e( 'Please enter the total amount into the card terminal:', 'loycart-pos' ); ?></p>
      <div class="payment-summary">
        <div class="summary-row">
          <span class="summary-label"></span>
          <span id="card-modal-final-total" class="summary-value large-total">
            <?php echo wp_kses( wc_price( 0 ), array( 'span' => array( 'class' => array() ) ) ); ?>
          </span>
        </div>
      </div>
      <p><?php esc_html_e( 'After the transaction is complete on the terminal, click "Confirm Payment".', 'loycart-pos' ); ?></p>
    </div>
    <div class="modal-footer">
      <button id="card-modal-confirm" class="button button-primary">
        <?php esc_html_e( 'Confirm Payment', 'loycart-pos' ); ?>
      </button>
      <button id="card-modal-cancel" class="button button-secondary">
        <?php esc_html_e( 'Cancel', 'loycart-pos' ); ?>
      </button>
    </div>
  </div>
</div>


<div id="hold-sale-modal" class="modal" role="dialog" aria-labelledby="hold-sale-modal-title">
  <div class="modal-content">
    <div class="modal-header">
      <h3 id="hold-sale-modal-title"><?php esc_html_e('Add a note for this held sale', 'loycart-pos'); ?></h3>
      <button id="hold-sale-cancel-btn" class="cart-remove-btn aria-label"<?php esc_attr_e( 'Close modal', 'loycart-pos' ); ?>">×</button>
    </div>
    <div class="modal-body">
      <div class="modal-form-group">
        <label for="hold-sale-note"><?php esc_attr_e('Enter note (optional)', 'loycart-pos'); ?></label>
        <textarea id="hold-sale-note" class="pos-input" rows="5"></textarea>
      </div>
    </div>
    <div class="modal-footer">
      <button id="hold-sale-cancel-btn" class="pos-button button-secondary"><?php esc_html_e('Cancel', 'loycart-pos'); ?></button>
      <button id="hold-sale-confirm-btn" class="pos-button button-primary"><?php esc_html_e('Confirm Hold', 'loycart-pos'); ?></button>
    </div>
  </div>
</div>



<div id="held-sales-modal" class="modal" role="dialog" aria-labelledby="held-sales-modal-title">
  <div class="modal-content">
    <div class="modal-header">
      <h3 id="held-sales-modal-title"><?php esc_html_e( 'Held Sales', 'loycart-pos' ); ?></h3>
      <button class="modal-close" aria-label="<?php esc_attr_e( 'Close modal', 'loycart-pos' ); ?>">×</button>
    </div>
    <div class="modal-body">
      <div class="modal-form-group">
        <input type="search" id="held-sales-search" class="pos-input" placeholder="<?php esc_attr_e( 'Search held sales by name, customer, etc...', 'loycart-pos' ); ?>" aria-label="<?php esc_attr_e( 'Search held sales', 'loycart-pos' ); ?>">
      </div>
      <div id="held-carts-list">
        <p class="empty-state-message"><?php esc_html_e( 'No sales currently on hold.', 'loycart-pos' ); ?></p>
      </div>
    </div>
    <div class="modal-footer">
      <button id="held-modal-close" class="button button-secondary">
        <?php esc_html_e( 'Close', 'loycart-pos' ); ?>
      </button>
    </div>
  </div>
</div>

<div id="discount-modal" class="modal" role="dialog" aria-labelledby="discount-modal-title">
  <div class="modal-content">
    <div class="modal-header">
      <h3 id="discount-modal-title"><?php esc_html_e( 'Cashier Item Discount', 'loycart-pos' ); ?></h3>
      <button class="modal-close" aria-label="<?php esc_attr_e( 'Close modal', 'loycart-pos' ); ?>">×</button>
    </div>
    <div class="product-options-header" id="product-options-header">
      <img id="discount-product-image" class="product-options-image" src="" alt="<?php esc_attr_e( 'Product image for discount', 'loycart-pos' ); ?>">
      <div class="product-options-details">
        <div class="product-options-name" id="discount-product-name">
          <?php esc_html_e( 'Product Name', 'loycart-pos' ); ?>
        </div>
        <span class="product-options-price" id="discount-product-price">
          <?php echo wp_kses( wc_price( 0 ), array( 'span' => array( 'class' => array() ) ) ); ?>
        </span>
      </div>
    </div>
    <div class="modal-body">
      <div class="discount-display">
        <div class="discount-value"><?php echo esc_html( get_woocommerce_currency_symbol() ); ?><span id="discount-value">0</span></div>
        <div class="discount-preview">
          <?php esc_html_e( 'New Price:', 'loycart-pos' ); ?>
          <span id="discount-preview-amount"><?php echo wp_kses( wc_price( 0 ), array( 'span' => array( 'class' => array() ) ) ); ?></span>
        </div>
      </div>
      <div class="discount-keypad">
        <button data-value="7">7</button>
        <button data-value="8">8</button>
        <button data-value="9">9</button>
        <button data-value="4">4</button>
        <button data-value="5">5</button>
        <button data-value="6">6</button>
        <button data-value="1">1</button>
        <button data-value="2">2</button>
        <button data-value="3">3</button>
        <button data-value="0">0</button>
        <button data-value=".">.</button>
        <button data-value="clear"><?php esc_html_e( 'C', 'loycart-pos' ); ?></button>
      </div>
      <div class="discount-actions">
        <button id="apply-discount" class="button button-primary">
          <?php esc_html_e( 'Apply Discount', 'loycart-pos' ); ?>
        </button>
        <button id="remove-discount" class="button button-secondary">
          <?php esc_html_e( 'Remove Discount', 'loycart-pos' ); ?>
        </button>
      </div>
    </div>
  </div>
</div>

<div id="receipt-modal" class="modal" role="dialog" aria-labelledby="receipt-modal-title">
  <div class="modal-content">
    <div class="modal-header">
      <h3 id="receipt-modal-title"><?php esc_html_e( 'Sale Completed', 'loycart-pos' ); ?></h3>
    </div>
    <div class="modal-body">

<div id="printer-control-area" style="display: none; background: #f9f9f9; padding: 10px; border-radius: 5px; margin-bottom: 15px; border: 1px solid #eee;">
    <button id="connect-usb-printer" class="pos-button" style="width: 100%; background: #444; color: white; display: flex; justify-content: center; align-items: center; gap: 8px;">
      <span class="dashicons dashicons-printer"></span>
      <?php esc_html_e( 'Connect USB Printer', 'loycart-pos' ); ?>
    </button><br/>
          <button id="print-usb-direct" class="addshipping-button" style="width: 100%; justify-content: center; display: flex; align-items: center;">
        <span class="dashicons dashicons-printer" style="margin-right: 8px;"></span>
        <?php esc_html_e( 'USB Direct 58mm', 'loycart-pos' ); ?>
      </button>
      </div>

      
    </div>
    <div class="modal-footer" style="display: flex; flex-direction: column; gap: 10px; width: 100%;">

      <div id="receipt-paper-width-indicator" style="align-self: flex-end; font-size: 12px; color: var(--text-muted);" title="<?php esc_attr_e('Receipt preview width', 'loycart-pos'); ?>">
        <?php esc_html_e( 'Paper:', 'loycart-pos' ); ?> <span>80mm</span>
      </div>


      <button id="print-receipt" class="addshipping-button" style="width: 100%; justify-content: center; display: flex; align-items: center;">
        <span class="dashicons dashicons-printer" style="margin-right: 8px;"></span>
        <span id="receipt-button-text"><?php esc_html_e( 'Print Receipt', 'loycart-pos' ); ?></span>
      </button>

       <button id="print-order-label-button" class="addshipping-button" style="display: none; width: 100%; justify-content: center; align-items: center;">
        <span class="dashicons dashicons-printer" style="margin-right: 8px;"></span>
        <span id="shipping-button-text"><?php esc_html_e( 'Print Order Label', 'loycart-pos' ); ?></span>
      </button>

      <button id="dismiss-receipt" class="addshipping-button" style="width: 100%; justify-content: center; display: flex; align-items: center; background-color: #28a745; color: white;">
        <span class="dashicons dashicons-cart" style="margin-right: 8px;"></span>
        <?php esc_html_e( 'New Sale', 'loycart-pos' ); ?>
      </button>
    </div>
  </div>
</div>

<div id="coupon-picker-modal" class="modal" role="dialog" aria-labelledby="coupon-modal-title">
  <div class="modal-content">
    <div class="modal-header">
      <h3 id="coupon-modal-title"><?php esc_html_e( 'Select Available Coupon', 'loycart-pos' ); ?></h3>
      <button class="modal-close" aria-label="<?php esc_attr_e( 'Close modal', 'loycart-pos' ); ?>">×</button>
    </div>
    <div class="modal-body">
      <p id="coupon-no-customer-notice" class="empty-state-message" style="display:none;">
        <?php esc_html_e( 'Add a customer to see available store credit.', 'loycart-pos' ); ?>
      </p>
      <div id="available-coupons-list" class="coupon-grid-list">
          </div>
      <div class="spinner-container" style="text-align:center; padding: 20px;">
          <span class="spinner"></span>
      </div>
    </div>
    <div class="modal-footer">
      <button class="modal-close button button-secondary"><?php esc_html_e( 'Cancel', 'loycart-pos' ); ?></button>
    </div>
  </div>
</div>


<div id="customer-modal" class="modal" role="dialog" aria-labelledby="customer-modal-title">
  <div class="modal-content">
    <div class="modal-header">
      <h3 id="customer-modal-title"><?php esc_html_e( 'Add Customer To Order', 'loycart-pos' ); ?></h3>
      <button class="modal-close" aria-label="<?php esc_attr_e( 'Close modal', 'loycart-pos' ); ?>">×</button>
    </div>
    <div class="modal-body">
      <div class="customer-modal-actions">
        <input type="text" id="modal-customer-search" class="pos-input" placeholder="<?php esc_attr_e( 'Search by Name, Email, or Phone...', 'loycart-pos' ); ?>" autocomplete="off">
      </div>
      <div id="modal-customer-results" role="listbox">
        <p class="empty-state-message"><?php esc_html_e( 'To add a customer to the order, use search to find a customer or create a new customer.', 'loycart-pos' ); ?></p>
      </div>
    </div>
    <div class="modal-footer">
      <button class="modal-close button button-secondary">
        <?php esc_html_e( 'Cancel', 'loycart-pos' ); ?>
      </button>
      <button id="create-new-customer-button" class="button button-primary">
        <?php esc_html_e( 'Create New Customer', 'loycart-pos' ); ?>
      </button>
    </div>
  </div>
</div>

<div id="barcode-scanner-modal" class="modal" role="dialog" aria-labelledby="barcode-scanner-title">
  <div class="modal-content" style="max-width: 600px; height: 500px;">

    <div class="modal-header">
      <h3 id="barcode-scanner-title"><?php esc_html_e( 'Scan Barcode with Camera', 'loycart-pos' ); ?></h3>
      <button class="modal-close" id="barcode-scanner-close" aria-label="<?php esc_attr_e( 'Close scanner', 'loycart-pos' ); ?>">×</button>
    </div>

    <div class="modal-body" style="padding: 0; display: flex; flex-direction: column; align-items: center; justify-content: center;">

      <div id="scanner-area" style="width: 100%; height: 100%; max-height: 350px; background: #000; overflow: hidden; position: relative;">
        <video id="scanner-video" autoplay="true" playsinline="true" muted="true" style="width: 100%; height: 100%; object-fit: cover;"></video>
        <div id="scanner-feedback" style="position: absolute; bottom: 0; left: 0; right: 0; padding: 10px; background: rgba(0,0,0,0.7); color: #fff; text-align: center; font-size: 14px;">
          <?php esc_html_e( 'Initializing camera...', 'loycart-pos' ); ?>
        </div>
      </div>

      <p id="scanner-instruction" style="padding: 15px; font-size: 14px; color: var(--text-muted);">
        <?php esc_html_e( 'Point your camera at the barcode. Scanning starts automatically.', 'loycart-pos' ); ?>
      </p>
    </div>
  </div>
</div>

<div id="add-new-product-modal" class="modal" role="dialog" aria-labelledby="add-new-product-modal-title">
  <div class="modal-content" style="max-width: 520px;">
    <div class="modal-header">
      <h3 id="add-new-product-modal-title"><?php esc_html_e( 'Add New Product', 'loycart-pos' ); ?></h3>
      <button class="modal-close" aria-label="<?php esc_attr_e( 'Close modal', 'loycart-pos' ); ?>">×</button>
    </div>
    <div class="modal-body">
      <div class="add-new-product-main">
        <div class="add-new-product-price-entry">
          <div class="modal-form-group">
            <label for="add-new-product-name"><?php esc_html_e( 'Item Name (Required)', 'loycart-pos' ); ?></label>
            <input type="text" id="add-new-product-name" class="pos-input" placeholder="<?php esc_attr_e( 'e.g., Bespoke product, fee or service', 'loycart-pos' ); ?>">
          </div>

          
            <div class="modal-form-group price-field-group">
              <label for="add-new-product-regular-price">
                <?php
                                printf(
                                    /* translators: %s: Currency symbol (e.g., £) */
                                    esc_html__( 'Price (%s) (Required)', 'loycart-pos' ), // Simplified label
                                    esc_html( get_woocommerce_currency_symbol() )
                                );
                                ?>
              </label>
              <input type="text" id="add-new-product-regular-price" class="pos-input wc_input_price">
            </div>
            <div class="modal-form-group price-field-group">
              <label for="add-new-product-sale-price">
                <?php
                                printf(
                                    /* translators: %s: Currency symbol (e.g., £) */
                                    esc_html__( 'Sale price (%s)', 'loycart-pos' ),
                                    esc_html( get_woocommerce_currency_symbol() )
                                );
                                ?>
                <a href="#" class="sale-price-schedule-link"><?php esc_html_e( 'Schedule', 'loycart-pos' ); ?></a></label>
              <div class="price-input-wrapper">
                <input type="text" id="add-new-product-sale-price" class="pos-input wc_input_price">
              </div>
            </div>
          </div>
          <div class="add-new-product-schedule-fields" style="display: none;">
            <div class="modal-form-group price-field-group">
              <label for="add-new-product-date-from"><?php esc_html_e( 'Sale start date', 'loycart-pos' ); ?></label>
              <input type="date" id="add-new-product-date-from" class="pos-input">
            </div>
            <div class="modal-form-group price-field-group">
              <label for="add-new-product-date-to"><?php esc_html_e( 'Sale end date', 'loycart-pos' ); ?></label>
              <input type="date" id="add-new-product-date-to" class="pos-input">
            </div>
          </div>

        <div class="modal-form-group">
          <label><?php esc_html_e( 'Product Image (Optional)', 'loycart-pos' ); ?></label>
          <div id="add-new-product-image-uploader" class="image-uploader-container">
            <div class="image-preview-wrapper">
              <img src="<?php echo esc_url( wc_placeholder_img_src('thumbnail') ); ?>" class="image-preview" alt="<?php esc_attr_e( 'Image preview', 'loycart-pos' ); ?>">
            </div>
            <input type="hidden" id="add-new-product-image-id">
            <div class="image-uploader-actions">
              <button type="button" id="add-new-product-upload-image" class="button"><?php esc_html_e( 'Set image', 'loycart-pos' ); ?></button>
              <button type="button" id="add-new-product-remove-image" class="button-link button-link-delete" style="display: none;"><?php esc_html_e( 'Remove image', 'loycart-pos' ); ?></button>
            </div>
          </div>
        </div>
        <button type="button" id="toggle-new-product-options" class="button button-secondary" style="width: 100%; margin-bottom: 15px;">
          <span class="dashicons dashicons-plus" style="vertical-align: text-top;"></span> <?php esc_html_e( 'More Options', 'loycart-pos' ); ?>
        </button>
        <div class="add-new-product-options-collapsible" style="display: none;">



          <div class="modal-form-group">
            <label for="add-new-product-barcode"><?php esc_html_e( 'Barcode (Scan or enter barcode)', 'loycart-pos' ); ?></label>
            <div style="display: flex; gap: 10px;">
              <input type="text" id="add-new-product-barcode" class="pos-input" placeholder="<?php esc_attr_e( 'Leave blank to auto-generate', 'loycart-pos' ); ?>">
              <button type="button" id="barcode-scan-button" class="button button-secondary" aria-label="<?php esc_attr_e( 'Scan barcode with device camera', 'loycart-pos' ); ?>" style="min-width: 44px; padding: 0;">
                <span class="dashicons dashicons-camera-alt" style="font-size: 20px;"></span>
              </button>
            </div>
          </div>
          
          
          <div class="modal-form-group">
            <label for="add-new-product-sku"><?php esc_html_e( 'SKU', 'loycart-pos' ); ?></label>
            <input type="text" id="add-new-product-sku" class="pos-input" placeholder="<?php esc_attr_e( 'Leave blank to auto-generate', 'loycart-pos' ); ?>">
          </div>
          

          <div class="modal-form-group">
            <label for="add-new-product-stock"><?php esc_html_e( 'Stock Quantity (Optional - Unlimited assumed if left blank)', 'loycart-pos' ); ?></label>
            <input type="number" id="add-new-product-stock" class="pos-input" placeholder="<?php esc_attr_e( 'Leave empty for unlimited', 'loycart-pos' ); ?>">
          </div>



          <div class="modal-form-group">
            <label for="add-new-product-description"><?php esc_html_e( 'Description (Optional)', 'loycart-pos' ); ?></label>
            <textarea id="add-new-product-description" class="pos-input" rows="4"></textarea>
          </div>


          <div class="modal-form-group">
            <label for="add-new-product-category"><?php esc_html_e( 'Category', 'loycart-pos' ); ?></label>
            <select id="add-new-product-category" class="pos-input">
              <option value=""><?php esc_html_e( 'Default (POS Custom Products)', 'loycart-pos' ); ?></option>
              <?php 
               if (isset($categories) && is_array($categories)) {
                foreach ( $categories as $loycart_category ) : ?>
              <option value="<?php echo esc_attr( $loycart_category->term_id ); ?>"><?php echo esc_html( $loycart_category->name ); ?></option>
              <?php endforeach; 
            }
        ?>
            </select>
          </div>
          <div id="add-new-product-tax-controls" style="display: none;">
            <div class="modal-form-group">
              <label for="add-new-product-tax-status"><?php esc_html_e( 'Tax Status', 'loycart-pos' ); ?></label>
              <select id="add-new-product-tax-status" class="pos-input"></select>
            </div>
            <div class="modal-form-group">
              <label for="add-new-product-tax-class"><?php esc_html_e( 'Tax Class', 'loycart-pos' ); ?></label>
              <select id="add-new-product-tax-class" class="pos-input"></select>
            </div>
          </div>
          
<div class="modal-form-group add-new-product-visibility">
    <label for="new_product_visibility"><?php esc_html_e( 'Visibility', 'loycart-pos' ); ?></label>
    <select id="new_product_visibility" name="new_product_visibility" class="pos-input">
        <option value="pos_only" selected><?php esc_html_e( 'POS Only', 'loycart-pos' ); ?></option>
        <option value="public"><?php esc_html_e( 'POS & Store', 'loycart-pos' ); ?></option>
        <option value="store_only"><?php esc_html_e( 'Store Only', 'loycart-pos' ); ?></option>
        <option value="hidden"><?php esc_html_e( 'Hidden from POS & Store', 'loycart-pos' ); ?></option>
    </select>
</div>
        </div>
      </div>
    </div>

    <div class="modal-footer" style="justify-content: space-between;">
      <button id="save-and-add-another" class="button button-secondary" style="flex-grow: 2;">
        <?php esc_html_e( 'Save & Add Another', 'loycart-pos' ); ?>
      </button>
      <button id="add-add-new-product-to-cart" class="button button-primary" style="flex-grow: 2;">
        <?php esc_html_e( 'Save & Add to Cart', 'loycart-pos' ); ?>
      </button>
      <button class="modal-close button button-secondary" style="flex-grow: 1;"><?php esc_html_e( 'Close', 'loycart-pos' ); ?></button>
    </div>
  </div>
</div>

<div id="shipping-modal" class="modal" role="dialog" aria-labelledby="shipping-modal-title">
  <div class="modal-content">
    <div class="modal-header">
      <h3 id="shipping-modal-title"><?php esc_html_e( 'Shipping Options', 'loycart-pos' ); ?></h3>
      <button class="modal-close" aria-label="<?php esc_attr_e( 'Close modal', 'loycart-pos' ); ?>">×</button>
    </div>
    <div class="modal-body">

      <form id="guest-shipping-form" style="display: none;">
        <p class="guest-form-intro"><?php esc_html_e( 'Enter a shipping address for the guest customer. All fields are required.', 'loycart-pos' ); ?></p>
        <div class="guest-address-fields">
          <div class="modal-form-group half-width">
            <label for="shipping_first_name"><?php esc_html_e( 'First Name', 'loycart-pos' ); ?></label>
            <input type="text" id="shipping_first_name" class="pos-input">
          </div>
          <div class="modal-form-group half-width">
            <label for="shipping_last_name"><?php esc_html_e( 'Last Name', 'loycart-pos' ); ?></label>
            <input type="text" id="shipping_last_name" class="pos-input">
          </div>
          <div class="modal-form-group half-width">
            <label for="shipping_email"><?php esc_html_e( 'Email', 'loycart-pos' ); ?></label>
            <input type="email" id="shipping_email" class="pos-input">
          </div>
          <div class="modal-form-group half-width">
            <label for="shipping_phone"><?php esc_html_e( 'Phone', 'loycart-pos' ); ?></label>
            <input type="tel" id="shipping_phone" class="pos-input">
          </div>
          <div class="modal-form-group">
            <label for="shipping_address_1"><?php esc_html_e( 'Address', 'loycart-pos' ); ?></label>
            <input type="text" id="shipping_address_1" class="pos-input">
          </div>
          <div class="modal-form-group">
            <label for="shipping_address_2"><?php esc_html_e( 'Address Line 2 (Optional)', 'loycart-pos' ); ?></label>
            <input type="text" id="shipping_address_2" class="pos-input">
          </div>
          <div class="modal-form-group half-width">
            <label for="shipping_city"><?php esc_html_e( 'City', 'loycart-pos' ); ?></label>
            <input type="text" id="shipping_city" class="pos-input">
          </div>
          <div class="modal-form-group half-width">
            <label for="shipping_postcode"><?php esc_html_e( 'Postcode / ZIP', 'loycart-pos' ); ?></label>
            <input type="text" id="shipping_postcode" class="pos-input">
          </div>
          <div class="modal-form-group half-width">
            <label for="shipping_country"><?php esc_html_e( 'Country', 'loycart-pos' ); ?></label>
            <select id="shipping_country" class="pos-input wc-enhanced-select">
              <?php
                                 $loycart_countries = new WC_Countries();
                                 $loycart_all_countries = $loycart_countries->get_shipping_countries();
                                 foreach ($loycart_all_countries as $loycart_code => $loycart_name) {
                                     echo '<option value="' . esc_attr($loycart_code) . '">' . esc_html($loycart_name) . '</option>';
                                 }
                             ?>
            </select>
          </div>
          <div class="modal-form-group half-width">
            <label for="shipping_state"><?php esc_html_e( 'State / County', 'loycart-pos' ); ?></label>
            <input type="text" id="shipping_state" class="pos-input">
          </div>
        </div>

        <div class="modal-form-group half-width">
          <label for="create_account_checkbox" class="create-account-label">
            <input type="checkbox" id="create_account_checkbox" name="create_account" value="1">
            <?php esc_html_e( 'Create an account for this customer?', 'loycart-pos' ); ?>
          </label>
        </div>

        <button id="calculate-guest-shipping" type="button" class="button button-primary full-width"><?php esc_html_e( 'Calculate Shipping', 'loycart-pos' ); ?></button>
        <hr class="shipping-divider">
      </form>

      <div id="shipping-options-content">
        <p class="empty-state-message"><?php esc_html_e( 'Please select a customer or enter a guest address to see shipping options.', 'loycart-pos' ); ?></p>
      </div>
    </div>

    <div class="modal-footer">
      <button id="apply-shipping-button" class="button button-primary" disabled><?php esc_html_e( 'Apply Selected Shipping to Cart', 'loycart-pos' ); ?></button>
      <button class="modal-close button button-secondary"><?php esc_html_e( 'Cancel', 'loycart-pos' ); ?></button>
    </div>
  </div>
</div>

<div id="payment-method-modal" class="modal" role="dialog" aria-labelledby="payment-modal-title">
  <div class="modal-content" style="max-width: 480px;">
    <div class="modal-header">
      <h3 id="payment-modal-title"><?php esc_html_e( 'Process Payment', 'loycart-pos' ); ?></h3>
      <button class="modal-close" aria-label="<?php esc_attr_e( 'Close modal', 'loycart-pos' ); ?>">×</button>
    </div>
    <div class="modal-body">
      <div class="split-payment-summary">

        <div class="summary-row remaining">
          <span class="summary-label"><?php esc_html_e( 'Total Order:', 'loycart-pos' ); ?></span>
          <span id="modal-original-total" class="summary-value large-total"></span>
        </div>
        <div id="split-payments-applied-list"></div>
        <hr class="shipping-divider">
        <div class="summary-row change" id="split-change-row" style="display: none;">
          <span class="summary-label"><?php esc_html_e( 'Change Due:', 'loycart-pos' ); ?></span>
          <span id="split-change-due" class="summary-value large-total change-value"><?php echo wp_kses_post( wc_price( 0 ) ); ?></span>
        </div>
      </div>
      <hr class="shipping-divider">
      <div class="modal-form-group">
        <label for="split-amount-input" id="split-amount-label"><?php esc_html_e('Amount to Pay:', 'loycart-pos'); ?></label>
        <div class="split-input-wrapper">
          <input type="text" id="split-amount-input" class="pos-input split-amount-display" inputmode="decimal" value="0.00" readonly>
          <div class="split-input-actions">
            <button id="split-keypad-clear" data-value="clear" class="split-action-button clear"><?php esc_html_e( 'Clear', 'loycart-pos' ); ?></button>
          </div>
        </div>
        <div id="split-quick-amounts" class="quick-amounts-wrapper">
          <?php
                        $loycart_currency_symbol = get_woocommerce_currency_symbol();
                        echo '<button class="quick-cash-btn exact" data-amount-type="exact">' . esc_html__( 'Exact', 'loycart-pos' ) . '</button>';
                        $loycart_quick_tenders = [1, 2, 5, 10, 20, 50, 100];
                        foreach ( $loycart_quick_tenders as $loycart_amount ) {
                            echo '<button class="quick-cash-btn" data-amount-value="' . esc_attr($loycart_amount) . '">' . esc_html( $loycart_currency_symbol . $loycart_amount ) . '</button>';
                        }
                    ?>
        </div>
      </div>
      <div id="split-payment-buttons" class="payment-buttons-grid">
        <button class="payment-button modal-payment-btn" data-payment-method="cash" data-title="<?php echo esc_attr__( 'Cash', 'loycart-pos' ); ?>"><?php esc_html_e( 'Cash', 'loycart-pos' ); ?></button>
        <button class="payment-button modal-payment-btn" data-payment-method="card" data-title="<?php echo esc_attr__( 'Card', 'loycart-pos' ); ?>"><?php esc_html_e( 'Card', 'loycart-pos' ); ?></button>
        <button id="pay-cheque-button" class="payment-button modal-payment-btn" data-payment-method="cheque" data-title="<?php echo esc_attr__( 'Cheque', 'loycart-pos' ); ?>"><?php esc_html_e( 'Cheque', 'loycart-pos' ); ?></button>
        <button id="pay-bank-button" class="payment-button modal-payment-btn" data-payment-method="bank_transfer" data-title="<?php echo esc_attr__( 'Bank', 'loycart-pos' ); ?>"><?php esc_html_e( 'Bank', 'loycart-pos' ); ?></button>
        </div>
    </div>
    <div class="modal-footer">
      <button id="split-complete-sale" class="button button-primary" disabled><?php esc_html_e( 'Complete Sale', 'loycart-pos' ); ?></button>
    </div>
  </div>
</div>




<div id="product-info-modal" class="modal" role="dialog" aria-labelledby="product-info-modal-title">
  <div class="modal-content">
    <div class="modal-header">
      <h3 id="product-info-modal-title"><?php esc_html_e( 'Product Information', 'loycart-pos' ); ?></h3>
      <button class="modal-close" aria-label="<?php esc_attr_e( 'Close modal', 'loycart-pos' ); ?>">×</button>
    </div>

    <div class="modal-body">
      <div id="product-info-content"></div>
    </div>

    <div class="modal-footer" id="info-modal-footer" style="display: flex; flex-direction: column; gap: 8px;"> 
      <div id="info-modal-footer-summary" class="footer-summary" style="display: flex; justify-content: space-between; align-items: center; width: 100%; border-bottom: 1px solid #eee; padding-bottom: 5px;"> 
        <div id="footer-price-display" style="font-size: 1.2em; font-weight: bold; color: var(--accent);"></div>
          <div id="footer-stock-display" style="font-size: 1.1em; font-weight: 600;"></div>
      </div>

      <div id="info-modal-attribute-selectors" class="attribute-selectors" style="width: 100%; margin-top: -5px;"></div>

      <div class="info-modal-actions" style="display: flex; align-items: flex-end; gap: 10px; width: 100%; margin-top: 5px;">
        <button id="print-label-button" class="button button-secondary" style="flex: 1; height: 40px;">
          <span class="dashicons dashicons-printer" style="vertical-align: middle;"></span> 
          <?php esc_html_e( 'Print Label', 'loycart-pos' ); ?>
        </button>

        <div class="modal-form-group" style="flex: 0 0 80px; margin-bottom: 0;">
          <label for="info-modal-quantity" style="display: block; font-size: 11px; margin-bottom: 4px;">
            <?php esc_html_e( 'Qty:', 'loycart-pos' ); ?>
          </label>
          <input type="number" id="info-modal-quantity" class="pos-input" value="1" min="1" style="width: 100%; height: 40px; text-align: center;">
        </div>

        <button id="info-modal-add-to-cart" class="button button-primary" style="flex: 2; height: 40px;">
          <?php esc_html_e( 'Add to Cart', 'loycart-pos' ); ?>
        </button>
      </div>

    </div>
  </div>
</div>

<div id="create-customer-modal" class="modal" role="dialog" aria-labelledby="create-customer-title">
  <div class="modal-content">
    <div class="modal-header">
      <h3 id="create-customer-title"><?php esc_html_e( 'Create New Customer', 'loycart-pos' ); ?></h3>
      <button class="modal-close" aria-label="<?php esc_attr_e( 'Close modal', 'loycart-pos' ); ?>">×</button>
    </div>
    <div class="modal-body">
      <p class="guest-form-intro"><?php esc_html_e( 'A password will be sent to the customer\'s email. All address fields are required.', 'loycart-pos' ); ?></p>
      <div class="guest-address-fields">
        <div class="modal-form-group half-width">
          <label for="new_customer_first_name"><?php esc_html_e( 'First Name', 'loycart-pos' ); ?></label>
          <input type="text" id="new_customer_first_name" class="pos-input">
        </div>
        <div class="modal-form-group half-width">
          <label for="new_customer_last_name"><?php esc_html_e( 'Last Name', 'loycart-pos' ); ?></label>
          <input type="text" id="new_customer_last_name" class="pos-input">
        </div>
        <div class="modal-form-group half-width">
          <label for="new_customer_email"><?php esc_html_e( 'Email (Required)', 'loycart-pos' ); ?></label>
          <input type="email" id="new_customer_email" class="pos-input">
        </div>
        <div class="modal-form-group half-width">
          <label for="new_customer_phone"><?php esc_html_e( 'Phone', 'loycart-pos' ); ?></label>
          <input type="tel" id="new_customer_phone" class="pos-input">
        </div>
        <div class="modal-form-group">
          <label for="new_customer_address_1"><?php esc_html_e( 'Address', 'loycart-pos' ); ?></label>
          <input type="text" id="new_customer_address_1" class="pos-input">
        </div>
        <div class="modal-form-group">
          <label for="new_customer_address_2"><?php esc_html_e( 'Address Line 2 (Optional)', 'loycart-pos' ); ?></label>
          <input type="text" id="new_customer_address_2" class="pos-input">
        </div>
        <div class="modal-form-group half-width">
          <label for="new_customer_city"><?php esc_html_e( 'City', 'loycart-pos' ); ?></label>
          <input type="text" id="new_customer_city" class="pos-input">
        </div>
        <div class="modal-form-group half-width">
          <label for="new_customer_postcode"><?php esc_html_e( 'Postcode / ZIP', 'loycart-pos' ); ?></label>
          <input type="text" id="new_customer_postcode" class="pos-input">
        </div>
        <div class="modal-form-group half-width">
          <label for="new_customer_country"><?php esc_html_e( 'Country', 'loycart-pos' ); ?></label>
          <select id="new_customer_country" class="pos-input wc-enhanced-select">
            <?php
                             $loycart_countries = new WC_Countries();
                             $loycart_all_countries = $loycart_countries->get_shipping_countries();
                             foreach ($loycart_all_countries as $loycart_code => $loycart_name) {
                                 echo '<option value="' . esc_attr($loycart_code) . '">' . esc_html($loycart_name) . '</option>';
                             }
                         ?>
          </select>
        </div>
        <div class="modal-form-group half-width">
          <label for="new_customer_state"><?php esc_html_e( 'State / County', 'loycart-pos' ); ?></label>
          <input type="text" id="new_customer_state" class="pos-input">
        </div>
      </div>
    </div>
    <div class="modal-footer">
      <button id="save-new-customer" class="button button-primary"><?php esc_html_e( 'Create & Select Customer', 'loycart-pos' ); ?></button>
      <button class="modal-close button button-secondary"><?php esc_html_e( 'Cancel', 'loycart-pos' ); ?></button>
    </div>
  </div>
</div>

<!-- Store Credit Reports Modal (top-level, not nested) -->
<div id="credit-reports-modal" class="modal" role="dialog" aria-labelledby="credit-reports-modal-title">
  <div class="modal-content">
    <div class="modal-header">
      <h3 id="credit-reports-modal-title"><?php esc_html_e( 'Store Credit Reports', 'loycart-pos' ); ?></h3>
      <button class="modal-close" aria-label="<?php esc_attr_e( 'Close modal', 'loycart-pos' ); ?>">×</button>
    </div>
    <div class="modal-body">
      <div class="modal-form-group credit-reports-filters">
        <div class="date-field">
          <label for="credit-reports-from"><?php esc_html_e('From', 'loycart-pos'); ?></label>
          <input type="date" id="credit-reports-from" class="pos-input" value="<?php echo esc_attr( gmdate('Y-m-d', time() - 30 * DAY_IN_SECONDS) ); ?>">
        </div>
        <div class="date-field">
          <label for="credit-reports-to"><?php esc_html_e('To', 'loycart-pos'); ?></label>
          <input type="date" id="credit-reports-to" class="pos-input" value="<?php echo esc_attr( gmdate('Y-m-d') ); ?>">
        </div>
        <div class="filters-actions">
          <button id="credit-reports-refresh" class="button button-secondary"><?php esc_html_e('Refresh', 'loycart-pos'); ?></button>
        </div>
      </div>
      <div id="credit-reports-content">
        <p class="empty-state-message"><?php esc_html_e('Use the filters above to load the latest store credit summary.', 'loycart-pos'); ?></p>
      </div>
    </div>
    <div class="modal-footer">
      <button class="modal-close button button-secondary"><?php esc_html_e('Close', 'loycart-pos'); ?></button>
    </div>
  </div>
</div>


<!-- Clear Cart Confirmation Modal  -->
<div id="clear-cart-modal" class="modal" role="dialog" aria-labelledby="clear-cart-modal-title">
  <div class="modal-content" style="max-width: 400px;">
    <div class="modal-header">
      <h3 id="clear-cart-modal-title"><?php esc_html_e('Clear Cart?', 'loycart-pos'); ?></h3>
      <button class="modal-close" aria-label="<?php esc_attr_e('Close modal', 'loycart-pos'); ?>">×</button>
    </div>
    <div class="modal-body">
      <p><?php esc_html_e('Are you sure you want to clear all items from the cart? This action cannot be undone.', 'loycart-pos'); ?></p>
    </div>
    <div class="modal-footer">
      <button id="clear-cart-cancel-btn" class="button button-secondary modal-close"><?php esc_html_e('Cancel', 'loycart-pos'); ?></button>
      <button id="clear-cart-confirm-btn" class="button button-primary"><?php esc_html_e('Yes, Clear Cart', 'loycart-pos'); ?></button>
    </div>
  </div>
</div>



