<?php
// Debug WooCommerce coupon validation for troubleshooting
add_filter('woocommerce_coupon_is_valid', function($valid, $coupon, $discount) {
    if (!$valid) {
        $msg = sprintf('[Coupon Debug] Coupon "%s" rejected. Reason: %s', $coupon->get_code(), json_encode($coupon->get_error_message()));
        error_log($msg);
        if (is_admin()) {
            add_action('admin_notices', function() use ($msg) {
                echo '<div class="notice notice-warning"><p>' . esc_html($msg) . '</p></div>';
            });
        }
    } else {
        $msg = sprintf('[Coupon Debug] Coupon "%s" accepted.', $coupon->get_code());
        error_log($msg);
    }
    return $valid;
}, 10, 3);

add_filter('woocommerce_coupon_error', function($err, $err_code, $coupon) {
    $msg = sprintf('[Coupon Debug] Coupon error "%s" for coupon "%s".', $err, is_object($coupon) ? $coupon->get_code() : 'N/A');
    error_log($msg);
    return $err;
}, 10, 3);