<?php
/**
 * LoyCart POS App Layout
 *
 * This file contains the HTML for the main POS interface.
 */


if ( ! defined( 'ABSPATH' ) ) {
    exit; 
}
?>

<div class="pos-wrapper">
    <div class="pos-main pos-redesigned">
        <div class="product-browser">
            <div class="pos-topbar">
            <div class="cart-header">


                <div id="header-content">
                    <div id="header-store-name">
                    <?php echo esc_html( get_option( 'woocommerce_pos_store_name', get_bloginfo('name') ) ); ?>
                    </div>

<div id="header-date-time">
    <div id="pos-cashier-display">
        <?php esc_html_e( 'Cashier:', 'loycart-pos' ); ?> 
        <span id="pos-cashier-name">
            <?php 
            echo is_user_logged_in() && ! empty( wp_get_current_user()->display_name )
                ? esc_html( wp_get_current_user()->display_name )
                : esc_html__( 'Not logged in', 'loycart-pos' );
            ?>
        </span>
    </div>
    
    <span id="pos-current-date"></span> 
    <span id="pos-current-time"></span>
</div>
 
                </div>
            </div>

            <header class="browser-header">
                <div class="search-wrapper">
                    <button type="button" id="header-barcode-scan-button" class="button button-secondary" aria-label="<?php esc_attr_e( 'Scan barcode with device camera', 'loycart-pos' ); ?>" title="<?php esc_attr_e( 'Scan barcode with camera', 'loycart-pos' ); ?>" style="min-width: 44px; padding: 0;">
                        <span class="dashicons dashicons-camera-alt" style="font-size: 20px;"></span>
                    </button>
                    <input type="search" id="product-search" class="pos-input" placeholder="<?php esc_attr_e( 'Search or Scan Barcode', 'loycart-pos' ); ?>" autocomplete="off">
                     <button type="button" id="product-search-clear" class="cart-edit-toggle" aria-label="<?php esc_attr_e( 'Clear search input', 'loycart-pos' ); ?>" title="<?php esc_attr_e( 'Clear search input', 'loycart-pos' ); ?>">
                        <span class="dashicons dashicons-undo" style="font-size: 20px;"></span>
                    </button>
                </div>

                <select id="sort-select" class="pos-input">
                    <option value="popular" selected><?php esc_html_e( 'Most Popular', 'loycart-pos' ); ?></option>
                    <option value="name_asc"><?php esc_html_e( 'Name (A-Z)', 'loycart-pos' ); ?></option>
                    <option value="name_desc"><?php esc_html_e( 'Name (Z-A)', 'loycart-pos' ); ?></option>
                    <option value="price_asc"><?php esc_html_e( 'Price (Low to High)', 'loycart-pos' ); ?></option>
                    <option value="price_desc"><?php esc_html_e( 'Price (High to Low)', 'loycart-pos' ); ?></option>
                    <option value="sale"><?php esc_html_e( 'Items on Sale', 'loycart-pos' ); ?></option>
                    <option value="newest"><?php esc_html_e( 'Newest', 'loycart-pos' ); ?></option>
                </select>

                <select id="category-select" class="pos-input">
                    <option value="all"><?php esc_html_e( 'All Categories', 'loycart-pos' ); ?></option>
                    <?php foreach ( $categories as $loycart_category ) : ?>
                        <option value="<?php echo esc_attr( $loycart_category->term_id ); ?>"><?php echo esc_html( $loycart_category->name ); ?></option>
                    <?php endforeach; ?>
                </select>

            </header>
            </div>
<main class="products-section">
<div id="original-order-info" class="original-order-info-bar" style="display: none;">
    <div class="order-context-details">
        <span class="context-label"><?php esc_html_e( 'Refunding Order:', 'loycart-pos' ); ?></span>
        <span id="refund-order-id" class="context-value"></span>
        <span class="context-divider">|</span>
        <span class="context-label"><?php esc_html_e( 'Original Total:', 'loycart-pos' ); ?></span>
        <span id="refund-order-total" class="context-value"></span>
        <span class="context-divider context-divider-date" style="display:none;">|</span>
        <span id="refund-order-date" class="context-date"></span>
        <span class="context-divider">|</span>
        <span class="context-label"><?php esc_html_e( 'Cashier:', 'loycart-pos' ); ?></span>
    </div>
</div>

    <div id="products-list" role="grid"></div>

    <div class="pagination-controls">
        <div class="pagination-info">
            <?php esc_html_e( 'Showing', 'loycart-pos' ); ?>
            <span class="page-numbers"><span id="items-from">0</span>-<span id="items-to">0</span></span>
            <?php esc_html_e( 'of', 'loycart-pos' ); ?> <span id="total-items">0</span>
        </div>
        <div class="pagination-buttons">
            <button id="prev-page" class="page-button" disabled><span class="dashicons dashicons-arrow-left-alt2"></span></button>
            <select id="page-select" class="pos-input"></select>
            <button id="next-page" class="page-button" disabled><span class="dashicons dashicons-arrow-right-alt2"></span></button>
        </div>
    </div>
</main>
        </div>

    

<aside class="cart-panel">
<div class="pos-topbar">
             <div id="customer-cart-indicator">
                    <div id="guest-customer-indicator">
                        <input type="hidden" id="customer-id" value="0">
                        <button id="add-guest-customer-button" class="customer-indicator-button">
                            <span class="dashicons dashicons-admin-users"></span>
                            <?php esc_html_e( 'Guest Customer', 'loycart-pos' ); ?>
                            <span class="dashicons dashicons-plus-alt"></span>
                        </button>
                    </div>
                    <div id="selected-customer-indicator" style="display: none;">
                        <button id="edit-selected-customer" class="customer-indicator-button">
                            <span class="dashicons dashicons-admin-users"></span>
                            <strong id="selected-customer-name"></strong>
                            <span class="credit-label"><?php esc_html_e( 'Store Credit:', 'loycart-pos' ); ?></span>
                            <span id="store-credit-balance"><?php echo wp_kses_post( wc_price( 0 ) ); ?></span>
                        </button>
                        <button id="remove-customer-from-cart" class="button-like-link" aria-label="<?php esc_attr_e( 'Remove selected customer', 'loycart-pos' ); ?>">×</button>
                    </div>
                </div>  
              </div>
            
<div id="cart-items">
<div class="empty-cart"><?php esc_html_e( 'Cart is empty', 'loycart-pos' ); ?></div>
</div>

 <div class="cart-footer">
    <div class="cart-totals">
        <div class="cart-subtotal-regular">
            <span><?php esc_html_e( 'Subtotal:', 'loycart-pos' ); ?></span>
            <span id="cart-subtotal"><?php echo wp_kses_post( wc_price( 0 ) ); ?></span>
        </div>
        
        <div class="cart-discount" id="cashier-discount-row" style="display: none">
    <span><?php esc_html_e( 'Cashier Discounts:', 'loycart-pos' ); ?></span>
    <span id="cashier-discount-val"></span>
</div>

<div class="cart-coupon" id="wc-coupon-row" style="display: none">
    <span><?php esc_html_e( 'Coupon:', 'loycart-pos' ); ?></span>
    <span class="coupon-wrapper">
        <span id="wc-coupon-val"></span>
        <button id="remove-applied-coupon" class="button-like-link" aria-label="<?php esc_attr_e( 'Remove coupon', 'loycart-pos' ); ?>">×</button>
    </span>
</div>
        
        <div class="cart-shipping" id="cart-shipping-row" style="display: none;">
            <span><?php esc_html_e( 'Shipping:', 'loycart-pos' ); ?></span>
            <span class="shipping-value-wrapper">
                <span id="cart-shipping-total"></span>
                <button id="remove-cart-shipping" class="button-like-link remove-shipping-in-totals">&times;</button>
            </span>
        </div>
        
        <div class="cart-shipping-tax" id="cart-shipping-tax-row" style="display: none;">
            <span><?php esc_html_e( 'Shipping Tax:', 'loycart-pos' ); ?></span>
            <span id="cart-shipping-tax-total"></span>
        </div>
        
        <div class="cart-tax" id="cart-tax-row" style="display: none;">
            <span id="tax-label-text"><?php esc_html_e( 'Tax:', 'loycart-pos' ); ?></span>
            <span id="cart-tax"></span>
        </div>
        
        <div class="cart-total">
            <span><?php esc_html_e( 'Total:', 'loycart-pos' ); ?></span>
            <span id="cart-total-amount"><?php echo wp_kses_post( wc_price( 0 ) ); ?></span>
            
        </div>
        
        <div class="cart-subtotal-regular">
            Items: <span class="header-item-count">0</span>
        </div>
        
        
    </div>
</div>

                <div class="cart-controls">
                    <div class="cart-secondary-actions" id="cart-secondary-actions" style="display: none;">
                        <div class="cart-actions-grid">
                            <button id="add-new-product-button" class="pos-button"><span class="dashicons dashicons-products pos-action-icon"></span> <?php esc_html_e( 'Add New Product', 'loycart-pos' ); ?></button>
                            <button id="return-mode-button" class="pos-button"><span class="dashicons dashicons-undo pos-action-icon"></span> <?php esc_html_e( 'Process Return', 'loycart-pos' ); ?></button>
                        </div>
                        <div class="cart-actions-grid">
                            <button id="add-note-button" class="pos-button"><span class="dashicons dashicons-edit pos-action-icon"></span> <?php esc_html_e( 'Add Note', 'loycart-pos' ); ?></button>
                            <button id="hold-sale-button" class="pos-button"><span class="dashicons dashicons-saved pos-action-icon"></span> <?php esc_html_e( 'Hold Sale', 'loycart-pos' ); ?></button>
                            <button id="clear-cart-button" class="pos-button button-danger"><span class="dashicons dashicons-trash pos-action-icon"></span> <?php esc_html_e( 'Clear Cart', 'loycart-pos' ); ?></button>
                            <button id="apply-coupon-btn" class="pos-button"><span class="dashicons dashicons-tag pos-action-icon"></span> <?php esc_html_e('Apply Coupon', 'loycart-pos'); ?></button>
                            <button id="store-credit-reports-button" class="pos-button"><span class="dashicons dashicons-chart-bar pos-action-icon"></span> <?php esc_html_e('Store Credit', 'loycart-pos'); ?></button>
                            <button id="pos-settings-button" class="pos-button"><span class="dashicons dashicons-admin-generic pos-action-icon"></span> <?php esc_html_e('POS Settings', 'loycart-pos'); ?></button>
                        </div>
                    </div>

                    <div class="cart-actions-grid" id="sales-actions-grid">
                        <button class="payment-button" id="more-actions-toggle">
                            <span class="dashicons dashicons-screenoptions"></span> <?php esc_html_e( 'More Actions', 'loycart-pos' ); ?>
                        </button>
                        <button id="checkout-button" class="payment-button"><?php esc_html_e( 'Charge ...', 'loycart-pos' ); ?></button>
                    </div>
                    <div id="return-actions-grid" class="cart-actions-grid" style="display: none;">
                        <button id="process-refund-button" class="pos-button"><?php esc_html_e( 'Process Refund', 'loycart-pos' ); ?></button>
                        <button id="cancel-return-button" class="pos-button button-secondary"><?php esc_html_e( 'Cancel Return', 'loycart-pos' ); ?></button>
                    </div>
                </div>
            </div>
        </aside>
    </div>
</div>


                

