// --- SHIPPING MANAGER MODULE ---
// Contains all logic for managing shipping
// -----------------------------
loycart.shippingManager = {

    updateShippingCallToAction: function () {
        const $shippingButton = jQuery('#add-shipping-button');
        if (!$shippingButton.length) return;

        const orderRequiresShipping = loycart.cart.some(item => !item.is_virtual);
        const shippingIsSelected = selectedShipping.id !== null;

        if (shippingIsSelected) {
            $shippingButton.html('<span class="dashicons dashicons-yes-alt"></span> Shipping Added');
        } else {
            $shippingButton.html('<span class="dashicons dashicons-airplane"></span> Add Shipping');
        }

        const needsAttention = orderRequiresShipping && !shippingIsSelected;
        $shippingButton.toggleClass('shipping-needed', needsAttention);
    },

    fetchShippingOptions: function (customerId, guestAddress) {
        const $shippingOptionsContent = jQuery('#shipping-options-content').html(`<p class="empty-state-message">Fetching shipping options...</p>`);
        jQuery('#apply-shipping-button').prop('disabled', true);

        api_getShippingOptions(JSON.stringify(loycart.cart), customerId, guestAddress)
            .done(function (response) {
                $shippingOptionsContent.empty();
                if (response.success && response.data.length > 0) {
                    const $list = jQuery('<div class="shipping-method-list"></div>');
                    response.data.forEach(method => {
                        const $item = jQuery(`
                            <div class="shipping-method-item" data-id="${method.id}" data-cost="${method.cost}" data-label="${method.label}" tabindex="0">
                                <label>
                                    <span class="shipping-method-label">${method.label}</span>
                                    <span class="shipping-method-cost">${formatPrice(method.cost)}</span>
                                </label>
                            </div>
                        `);
                        $list.append($item);
                    });
                    $shippingOptionsContent.append($list);
                } else {

                    const errorMessage = response.data || 'No shipping options available for the provided address.';
                    $shippingOptionsContent.html(`<p class="empty-state-message">${errorMessage}</p>`);
                }
            })
            .fail(function () {
                $shippingOptionsContent.html(`<p class="empty-state-message">Could not connect to the server to get shipping options.</p>`);
            });
    },

initiateShippingProcess: function () {
    const customerId = $customerId.val();
    const $shippingModal = jQuery('#shipping-modal');
    const $guestForm = jQuery('#guest-shipping-form');
    const $shippingOptionsContent = jQuery('#shipping-options-content');

    $guestForm[0].reset();
    $shippingOptionsContent.html('<p class="empty-state-message">Enter an address to calculate shipping.</p>');


    if (!customerId || customerId === '0') {

        showNotification('Please select or create a customer for shipping.', 'info');


        openModal($customerModal);
        return;
    }


    else {

        $shippingModal.find('.guest-form-intro').text('Loading customer address...');
        $guestForm.find('#create_account_checkbox').closest('.modal-form-group').hide();
        $guestForm.show();
        openModal($shippingModal);

        api_getCustomerAddress(customerId)
            .done(function (response) {
                if (response.success) {
                    const shippingAddress = response.data.shipping || response.data;
                    const billingEmail = response.data.billing_email || '';
                    const billingPhone = response.data.billing_phone || '';

                    jQuery('#shipping_first_name').val(shippingAddress.first_name);
                    jQuery('#shipping_last_name').val(shippingAddress.last_name);

                    jQuery('#shipping_email').val(billingEmail);
                    jQuery('#shipping_phone').val(billingPhone);

                    jQuery('#shipping_address_1').val(shippingAddress.address_1);
                    jQuery('#shipping_address_2').val(shippingAddress.address_2);
                    jQuery('#shipping_city').val(shippingAddress.city);
                    jQuery('#shipping_postcode').val(shippingAddress.postcode);
                    jQuery('#shipping_country').val(shippingAddress.country);
                    jQuery('#shipping_state').val(shippingAddress.state);

                    $shippingModal.find('.guest-form-intro').text('Confirm or edit the shipping address for this order.');
                    $shippingOptionsContent.html('<p class="empty-state-message">Click "Calculate Shipping" to see available options.</p>');
                } else {
                    $shippingModal.find('.guest-form-intro').text('Could not load address. Please enter manually.');
                }
            })
            .fail(function () {
                $shippingModal.find('.guest-form-intro').text('Error loading address. Please enter manually.');
            });
    }
}
};
// --- END SHIPPING MANAGER MODULE ---