    // ...rollback: removed updateProductCardStates...
// --- PRODUCT MANAGER MODULE ---
const BARCODE_MIN_SCAN_LENGTH = 3; 
const BARCODE_SCAN_TIMEOUT = 300;
let isScanning = false;


loycart.productManager = {
    animateToCart: function ($imageElement, productData) {

        let $cartTarget;

        if (productData) {
            // Find the specific cart item image
            const $cartItems = jQuery('#cart-items');
            const selector = productData.variation_id 
                ? `.cart-item[data-id="${productData.id}"][data-variation-id="${productData.variation_id}"] .cart-item-thumbnail`
                : `.cart-item[data-id="${productData.id}"]:not([data-variation-id]) .cart-item-thumbnail`;
            $cartTarget = $cartItems.find(selector);
        }

        if (!$cartTarget || $cartTarget.length === 0) {
            // Fallback to cart container
            $cartTarget = jQuery('#cart-items');
        }

        if ($imageElement.length > 0 && $cartTarget.length > 0) {
            const $imageClone = $imageElement.clone();
            const startPos = $imageElement.offset();
            const endPos = $cartTarget.offset();

            $imageClone.css({
                position: 'absolute',
                top: startPos.top,
                left: startPos.left,
                width: $imageElement.width(),
                height: $imageElement.height(),
                zIndex: 2000,
                borderRadius: '4px',
                boxShadow: '0 5px 15px rgba(0,0,0,0.3)'
            }).appendTo('body');

            $imageClone.animate({
                top: endPos.top + 20,
                left: endPos.left + 20,
                width: 30,
                height: 30,
                opacity: 0.1
            }, 700, 'swing', function () {
                jQuery(this).remove();
                // Removed scroll-into-view to prevent jumpy cart
            });

            const cartSound = document.getElementById('add-to-cart-sound');
            if (cartSound) {
                cartSound.currentTime = 0;
                cartSound.play();
            }
        }
    },


    loadProducts: function (page = 1, append = false) {

        if (isProcessing) {

            return;
        }
        isProcessing = true;





        api_loadProducts(currentCategory, currentSearch, page, itemsPerPage, currentSort)
            .done(function (response) {

                if (response.success) {
                    let products = response.data;
                    let pagination = response.pagination || {};

                    if (Array.isArray(response.data)) {
                        products = response.data;
                        pagination = {
                            current_page: response.pagination?.current_page || 1,
                            total_pages: response.pagination?.total_pages || 1,
                            total_items: response.pagination?.total_items || products.length,
                            items_from: response.pagination?.items_from || 1,
                            items_to: response.pagination?.items_to || products.length
                        };
                    } else if (response.data && response.data.products) {
                        products = response.data.products;
                        pagination = {
                            current_page: response.data.current_page || 1,
                            total_pages: response.data.total_pages || 1,
                            total_items: response.data.total_products || products.length,
                            items_from: (response.data.current_page - 1) * itemsPerPage + 1,
                            items_to: Math.min(response.data.current_page * itemsPerPage, response.data.total_products)
                        };
                    }

                    if (!append) $productsList.empty();
                    else $productsList.find('.product-loader').remove();

                    if (products && products.length === 0 && !append && page === 1) {
                        $productsList.append(`
                            <div class="no-products-found" style="text-align:center;color:var(--text-muted);padding:24px;">
                                <div style="font-size:1.1em;font-weight:500;">${strings.noProductsFoundCriteria || 'No products found.'}</div>
                                <small>Try adjusting your search or filters.</small>
                            </div>
                        `);
                        setTimeout(function () {
                            const $msg = $productsList.find('.no-products-found');
                            if ($msg.length) {
                                $msg.fadeOut(150, function(){ jQuery(this).remove(); });
                            }
                            // Auto-reset search and reload products
                            if (typeof currentSearch === 'string' && currentSearch.length > 0) {
                                currentSearch = '';
                                jQuery('#product-search').val('');
                                loycart.productManager.loadProducts(1, false);
                            }
                        }, 1200);
                    } else if (products) {
                        products.forEach(function (product) {

                            let infoHtml = '';
                            let productPriceText = '';
                            const isVariable = product.type === 'variable';


                            const selectOptionsText = (typeof loycartPOS !== 'undefined' && loycartPOS.strings && loycartPOS.strings.selectOptions) ? loycartPOS.strings.selectOptions : 'Select options for price and stock';

                            if (product.stock_status === 'options') {

                                infoHtml = `<span class="stock-status" style="font-weight: 500; font-size: 13px; color: var(--text-muted); padding-top: 5px;">${selectOptionsText}</span>`;
                                productPriceText = selectOptionsText;
                            } else {

                                const stockText = product.stock_status === 'instock' && product.stock_quantity !== null
                                    ? `${strings.stockPrefix}${product.stock_quantity}`
                                    : product.stock_status === 'outofstock'
                                    ? strings.outOfStock
                                    : product.stock_status === 'onbackorder'
                                    ? strings.onBackorder
                                    : `${strings.stockPrefix || 'Stock: '}N/A`;

                                infoHtml = `
                                    <div class="product-name">${product.name || 'Unnamed Product'}</div><br>
                                    <div class="product-price">${generatePriceHTML(product)}</div>
                                    <div class="product-info-icon" data-product-id="${product.id}" role="button" aria-label="View product info"><span class="dashicons dashicons-info"></span></div>`;


                                productPriceText = product.on_sale ?
                                    `${formatPrice(product.regular_price)} ${formatPrice(product.sale_price)}` :
                                    formatPrice(product.price);
                            }


                            const isOutOfStock = product.stock_status === 'outofstock';

                            const isSoldIndividually = product.sold_individually || false;
                            const isInCart = isSoldIndividually && loycart.cart.some(item => (item.id === product.id || item.variation_id === product.id) && !item.is_custom);
                            const isDisabled = isOutOfStock || isInCart;
                            const disabledAttr = isDisabled ? 'aria-disabled="true"' : '';
                            const disabledTabIndex = isDisabled ? '-1' : '0';

                            let disabledNoteContent = '';
                            if (isOutOfStock) {
                                disabledNoteContent = strings.outOfStock;
                            } else if (isSoldIndividually) {
                                disabledNoteContent = strings.disabledNote || '1 per customer';
                            }
                            const disabledNote = disabledNoteContent ?
                                `<span class="disabled-note" role="status">${disabledNoteContent}</span>` :
                                '';

                            const productAriaLabel = `${product.name || 'Unnamed Product'} - ${productPriceText}` +
                                (isOutOfStock ? ` (${strings.outOfStock})` : '') +
                                (isSoldIndividually ? ` (${strings.disabledNote || '1 per customer'})` : '');


const hasProductImage = product.image && product.image.trim() !== '';


const imageContent = hasProductImage
    ? `<img src="${product.image}" alt="${product.name || (loycartPOS?.strings?.productAltFallback || 'Product')}" onerror="this.style.display='none'; this.nextElementSibling.style.display='flex';">`
    : '';

const localIconFallback = `
    <div class="product-image-fallback" style="${hasProductImage ? 'display:none;' : 'display:flex;'}">
        <span class="dashicons dashicons-format-image"></span>
    </div>`;


const $product_el = jQuery([
    `<div class="product ${isDisabled ? 'disabled' : ''} ${product.on_sale ? 'on-sale' : ''}"`,
    `    data-id="${product.id}"`,
    `    role="button" tabindex="${disabledTabIndex}" aria-label="${productAriaLabel}" ${disabledAttr}>`,
    `    <div class="product-card-inner">`,
    `        <div class="product-image-container">`,
    `            <div class="product-image">`,
    `                ${imageContent}`,
    `                ${localIconFallback}`,
    `            </div>`,
    `            ${product.on_sale ? '<div class="sale-badge"><span class="badge-text">SALE</span></div>' : ''}`,
    `            <div class="product-note-wrapper">`,
    `                ${disabledNote}`,
    `            </div>`,
        `            <div class="product-icon-strip" aria-hidden="true"></div>`,
    `            <button class="add-to-cart-btn" aria-label="Add to cart" ${isDisabled ? 'disabled' : ''}><span class="dashicons dashicons-cart"></span></button>`,
    `            <div class="product-print-icon" data-product-id="${product.id}" role="button" aria-label="${(loycartPOS?.strings?.printProductLabelAria || 'Print product label')}">`,
    `                <span class="dashicons dashicons-printer"></span>`,
    `            </div>`,
    `            <div class="product-info-icon" data-product-id="${product.id}" role="button" aria-label="View product info">`,
    `                <span class="dashicons dashicons-info"></span>`,
    `            </div>`,
    `        </div>`,
    `        <div class="product-footer">`,
    `                <div class="product-name">${product.name || 'Unnamed Product'}</div>`,
    `            <div class="product-footer">`,
    `                <div class="product-price-wrapper">`,
    `                    ${product.stock_status === 'options' ? `<span class="select-options-text">${selectOptionsText}</span>` : generatePriceHTML(product)}`,
    `                </div>`,
    
    `            </div>`,
    `        </div>`,
    `    </div>`,
    `</div>`
].join(''));

                            $product_el.data('product-data', product);
                            $productsList.append($product_el);
                        });
                    }

                    if (pagination) {
                        currentPage = parseInt(pagination.current_page);
                        $itemsFrom.text(pagination.total_items > 0 ? pagination.items_from : 0);
                        $itemsTo.text(pagination.items_to);
                        $totalItems.text(pagination.total_items);
                        // *** NEW LOGIC: BUILD PAGE DROPDOWN ***
        const $pageSelect = jQuery('#page-select').empty();
        for (let p = 1; p <= pagination.total_pages; p++) {
            $pageSelect.append(`<option value="${p}" ${p === currentPage ? 'selected' : ''}>Page ${p} of ${pagination.total_pages}</option>`);
        }
        // If no pages, ensure something is displayed
        if (pagination.total_pages === 0) {
             $pageSelect.append(`<option value="1">Page 1 of 1</option>`);
        }
        // *** END NEW LOGIC ***
                        $currentPage.text(strings.pageText ? strings.pageText.replace('%s', currentPage) : `Page ${currentPage}`);
                        $prevPage.prop('disabled', currentPage === 1).attr('aria-disabled', currentPage === 1);
                        $nextPage.prop('disabled', currentPage >= pagination.total_pages || pagination.total_pages === 0)
                            .attr('aria-disabled', currentPage >= pagination.total_pages || pagination.total_pages === 0);
                    } else {
                        $itemsFrom.text(products && products.length > 0 ? 1 : 0);
                        $itemsTo.text(products ? products.length : 0);
                        $totalItems.text(products ? products.length : 0);
                        $currentPage.text(strings.pageText ? strings.pageText.replace('%s', 1) : `Page 1`);
                        $prevPage.prop('disabled', true).attr('aria-disabled', 'true');
                        $nextPage.prop('disabled', true).attr('aria-disabled', 'true');
                    }

                    if (!append) $productsList.scrollTop(0);
                } else {
                    showNotification(strings.failedLoadProducts.replace('%s', (response.data || strings.unknownError)), 'error');
                    $productsList.empty().append(`<div class="no-products-found">${strings.errorLoadProducts}</div>`);
                }
            })
            .fail(function (jqXHR, textStatus, errorThrown) {
                showNotification(strings.errorLoadProductsConnection, 'error');
                $productsList.empty().append(`<div class="no-products-found">${strings.errorLoadProductsConnection}</div>`);
            })
            .always(function () {
                isProcessing = false;
                $productsList.removeClass('loading').attr('aria-busy', 'false');
            });
    },

    updateProductStock: function (soldItems) {
        if (!soldItems || soldItems.length === 0) return;
        soldItems.forEach(soldItem => {
            const $productEl = $productsList.find(`.product[data-id="${soldItem.id}"]`);
            if ($productEl.length) {
                if ($productEl.data('type') !== 'variable') {
                    const currentStockData = $productEl.data('stock-quantity');
                    if (currentStockData !== '' && !isNaN(parseInt(currentStockData))) {
                        const newStock = parseInt(currentStockData) - soldItem.quantity;
                        const stockText = newStock > 0 ? `${strings.stockPrefix}${newStock}` : strings.outOfStock;
                        $productEl.find('.stock-status').text(stockText).removeClass('instock outofstock onbackorder').addClass(newStock > 0 ? 'instock' : 'outofstock');
                        if (newStock <= 0) {
                            $productEl.addClass('disabled').data('stock-status', 'outofstock').attr('aria-disabled', 'true').attr('tabindex', '-1');
                        }
                        $productEl.data('stock-quantity', newStock);
                        const currentAriaLabel = $productEl.attr('aria-label');
                        const baseLabel = currentAriaLabel.split(' (')[0];
                        $productEl.attr('aria-label', `${baseLabel}${newStock <=0 ? ` (${strings.outOfStock})` : ''}`);

                    }
                } else {
                    const productData = $productEl.data('product-data');
                    if (productData && productData.variations) {
                        const variation = productData.variations.find(v => v.id === soldItem.variation_id);
                        if (variation && variation.stock_quantity !== null) {
                            variation.stock_quantity -= soldItem.quantity;
                        }
                    }
                }
                $productEl.addClass('stock-updated');
                setTimeout(() => $productEl.removeClass('stock-updated'), 1500);
            }
        });
    },

    handleBarcodeScan: function (barcode) {
        // ...existing code...
    const $productSearch = jQuery('#product-search'); // Ensure this selector matches your input
    $productSearch.val('').prop('readonly', true); // Clear and disable input to prevent concatenation
    
    // 1. Safety check for the constant
    const minLength = (typeof BARCODE_MIN_SCAN_LENGTH !== 'undefined') ? BARCODE_MIN_SCAN_LENGTH : 3;

    if (barcode.length < minLength) {
        $productSearch.prop('readonly', false);
        return;
    }

    if (isScanning) {
        // ...existing code...
        showNotification(strings.posIsBusy || 'Scanner busy...', 'warning');
        return;
    }
    // ...existing code...

    // 2. Pivot: If in Refund Mode, use the Refund Scanner logic instead
    if (window.isReturnMode) {
        this.handleRefundBarcodeScan(barcode);
        $productSearch.val('');
        return;
    }

    isScanning = true;
    // ...existing code...

    api_searchByBarcode(barcode)
        .done(function (response) {
            // ...existing code...
            const products = response.data;
            if (response.success && products && products.length > 0) {
                const product = products[0];
                
                // Handle Variations
                if (product.matched_variation_id && product.variations) {
                    // ...existing code...
                    const matchedVariation = product.variations.find(v => v.id === product.matched_variation_id);
                    if (matchedVariation) {
                        // ...existing code...
                        loycart.cartManager.addToCart(product, 1, matchedVariation.id, matchedVariation.attributes);
                        $productSearch.val('').prop('readonly', false);
                        isScanning = false;
                        return;
                    } else {
                        // ...existing code...
                        loycart.modals.showProductInfoModal(product);
                        $productSearch.val('').prop('readonly', false);
                        isScanning = false;
                        return;
                    }
                }
                // Handle Variable Products (without a specific match)
                else if (product.type === 'variable') {
                    // ...existing code...
                    loycart.modals.showProductInfoModal(product);
                    $productSearch.val('').prop('readonly', false);
                    isScanning = false;
                    return;
                }
                // Handle Simple Products
                else {
                    loycart.cartManager.addToCart(product);
                }
            } else {
                showNotification(strings.productNotFoundBarcode.replace('%s', barcode), 'error');
            }
        })
        .fail(function () {
            showNotification(strings.errorSearchingBarcode || 'Error searching barcode', 'error');
        })
        .always(function () {
            isScanning = false;
            // ...existing code...
            $productSearch.val('').prop('readonly', false); // Do not refocus after scan
        });
},


handleRefundBarcodeScan: function(barcode) {
    // Search the items already loaded for the original order
    const item = refundableOrderItems.find(i => i.barcode === barcode || i.sku === barcode);

    if (item) {
        // Trigger the same logic as clicking the product in the grid
        loycart.refundManager.addItemToRefund(item.original_item_id);
        showNotification(`Found in Order: ${item.name}`, 'success');
    } else {
        showNotification(`Item ${barcode} was not part of this order.`, 'error');
    }
},

    refreshNonce: function () {


        api_refreshNonce()
            .done(function (response) {
                if (response.success && response.data.nonce) {
                    loycartPOS.nonce = response.data.nonce;
                    nonce = response.data.nonce;
                    showNotification('Nonce refreshed. Please try scanning again.', 'success');
                } else {
                    showNotification('Failed to refresh nonce.', 'error');
                }
            })
            .fail(function (jqXHR, textStatus, errorThrown) {
                showNotification('Error connecting to refresh nonce.', 'error');
            });
    },


    handleProductClick: function ($product_el) {
        const productData = $product_el.data('product-data');
        if (!productData || (!productData.id && !productData.is_shipping_refund)) {
            showNotification(strings.productDataMissing, 'error');
            return;
        }

        // Special handling for shipping in refund mode: fly to totals section instead of cart items
        if (window.isReturnMode && productData.is_shipping_refund) {
            const $shippingElement = $product_el.find('.product-image, .dashicons-airplane').first();
            
            // Set the shipping refund directly in selectedShipping (positive value for refund)
            window.selectedShipping = {
                id: productData.original_item_id,
                cost: Math.abs(parseFloat(productData.price_paid || 0)),
                label: productData.name || 'Shipping'
            };
            
            // Trigger cart totals update first so the shipping row appears
            loycart.cartManager.getCartTotalsFromServer().done(() => {
                // Then animate after the row is rendered
                this.animateToShippingTotal($shippingElement);
            });
            
            showNotification('Shipping added to refund.', 'success');
            if (loycart.refundManager) loycart.refundManager.updateRefundableItemState();
            return;
        }

        const needsFullFetch = !productData.gallery_images || productData.gallery_images.length === 0;


        if (productData.type === 'variable') {

            if (needsFullFetch) {
                loycart.productManager.fetchAndShowProductInfo(String(productData.id));
            } else {
                loycart.modals.showProductInfoModal(productData);
            }

        } else {

            const $productImage = $product_el.find('img');
            loycart.cartManager.addToCart(productData);
            this.animateToCart($productImage, productData);
        }
    },

    animateToShippingTotal: function ($imageElement) {
        const $shippingTarget = jQuery('#cart-shipping-row');

        if ($imageElement.length > 0 && $shippingTarget.length > 0) {
            const $imageClone = $imageElement.clone();
            const startPos = $imageElement.offset();
            const endPos = $shippingTarget.offset();

            $imageClone.css({
                position: 'absolute',
                top: startPos.top,
                left: startPos.left,
                width: 60,
                height: 60,
                zIndex: 2000,
                borderRadius: '50%',
                backgroundColor: '#007cba',
                display: 'flex',
                alignItems: 'center',
                justifyContent: 'center',
                color: 'white',
                fontSize: '30px',
                boxShadow: '0 5px 15px rgba(0,0,0,0.3)'
            }).appendTo('body');

            $imageClone.animate({
                top: endPos.top + 10,
                left: endPos.left + 10,
                width: 30,
                height: 30,
                opacity: 0.1
            }, 700, 'swing', function () {
                jQuery(this).remove();
            });

            const cartSound = document.getElementById('add-to-cart-sound');
            if (cartSound) {
                cartSound.currentTime = 0;
                cartSound.play();
            }
        }
    },

    fetchAndShowProductInfo: function (productId) {
        if (isScanning) {
            return;
        }
        isScanning = true;


        api_searchByBarcode(productId)
            .done(function (response) {
                if (response.success && response.data && response.data.length > 0) {

                    loycart.modals.showProductInfoModal(response.data[0]);
                } else {
                    showNotification('Could not retrieve product details.', 'error');
                }
            })
            .fail(function () {
                showNotification('Error fetching product details.', 'error');
            })
            .always(function () {
                isScanning = false;
            });
    }

};
// --- END PRODUCT MANAGER MODULE ---