// --- MODALS MODULE ---
// Contains all logic for showing and managing pop-up modals
// ---------------------
loycart.modals = {

    showProductInfoModal: function (product) {
    // RESET: Clear old variation data and footer summary first
    jQuery('#product-info-modal').removeData('selected-variation');
    jQuery('#footer-price-display').empty();
    jQuery('#footer-stock-display').empty().attr('class', '');

        const $content = jQuery('#product-info-content').empty();
        const $selectors = jQuery('#info-modal-attribute-selectors').empty().hide();
        const $variationList = jQuery('#info-modal-variation-list').empty().hide();
        const $footer = jQuery('#info-modal-footer').show();
        const $quantityInput = jQuery('#info-modal-quantity').val(1).prop('disabled', false);
        const $addToCartButton = jQuery('#info-modal-add-to-cart').prop('disabled', false).text('Add to Cart');
        const $printLabelButton = jQuery('#print-label-button');
        // Ensure print label starts enabled by default; only variable products should disable until options are selected
        $printLabelButton.prop('disabled', false);
        
        jQuery('#product-info-modal').data('product-data', product);
        
       
        const $gallery = jQuery('<div class="product-info-gallery"></div>');
        const $imageWrapper = jQuery('<div class="product-info-image-wrapper"></div>');
        const $mainImage = jQuery(`<img src="${product.image}" class="product-info-main-image" alt="${product.name}">`);

        if (product.on_sale) {
            $imageWrapper.append('<span class="sale-badge">Sale</span>');
        }
        if (product.stock_status === 'outofstock') {
            $imageWrapper.append('<span class="stock-badge outofstock">Out of Stock</span>');
        }

        $imageWrapper.append($mainImage);
        const $thumbnails = jQuery('<div class="product-info-thumbnails"></div>');

       
        const $details = jQuery(
    '<div class="product-info-details">' +
    '<h3 class="product-options-name">' + product.name + '</h3>' +
    // Add display: block and margin-bottom to ensure separation
    '<div class="product-options-price" id="info-modal-price-display" style="display: block; margin-bottom: 15px; width: 100%; clear: both;">' + generatePriceHTML(product) + '</div>' +
    // Add clear: both here as well to be safe
    '<div class="product-info-description" style="clear: both; display: block; margin-top: 10px;">' + (product.description || (window.loycartPOS?.strings?.noDescriptionAvailable || 'No description available.')) + '</div>' +
    '<div class="stock-status ' + product.stock_status + '" id="info-modal-stock-display">' + (product.stock_status === 'instock' && product.stock_quantity !== null ? strings.stockPrefix + product.stock_quantity : product.stock_status === 'outofstock' ? strings.outOfStock : '') + '</div>' +
    '</div>'
);

        const currentQuantityInCart = loycart.checkSoldIndividuallyLimit(product.id);
        const isProductLimited = product.sold_individually || (product.type === 'variable' && product.variations && product.variations.some(v => v.sold_individually));
        const isLimitReached = isProductLimited && currentQuantityInCart >= 1;


        $gallery.append($imageWrapper).append($thumbnails);
        [product.image, ...product.gallery_images].forEach((imgUrl, index) => {
            if (imgUrl) {
                $thumbnails.append(jQuery(`<img src="${imgUrl}" class="product-info-thumbnail ${index === 0 ? 'active' : ''}" data-full-src="${imgUrl}">`));
            }
        });
        $content.append($gallery).append($details);



        if (isProductLimited) {
            $quantityInput.val(1).prop('disabled', true);
            $details.append(`<div class="sold-individually-notice">This item is limited to one per order.</div>`);
            
            
            if (isLimitReached) {
                $addToCartButton.prop('disabled', true).text('Already 1 in Cart');
                $details.find('.sold-individually-notice').text('Limit Reached: Already 1 in cart.');
                $quantityInput.prop('disabled', true);
            } else {
                
                $addToCartButton.prop('disabled', false).text('Add to Cart');
                $quantityInput.prop('disabled', true);
            }
        } else if (product.type === 'variable') {
                $addToCartButton.prop('disabled', true).text('Select Options');
        } else if (product.stock_status === 'outofstock') {

                $addToCartButton.prop('disabled', true).text('Out of Stock');
        } else {
  
                $addToCartButton.prop('disabled', false).text('Add to Cart');
        }


        if (product.type === 'variable') {
            $printLabelButton.prop('disabled', true);
            $selectors.show();
jQuery('#footer-price-display').html(
        '<span style="font-size: 0.8em; color: #666; font-weight: normal;">' + 
        'Select options for price and stock availability' + 
        '</span>'
    );
    jQuery('#footer-stock-display').text('');

            
            $variationList.show().append('<h4>Available Options & Stock</h4>');

            const productAttributes = {};
            if (product.variations) {
                product.variations.forEach(variation => {
                    const attributes = Object.values(variation.attributes).join(' - ');
                    const stock = variation.stock_status === 'instock' && variation.stock_quantity !== null ? `${strings.stockPrefix}${variation.stock_quantity}` : variation.stock_status === 'outofstock' ? strings.outOfStock : 'Available';
                    $variationList.append(`<div class="product-info-variation-item">
                        <span class="product-info-variation-attributes">${attributes}</span>
                        <span class="stock-status ${variation.stock_status}">${stock}</span>
                    </div>`);

                    Object.keys(variation.attributes).forEach(attrKey => {
                        if (!productAttributes[attrKey]) productAttributes[attrKey] = new Set();
                        if (variation.attributes[attrKey]) productAttributes[attrKey].add(variation.attributes[attrKey]);
                    });
                });
            }
            
            Object.keys(productAttributes).forEach(attributeKey => {
                const attributeName = formatAttributeName(attributeKey);
                const terms = Array.from(productAttributes[attributeKey]);
                if (terms.length > 0) {
                    let optionsHtml = `<option value="">${strings.selectAttribute.replace('%s', attributeName)}</option>`;
                    terms.forEach(term => optionsHtml += `<option value="${term}">${term}</option>`);
                    $selectors.append(`<div class="modal-form-group"><label for="info-modal-attr-${attributeKey}">${attributeName}:</label><select class="pos-input info-modal-variation-select" id="info-modal-attr-${attributeKey}" data-attribute-key="${attributeKey}">${optionsHtml}</select></div>`);
                }
            });
        }

        openModal($productInfoModal);
    },

updateInfoModalVariationDisplay: function () {
    const $modal = jQuery('#product-info-modal');
    const product = $modal.data('product-data');
    if (!product || !product.variations) return;

    const selectedAttributes = {};
    let allOptionsSelected = true;
    
    // 1. Gather selected attributes
    $modal.find('.info-modal-variation-select').each(function () {
        const key = jQuery(this).data('attribute-key');
        const value = jQuery(this).val();
        if (value) {
            selectedAttributes[key] = value;
        } else {
            allOptionsSelected = false;
        }
    });

    // 2. Find the matching variation
    let selectedVariation = null;
    if (allOptionsSelected) {
        selectedVariation = product.variations.find(variation =>
            Object.keys(selectedAttributes).every(selKey => variation.attributes[selKey] === selectedAttributes[selKey])
        );
    }

    $modal.data('selected-variation', selectedVariation);

    // Existing selectors
    const $priceDisplay = jQuery('#info-modal-price-display');
    const $stockDisplay = jQuery('#info-modal-stock-display');
    const $addToCartButton = jQuery('#info-modal-add-to-cart');
    const $quantityInput = jQuery('#info-modal-quantity');
    const $printLabelButton = jQuery('#print-label-button');

    // NEW: Footer summary selectors
    const $footerPrice = jQuery('#footer-price-display');
    const $footerStock = jQuery('#footer-stock-display');

    // Check for "Sold Individually" limits
    const isLimitReached = product.sold_individually && loycart.checkSoldIndividuallyLimit(product.id) >= 1;

    $quantityInput.prop('disabled', product.sold_individually);
    if (product.sold_individually) $quantityInput.val(1);

    if (selectedVariation) {
        // Prepare HTML/Text values
        
        const priceHtml = generatePriceHTML(selectedVariation);
        const stockText = selectedVariation.stock_status === 'instock' && selectedVariation.stock_quantity !== null 
            ? strings.stockPrefix + selectedVariation.stock_quantity 
            : strings.outOfStock;

        // Update Body AND Footer
        $priceDisplay.html(priceHtml);
        $footerPrice.html(priceHtml);

        $stockDisplay.text(stockText).attr('class', 'stock-status ' + selectedVariation.stock_status);
        $footerStock.text(stockText).attr('class', 'stock-status ' + selectedVariation.stock_status);

        // Handle buttons and quantity
        $printLabelButton.prop('disabled', false);
        const buttonDisabled = selectedVariation.stock_status === 'outofstock' || isLimitReached;
        $addToCartButton.prop('disabled', buttonDisabled);
        
        if (isLimitReached) {
            $addToCartButton.text('Already 1 in Cart');
        } else if (selectedVariation.stock_status === 'outofstock') {
            $addToCartButton.text('Out of Stock');
        } else {
            $addToCartButton.text('Add to Cart'); 
        }

        if (selectedVariation.sold_individually) {
            $quantityInput.val(1).prop('disabled', true);
        }

    } else {
        // Reset Logic when selection is incomplete
        const basePriceHtml = generatePriceHTML(product);
        
        $priceDisplay.html(basePriceHtml);
        $stockDisplay.text('');
        
        // Reset footer with a helpful prompt
        $footerPrice.html('<span style="font-size: 0.8em; color: #666; font-weight: normal;">' + 
            'Select options for price and stock availability' + 
        '</span>');
        
        $footerStock.text('');
        
        $printLabelButton.prop('disabled', true);
        $addToCartButton.prop('disabled', true).text('Select Options');
    }
}
};

// --- END MODALS MODULE ---