// --- LOYCART LOGGER MODULE ---
// Centralizes logging for the POS app
// -----------------------------------
loycart.logger = {
    debug: false,
    log: function () { if (this.debug) { console.log.apply(console, arguments); } },
    error: function () { console.error.apply(console, arguments); }
};

loycart.checkSoldIndividuallyLimit = function (productId) {
    const currentCartQuantity = loycart.cart.reduce((acc, item) => {
        if (item.id === productId && !item.is_custom) {
            return acc + Math.abs(item.quantity);
        }
        return acc;
    }, 0);
    return currentCartQuantity;
};
// --- END LOYCART LOGGER MODULE ---