// --- SHIPPING LABEL MODULE  ---
loycart.labelManager = {
    formatAddressBlock: function(addressString) {
        if (!addressString) return 'N/A';
        let formatted = addressString.replace(/<br\s*\/?>/gi, '\n').trim();
        return formatted;
    },
    
    buildLabelHtml: function(data) {
        const storeName = loycartPOS.store_name || 'Store Name Not Set';
        const storeAddressRaw = loycartPOS.store_address || 'Address Not Set';
        
        const fromAddressBlockHtml = this.formatAddressBlock(storeAddressRaw).replace(/\n/g, '<br>');
        const toAddressBlockRaw = data.label_address;
        const toAddressBlockHtml = this.formatAddressBlock(toAddressBlockRaw).replace(/\n/g, '<br>');
        
        const barcodeValue = data.barcode_id || data.order_number;
        const weight = data.weight || 'N/A'; 
        const dimensions = data.dimensions || 'N/A'; 
        const shippingDate = (new Date()).toISOString().substring(0, 10); 
        
        const style = `
            <style>
                @page { size: 4in 6in; margin: 0; }
                body { margin: 0; padding: 0; font-family: Arial, sans-serif; box-sizing: border-box; }
                .label-container {
                    width: 4in; height: 6in; border: 4px solid black; 
                    display: flex; flex-direction: column; overflow: hidden;
                    box-sizing: border-box; font-size: 10pt;
                }
                
                .address-row { 
                    display: flex; flex: 1 0 150px; 
                    border-bottom: 2px solid black;
                }
                .ship-to { 
                    flex: 2; border-right: 2px solid black; 
                    padding: 8px 10px; font-size: 11pt; 
                    line-height: 1.2;
                }
                .ship-to h2, .from-block h2 { 
                    margin: 0; font-size: 12pt; font-weight: bold;
                }
                .address-text {
                    font-weight: bold;
                    font-size: 14pt;
                    line-height: 1.3;
                    margin-top: 5px;
                }
                .from-block { 
                    flex: 1; padding: 8px 10px; font-size: 9pt; 
                    align-content: flex-start;
                }
                .from-address-text {
                    line-height: 1.25;
                    margin-top: 5px;
                    font-size: 10pt;
                }
                
                .detail-row { display: flex; flex: 0 0 auto; height: 35px; border-bottom: 2px solid black; }
                .detail-cell { 
                    border-right: 2px solid black; padding: 5px 10px; 
                    flex: 1; display: flex; flex-direction: column; 
                    justify-content: center; font-size: 9pt;
                }
                .detail-cell:last-child { border-right: none; }
                .detail-cell strong { font-size: 11pt; font-weight: bold; }

                .barcode-section { 
                    flex: 0 0 1in; border-top: 2px solid black; 
                    padding: 10px 5px; text-align: center; 
                    display: flex; flex-direction: column; justify-content: center;
                }
                .barcode-text { font-size: 8pt; margin-top: 5px; }
            </style>
        `;

        const html = `
            <!DOCTYPE html>
            <html>
            <head>
                <title>${(window.loycartPOS?.strings?.shippingLabelTitleWithOrder || 'Shipping Label - Order %s').replace('%s', data.order_number)}</title>
                ${style}
            </head>
            <body>
                <div class="label-container">
                    
                    <div class="address-row">
                        <div class="ship-to">
                            <h2>SHIP TO:</h2>
                            <div class="address-text">
                                ${toAddressBlockHtml}
                            </div>
                        </div>
                        <div class="from-block">
                            <h2>FROM:</h2>
                            <div class="from-address-text">
                                <strong>${storeName}</strong><br>
                                ${fromAddressBlockHtml}
                            </div>
                        </div>
                    </div>
                    
                    <div class="detail-row">
                        <div class="detail-cell" style="flex: 2;">
                            <span class="detail-label">ORDER ID:</span>
                            <span class="detail-value">${data.order_number}</span>
                        </div>
                        <div class="detail-cell" style="flex: 1;">
                            <span class="detail-label">REMARKS:</span>
                            <span class="detail-value">N/A</span>
                        </div>
                    </div>
                    
                    <div class="detail-row">
                        <div class="detail-cell">
                            <span class="detail-label">WEIGHT:</span>
                            <span class="detail-value">${weight}</span>
                        </div>
                        <div class="detail-cell">
                            <span class="detail-label">DIMENSIONS:</span>
                            <span class="detail-value">${dimensions}</span>
                        </div>
                        <div class="detail-cell">
                            <span class="detail-label">${window.loycartPOS?.strings?.shippingDateLabel || 'SHIPPING DATE:'}</span>
                            <span class="detail-value">${shippingDate}</span>
                        </div>
                    </div>

                    <div class="barcode-section">
                        <svg id="jsbarcode-target"></svg>
                        <p>${barcodeValue}</p>
                    </div>
                </div>
                
                <script src="${loycartPOS.plugin_url}/assets/js/JsBarcode.all.min.js"></script>
                <script>
                    function renderBarcode() {
                        try {
                            if (typeof JsBarcode !== 'undefined') {
                                JsBarcode("#jsbarcode-target", "${barcodeValue}", {
                        format: "CODE128",
                        displayValue: false,
                        fontSize: 14,
                        margin: 0,
                        height: 40
                                });
                            }
                        } catch (e) { loycart.logger.error('Barcode failed:', e); }
                    }
                    renderBarcode();
                    window.onload = renderBarcode;
                </script>
            </body>
            </html>
        `;
        return html;
    }
};
// --- END SHIPPING LABEL MODULE ---