// --- HELD SALES MANAGER MODULE ---
// Contains all logic for holding and retrieving sales
// -------------------------------
(function($) {
    // Ensure namespace exists
    window.loycart = window.loycart || {};

    loycart.heldSalesManager = {

        refreshHeldSales: function () {
            // Reference window scope for state management
            window.isProcessing = true;
            
            if (window.$heldCartsList) {
                window.$heldCartsList.empty().append(`<p class="empty-state-message">${loycartPOS.strings.loadingHeldSales}</p>`);
            }

            api_getHeldCarts()
                .done(function (response) {
                    if (window.$heldCartsList) window.$heldCartsList.empty();
                    
                    if (response.success && response.data && response.data.length > 0) {
                        // Update global count on window object
                        window.heldSalesCount = response.data.length;
                        
                        response.data.forEach(heldCart => {
                            const displayTitle = heldCart.held_name || heldCart.title || 'Untitled Held Sale';
                            const $item = jQuery(`
                                <div class="held-cart-item" data-id="${heldCart.id}" tabindex="0">
                                    <div class="held-cart-info">
                                        <div class="held-cart-title">${displayTitle}</div>
                                        <div class="held-cart-meta">By: ${heldCart.operator_name || 'N/A'} | Cust: ${heldCart.customer_name || 'Guest'} | ${heldCart.total} | ${heldCart.date_held}</div>
                                    </div>
                                    <div class="held-cart-actions">
                                        <button class="resume-held-cart button-primary">Resume</button>
                                        <button class="delete-held-cart button-secondary">Delete</button>
                                    </div>
                                </div>`);
                            if (window.$heldCartsList) window.$heldCartsList.append($item);
                        });
                    } else {
                        window.heldSalesCount = 0;
                        if (window.$heldCartsList) window.$heldCartsList.html(`<p class="empty-state-message">${loycartPOS.strings.noSalesOnHold}</p>`);
                    }

                    loycart.heldSalesManager.updateHoldRetrieveButton();
                })
                .fail(function () {
                    if (window.$heldCartsList) window.$heldCartsList.html(`<p class="empty-state-message">${loycartPOS.strings.failedLoadHeldSales}</p>`);
                    showNotification(loycartPOS.strings.errorRetrievingHeldSales, 'error');
                })
                .always(function () {
                    window.isProcessing = false;
                });
        },

        holdSaleAjax: function (heldName) {
            window.isProcessing = true;

            // Use window scope for selectors and variables
            const custId = window.$customerId ? window.$customerId.val() : '0';
            const cartTotal = window.$cartTotal ? window.$cartTotal.text() : '0';

            api_holdSale(JSON.stringify(loycart.cart), custId, cartTotal, heldName)
                .done(function (response) {
                    if (response.success) {
                        showNotification(loycartPOS.strings.saleHeldSuccess.replace('%s', (response.title || '')), 'success');

                        loycart.cart = [];
                        window.selectedShipping = { id: null, cost: 0, label: '' };
                        
                        jQuery('#remove-customer-from-cart').trigger('click');
                        loycart.cartManager.updateCart();
                        loycart.heldSalesManager.refreshHeldSales();
                    } else {
                        showNotification(response.data || loycartPOS.strings.failedHoldSale, 'error');
                    }
                })
                .fail(function () {
                    showNotification(loycartPOS.strings.errorHoldingSale, 'error');
                })
                .always(function () {
                    window.isProcessing = false;
                });
        },

        updateHoldRetrieveButton: function () {
            const $holdButton = jQuery('#hold-sale-button');
            if (!$holdButton.length) return;

            if (loycart.cart.length > 0) {
                $holdButton.text('Hold Sale');
                $holdButton.data('action', 'hold');
                $holdButton.prop('disabled', false).attr('aria-disabled', 'false');
            } else {
                // Accessing the shared global variable from window
                if (window.heldSalesCount > 0) {
                    $holdButton.text('Resume Sale (' + window.heldSalesCount + ')');
                    $holdButton.data('action', 'retrieve');
                    $holdButton.prop('disabled', false).attr('aria-disabled', 'false');
                } else {
                    $holdButton.text('Hold Sale');
                    $holdButton.data('action', 'hold');
                    $holdButton.prop('disabled', true).attr('aria-disabled', 'true');
                }
            }
        }
    };
})(jQuery);
// --- END HELD SALES MANAGER MODULE ---